# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2007-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Philippe Normand <philippe@fluendo.com>

import base64

def generate_basic_auth_headers(username, password):
    """ Generate HTTP Basic Authentication headers given a username
    and a password. This is implemented in respect with RFC 2617.

    @param username: user id to use for the authentication against the server
    @type username:  C{str}
    @param password: password to use during the authentication
    @type password:  C{str}
    @rtype:          C{dict}
    """
    challenge = base64.b64encode("%s:%s" % (username, password))
    headers = {"Authorization": ["Basic %s" % challenge]}
    return headers
