# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

from elisa.plugins.pigment.widgets.widget import Widget

from elisa.plugins.pigment.graph.quad import Quad


class WidgetWithBackground(Widget):

    """
    A container with an image as a background and foreground widget,
    positioned as needed inside.

    @ivar background: the background image
    @type background: L{elisa.plugins.pigment.graph.image.Quad}
    @ivar foreground: the foreground widget positioned inside C{self}
    @type foreground: L{elisa.plugins.pigment.graph.node.Node}
    """

    def __init__(self, foreground=None):
        super(WidgetWithBackground, self).__init__()
        self._create_widgets()
        self.foreground = None
        self.set_foreground(foreground)
        self.update_style_properties(self.style.get_items())

    def _create_widgets(self):
        self.background = Quad()
        self.background.visible = True
        self.add(self.background)

    def set_foreground(self, foreground):
        if self.foreground is not None:
            self.remove(self.foreground)
        self.foreground = foreground
        if foreground is not None:
            foreground.visible = True
            self.add(foreground)
            self.set_focus_proxy(foreground)

    def update_style_properties(self, props=None):
        if props is None:
            return

        if self.foreground is None:
            # widget is used without foreground, clean up the styles
            # accordingly
            remaining_props = {}
            for key, value in props.iteritems():
                try:
                    subwidget, attribute = key.split('-', 1)
                except ValueError:
                    remaining_props[key] = value
                    continue
                if subwidget != 'foreground':
                    remaining_props[key] = value
            props = remaining_props

        return super(WidgetWithBackground, self).update_style_properties(props)

    @classmethod
    def _demo_widget(cls, *args, **kwargs):
        widget = cls(foreground=Quad())
        widget.set_name('demo')
        return widget


if __name__ == '__main__':
    # absolute import required in order to make styling work
    from elisa.plugins.poblesec.widgets.background import WidgetWithBackground

    widget = WidgetWithBackground.demo()

    try:
        __IPYTHON__
    except NameError:
        import pgm
        pgm.main()
