<?php
/**
 * Internationalisation file for Cite special page extension.
 *
 * @addtogroup Extensions
*/

$messages = array();

$messages['en'] = array(
	'cite_article_desc' => 'Adds a [[Special:Cite|citation]] special page and toolbox link',
	'cite_article_link' => 'Cite this page',
	'cite'              => 'Cite',
	'cite_page'         => 'Page:',
	'cite_submit'       => 'Cite',
	'cite_text'         => '', # Do not translate this
);

/** Message documentation (Message documentation)
 * @author Jon Harald Søby
 * @author Siebrand
 */
$messages['qqq'] = array(
	'cite_article_desc' => 'Extension description for cite. Do not translate or change links, and tag names.',
	'cite' => '{{Identical|Cite}}',
	'cite_page' => '{{Identical|Page}}',
	'cite_submit' => '{{Identical|Cite}}',
);

/** Säggssch (Säggssch)
 * @author Thogo
 */
$messages['sxu'] = array(
	'cite_article_link' => 'Zidier dän ardiggl hier',
	'cite' => 'Zidierhilfe',
	'cite_submit' => 'Zidierhilfe',
);

/** Niuean (ko e vagahau Niuē)
 * @author Jose77
 */
$messages['niu'] = array(
	'cite_article_link' => 'Fakakite e tala nei',
);

/** Veps (Vepsan kel')
 * @author Triple-ADHD-AS
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'cite' => 'Citiruind',
	'cite_page' => 'Lehtpol’:',
	'cite_submit' => 'Citiruida',
);

/** Afrikaans (Afrikaans)
 * @author Naudefj
 * @author SPQRobin
 */
$messages['af'] = array(
	'cite_article_desc' => "Maak 'n [[Special:Cite|spesiale bladsy vir sitasie]], en 'n skakel daarna in hulpmiddels beskikbaar",
	'cite_article_link' => 'Haal dié blad aan',
	'cite' => 'Aanhaling',
	'cite_page' => 'Bladsy:',
	'cite_submit' => 'Aanhaling',
);

/** Amharic (አማርኛ)
 * @author Codex Sinaiticus
 * @author Teferra
 */
$messages['am'] = array(
	'cite_article_link' => 'ይህንን ገጽ አጣቅስ',
	'cite' => 'መጥቀሻ',
	'cite_page' => 'አርዕስት፦',
	'cite_submit' => 'ዝርዝሮች ይታዩ',
);

/** Aragonese (Aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'cite_article_desc' => 'Adibe un binclo y una pachina espezial de [[Special:Cite|zita]]',
	'cite_article_link' => 'Zitar ista pachina',
	'cite' => 'Zitar',
	'cite_page' => 'Pachina:',
	'cite_submit' => 'Zitar',
);

/** Arabic (العربية)
 * @author Meno25
 */
$messages['ar'] = array(
	'cite_article_desc' => 'يضيف صفحة [[Special:Cite|استشهاد]] خاصة ووصلة صندوق أدوات',
	'cite_article_link' => 'استشهد بهذه الصفحة',
	'cite' => 'استشهاد',
	'cite_page' => 'الصفحة:',
	'cite_submit' => 'استشهاد',
);

/** Araucanian (Mapudungun)
 * @author Remember the dot
 */
$messages['arn'] = array(
	'cite_page' => 'Pakina:',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Ghaly
 * @author Ramsis II
 */
$messages['arz'] = array(
	'cite_article_desc' => 'بيضيف [[Special:Cite|استشهاد]] صفحة مخصوصة ولينك لصندوء أدوات',
	'cite_article_link' => 'استشهد بالصفحة دى',
	'cite' => 'مرجع',
	'cite_page' => 'الصفحه:',
	'cite_submit' => 'مرجع',
);

/** Asturian (Asturianu)
 * @author Esbardu
 */
$messages['ast'] = array(
	'cite_article_desc' => 'Añade una páxina especial de [[Special:Cite|cites]] y un enllaz a la caxa de ferramientes',
	'cite_article_link' => 'Citar esta páxina',
	'cite' => 'Citar',
	'cite_page' => 'Páxina:',
	'cite_submit' => 'Citar',
);

/** Samogitian (Žemaitėška)
 * @author Hugo.arg
 */
$messages['bat-smg'] = array(
	'cite' => 'Citoutė',
	'cite_page' => 'Poslapis:',
);

/** Southern Balochi (بلوچی مکرانی)
 * @author Mostafadaneshvar
 */
$messages['bcc'] = array(
	'cite_article_desc' => 'اضافه کن یک [[Special:Cite|citation]] صفحه حاص و لینک جعبه ابزار',
	'cite_article_link' => 'ای صفحه ی مرجع بل',
	'cite' => 'مرجع',
	'cite_page' => 'صفحه:',
	'cite_submit' => 'مرجع',
);

/** Bikol Central (Bikol Central)
 * @author Filipinayzd
 */
$messages['bcl'] = array(
	'cite_article_link' => 'Sambiton an artikulong ini',
	'cite' => 'Sambiton',
	'cite_page' => 'Pahina:',
	'cite_submit' => 'Sambiton',
);

/** Belarusian (Беларуская) */
$messages['be'] = array(
	'cite_article_link' => 'Цытаваць гэты артыкул',
);

/** Belarusian (Taraškievica orthography) (Беларуская (тарашкевіца))
 * @author EugeneZelenko
 */
$messages['be-tarask'] = array(
	'cite_article_desc' => 'Дадае спэцыяльную старонку [[Special:Cite|цытаваньня]] і спасылку ў інструмэнтах',
	'cite_article_link' => 'Цытаваць гэтую старонку',
	'cite' => 'Цытаваньне',
	'cite_page' => 'Старонка:',
	'cite_submit' => 'Цытаваць',
);

/** Bulgarian (Български)
 * @author DCLXVI
 */
$messages['bg'] = array(
	'cite_article_desc' => 'Добавя специална страница и препратка за [[Special:Cite|цитиране]]',
	'cite_article_link' => 'Цитиране на страницата',
	'cite' => 'Цитиране',
	'cite_page' => 'Страница:',
	'cite_submit' => 'Цитиране',
);

/** Bengali (বাংলা)
 * @author Bellayet
 * @author Zaheen
 */
$messages['bn'] = array(
	'cite_article_desc' => 'একটি বিশেষ [[Special:Cite|উদ্ধৃতি]] পাতা ও টুলবক্স সংযোগ যোগ করে',
	'cite_article_link' => 'এ পাতাটি উদ্ধৃত করো',
	'cite' => 'উদ্ধৃত',
	'cite_page' => 'পাতা:',
	'cite_submit' => 'উদ্ধৃত করো',
);

/** Bishnupria Manipuri (ইমার ঠার/বিষ্ণুপ্রিয়া মণিপুরী) */
$messages['bpy'] = array(
	'cite_article_link' => 'নিবন্ধ এহানরে উদ্ধৃত করেদে',
	'cite' => 'উদ্ধৃত করেদে',
);

/** Breton (Brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'cite_article_desc' => 'Ouzhpennañ a ra ur bajenn zibar [[Special:Cite|arroud]] hag ul liamm er voest ostilhoù',
	'cite_article_link' => 'Menegiñ ar pennad-mañ',
	'cite' => 'Menegiñ',
	'cite_page' => 'Pajenn :',
	'cite_submit' => 'Menegiñ',
);

/** Bosnian (Bosanski)
 * @author CERminator
 */
$messages['bs'] = array(
	'cite_article_desc' => 'Dodaje posebnu stranicu za [[Special:Cite|citiranje]] i link u alatnoj kutiji',
	'cite_article_link' => 'Citiraj ovu stranicu',
	'cite' => 'Citiranje',
	'cite_page' => 'Članak:',
	'cite_submit' => 'Citiraj',
);

/** Catalan (Català)
 * @author SMP
 * @author Toniher
 */
$messages['ca'] = array(
	'cite_article_desc' => 'Afegeix un enllaç i una pàgina especial de [[Special:Cite|citació]]',
	'cite_article_link' => 'Cita aquesta pàgina',
	'cite' => 'Citeu',
	'cite_page' => 'Pàgina:',
	'cite_submit' => 'Cita',
);

/** Min Dong Chinese (Mìng-dĕ̤ng-ngṳ̄) */
$messages['cdo'] = array(
	'cite_article_link' => 'Īng-ê̤ṳng cī piĕng ùng-ciŏng',
	'cite' => 'Īng-ê̤ṳng',
	'cite_page' => 'Hiĕk-miêng:',
	'cite_submit' => 'Īng-ê̤ṳng',
);

/** Cebuano (Cebuano)
 * @author Abastillas
 */
$messages['ceb'] = array(
	'cite' => 'Kutloa',
);

/** Corsican (Corsu) */
$messages['co'] = array(
	'cite_article_link' => 'Cità issu articulu',
	'cite' => 'Cità',
	'cite_page' => 'Pagina:',
);

/** Czech (Česky)
 * @author Beren
 * @author Li-sung
 * @author Martin Kozák
 */
$messages['cs'] = array(
	'cite_article_desc' => 'Přidává speciální stránku [[Special:Cite|Citace]] a odkaz v nabídce nástrojů',
	'cite_article_link' => 'Citovat stránku',
	'cite' => 'Citace',
	'cite_page' => 'Článek:',
	'cite_submit' => 'Citovat',
);

/** Church Slavic (Словѣ́ньскъ / ⰔⰎⰑⰂⰡⰐⰠⰔⰍⰟ)
 * @author ОйЛ
 */
$messages['cu'] = array(
	'cite_article_link' => 'привєдє́ниѥ члѣ́на словє́съ',
	'cite_page' => 'страни́ца :',
);

/** Welsh (Cymraeg)
 * @author Lloffiwr
 */
$messages['cy'] = array(
	'cite_article_desc' => 'Yn ychwanegu tudalen arbennig ar gyfer [[Special:Cite|cyfeirio at erthygl]] a chyswllt bocs offer',
	'cite_article_link' => 'Cyfeiriwch at yr erthygl hon',
	'cite' => 'Cyfeirio at erthygl',
	'cite_page' => 'Tudalen:',
	'cite_submit' => 'Cyfeirio',
);

/** Danish (Dansk)
 * @author Byrial
 * @author Morten LJ
 */
$messages['da'] = array(
	'cite_article_desc' => 'Tilføjer en [[Special:Cite|specialside til citering]] og en henvisning i værktøjsmenuen',
	'cite_article_link' => 'Citér denne artikel',
	'cite' => 'Citér',
	'cite_page' => 'Side:',
	'cite_submit' => 'Citér',
);

/** German (Deutsch) */
$messages['de'] = array(
	'cite_article_desc' => 'Ergänzt die [[Special:Cite|Zitierhilfe]]-Spezialseite und einen Link im Kasten Werkzeuge',
	'cite_article_link' => 'Seite zitieren',
	'cite' => 'Zitierhilfe',
	'cite_page' => 'Seite:',
	'cite_submit' => 'anzeigen',
);

/** Zazaki (Zazaki) */
$messages['diq'] = array(
	'cite_article_link' => 'Na pele çıme bımocne',
	'cite' => 'Çıme bımocne',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'cite_article_desc' => 'Pśidawa specialny bok [[Special:Cite|Citěrowańska pomoc]] a link w kašćiku źěłowe rědy',
	'cite_article_link' => 'Toś ten bok citěrowaś',
	'cite' => 'Citěrowańska pomoc',
	'cite_page' => 'Bok:',
	'cite_submit' => 'pokazaś',
);

/** Ewe (Eʋegbe) */
$messages['ee'] = array(
	'cite_page' => 'Nuŋɔŋlɔ:',
);

/** Greek (Ελληνικά)
 * @author Consta
 * @author Omnipaedista
 */
$messages['el'] = array(
	'cite_article_desc' => 'Προσθέτει μία ειδική σελίδα [[Special:Cite|παραθέσεων]] καί έναν σύνδεσμο προς την εργαλειοθήκη',
	'cite_article_link' => 'Αναφέρεται αυτή τη σελίδα',
	'cite' => 'Αναφορά',
	'cite_page' => 'Σελίδα:',
	'cite_submit' => 'Προσθήκη παραθέσεων',
);

/** Esperanto (Esperanto)
 * @author Tlustulimu
 * @author Yekrats
 */
$messages['eo'] = array(
	'cite_article_desc' => 'Aldonas specialan paĝon por [[Special:Cite|citado]] kaj ligilo al ilaro',
	'cite_article_link' => 'Citi ĉi tiun paĝon',
	'cite' => 'Citado',
	'cite_page' => 'Paĝo:',
	'cite_submit' => 'Citi',
);

/** Spanish (Español)
 * @author Icvav
 * @author Jatrobat
 * @author Muro de Aguas
 * @author Sanbec
 */
$messages['es'] = array(
	'cite_article_desc' => 'Añade una página especial para [[Special:Cite|citar la página]] y un enlace en la caja de herramientas.',
	'cite_article_link' => 'Citar este artículo',
	'cite' => 'Citar',
	'cite_page' => 'Página:',
	'cite_submit' => 'Citar',
);

/** Estonian (Eesti)
 * @author WikedKentaur
 */
$messages['et'] = array(
	'cite_article_link' => 'Tsiteeri seda artiklit',
	'cite' => 'Tsiteeri',
	'cite_page' => 'Leht:',
	'cite_submit' => 'Tsiteeri',
);

/** Basque (Euskara)
 * @author Theklan
 */
$messages['eu'] = array(
	'cite_article_desc' => '[[Special:Cite|Aipatu]] orrialde berezia gehitzen du tresna-kutxaren loturetan',
	'cite_article_link' => 'Orrialde hau aipatu',
	'cite' => 'Aipamenak',
	'cite_page' => 'Orrialdea:',
	'cite_submit' => 'Aipatu',
);

/** Extremaduran (Estremeñu)
 * @author Better
 */
$messages['ext'] = array(
	'cite_article_link' => 'Almiental esti artículu',
	'cite' => 'Almiental',
	'cite_page' => 'Páhina:',
	'cite_submit' => 'Almiental',
);

/** Persian (فارسی)
 * @author Huji
 */
$messages['fa'] = array(
	'cite_article_desc' => 'صفحهٔ ویژه‌ای برای [[Special:Cite|یادکرد]] اضافه می‌کند و پیوندی به جعبه ابزار می‌افزاید',
	'cite_article_link' => 'یادکرد پیوند این مقاله',
	'cite' => 'یادکرد این مقاله',
	'cite_page' => 'صفحه:',
	'cite_submit' => 'یادکرد',
);

/** Finnish (Suomi)
 * @author Nike
 */
$messages['fi'] = array(
	'cite_article_desc' => 'Lisää työkaluihin toimintosivun, joka neuvoo [[Special:Cite|viittaamaan]] oikeaoppisesti.',
	'cite_article_link' => 'Viitetiedot',
	'cite' => 'Viitetiedot',
	'cite_page' => 'Sivu:',
	'cite_submit' => 'Viittaa',
);

/** Fijian (Na Vosa Vakaviti) */
$messages['fj'] = array(
	'cite_article_link' => 'Vola dau vaqarai',
);

/** Faroese (Føroyskt)
 * @author Spacebirdy
 */
$messages['fo'] = array(
	'cite_article_link' => 'Sitera hesa greinina',
	'cite' => 'Sitera',
	'cite_page' => 'Síða:',
	'cite_submit' => 'Sitera',
);

/** French (Français)
 * @author Grondin
 * @author Hégésippe Cormier
 * @author Urhixidur
 */
$messages['fr'] = array(
	'cite_article_desc' => 'Ajoute une page spéciale [[Special:Cite|citation]] et un lien dans la boîte à outils',
	'cite_article_link' => 'Citer cette page',
	'cite' => 'Citation',
	'cite_page' => 'Page :',
	'cite_submit' => 'Citer',
);

/** Franco-Provençal (Arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'cite_article_desc' => 'Apond una pâge spèciâla [[Special:Cite|citacion]] et un lim dens la bouèta d’outils.',
	'cite_article_link' => 'Citar ceta pâge',
	'cite' => 'Citacion',
	'cite_page' => 'Pâge :',
	'cite_submit' => 'Citar',
);

/** Friulian (Furlan)
 * @author Klenje
 * @author MF-Warburg
 */
$messages['fur'] = array(
	'cite_article_link' => 'Cite cheste vôs',
	'cite' => 'Citazion',
	'cite_page' => 'Pagjine:',
	'cite_submit' => 'Cree la citazion',
);

/** Western Frisian (Frysk)
 * @author Snakesteuben
 */
$messages['fy'] = array(
	'cite_article_link' => 'Sitearje dizze side',
	'cite' => 'Sitearje',
	'cite_page' => 'Side:',
	'cite_submit' => 'Sitearje',
);

/** Irish (Gaeilge)
 * @author Alison
 */
$messages['ga'] = array(
	'cite_article_desc' => 'Cuir [[Special:Cite|deismireacht]] leathanach speisíalta agus nasc bosca uirlisí',
	'cite_article_link' => 'Luaigh an lch seo',
	'cite' => 'Luaigh',
	'cite_page' => 'Leathanach:',
	'cite_submit' => 'Luaigh',
);

/** Galician (Galego)
 * @author Toliño
 * @author Xosé
 */
$messages['gl'] = array(
	'cite_article_desc' => 'Engade unha páxina especial de [[Special:Cite|citas]] e unha ligazón na caixa de ferramentas',
	'cite_article_link' => 'Citar esta páxina',
	'cite' => 'Citar un artigo',
	'cite_page' => 'Páxina:',
	'cite_submit' => 'Citar',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author AndreasJS
 * @author LeighvsOptimvsMaximvs
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'cite_article_desc' => 'Προσθέτει εἰδικὴν δἐλτον [[Special:Cite|ἀναφορῶν]] τινὰ καὶ σύνδεσμον τινὰ ἐν τῷ ἐργαλειοκάδῳ',
	'cite_article_link' => 'Άναφέρειν τήνδε τὴν δέλτον',
	'cite' => 'Μνημονεύειν',
	'cite_page' => 'Δέλτος:',
	'cite_submit' => 'Μνημονεύειν',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 * @author Strommops
 */
$messages['gsw'] = array(
	'cite_article_desc' => 'Ergänzt d [[Special:Cite|Zitierhilf]]-Spezialsyte un e Gleich im Chaschte Wärchzyyg',
	'cite_article_link' => 'Die Site zitiere',
	'cite' => 'Zitierhilf',
	'cite_page' => 'Syte:',
	'cite_submit' => 'aazeige',
);

/** Gujarati (ગુજરાતી) */
$messages['gu'] = array(
	'cite_page' => 'પાનું:',
);

/** Manx (Gaelg)
 * @author MacTire02
 */
$messages['gv'] = array(
	'cite_article_link' => 'Symney yn duillag shoh',
	'cite' => 'Symney',
	'cite_page' => 'Duillag:',
	'cite_submit' => 'Symney',
);

/** Hawaiian (Hawai`i)
 * @author Singularity
 */
$messages['haw'] = array(
	'cite_article_link' => "E ho'ōia i kēia mea",
	'cite_page' => '‘Ao‘ao:',
);

/** Hebrew (עברית)
 * @author Rotem Liss
 */
$messages['he'] = array(
	'cite_article_desc' => 'הוספת דף מיוחד וקישור בתיבת הכלים ל[[Special:Cite|ציטוט]]',
	'cite_article_link' => 'ציטוט דף זה',
	'cite' => 'ציטוט',
	'cite_page' => 'דף:',
	'cite_submit' => 'ציטוט',
);

/** Hindi (हिन्दी)
 * @author Kaustubh
 */
$messages['hi'] = array(
	'cite_article_desc' => 'एक विशेष [[Special:Cite|बाह्यकड़ियां]] देनेवाला पन्ना और टूलबॉक्सका लिंक बनाईयें',
	'cite_article_link' => 'इस पन्ने को उद्घृत करें',
	'cite' => 'उद्घॄत करें',
	'cite_page' => 'पन्ना:',
	'cite_submit' => 'उद्घृत करें',
);

/** Hiligaynon (Ilonggo)
 * @author Jose77
 */
$messages['hil'] = array(
	'cite_article_link' => 'Tumuron ining artikulo',
);

/** Croatian (Hrvatski)
 * @author Dalibor Bosits
 * @author SpeedyGonsales
 */
$messages['hr'] = array(
	'cite_article_desc' => 'Dodaje posebnu stranicu za [[Special:Cite|citiranje]] i link u okvir za alate',
	'cite_article_link' => 'Citiraj ovaj članak',
	'cite' => 'Citiranje',
	'cite_page' => 'Stranica:',
	'cite_submit' => 'Citiraj',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'cite_article_desc' => 'Přidawa specialnu stronu [[Special:Cite|Citowanska pomoc]] a wotkaz w gratowym kašćiku',
	'cite_article_link' => 'Nastawk citować',
	'cite' => 'Citowanska pomoc',
	'cite_page' => 'Strona:',
	'cite_submit' => 'pokazać',
);

/** Haitian (Kreyòl ayisyen)
 * @author Masterches
 */
$messages['ht'] = array(
	'cite_article_desc' => 'Ajoute yon paj espesyal [[Special:Cite|sitasyon]] epitou yon lyen nan bwat zouti yo',
	'cite_article_link' => 'Site paj sa',
	'cite' => 'Sitasyon',
	'cite_page' => 'Paj:',
	'cite_submit' => 'Site',
);

/** Hungarian (Magyar)
 * @author Dani
 */
$messages['hu'] = array(
	'cite_article_desc' => '[[Special:Cite|Irodalomjegyzék-bejegyzés készítése]] speciális lap és hivatkozás az eszközdobozba',
	'cite_article_link' => 'A lap idézése',
	'cite' => 'Irodalomjegyzék-bejegyzés készítése',
	'cite_page' => 'Idézendő lap:',
	'cite_submit' => 'Bejegyzés elkészítése',
);

/** Armenian (Հայերեն)
 * @author Teak
 */
$messages['hy'] = array(
	'cite_article_link' => 'Քաղվածել հոդվածը',
	'cite' => 'Քաղվածում',
	'cite_page' => 'Էջ.',
	'cite_submit' => 'Քաղվածել',
);

/** Interlingua (Interlingua)
 * @author Malafaya
 * @author McDutchie
 */
$messages['ia'] = array(
	'cite_article_desc' => 'Adde un pagina special de [[Special:Cite|citation]] e un ligamine verso le instrumentario',
	'cite_article_link' => 'Citar iste pagina',
	'cite' => 'Citation',
	'cite_page' => 'Pagina:',
	'cite_submit' => 'Citar',
);

/** Indonesian (Bahasa Indonesia)
 * @author IvanLanin
 */
$messages['id'] = array(
	'cite_article_desc' => 'Menambahkan halaman istimewa [[Special:Cite|kutipan]] dan pranala pada kotak peralatan',
	'cite_article_link' => 'Kutip artikel ini',
	'cite' => 'Kutip',
	'cite_page' => 'Halaman:',
	'cite_submit' => 'Kutip',
);

/** Interlingue (Interlingue)
 * @author Malafaya
 */
$messages['ie'] = array(
	'cite_page' => 'Págine:',
);

/** Iloko (Ilokano) */
$messages['ilo'] = array(
	'cite_article_link' => 'Dakamaten ti articulo',
	'cite' => 'Dakamaten',
	'cite_page' => 'Panid:',
	'cite_submit' => 'Idakamat',
);

/** Ido (Ido)
 * @author Malafaya
 */
$messages['io'] = array(
	'cite_article_desc' => 'Ico adjuntas specala pagino e ligilo por [[Special:Cite|citaji]] en utensilo-buxo',
	'cite_article_link' => 'Citar ca pagino',
	'cite' => 'Citar',
	'cite_page' => 'Pagino:',
	'cite_submit' => 'Citar',
);

/** Icelandic (Íslenska)
 * @author S.Örvarr.S
 * @author לערי ריינהארט
 */
$messages['is'] = array(
	'cite_article_link' => 'Vitna í þessa síðu',
	'cite' => 'Vitna í síðu',
	'cite_page' => 'Síða:',
	'cite_submit' => 'Vitna í',
);

/** Italian (Italiano)
 * @author BrokenArrow
 */
$messages['it'] = array(
	'cite_article_desc' => 'Aggiunge una pagina speciale per le [[Special:Cite|citazioni]] e un collegamento negli strumenti',
	'cite_article_link' => 'Cita questa pagina',
	'cite' => 'Citazione',
	'cite_page' => 'Pagina da citare:',
	'cite_submit' => 'Crea la citazione',
);

/** Japanese (日本語)
 * @author Aotake
 * @author Fryed-peach
 * @author JtFuruhata
 * @author Suisui
 */
$messages['ja'] = array(
	'cite_article_desc' => '[[Special:Cite|引用情報のための特別ページ]]とツールボックスからのリンクを追加する',
	'cite_article_link' => 'この項目を引用する',
	'cite' => '{{SITENAME}}の項目を引用する',
	'cite_page' => 'ページ:',
	'cite_submit' => '引用する',
);

/** Jutish (Jysk)
 * @author Huslåke
 */
$messages['jut'] = array(
	'cite_article_link' => 'Fodnåter denne ertikel',
	'cite' => 'Fodnåt',
	'cite_page' => 'Side:',
	'cite_submit' => 'Fodnåt',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 */
$messages['jv'] = array(
	'cite_article_desc' => 'Nambahaké kaca astaméwa [[Special:Cite|sitat (kutipan)]] lan pranala ing kothak piranti',
	'cite_article_link' => 'Kutip (sitir) kaca iki',
	'cite' => 'Kutip (sitir)',
	'cite_page' => 'Kaca:',
	'cite_submit' => 'Kutip (sitir)',
);

/** Georgian (ქართული)
 * @author Malafaya
 */
$messages['ka'] = array(
	'cite_article_link' => 'ამ გვერდის ციტირება',
	'cite_page' => 'გვერდი:',
);

/** Kazakh (Arabic script) (‫قازاقشا (تٴوتە)‬) */
$messages['kk-arab'] = array(
	'cite_article_link' => 'بەتتەن دايەكسوز الۋ',
	'cite' => 'دايەكسوز الۋ',
	'cite_page' => 'بەت اتاۋى:',
	'cite_submit' => 'دايەكسوز ال!',
);

/** Kazakh (Cyrillic) (Қазақша (Cyrillic)) */
$messages['kk-cyrl'] = array(
	'cite_article_link' => 'Беттен дәйексоз алу',
	'cite' => 'Дәйексөз алу',
	'cite_page' => 'Бет атауы:',
	'cite_submit' => 'Дәйексөз ал!',
);

/** Kazakh (Latin) (Қазақша (Latin)) */
$messages['kk-latn'] = array(
	'cite_article_link' => 'Betten däýeksoz alw',
	'cite' => 'Däýeksöz alw',
	'cite_page' => 'Bet atawı:',
	'cite_submit' => 'Däýeksöz al!',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Chhorran
 * @author Lovekhmer
 */
$messages['km'] = array(
	'cite_article_link' => 'ប្រភពនៃទំព័រនេះ',
	'cite_page' => 'ទំព័រ ៖',
);

/** Kannada (ಕನ್ನಡ)
 * @author Shushruth
 */
$messages['kn'] = array(
	'cite_article_link' => 'ಈ ಪುಟವನ್ನು ಉಲ್ಲೇಖಿಸಿ',
	'cite' => 'ಉಲ್ಲೇಖಿಸಿ',
);

/** Korean (한국어)
 * @author ToePeu
 */
$messages['ko'] = array(
	'cite_article_desc' => '[[Special:Cite|인용]] 특수문서와 도구상자 고리를 더함',
	'cite_article_link' => '이 문서 인용하기',
	'cite' => '인용',
	'cite_page' => '문서:',
	'cite_submit' => '인용',
);

/** Kinaray-a (Kinaray-a)
 * @author Jose77
 */
$messages['krj'] = array(
	'cite_page' => 'Pahina:',
);

/** Ripoarisch (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'cite_article_desc' => 'Brenk de Sondersigg „[[Special:Cite|Ziteere]]“ un ene Link onger „{{int:toolbox}}“.',
	'cite_article_link' => 'Di Sigk Zitteere',
	'cite' => 'Zittiere',
	'cite_page' => 'Sigk:',
	'cite_submit' => 'Zittėere',
);

/** Cornish (Kernewek)
 * @author Kw-Moon
 */
$messages['kw'] = array(
	'cite_article_link' => 'Devynna an erthygel ma',
);

/** Latin (Latina)
 * @author SPQRobin
 * @author UV
 */
$messages['la'] = array(
	'cite_article_link' => 'Hanc paginam citare',
	'cite' => 'Paginam citare',
	'cite_page' => 'Pagina:',
	'cite_submit' => 'Citare',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Kaffi
 * @author Robby
 */
$messages['lb'] = array(
	'cite_article_desc' => "Setzt eng [[Special:Cite|Zitatioun op dëser Spezialsäit]] bäi an e Link an d'Geschiirkëscht",
	'cite_article_link' => 'Dës Säit zitéieren',
	'cite' => 'Zitéierhëllef',
	'cite_page' => 'Säit:',
	'cite_submit' => 'weisen',
);

/** Lingua Franca Nova (Lingua Franca Nova)
 * @author Malafaya
 */
$messages['lfn'] = array(
	'cite_page' => 'Paje:',
);

/** Limburgish (Limburgs)
 * @author Ooswesthoesbes
 * @author Pahles
 */
$messages['li'] = array(
	'cite_article_desc' => "Voog 'n [[Special:Cite|speciaal pagina óm te citere]] toe en 'ne link derhaer in de gereidsjapskis",
	'cite_article_link' => 'Citeer dees pagina',
	'cite' => 'Citere',
	'cite_page' => 'Pagina:',
	'cite_submit' => 'Citere',
);

/** Lumbaart (Lumbaart) */
$messages['lmo'] = array(
	'cite_article_link' => 'Cita questa vus',
	'cite' => 'Cita una vus',
);

/** Lao (ລາວ) */
$messages['lo'] = array(
	'cite_article_link' => 'ອ້າງອີງບົດຄວາມນີ້',
	'cite' => 'ອ້າງອີງ',
	'cite_page' => 'ໜ້າ:',
);

/** Lithuanian (Lietuvių)
 * @author Garas
 */
$messages['lt'] = array(
	'cite_article_link' => 'Cituoti šį puslapį',
	'cite' => 'Cituoti',
	'cite_page' => 'Puslapis:',
	'cite_submit' => 'Cituoti',
);

/** Latvian (Latviešu)
 * @author Xil
 */
$messages['lv'] = array(
	'cite_article_link' => 'Atsauce uz šo lapu',
	'cite' => 'Citēšana',
	'cite_page' => 'Raksts:',
	'cite_submit' => 'Parādīt atsauci',
);

/** Classical Chinese (文言) */
$messages['lzh'] = array(
	'cite_article_link' => '引文',
	'cite' => '引文',
);

/** Eastern Mari (Олык Марий)
 * @author Сай
 */
$messages['mhr'] = array(
	'cite_page' => 'Лаштык:',
);

/** Macedonian (Македонски)
 * @author Brest
 * @author Misos
 */
$messages['mk'] = array(
	'cite_article_desc' => 'Додава специјална страница за [[Special:Cite|цитирање]] и врска кон алатникот.',
	'cite_article_link' => 'Цитирање на оваа страница',
	'cite' => 'Цитат',
	'cite_page' => 'Страница:',
	'cite_submit' => 'Цитат',
);

/** Malayalam (മലയാളം)
 * @author Shijualex
 */
$messages['ml'] = array(
	'cite_article_desc' => '[[Special:Cite|സൈറ്റേഷന്‍]] എന്ന പ്രത്യേക താളും, പണി സഞ്ചി  കണ്ണിയും ചേര്‍ക്കുന്നു',
	'cite_article_link' => 'ഈ താള്‍ ഉദ്ധരിക്കുക',
	'cite' => 'ഉദ്ധരിക്കുക',
	'cite_page' => 'താള്‍:',
	'cite_submit' => 'ഉദ്ധരിക്കുക',
);

/** Mongolian (Монгол) */
$messages['mn'] = array(
	'cite_article_link' => 'Энэ бичлэгийг эш татах',
);

/** Marathi (मराठी)
 * @author Kaustubh
 * @author Mahitgar
 */
$messages['mr'] = array(
	'cite_article_desc' => 'एक विशेष [[Special:Cite|बाह्यदुवे]] देणारे पान व टूलबॉक्सची लिंक तयार करा',
	'cite_article_link' => 'हे पान उधृत करा',
	'cite' => 'उधृत करा',
	'cite_page' => 'पान',
	'cite_submit' => 'उधृत करा',
);

/** Malay (Bahasa Melayu)
 * @author Aviator
 */
$messages['ms'] = array(
	'cite_article_desc' => 'Menambah laman khas dan pautan kotak alatan untuk [[Special:Cite|pemetikan]]',
	'cite_article_link' => 'Petik laman ini',
	'cite' => 'Petik',
	'cite_page' => 'Laman:',
	'cite_submit' => 'Petik',
);

/** Maltese (Malti)
 * @author Giangian15
 */
$messages['mt'] = array(
	'cite_page' => 'Paġna:',
);

/** Mirandese (Mirandés)
 * @author Malafaya
 */
$messages['mwl'] = array(
	'cite_page' => 'Páigina:',
);

/** Erzya (Эрзянь)
 * @author Amdf
 * @author Botuzhaleny-sodamo
 */
$messages['myv'] = array(
	'cite_page' => 'Лопась:',
);

/** Nahuatl (Nāhuatl)
 * @author Fluence
 */
$messages['nah'] = array(
	'cite_article_link' => 'Tlahtoa inīn tlahcuilōltechcopa',
	'cite' => 'Tlahtoa',
	'cite_page' => 'Zāzanilli:',
);

/** Min Nan Chinese (Bân-lâm-gú) */
$messages['nan'] = array(
	'cite_article_link' => 'Ín-iōng chit phiⁿ bûn-chiuⁿ',
	'cite' => 'Ín-iōng',
	'cite_page' => 'Ia̍h:',
	'cite_submit' => 'Ín-iōng',
);

/** Low German (Plattdüütsch)
 * @author Slomox
 */
$messages['nds'] = array(
	'cite_article_desc' => 'Föögt en [[Special:Cite|Spezialsied för Zitaten]] un en Lenk dorop in’n Kasten Warktüüch to',
	'cite_article_link' => 'Disse Siet ziteren',
	'cite' => 'Ziteerhelp',
	'cite_page' => 'Siet:',
	'cite_submit' => 'Ziteren',
);

/** Nepali (नेपाली) */
$messages['ne'] = array(
	'cite_article_link' => 'लेख उद्दरण गर्नुहोस्',
	'cite' => 'उद्दरण गर्नु',
	'cite_page' => 'पृष्ठ:',
);

/** Dutch (Nederlands)
 * @author Effeietsanders
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'cite_article_desc' => 'Voegt een [[Special:Cite|speciale pagina om te citeren]] toe, en een link ernaar in de hulpmiddelen',
	'cite_article_link' => 'Deze pagina citeren',
	'cite' => 'Citeren',
	'cite_page' => 'Pagina:',
	'cite_submit' => 'Citeren',
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Harald Khan
 * @author Jon Harald Søby
 */
$messages['nn'] = array(
	'cite_article_desc' => 'Legg til ei [[Special:Cite|siteringssida]] og lenkja i verktøy-menyen',
	'cite_article_link' => 'Siter denne sida',
	'cite' => 'Siter',
	'cite_page' => 'Side:',
	'cite_submit' => 'Siter',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Jon Harald Søby
 */
$messages['no'] = array(
	'cite_article_desc' => 'Legger til en [[Special:Cite|siteringsside]] og lenke i verktøy-menyen',
	'cite_article_link' => 'Siter denne siden',
	'cite' => 'Siter',
	'cite_page' => 'Side:',
	'cite_submit' => 'Siter',
);

/** Novial (Novial)
 * @author MF-Warburg
 */
$messages['nov'] = array(
	'cite_article_link' => 'Sita disi artikle',
	'cite' => 'Sita',
);

/** Northern Sotho (Sesotho sa Leboa)
 * @author Mohau
 */
$messages['nso'] = array(
	'cite_page' => 'Letlakala:',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'cite_article_desc' => "Apond una pagina especiala [[Special:Cite|citacion]] e un ligam dins la bóstia d'espleches",
	'cite_article_link' => 'Citar aqueste article',
	'cite' => 'Citacion',
	'cite_page' => 'Pagina :',
	'cite_submit' => 'Citar',
);

/** Ossetic (Иронау)
 * @author Amikeco
 */
$messages['os'] = array(
	'cite_page' => 'Фарс:',
);

/** Pangasinan (Pangasinan) */
$messages['pag'] = array(
	'cite_article_link' => 'Bitlaen yan article',
	'cite' => 'Bitlaen',
	'cite_page' => 'Bolong:',
	'cite_submit' => 'Bitlaen',
);

/** Pampanga (Kapampangan) */
$messages['pam'] = array(
	'cite_article_link' => 'Banggitan ya ing articulung ini',
	'cite' => 'Banggitan ya',
	'cite_page' => 'Bulung:',
	'cite_submit' => 'Banggitan me',
);

/** Pfälzisch (Pfälzisch)
 * @author SPS
 */
$messages['pfl'] = array(
	'cite' => 'Hilf zum Zidiere',
	'cite_submit' => 'Schbeichere',
);

/** Polish (Polski)
 * @author Sp5uhe
 */
$messages['pl'] = array(
	'cite_article_desc' => 'Dodaje stronę specjalną i guzik w toolbarze edycyjnym do obsługi [[Special:Cite|cytowania]]',
	'cite_article_link' => 'Odwołanie bibliograficzne',
	'cite' => 'Cytowanie',
	'cite_page' => 'Strona:',
	'cite_submit' => 'stwórz wpis bibliograficzny',
);

/** Piedmontese (Piemontèis)
 * @author Bèrto 'd Sèra
 */
$messages['pms'] = array(
	'cite_article_link' => 'Cita sta vos-sì',
	'cite' => 'Citassion',
	'cite_page' => 'Pàgina da cité:',
	'cite_submit' => 'Pronta la citassion',
);

/** Pontic (Ποντιακά)
 * @author Sinopeus
 */
$messages['pnt'] = array(
	'cite_page' => 'Σελίδα:',
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'cite_article_link' => 'د همدې ليکنې درک',
	'cite' => 'درک',
	'cite_page' => 'مخ:',
	'cite_submit' => 'درک لګول',
);

/** Portuguese (Português)
 * @author 555
 * @author Malafaya
 */
$messages['pt'] = array(
	'cite_article_desc' => 'Adiciona uma página especial de [[Special:Cite|citação]] & ligação da caixa de ferramentas',
	'cite_article_link' => 'Citar esta página',
	'cite' => 'Citar',
	'cite_page' => 'Página:',
	'cite_submit' => 'Citar',
);

/** Brazilian Portuguese (Português do Brasil)
 * @author Carla404
 */
$messages['pt-br'] = array(
	'cite_article_desc' => 'Adiciona uma página especial de [[Special:Cite|citação]] e link para a caixa de ferramentas',
	'cite_article_link' => 'Citar esta página',
	'cite' => 'Citar',
	'cite_page' => 'Página:',
	'cite_submit' => 'Citar',
);

/** Quechua (Runa Simi)
 * @author AlimanRuna
 */
$messages['qu'] = array(
	'cite_article_link' => 'Kay qillqamanta willay',
	'cite' => 'Qillqamanta willay',
	'cite_page' => "P'anqa:",
	'cite_submit' => 'Qillqamanta willay',
);

/** Rhaeto-Romance (Rumantsch) */
$messages['rm'] = array(
	'cite_page' => 'Pagina:',
);

/** Romani (Romani)
 * @author Desiphral
 */
$messages['rmy'] = array(
	'cite_article_link' => 'Prinjardo phandipen ko lekh',
	'cite' => 'Kana trebul phandipen',
	'cite_submit' => 'Ja',
);

/** Romanian (Română)
 * @author Emily
 * @author Firilacroco
 * @author KlaudiuMihaila
 * @author Mihai
 */
$messages['ro'] = array(
	'cite_article_desc' => 'Adaugă o pagină specială [[Special:Cite|citare]] şi o legătură cutie unelte',
	'cite_article_link' => 'Citează acest articol',
	'cite' => 'Citează',
	'cite_page' => 'Pagină:',
	'cite_submit' => 'Deschide informaţii',
);

/** Aromanian (Armãneashce) */
$messages['roa-rup'] = array(
	'cite_article_link' => 'Bagã articlu aistu ca tsitat',
);

/** Tarandíne (Tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'cite_article_desc' => "Aggiunge 'na pàgena speciele de [[Special:Cite|citaziune]] e collegamende a scatele de le struminde",
	'cite_article_link' => 'Cite sta pàgene',
	'cite' => 'Cite',
	'cite_page' => 'Pàgene:',
	'cite_submit' => 'Cite',
);

/** Russian (Русский)
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'cite_article_desc' => 'Добавляет служебную страницу [[Special:Cite|цитирования]] и ссылку в инструментах',
	'cite_article_link' => 'Цитировать страницу',
	'cite' => 'Цитирование',
	'cite_page' => 'Страница:',
	'cite_submit' => 'Процитировать',
);

/** Yakut (Саха тыла)
 * @author HalanTul
 */
$messages['sah'] = array(
	'cite_article_desc' => 'Аналлаах [[Special:Cite|быһа тардыы]] сирэйин уонна үнүстүрүмүөннэргэ ыйынньык эбэн биэрэр',
	'cite_article_link' => 'Сирэйи цитируйдааһын',
	'cite' => 'Цитата',
	'cite_page' => 'Сирэй:',
	'cite_submit' => 'Цитаата',
);

/** Sicilian (Sicilianu)
 * @author Santu
 */
$messages['scn'] = array(
	'cite_article_desc' => 'Junci na pàggina spiciali pi li [[Special:Cite|cosi di muntuari]] e nu lijami ntê strumenti',
	'cite_article_link' => 'Muntùa sta pàggina',
	'cite' => 'Muntuazzioni',
	'cite_page' => 'Pàggina di muntari',
	'cite_submit' => 'Cria la cosa di muntuari',
);

/** Sindhi (سنڌي) */
$messages['sd'] = array(
	'cite' => 'حواليو',
);

/** Sinhala (සිංහල)
 * @author නන්දිමිතුරු
 */
$messages['si'] = array(
	'cite_article_desc' => '[[Special:Cite|උපහරණ]] විශේෂ පිටුවක් හා මෙවලම්ගොන්න සබැඳියක් එක්කරයි',
	'cite_article_link' => 'මෙම පිටුව උපන්‍යාස කරන්න',
	'cite' => 'උපන්‍යාසය',
	'cite_page' => 'පිටුව:',
	'cite_submit' => 'උපන්‍යාසය',
);

/** Slovak (Slovenčina)
 * @author Helix84
 * @author Martin Kozák
 */
$messages['sk'] = array(
	'cite_article_desc' => 'Pridáva špeciálnu stránku [[Special:Cite|Citovať]] a odkaz v nástrojoch',
	'cite_article_link' => 'Citovať túto stránku',
	'cite' => 'Citovať',
	'cite_page' => 'Stránka:',
	'cite_submit' => 'Citovať',
);

/** Slovenian (Slovenščina)
 * @author Smihael
 */
$messages['sl'] = array(
	'cite_article_desc' => 'Doda [[Special:Cite|posebno stran za navedbo vira]] in povezavo v orodno vrstico',
	'cite_article_link' => 'Navedi to stran',
	'cite' => 'Navedi',
	'cite_page' => 'Stran:',
	'cite_submit' => 'Navedi',
);

/** Southern Sami (Åarjelsaemien)
 * @author M.M.S.
 */
$messages['sma'] = array(
	'cite_page' => 'Bielie:',
);

/** Shona (chiShona) */
$messages['sn'] = array(
	'cite_article_link' => 'Ita cite nyaya iyi',
);

/** Albanian (Shqip) */
$messages['sq'] = array(
	'cite_article_link' => 'Cito artikullin',
	'cite' => 'Citate',
	'cite_page' => 'Faqja:',
	'cite_submit' => 'Citoje',
);

/** Serbian Cyrillic ekavian (ћирилица)
 * @author Millosh
 * @author Sasa Stefanovic
 */
$messages['sr-ec'] = array(
	'cite_article_desc' => 'Додаје специјалну страну за [[Special:Cite|цитирање]] и везу ка оруђима.',
	'cite_article_link' => 'цитирање ове стране',
	'cite' => 'цитат',
	'cite_page' => 'Страна:',
	'cite_submit' => 'цитат',
);

/** Seeltersk (Seeltersk)
 * @author Pyt
 */
$messages['stq'] = array(
	'cite_article_desc' => 'Föiget ju [[Special:Cite|Zitierhilfe]]-Spezioalsiede un n Link in dän Kasten Reewen bietou',
	'cite_article_link' => 'Disse Siede zitierje',
	'cite' => 'Zitierhälpe',
	'cite_page' => 'Siede:',
	'cite_submit' => 'anwiese',
);

/** Sundanese (Basa Sunda)
 * @author Kandar
 */
$messages['su'] = array(
	'cite_article_desc' => 'Nambahkeun kaca husus [[Special:Cite|cutatan]] & tumbu toolbox',
	'cite_article_link' => 'Cutat kaca ieu',
	'cite' => 'Cutat',
	'cite_page' => 'Kaca:',
	'cite_submit' => 'Cutat',
);

/** Swedish (Svenska)
 * @author Lejonel
 * @author Sannab
 */
$messages['sv'] = array(
	'cite_article_desc' => 'Lägger till en specialsida för [[Special:Cite|källhänvisning]] och en länk i verktygslådan',
	'cite_article_link' => 'Citera denna artikel',
	'cite' => 'Citera',
	'cite_page' => 'Sida:',
	'cite_submit' => 'Citera',
);

/** Silesian (Ślůnski)
 * @author Herr Kriss
 * @author Timpul
 */
$messages['szl'] = array(
	'cite_article_link' => 'Cytuj ta zajta',
	'cite_page' => 'Zajta:',
);

/** Tamil (தமிழ்)
 * @author Trengarasu
 */
$messages['ta'] = array(
	'cite_article_desc' => 'கருவிப் பெட்டியில் [[Special:Cite|மேற்கோள்]] காடுவதற்கான இணைப்பை ஏற்படுத்துகிறது',
	'cite_article_link' => 'இப்பக்க்த்தை மேற்கோள் காட்டு',
	'cite' => 'மேற்கோள் காட்டு',
	'cite_page' => 'பக்கம்',
	'cite_submit' => 'மேற்கோள் காட்டு',
);

/** Telugu (తెలుగు)
 * @author Mpradeep
 * @author Veeven
 */
$messages['te'] = array(
	'cite_article_desc' => '[[Special:Cite|ఉదహరింపు]] అనే ప్రత్యేక పేజీని & పరికర పెట్టె లింకునీ చేరుస్తుంది',
	'cite_article_link' => 'ఈ వ్యాసాన్ని ఉదహరించండి',
	'cite' => 'ఉదహరించు',
	'cite_page' => 'పేజీ:',
	'cite_submit' => 'ఉదహరించు',
);

/** Tetum (Tetun)
 * @author MF-Warburg
 */
$messages['tet'] = array(
	'cite_article_desc' => 'Kria pájina espesíal ba [[Special:Cite|sitasaun]] ho ligasaun iha kaixa besi nian',
	'cite_article_link' => "Sita pájina ne'e",
	'cite' => 'Sita',
	'cite_page' => 'Pájina:',
	'cite_submit' => 'Sita',
);

/** Tajik (Cyrillic) (Тоҷикӣ (Cyrillic))
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'cite_article_desc' => 'Саҳифаи вижае барои [[Special:Cite|ёдкард]] изофа мекунад ва пайванде ба ҷаъбаи абзор меафзояд',
	'cite_article_link' => 'Ёд кардани пайванди ин мақола',
	'cite' => 'Ёд кардани ин мақола',
	'cite_page' => 'Саҳифа:',
	'cite_submit' => 'Ёд кардан',
);

/** Thai (ไทย)
 * @author Passawuth
 */
$messages['th'] = array(
	'cite_article_link' => 'อ้างอิงหน้านี้',
	'cite' => 'อ้างอิง',
	'cite_page' => 'หน้า:',
	'cite_submit' => 'อ้างอิง',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'cite_article_desc' => 'Nagdaragdag ng isang natatanging pahinang [[Special:Cite|pampagtutukoy]] at kawing sa kahon (lalagyan) ng kagamitan',
	'cite_article_link' => 'Tukuyin ang pahinang ito',
	'cite' => 'Tukuyin',
	'cite_page' => 'Pahina:',
	'cite_submit' => 'Tukuyin',
);

/** Tswana (Setswana) */
$messages['tn'] = array(
	'cite_article_link' => 'Nopola mokwalo o',
);

/** Tonga (faka-Tonga) */
$messages['to'] = array(
	'cite_article_link' => 'Lau ki he kupú ni',
	'cite' => 'Lau ki he',
);

/** Turkish (Türkçe)
 * @author Erkan Yilmaz
 * @author Joseph
 * @author Srhat
 * @author Uğur Başak
 */
$messages['tr'] = array(
	'cite_article_desc' => '[[Special:Cite|Alıntı]] özel sayfa ve araç kutusu linkini ekler',
	'cite_article_link' => 'Sayfayı kaynak göster',
	'cite' => 'Kaynak göster',
	'cite_page' => 'Sayfa:',
	'cite_submit' => 'Belirt',
);

/** Tsonga (Xitsonga)
 * @author Thuvack
 */
$messages['ts'] = array(
	'cite_page' => 'Tluka:',
);

/** Udmurt (Удмурт)
 * @author ОйЛ
 */
$messages['udm'] = array(
	'cite_article_link' => 'Кызьы со статьяез цитировать кароно',
);

/** Uighur (Latin) (Uyghurche‎ / ئۇيغۇرچە (Latin))
 * @author Jose77
 */
$messages['ug-latn'] = array(
	'cite_page' => 'Bet:',
);

/** Ukrainian (Українська)
 * @author Ahonc
 */
$messages['uk'] = array(
	'cite_article_desc' => 'Додає спеціальну сторінку [[Special:Cite|цитування]] і посилання в інструментах',
	'cite_article_link' => 'Цитувати сторінку',
	'cite' => 'Цитування',
	'cite_page' => 'Сторінка:',
	'cite_submit' => 'Процитувати',
);

/** Urdu (اردو) */
$messages['ur'] = array(
	'cite_article_link' => 'مضمون کا حوالہ دیں',
	'cite' => 'حوالہ',
	'cite_page' => 'صفحہ:',
);

/** Vèneto (Vèneto)
 * @author Candalua
 */
$messages['vec'] = array(
	'cite_article_desc' => 'Zonta na pagina speciale par le [[Special:Cite|citazion]] e un colegamento nei strumenti',
	'cite_article_link' => 'Cita sta pagina',
	'cite' => 'Citazion',
	'cite_page' => 'Pagina da citar:',
	'cite_submit' => 'Crea la citazion',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 * @author Vinhtantran
 */
$messages['vi'] = array(
	'cite_article_desc' => 'Thêm trang đặc biệt để [[Special:Cite|ghi chú bài]] và đặt liên kết đến nó trong thanh công cụ',
	'cite_article_link' => 'Chú thích trang này',
	'cite' => 'Chú thích',
	'cite_page' => 'Trang:',
	'cite_submit' => 'Chú thích',
);

/** Volapük (Volapük)
 * @author Malafaya
 * @author Smeira
 */
$messages['vo'] = array(
	'cite_article_desc' => 'Läükon padi patik [[Special:Cite|saitama]] sa yüm ad stumem',
	'cite_article_link' => 'Saitön padi at',
	'cite' => 'Saitön',
	'cite_page' => 'Pad:',
	'cite_submit' => 'Saitön',
);

/** Walloon (Walon)
 * @author Srtxg
 */
$messages['wa'] = array(
	'cite_page' => 'Pådje:',
);

/** Wu (吴语) */
$messages['wuu'] = array(
	'cite_article_link' => '引用该篇文章',
	'cite' => '引用',
	'cite_page' => '页面:',
	'cite_submit' => '引用',
);

/** Yiddish (ייִדיש)
 * @author פוילישער
 */
$messages['yi'] = array(
	'cite_article_link' => 'ציטירן דעם דאזיגן בלאט',
	'cite' => 'ציטיר',
);

/** Yue (粵語) */
$messages['yue'] = array(
	'cite_article_desc' => '加一個[[Special:Cite|引用]]特別頁同埋一個工具箱連結',
	'cite_article_link' => '引用呢篇文',
	'cite' => '引用文章',
	'cite_page' => '版：',
	'cite_submit' => '引用',
);

/** Simplified Chinese (‪中文(简体)‬) */
$messages['zh-hans'] = array(
	'cite_article_desc' => '增加[[Special:Cite|引用]]特殊页面以及工具箱链接',
	'cite_article_link' => '引用此文',
	'cite' => '引用文章',
	'cite_page' => '页面：',
	'cite_submit' => '引用',
);

/** Traditional Chinese (‪中文(繁體)‬) */
$messages['zh-hant'] = array(
	'cite_article_desc' => '增加[[Special:Cite|引用]]特殊頁面以及工具箱連結',
	'cite_article_link' => '引用此文',
	'cite' => '引用文章',
	'cite_page' => '頁面：',
	'cite_submit' => '引用',
);

