#!/usr/bin/python
import pygtk
pygtk.require('2.0')

import gconf
import gtk
import gnome.ui
import gnome.applet
import configmbox
import os
import re

import copy

mbox_mails_from={}

mbox_nmails_total={}
mbox_nmails_read={}

indicators_nmails_total={}
indicators_nmails_read={}

widgets_list=[]

mboxcheck_applet_menu_xml = '<popup name="button3">' \
                       '  <menuitem name="Settings"'\
                       '            verb="MenuSettings"'\
                       '            label="Config"'\
                       '            pixtype="stock"'\
                       '            pixname="gtk-properties"/>'\
                       '  <menuitem name="About"'\
                       '            verb="MenuAbout"'\
                       '            label="About ..."'\
                       '            pixtype="stock"'\
                       '            pixname="gnome-stock-about"/>'\
                       '</popup>'

def config_ok(fct_mbox2check, fct_indicators, fct_indicators_names, fct_time, fct_tooltips_infos, fct_run_infos, fct_run_list, apply):

    global mbox2check, indicators_names, indicators, time, tooltips_infos, run_infos, run_list, timeout_id, tooltips, hbox, config_run, gconf_client

    config_run = 0
    mbox2check = fct_mbox2check
    indicators = fct_indicators
    indicators_names = fct_indicators_names
    time = fct_time
    tooltips_infos = fct_tooltips_infos
    run_infos = fct_run_infos
    run_list = fct_run_list

    if(apply==gtk.FALSE):
        return

    gconf_client.set_int("/apps/mbox-check-applet/time2check", int(time))
    gconf_client.set_list("/apps/mbox-check-applet/run_infos", gconf.VALUE_BOOL, run_infos)
    gconf_client.set_list("/apps/mbox-check-applet/run_list", gconf.VALUE_STRING, run_list)

    if(tooltips_infos[0]==True):
        tooltips.enable()
    else:
        tooltips.disable()
    
    i = len(widgets_list)-1

    if(i==-1):
        label = hbox.get_children()[0]
        hbox.remove(label)
        label.destroy()

    if(indicators_names == []):
        label=gtk.Label("E")
        hbox.pack_start(label, gtk.TRUE, gtk.TRUE, 0)
    
    while(i >= 0):
        widget = widgets_list[i]
        hbox.remove(widget)
        widgets_list.remove(widget)
        widget.get_child()
        widget.destroy()
        i = i - 1  

    for name in indicators_names:
        if(indicators[name][0]):
            num = 0
            str_tooltip = ""
            if(tooltips_infos[1]==True):            
                str_tooltip = str_tooltip + "Name: " + str_tooltip + name
            if(tooltips_infos[2]==True):            
                str_tooltip = str_tooltip + "\n\nNumber of mails : " + str(int(indicators_nmails_total[name])-int(indicators_nmails_read[name])) + "/" + str(indicators_nmails_total[name])
            if(tooltips_infos[3]==True):            
                str_tooltip = str_tooltip + "\n\nList of mboxes : \n"
                for mbox in indicators[name][2]:
                    if mbox_nmails_read.has_key(mbox):
                        str_tooltip = str_tooltip + mbox + "  (" + str(int(mbox_nmails_total[mbox])-int(mbox_nmails_read[mbox])) + "/" + str(mbox_nmails_total[mbox])+ ")\n"
                    else:
                        str_tooltip = str_tooltip + mbox + "\n"
            if(indicators[name][1]=="text"):
                label = gtk.Label(str(num))
                event_box = gtk.EventBox()
                tooltips.set_tip(event_box, str_tooltip)
                event_box.add(label)
                widgets_list.append(event_box)
            elif(indicators[name][1]=="pixmap"):
                image = gtk.Image()
                event_box = gtk.EventBox()
                if(int(num)==0):
                    image.set_from_stock(gtk.STOCK_NO, gtk.ICON_SIZE_MENU)
                else:
                    image.set_from_stock(gtk.STOCK_YES, gtk.ICON_SIZE_MENU)
                tooltips.set_tip(event_box, str_tooltip)
                event_box.add(image)
                widgets_list.append(event_box)

    for widgets in widgets_list:
        hbox.pack_start(widgets, gtk.TRUE, gtk.TRUE, 0)

    hbox.show_all()

    gtk.timeout_remove(timeout_id)
    check_mail(0)
    timeout_id = gtk.timeout_add(int(time)*1000, check_mail, 0)
    
def menu_settings_cb(component, data, verbname):
    global config_run
    if(config_run == 0):
        config_run = 1
        configmbox.configmbox(config_ok, gconf_client, copy.deepcopy(mbox2check), copy.deepcopy(indicators_names), copy.deepcopy(indicators), time, copy.deepcopy(tooltips_infos), copy.deepcopy(run_infos), copy.deepcopy(run_list))

def menu_settings_about(component, data, verbname):
    logo_app = gtk.gdk.pixbuf_new_from_file("/usr/share/pixmaps/mboxcheck.png")

    about_box = gnome.ui.About("Mbox check", "0.3", "Copyright 2003 Sebastien Bacher", "Check a list of mboxes and notify you when new mail arrives", ["Sebastien Bacher <seb128@debian.org>"], [],"", logo_app)
    about_box.show_all()

mboxcheck_applet_menu_verbs = [
    ('MenuSettings', menu_settings_cb),
    ('MenuAbout', menu_settings_about),
]

def check_mail(data):
    global tooltips
    global total_mails_old
    
    total_mails=0
    total_mails_read=0

    for mbox_name in mbox2check:
        n_mail_total=0
        n_mail_read=0
        n_mail=0
        
        if(not os.path.isfile(mbox_name)):
            print "Not a file (", mbox_name, ")"
            continue
        
        try:
            stats_fich=os.stat(mbox_name)
        except OSError:
            print "Error : ", mbox_name
            continue
        
        try:
            file = open(mbox_name, "r")
        except:
            print "Open error: ", mbox_name
            continue

        mbox_mails_from[mbox_name]=[]
        for line in file.readlines():
            any_from = re.search("^From (\S*) ", line)
            if(any_from):
                n_mail_total = n_mail_total + 1
                total_mails = total_mails + 1
                mbox_mails_from[mbox_name].append(any_from.group(1))
                # evolution read hack
            if (line.startswith("X-Evolution: ")):
                if (line[24:25] == "1") or (line[24:25] == "3"):
                    n_mail_total = n_mail_total - 1
            any_status = re.search("^Status:.*R.*", line)
            if(any_status):
                total_mails_read = total_mails_read + 1
                n_mail_read = n_mail_read + 1
                
        if(stats_fich.st_size!=0):
            if(stats_fich.st_atime>stats_fich.st_mtime):
                # mbox already opened
                pass
            else:
                # mbox not yet opened
                pass
        else:
            # no mail
            pass
        mbox_nmails_total[mbox_name]=n_mail_total
        mbox_nmails_read[mbox_name]=n_mail_read

    n=0
    for name in indicators_names:
        num_t=0
        num_r=0
        
        for mbox in indicators[name][2]:
            if(mbox_nmails_total.has_key(mbox)):
               num_t = num_t + mbox_nmails_total[mbox]
               num_r = num_r + mbox_nmails_read[mbox]
        widget = widgets_list[n].get_child()
        if(type(widget)==gtk.Label):
            widget.set_label(str(num_t - num_r))
        elif(type(widget)==gtk.Image):
            if((num_t - num_r) == 0):
                widget.set_from_stock(gtk.STOCK_NO, gtk.ICON_SIZE_MENU)
            else:
                widget.set_from_stock(gtk.STOCK_YES, gtk.ICON_SIZE_MENU)
        indicators_nmails_total[name]=str(num_t)
        indicators_nmails_read[name]=str(num_r)
        str_tooltip = ""
        if(tooltips_infos[1]==True):            
            str_tooltip = str_tooltip + "Name: " + str_tooltip + name
        if(tooltips_infos[2]==True):            
            str_tooltip = str_tooltip + "\n\nNumber of mails : " + str(int(indicators_nmails_total[name])-int(indicators_nmails_read[name])) + "/" + str(indicators_nmails_total[name])
        if(tooltips_infos[3]==True):            
            str_tooltip = str_tooltip + "\n\nList of mboxes : \n"
            for mbox in indicators[name][2]:
                if mbox_nmails_read.has_key(mbox):
                    str_tooltip = str_tooltip + mbox + "  (" + str(int(mbox_nmails_total[mbox])-int(mbox_nmails_read[mbox])) + "/" + str(mbox_nmails_total[mbox])+ ")\n"
                else:
                    str_tooltip = str_tooltip + mbox + "\n"

        tooltips.set_tip(widgets_list[n], str_tooltip)
        n=n+1
    if(total_mails_old != total_mails and total_mails!=0):
        if(run_infos[0] == True):
            value = os.fork()
            if(value == 0):
                os.system(run_list[0])
        total_mails_old = total_mails
    return True

def click_on_panel(applet, event, data):
    global run_infos, run_list
    if(event.type == gtk.gdk._2BUTTON_PRESS):
        if(run_infos[1] == True):
            value = os.fork()
            if(value == 0):
                os.system(run_list[1])
               
def mboxcheck_factory(applet, iid):

    global gconf_client, mbox2check, indicators_names, indicators, time, tooltips_infos, run_infos, run_list, timeout_id, hbox, config_run
    global total_mails_old
    
    total_mails_old=0
    config_run=0

    # Get the default client
    gconf_client = gconf.client_get_default ();

    gconf_client.add_dir ("/apps/mbox-check-applet", gconf.CLIENT_PRELOAD_NONE)        

    tooltips_infos = gconf_client.get_list("/apps/mbox-check-applet/tooltips_infos", gconf.VALUE_BOOL)
    if(len(tooltips_infos) != 4):
       tooltips_infos = [True, True, True, True]
       print "tooltips_infos init"
 
    run_infos = gconf_client.get_list("/apps/mbox-check-applet/run_infos", gconf.VALUE_BOOL)
    if(len(run_infos) != 2):
       run_infos = [False, False]
       print "run_infos init"

    run_list = gconf_client.get_list("/apps/mbox-check-applet/run_list", gconf.VALUE_STRING)
    if(len(run_list) != 2):
       run_list = ["", ""]
       print "run_list init"


    # List of mboxes to check
    mbox2check = gconf_client.get_list("/apps/mbox-check-applet/mbox2check", gconf.VALUE_STRING)
    
    # List of indicators
    indicators_names = gconf_client.get_list("/apps/mbox-check-applet/indicators_names", gconf.VALUE_STRING)

    # Datas for indicators
    indicators={}
    for data in indicators_names:
        activate = gconf_client.get_bool("/apps/mbox-check-applet/"+data+"/activate")
        type = gconf_client.get_string("/apps/mbox-check-applet/"+data+"/type")
        list = gconf_client.get_list("/apps/mbox-check-applet/"+data+"/list_of_mbox", gconf.VALUE_STRING)
        indicators[data] = [activate, type, list]
        indicators_nmails_total[data]=0
        indicators_nmails_read[data]=0
    #print "indicators: ", indicators

    time = gconf_client.get_int("/apps/mbox-check-applet/time2check")
    print "temps ", time

    # default to 30s
    if(time==0):
        time=30

    global tooltips
    tooltips = gtk.Tooltips()
    if(tooltips_infos[0]==True):
        tooltips.enable()
    else:
        tooltips.disable()
    
    hbox=gtk.HBox(gtk.FALSE, 4)

    for name in indicators_names:
        if(indicators[name][0]):
            str_tooltip = ""
            if(tooltips_infos[1]==True):            
                str_tooltip = str_tooltip + "Name: " + str_tooltip + name
            if(tooltips_infos[2]==True):            
                str_tooltip = str_tooltip + "\n\nNumber of mails : " + str(int(indicators_nmails_total[name])-int(indicators_nmails_read[name])) + "/" + str(indicators_nmails_total[name])
            if(tooltips_infos[3]==True):            
                str_tooltip = str_tooltip + "\n\nList of mboxes : \n"
                for mbox in indicators[name][2]:
                    if mbox_nmails_read.has_key(mbox):
                        str_tooltip = str_tooltip + mbox + "  (" + str(int(mbox_nmails_total[mbox])-int(mbox_nmails_read[mbox])) + "/" + str(mbox_nmails_total[mbox])+ ")\n"
                    else:
                        str_tooltip = str_tooltip + mbox + "\n"

            if(indicators[name][1]=="text"):
                label = gtk.Label("?")
                event_box = gtk.EventBox()
                tooltips.set_tip(event_box, str_tooltip)
                event_box.add(label)
                widgets_list.append(event_box)
            elif(indicators[name][1]=="pixmap"):
                image = gtk.Image()
                event_box = gtk.EventBox()
                image.set_from_stock(gtk.STOCK_CANCEL, gtk.ICON_SIZE_MENU)
                tooltips.set_tip(event_box, str_tooltip)
                event_box.add(image)
                widgets_list.append(event_box)

    if(indicators_names == []):
        label=gtk.Label("E")
        hbox.pack_start(label, gtk.TRUE, gtk.TRUE, 0)
    
    for widgets in widgets_list:
        hbox.pack_start(widgets, gtk.TRUE, gtk.TRUE, 0)

    applet.add(hbox)

    # setup menu
    applet.setup_menu(mboxcheck_applet_menu_xml, mboxcheck_applet_menu_verbs, 0)

    check_mail(0)
    timeout_id = gtk.timeout_add(time*1000, check_mail, 0)

    applet.show_all()
    applet.connect("button-press-event", click_on_panel, 0)

    return gtk.TRUE

gnome.applet.bonobo_factory("OAFIID:GNOME_MboxCheck_Factory", 
                             gnome.applet.Applet.__gtype__, 
                             "Mbox check", "0", mboxcheck_factory)
