(* Copyright (C) 2004-2005, HELM Team.
 * 
 * This file is part of HELM, an Hypertextual, Electronic
 * Library of Mathematics, developed at the Computer Science
 * Department, University of Bologna, Italy.
 * 
 * HELM is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * HELM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HELM; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA  02111-1307, USA.
 * 
 * For details, see the HELM World-Wide-Web page,
 * http://helm.cs.unibo.it/
 *)

(** raised when ambiguous input is found but not expected (e.g. in the batch
  * compiler) *)
exception Ambiguous_input
(* the integer is an offset to be added to each location *)
exception DisambiguationError of
 int *
 ((Stdpp.location list * string * string) list *
  (DisambiguateTypes.domain_item * DisambiguateTypes.codomain_item) list *
  Stdpp.location option * string Lazy.t * bool) list list
  (** parameters are: option name, error message *)

(** initially false; for debugging only (???) *)
val only_one_pass: bool ref

type choose_uris_callback = id:string -> UriManager.uri list -> UriManager.uri list
type choose_interp_callback = 
  string -> int -> (Stdpp.location list * string * string) list list -> 
    int list

val set_choose_uris_callback:   choose_uris_callback -> unit
val set_choose_interp_callback: choose_interp_callback -> unit

(** @raise Ambiguous_input if called, default value for internal
  * choose_uris_callback if not set otherwise with set_choose_uris_callback
  * above *)
val mono_uris_callback: choose_uris_callback

(** @raise Ambiguous_input if called, default value for internal
  * choose_interp_callback if not set otherwise with set_choose_interp_callback
  * above *)
val mono_interp_callback: choose_interp_callback

(** for GUI callbacks see MatitaGui.interactive_{interp,user_uri}_choice *)

include Disambiguate.Disambiguator
