/* This file is part of the KDE project
   Copyright (C) 2006-2007 KovoKs <info@kovoks.nl>
   Copyright (C) 2007 Frode M. Døving <frode@lnix.net>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/


#include <kabc/stdaddressbook.h>
#include <kapplication.h>
#include <krun.h>
#include <klocale.h>
#include "../libkmime/kmime_headers.h"
#include "addressbook.h"

namespace Mailody {

Addressbook *Addressbook::m_instance = 0;

Addressbook::Addressbook( QObject *parent, const char *name )
    : QObject( parent, name )
{
    m_ab = KABC::StdAddressBook::self(true);
}

Addressbook::~Addressbook()
{
    delete m_ab;
}

Addressbook* Addressbook::instance()
{
    if ( !m_instance )
        m_instance = new Addressbook();
    return m_instance;
}

void Addressbook::add(const QString& name)
{
    kdDebug() << k_funcinfo << name << endl;

    using namespace KABC;
    QString uid;

    // First search for the emailaddress
    KMime::Headers::AddressField* af =
            new KMime::Headers::AddressField();
    af->fromUnicodeString(name,"");
    Addressee::List a(m_ab->findByEmail(af->email()));
    if (a.count() > 0)
    {
        kdDebug() << "Address exists" << endl;
        uid = a[0].uid();
    }
    else
    {
        // not found? add it
        kdDebug() << "Address does not exists" << endl;

        KABC::Addressee addr;
        addr.setNameFromString( af->name() );
        addr.insertEmail( af->email(), true );

        m_ab->insertAddressee(addr);
        KABC::Ticket *ticket = m_ab->requestSaveTicket( addr.resource() );
        if ( ticket )
            m_ab->save( ticket );

        uid = addr.uid();
        kdDebug() << "new uid: " << uid << endl;
    }

    // Open it
    if (!uid.isEmpty())
        KRun::runCommand("kaddressbook --uid " + uid);
}

Addressee::List Addressbook::findByEmail(const QString& email)
{
    return m_ab->findByEmail(email);
}


}
