/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file IsoHighlightAttributes.h
    \brief Definition of IsoHighlight Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:39 2011
*/
   

#ifndef IsoHighlightAttributes_H
#define IsoHighlightAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class IsoHighlightAttributes 
{
public:
//  --  constructor
    IsoHighlightAttributes();
    
//  --  destructor
    virtual ~IsoHighlightAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const IsoHighlightAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Style of highlighting (SOLID/ DASH/ DOT/ CHAIN_DASH/ CHAIN_DOT) 
    \param style Setting contour_highlight_style - default=solid
*/
	void setStyle(LineStyle style) 
		{ style_ =  style; } 
	LineStyle getStyle() const 
		{ return style_; } 
        
/*!
    Magics Information:
    \brief  Contour level reference 
    \param reference Setting contour_reference_level - default=0.0
*/
	void setReference(double reference) 
		{ reference_ =  reference; } 
	double getReference() const 
		{ return reference_; } 
        
/*!
    Magics Information:
    \brief  Colour of highlight line 
    \param colour Setting contour_highlight_colour - default=blue
*/
	void setColour(Colour* colour) 
		{ auto_ptr<Colour> tmp(colour); colour_ = tmp; } 
	const Colour&  getColour() const 
		{ return *colour_; }
/*!
    Magics Information:
    \brief  Thickness of highlight line 
    \param thickness Setting contour_highlight_thickness - default=3
*/
	void setThickness(int thickness) 
		{ thickness_ =  thickness; } 
	int getThickness() const 
		{ return thickness_; } 
        
/*!
    Magics Information:
    \brief  Frequency of highlight line 
    \param frequency Setting contour_highlight_frequency - default=4
*/
	void setFrequency(int frequency) 
		{ frequency_ =  frequency; } 
	int getFrequency() const 
		{ return frequency_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	LineStyle style_;
	double reference_;
	auto_ptr<Colour> colour_;
	int thickness_;
	int frequency_;

private:
  
	friend ostream& operator<<(ostream& s,const IsoHighlightAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
