/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file CurveMethod.h
    \brief Definition of the Template class CurveMethod.
    
    Magics Team - ECMWF 2004
    
    Started: Wed 5-May-2004
    
    Changes:
    
*/

#ifndef CurveMethod_H
#define CurveMethod_H

#include "magics.h"
#include "Factory.h"
#include "MagTranslator.h"


namespace magics {
	
class XmlNode;

class CurveMethod {

public:
	CurveMethod();
	virtual ~CurveMethod();
        // Implements the set method ... 
	virtual void set(const map<string, string>& ) {}
	virtual void set(const XmlNode& ) {}
	 virtual void toxml(ostream&, int)  const {}
	 virtual bool accept(const string&)  { return true; }
	virtual CurveMethod* clone() const { return new CurveMethod(); }
protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream&) const; 

private:
	//! Copy constructor - No copy allowed
	CurveMethod(const CurveMethod&);
	//! Overloaded << operator to copy - No copy allowed
	CurveMethod& operator=(const CurveMethod&);

// -- Friends
	//! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const CurveMethod& p)
		{ p.print(s); return s; }

};
template<>
class MagTranslator<string, CurveMethod> { 
public:
	CurveMethod* operator()(const string& val ) {
		 return SimpleObjectMaker<CurveMethod>::create(val);
	}
	 
	CurveMethod* magics(const string& param)
	{
		CurveMethod* object;
		ParameterManager::update(param, object);
		return object;
	}
};

} // namespace magics
#endif
