/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisTipAttributes.cc
    \brief Implemtation of AxisTip Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Tue Nov 22 10:53:40 2011
*/    

#include "AxisTipAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


AxisTipAttributes::AxisTipAttributes():
	orientation_(ParameterManager::getString("axis_tip_title_orientation")),
	colour_(MagTranslator<string, Colour>().magics("axis_tip_title_colour")),
	height_(ParameterManager::getDouble("axis_tip_title_height")),
	quality_(ParameterManager::getString("axis_tip_title_quality")),
	text_(ParameterManager::getString("axis_tip_title_text"))
{
} 



AxisTipAttributes::~AxisTipAttributes()
{
}

    
void AxisTipAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "axis_tip";
	prefix[1] = "axis";

	setAttribute(prefix, "axis_tip_title_orientation", orientation_, params);
	setAttribute(prefix, "axis_tip_title_colour", colour_, params);
	setAttribute(prefix, "axis_tip_title_height", height_, params);
	setAttribute(prefix, "axis_tip_title_quality", quality_, params);
	setAttribute(prefix, "axis_tip_title_text", text_, params);
}

void AxisTipAttributes::copy(const AxisTipAttributes& other)
{
	orientation_ = other.orientation_;
	setColour(other.colour_->clone());
	height_ = other.height_;
	quality_ = other.quality_;
	text_ = other.text_;
} 


bool AxisTipAttributes::accept(const string& node)
{	
	if ( magCompare(node, "tip")  )
		return true;
	return false;
}

void AxisTipAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "tip") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void AxisTipAttributes::print(ostream& out)  const
{
	out << "AxisTipAttributes[";
	out << "orientation = " << orientation_;
	out << ", colour = " << *colour_;
	out << ", height = " << height_;
	out << ", quality = " << quality_;
	out << ", text = " << text_;
	out << "]" << "\n";
}


void AxisTipAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"tip\"";
	 out << ", \"axis_tip_title_orientation\":";
	 niceprint(out,orientation_);
	 out << ", \"axis_tip_title_colour\":";
	 niceprint(out, *colour_);
	 out << ", \"axis_tip_title_height\":";
	 niceprint(out,height_);
	 out << ", \"axis_tip_title_quality\":";
	 niceprint(out,quality_);
	 out << ", \"axis_tip_title_text\":";
	 niceprint(out,text_);
}
static MagicsParameter<string> axis_tip_title_orientation("axis_tip_title_orientation", "horizontal", "");
static MagicsParameter<string> axis_tip_title_colour("axis_tip_title_colour", "automatic", "");
static MagicsParameter<double> axis_tip_title_height("axis_tip_title_height", 0.4, "");
static MagicsParameter<string> axis_tip_title_quality("axis_tip_title_quality", "sansserif", "");
static MagicsParameter<string> axis_tip_title_text("axis_tip_title_text", " ", "");
