/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file NetcdfVectorInterpretorAttributes.h
    \brief Definition of NetcdfVectorInterpretor Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:39 2011
*/
   

#ifndef NetcdfVectorInterpretorAttributes_H
#define NetcdfVectorInterpretorAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class NetcdfVectorInterpretorAttributes 
{
public:
//  --  constructor
    NetcdfVectorInterpretorAttributes();
    
//  --  destructor
    virtual ~NetcdfVectorInterpretorAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const NetcdfVectorInterpretorAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief Variable name representing the x component of the vector
    \param x_component Setting netcdf_x_component_variable - default=
*/
	void setX_component(const string& x_component) 
		{ x_component_ =  x_component; } 
	const string& getX_component() const 
		{ return x_component_; } 
        
/*!
    Magics Information:
    \brief Variable name representing the y component of the vector
    \param y_component Setting netcdf_y_component_variable - default=
*/
	void setY_component(const string& y_component) 
		{ y_component_ =  y_component; } 
	const string& getY_component() const 
		{ return y_component_; } 
        
/*!
    Magics Information:
    \brief Variable name representing the x dimension
    \param y Setting netcdf_y_position_variable - default=y
*/
	void setY(const string& y) 
		{ y_ =  y; } 
	const string& getY() const 
		{ return y_; } 
        
/*!
    Magics Information:
    \brief Variable name representing the y dimension
    \param x Setting netcdf_x_position_variable - default=x
*/
	void setX(const string& x) 
		{ x_ =  x; } 
	const string& getX() const 
		{ return x_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string x_component_;
	string y_component_;
	string y_;
	string x_;

private:
  
	friend ostream& operator<<(ostream& s,const NetcdfVectorInterpretorAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
