/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file NetcdfOrcaInterpretor.h
    \brief Implementation of the Template class NetcdfOrcaInterpretor.
    
    Magics Team - ECMWF 2004
    
    Started: Tue 17-Feb-2004
    
    Changes:
    
*/

#include "NetcdfOrcaInterpretor.h"
#include "Factory.h"
#include "Netcdf.h"
#include <limits>

using namespace magics;

NetcdfOrcaInterpretor::NetcdfOrcaInterpretor() 
{}


NetcdfOrcaInterpretor::~NetcdfOrcaInterpretor() 
{}

void NetcdfOrcaInterpretor::interpretAsMatrix(Matrix** data)
{
	
	if ( *data ) return;
	

	
	    
		
	  
		Netcdf netcdf(path_);
		
		
		int jm = netcdf.getDimension("y");
		int im = netcdf.getDimension("x");
		
		Matrix* matrix = new Matrix(jm, im);
		
		*data = matrix;
		double m = std::numeric_limits<double>::max();
		matrix->missing(std::numeric_limits<double>::max());
		string missing = netcdf.getVariableAttribute(field_, missing_attribute_, "");
		if ( !missing.empty() ) {
			std::stringstream ss(missing);
			ss >> m;
		}
		matrix->missing(m);
		// get the data ...
		try
		{
			
					map<string, string> first, last;
					setDimensions(dimension_, first, last);



					MagLog::debug() << "data[" << matrix->size() << ":" << *std::min_element(matrix->begin(), matrix->end()) << ", " << offset_ << "\n";


					vector<double> latm;
					vector<double> lonm;
					netcdf.get(longitude_, lonm, first, last);
					netcdf.get(latitude_,  latm, first, last);

					vector<double>& lon = matrix->columnsAxis();
					vector<double>& lat = matrix->rowsAxis();

					// for the lon we take the fisrt line :
					for (int i = 0; i < im; i++)
						lon.push_back(lonm[i]);
					// for the lon we take the fisrt column :
					for (int i = 0; i < jm; i++)
						lat.push_back(latm[i * im]);

					 matrix->setMapsAxis();

					 vector<double> data;
					 netcdf.get(field_, data, first, last);
					 for (vector<double>::iterator d = data.begin(); d != data.end(); ++d ) {
					 				if ( same(*d, m) ) {
					 					matrix->push_back(m);
					 				}
					 				else
					 					matrix->push_back(*d);

					 			}
					


					//matrix->getReady();
					//matrix->multiply(scaling_);
					//matrix->plus(offset_);
					
	        
			MagLog::dev() << *matrix << "\n";
			
		}
	    
		catch (MagicsException& e)
		{
			MagLog::error() << e << "\n";
		}
}


void NetcdfOrcaInterpretor::interpretAsPoints(PointsList<GeoPoint>& points)
{
	
    Matrix latitudes;
    Matrix longitudes;
	Matrix matrix;
	
	matrix.missing(std::numeric_limits<double>::max());
	// later!
#ifdef later
	// get the data ...
	try
	{
		MagLog::dev() << " Netcdf File Path --->" << path_ << "\n";
		Netcdf netcdf(path_);
		map<string, string> first, last;
		setDimensions(dimension_, first, last);
       
		netcdf.get(field_, matrix, first, last);
		MagLog::debug() << "data[" << matrix->size() << ":" << scaling_ << ", " << offset_ << "\n";

		matrix->multiply(scaling_);
		matrix->plus(offset_);
		vector<double> rows, columns;
	
		
		for (int i = 0; i < netcdf.getDimension(x_); i++)
			columns.push_back(i);
	   
	    for (int i = 0; i < netcdf.getDimension(y_); i++)
			rows.push_back(i);

		matrix->setRowsAxis(rows);
		matrix->setColumnsAxis(columns);
		
		
		
	 
		MagLog::debug() << "data[" << matrix->size() << ", " << scaling_ << ", " << offset_ << "]" << "\n";
        
		netcdf.get(longitude_,longitudes, first, last);
		netcdf.get(latitude_, latitudes, first, last);
		
		longitudes.setRowsAxis(rows);
		longitudes.setColumnsAxis(columns);
		
		latitudes.setColumnsAxis(columns);
        latitudes.setRowsAxis(rows);
        
        MagLog::debug() << latitudes.size() << ", " << rows.size() << ", " << columns.size() << "]" << "\n";
            
		for (unsigned int y = 0; y < rows.size(); y++) {
		  for (unsigned int x = 0; x < columns.size(); x++) {
		  	points.push_back(GeoPoint(longitudes(y, x), latitudes(y, x), matrix(y, x)));		  	
		  	MagLog::dev() << "(" << longitudes(y, x) << ", " << latitudes(y, x) << ", " << matrix(y, x) << "]" << "\n";
		  }
	} 
	}
   
	catch (MagicsException& e)
	{
		MagLog::error() << e << "\n";
	}
#endif
}



/*!
 Class information are given to the output-stream.
*/		
void NetcdfOrcaInterpretor::print(ostream& out)  const
{
	out << "NetcdfOrcaInterpretor[";
	NetcdfInterpretor::print(out);
	NetcdfOrcaInterpretorAttributes::print(out);
	out << "]";
}

static SimpleObjectMaker<NetcdfOrcaInterpretor, NetcdfInterpretor> netcdf_geovalues_interpretor("orca");

