/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file Wind.cc
    \brief Implementation of the Template class Wind.
    
    Magics Team - ECMWF 2005
    
    Started: Thu 17-Mar-2005
    
    Changes:
    
*/

#include "Wind.h"
#include "MatrixHandler.h"
#include "Layout.h"
#include "CustomisedPoint.h"

using namespace magics;

template <class P>
Wind<P>::Wind() 
{
}

template <class P>
Wind<P>::~Wind() 
{
}

/*!
 Class information are given to the output-stream.
*/	
template <class P>	
void Wind<P>::print(ostream& out)  const
{
	out << "Wind<P>";
}

template <class P>	
void Wind<P>::operator()(Data<P>& data, BasicGraphicsObjectContainer& parent)
{	
	ThinningMethod* method=0;

	const Transformation& transformation = parent.transformation();

	try {
		method = Translator<string, ThinningMethod>()(this->thinning_method_);
	}
	catch (...) {
	}
	if(!method) method = new BasicThinningMethod();

	method->set2D();

	this->factor_ = maground(this->thinning_factor_);
	this->nbPoints_ = this->thinning_factor_*parent.absoluteWidth();
	this->rawOnly_ = false;
	method->set(*this);
	

	CustomisedPointsList points;
	std::set<string> request;
	request.insert("x_component");
	request.insert("y_component");
	request.insert("colour_component");
	(*method)(data, transformation, request, points);
	if (points.empty() )
		return;
		(*this->type_).prepare(parent, method->units());
				
		(*this->type_).adjust(points, transformation);

		
		for (vector<CustomisedPoint*>::const_iterator point =points.begin(); point != points.end(); ++point) {
			 P position((*point)->longitude(), (*point)->latitude());	 
			 if ( transformation.in(position) )  {
				 pair<double, double> component = make_pair(  (**point)["x_component"], (**point)["y_component"]);		 
				 transformation.reprojectComponents(position, component);
				 (*this->type_)(position, transformation(position), component.first,  component.second, (**point)["colour_component"]);
			 }	
		}
	(*this->type_).finish(parent);
}

template <class P>	
void Wind<P>::visit(LegendVisitor& legend)
{
	(*this->type_).visit(legend);
}
