/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file CoastPlottingAttributes.h
    \brief Definition of CoastPlotting Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:54 2011
*/
   

#ifndef CoastPlottingAttributes_H
#define CoastPlottingAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Boundaries.h"
#include "Cities.h"
#include "LandShading.h"
#include "Colour.h"

namespace magics {

class XmlNode;



class CoastPlottingAttributes 
{
public:
//  --  constructor
    CoastPlottingAttributes();
    
//  --  destructor
    virtual ~CoastPlottingAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const CoastPlottingAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief Colour of coastlines
    \param colour Setting map_coastline_colour - default=BLACK
*/
	void setColour(Colour* colour) 
		{ auto_ptr<Colour> tmp(colour); colour_ = tmp; } 
	const Colour&  getColour() const 
		{ return *colour_; }
/*!
    Magics Information:
    \brief Select one of the pre-defined resolutions: AUTOMATIC, TINY, VERY_LOW, LOW, MEDIUM, MEDIUM_HIGH and HIGH.
  When set to AUTOMATIC, a coastline resolution appropriate to the scale of the map
  is chosen in order to balance quality with speed (but TINY will never be chosen with the AUTOMATIC method).
 
    \param resolution Setting map_coastline_resolution - default=AUTOMATIC
*/
	void setResolution(string resolution) 
		{ resolution_ =  resolution; } 
	string getResolution() const 
		{ return resolution_; } 
        
/*!
    Magics Information:
    \brief Path to a coastline file. Can be the name of a supplied file or a path
  to a user-defined file. This parameter overrides 'map_coastline_resolution'.
 
    \param file Setting map_coastline_path - default=
*/
	void setFile(string file) 
		{ file_ =  file; } 
	string getFile() const 
		{ return file_; } 
        
/*!
    Magics Information:
    \brief Line style of coastlines
    \param style Setting map_coastline_style - default=SOLID
*/
	void setStyle(LineStyle style) 
		{ style_ =  style; } 
	LineStyle getStyle() const 
		{ return style_; } 
        
/*!
    Magics Information:
    \brief Line thickness of coastlines
    \param thickness Setting map_coastline_thickness - default=1
*/
	void setThickness(int thickness) 
		{ thickness_ =  thickness; } 
	int getThickness() const 
		{ return thickness_; } 
        
/*!
    Magics Information:
    \brief Sets if land areas are shaded
    \param land Setting map_coastline_land_shade - default=off
*/
	void setLand(LandShading* land) 
		{ auto_ptr<LandShading> tmp(land); land_ = tmp; } 
	const LandShading&  getLand() const 
		{ return *land_; }
/*!
    Magics Information:
    \brief Add the political boundaries
    \param boundaries Setting map_boundaries - default=off
*/
	void setBoundaries(NoBoundaries* boundaries) 
		{ auto_ptr<NoBoundaries> tmp(boundaries); boundaries_ = tmp; } 
	const NoBoundaries&  getBoundaries() const 
		{ return *boundaries_; }
/*!
    Magics Information:
    \brief Add the cities (capitals)
    \param cities Setting map_cities - default=off
*/
	void setCities(NoCities* cities) 
		{ auto_ptr<NoCities> tmp(cities); cities_ = tmp; } 
	const NoCities&  getCities() const 
		{ return *cities_; }
/*!
    Magics Information:
    \brief Add a preview : only for metview
    \param preview Setting map_preview - default=off
*/
	void setPreview(bool preview) 
		{ preview_ =  preview; } 
	bool getPreview() const 
		{ return preview_; } 
        
/*!
    Magics Information:
    \brief Display rivers (on/off)
    \param rivers Setting map_rivers - default=off
*/
	void setRivers(string rivers) 
		{ rivers_ =  rivers; } 
	string getRivers() const 
		{ return rivers_; } 
        
/*!
    Magics Information:
    \brief Line style for rivers
    \param rivers_style Setting map_rivers_style - default=solid
*/
	void setRivers_style(LineStyle rivers_style) 
		{ rivers_style_ =  rivers_style; } 
	LineStyle getRivers_style() const 
		{ return rivers_style_; } 
        
/*!
    Magics Information:
    \brief Colour of the rivers
    \param rivers_colour Setting map_rivers_colour - default=blue
*/
	void setRivers_colour(Colour* rivers_colour) 
		{ auto_ptr<Colour> tmp(rivers_colour); rivers_colour_ = tmp; } 
	const Colour&  getRivers_colour() const 
		{ return *rivers_colour_; }
/*!
    Magics Information:
    \brief Line thickness of rivers
    \param rivers_thickness Setting map_rivers_thickness - default=1
*/
	void setRivers_thickness(int rivers_thickness) 
		{ rivers_thickness_ =  rivers_thickness; } 
	int getRivers_thickness() const 
		{ return rivers_thickness_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<Colour> colour_;
	string resolution_;
	string file_;
	LineStyle style_;
	int thickness_;
	auto_ptr<LandShading> land_;
	auto_ptr<NoBoundaries> boundaries_;
	auto_ptr<NoCities> cities_;
	bool preview_;
	string rivers_;
	LineStyle rivers_style_;
	auto_ptr<Colour> rivers_colour_;
	int rivers_thickness_;

private:
  
	friend ostream& operator<<(ostream& s,const CoastPlottingAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
