/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file CdfGraphAttributes.cc
    \brief Implemtation of CdfGraph Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Thu Jun 16 12:02:55 2011
*/    

#include "CdfGraphAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


CdfGraphAttributes::CdfGraphAttributes():
	colour_(Translator<stringarray, stringarray>().magics("cdf_lines_colour_array")),
	style_(Translator<stringarray, stringarray>().magics("cdf_lines_style_array")),
	thickness_(Translator<intarray, intarray>().magics("cdf_lines_thickness_array")),
	clim_colour_(Translator<string, Colour>().magics("cdf_clim_line_colour")),
	clim_thickness_(ParameterManager::getInt("cdf_clim_line_thickness")),
	clim_style_(Translator<string, LineStyle>().magics("cdf_clim_line_style"))
{
} 



CdfGraphAttributes::~CdfGraphAttributes()
{
}

    
void CdfGraphAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "cdf";

	setAttribute(prefix, "cdf_lines_colour_array", colour_, params);
	setAttribute(prefix, "cdf_lines_style_array", style_, params);
	setAttribute(prefix, "cdf_lines_thickness_array", thickness_, params);
	setAttribute(prefix, "cdf_clim_line_colour", clim_colour_, params);
	setAttribute(prefix, "cdf_clim_line_thickness", clim_thickness_, params);
	setAttribute(prefix, "cdf_clim_line_style", clim_style_, params);
}

void CdfGraphAttributes::copy(const CdfGraphAttributes& other)
{
	colour_ = other.colour_;
	style_ = other.style_;
	thickness_ = other.thickness_;
	setClim_colour(other.clim_colour_->clone());
	clim_thickness_ = other.clim_thickness_;
	clim_style_ = other.clim_style_;
} 


bool CdfGraphAttributes::accept(const string& node)
{	
	if ( magCompare(node, "cdfgraph")  )
		return true;
	return false;
}

void CdfGraphAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "cdfgraph") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void CdfGraphAttributes::print(ostream& out)  const
{
	out << "CdfGraphAttributes[";
	out << "colour = " << colour_;
	out << ", style = " << style_;
	out << ", thickness = " << thickness_;
	out << ", clim_colour = " << *clim_colour_;
	out << ", clim_thickness = " << clim_thickness_;
	out << ", clim_style = " << clim_style_;
	out << "]" << "\n";
}


void CdfGraphAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\tcdf_lines_colour_array = \'" << colour_ << "\'\n";
	out << tab << "\tcdf_lines_style_array = \'" << style_ << "\'\n";
	out << tab << "\tcdf_lines_thickness_array = \'" << thickness_ << "\'\n";
	out << tab << "\tcdf_clim_line_colour = \'" << *clim_colour_ << "\'\n";
	out << tab << "\tcdf_clim_line_thickness = \'" << clim_thickness_ << "\'\n";
	out << tab << "\tcdf_clim_line_style = \'" << clim_style_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<stringarray> cdf_lines_colour_array("cdf_lines_colour_array", stringarray(), "");
static MagicsParameter<stringarray> cdf_lines_style_array("cdf_lines_style_array", stringarray(), "");
static MagicsParameter<intarray> cdf_lines_thickness_array("cdf_lines_thickness_array", intarray(), "");
static MagicsParameter<string> cdf_clim_line_colour("cdf_clim_line_colour", "black", "");
static MagicsParameter<int> cdf_clim_line_thickness("cdf_clim_line_thickness", 4, "");
static MagicsParameter<string> cdf_clim_line_style("cdf_clim_line_style", "solid", "");
