/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file BoundariesAttributes.h
    \brief Definition of Boundaries Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:54 2011
*/
   

#ifndef BoundariesAttributes_H
#define BoundariesAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class BoundariesAttributes 
{
public:
//  --  constructor
    BoundariesAttributes();
    
//  --  destructor
    virtual ~BoundariesAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const BoundariesAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief Path to a directores where user boundary shape files are!
    \param file Setting map_boundaries_root - default=
*/
	void setFile(string file) 
		{ file_ =  file; } 
	string getFile() const 
		{ return file_; } 
        
/*!
    Magics Information:
    \brief Line style of boundaries
    \param style Setting map_boundaries_style - default=SOLID
*/
	void setStyle(LineStyle style) 
		{ style_ =  style; } 
	LineStyle getStyle() const 
		{ return style_; } 
        
/*!
    Magics Information:
    \brief Colour of boundaries
    \param colour Setting map_boundaries_colour - default=grey
*/
	void setColour(Colour* colour) 
		{ auto_ptr<Colour> tmp(colour); colour_ = tmp; } 
	const Colour&  getColour() const 
		{ return *colour_; }
/*!
    Magics Information:
    \brief Line thickness of boundaries
    \param thickness Setting map_boundaries_thickness - default=1
*/
	void setThickness(int thickness) 
		{ thickness_ =  thickness; } 
	int getThickness() const 
		{ return thickness_; } 
        
/*!
    Magics Information:
    \brief Display the disputed boundaries (on/off)
    \param disputed Setting map_disputed_boundaries - default=on
*/
	void setDisputed(bool disputed) 
		{ disputed_ =  disputed; } 
	bool getDisputed() const 
		{ return disputed_; } 
        
/*!
    Magics Information:
    \brief Line style of disputed boundaries
    \param disputed_style Setting map_disputed_boundaries_style - default=dash
*/
	void setDisputed_style(LineStyle disputed_style) 
		{ disputed_style_ =  disputed_style; } 
	LineStyle getDisputed_style() const 
		{ return disputed_style_; } 
        
/*!
    Magics Information:
    \brief Colour of disputed boundaries
    \param disputed_colour Setting map_disputed_boundaries_colour - default=automatic
*/
	void setDisputed_colour(Colour* disputed_colour) 
		{ auto_ptr<Colour> tmp(disputed_colour); disputed_colour_ = tmp; } 
	const Colour&  getDisputed_colour() const 
		{ return *disputed_colour_; }
/*!
    Magics Information:
    \brief Line thickness of disputed boundaries
    \param disputed_thickness Setting map_disputed_boundaries_thickness - default=1
*/
	void setDisputed_thickness(int disputed_thickness) 
		{ disputed_thickness_ =  disputed_thickness; } 
	int getDisputed_thickness() const 
		{ return disputed_thickness_; } 
        
/*!
    Magics Information:
    \brief Display second level administrative boundaries (on/off)
    \param admistrative Setting map_administrative_boundaries - default=off
*/
	void setAdmistrative(bool admistrative) 
		{ admistrative_ =  admistrative; } 
	bool getAdmistrative() const 
		{ return admistrative_; } 
        
/*!
    Magics Information:
    \brief List of countries for which to show second level administrative borders.
    \param administrative_list Setting map_administrative_boundaries_countries_list - default=stringarray()
*/
	void setAdministrative_list(stringarray administrative_list) 
		{ administrative_list_ =  administrative_list; } 
	stringarray getAdministrative_list() const 
		{ return administrative_list_; } 
        
/*!
    Magics Information:
    \brief Line style of second level administrative boundaries
    \param administrative_style Setting map_administrative_boundaries_style - default=dash
*/
	void setAdministrative_style(LineStyle administrative_style) 
		{ administrative_style_ =  administrative_style; } 
	LineStyle getAdministrative_style() const 
		{ return administrative_style_; } 
        
/*!
    Magics Information:
    \brief Colour of administrative boundaries
    \param administrative_colour Setting map_administrative_boundaries_colour - default=automatic
*/
	void setAdministrative_colour(Colour* administrative_colour) 
		{ auto_ptr<Colour> tmp(administrative_colour); administrative_colour_ = tmp; } 
	const Colour&  getAdministrative_colour() const 
		{ return *administrative_colour_; }
/*!
    Magics Information:
    \brief Line thickness of boundaries
    \param administrative_thickness Setting map_administrative_boundaries_thickness - default=1
*/
	void setAdministrative_thickness(int administrative_thickness) 
		{ administrative_thickness_ =  administrative_thickness; } 
	int getAdministrative_thickness() const 
		{ return administrative_thickness_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string file_;
	LineStyle style_;
	auto_ptr<Colour> colour_;
	int thickness_;
	bool disputed_;
	LineStyle disputed_style_;
	auto_ptr<Colour> disputed_colour_;
	int disputed_thickness_;
	bool admistrative_;
	stringarray administrative_list_;
	LineStyle administrative_style_;
	auto_ptr<Colour> administrative_colour_;
	int administrative_thickness_;

private:
  
	friend ostream& operator<<(ostream& s,const BoundariesAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
