/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisTitleAttributes.cc
    \brief Implemtation of AxisTitle Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Thu Jun 16 12:02:58 2011
*/    

#include "AxisTitleAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


AxisTitleAttributes::AxisTitleAttributes():
	colour_(Translator<string, Colour>().magics("axis_title_colour")),
	height_(ParameterManager::getDouble("axis_title_height")),
	orientation_(ParameterManager::getString("axis_title_orientation")),
	text_(ParameterManager::getString("axis_title_text")),
	lines_(Translator<stringarray, stringarray>().magics("axis_title_lines"))
{
} 



AxisTitleAttributes::~AxisTitleAttributes()
{
}

    
void AxisTitleAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "axis_title";
	prefix[1] = "axis";

	setAttribute(prefix, "axis_title_colour", colour_, params);
	setAttribute(prefix, "axis_title_height", height_, params);
	setAttribute(prefix, "axis_title_orientation", orientation_, params);
	setAttribute(prefix, "axis_title_text", text_, params);
	setAttribute(prefix, "axis_title_lines", lines_, params);
}

void AxisTitleAttributes::copy(const AxisTitleAttributes& other)
{
	setColour(other.colour_->clone());
	height_ = other.height_;
	orientation_ = other.orientation_;
	text_ = other.text_;
	lines_ = other.lines_;
} 


bool AxisTitleAttributes::accept(const string& node)
{	
	if ( magCompare(node, "title")  )
		return true;
	return false;
}

void AxisTitleAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "title") )
		set(node.attributes());
	else {
	}
	for (XmlNode::DataIterator data = node.firstData(); data != node.lastData(); ++data)
		setXmlData(*data);

	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void AxisTitleAttributes::print(ostream& out)  const
{
	out << "AxisTitleAttributes[";
	out << "colour = " << *colour_;
	out << ", height = " << height_;
	out << ", orientation = " << orientation_;
	out << ", text = " << text_;
	out << ", lines = " << lines_;
	out << "]" << "\n";
}


void AxisTitleAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\taxis_title_colour = \'" << *colour_ << "\'\n";
	out << tab << "\taxis_title_height = \'" << height_ << "\'\n";
	out << tab << "\taxis_title_orientation = \'" << orientation_ << "\'\n";
	out << tab << "\taxis_title_text = \'" << text_ << "\'\n";
	out << tab << "\taxis_title_lines = \'" << lines_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> axis_title_colour("axis_title_colour", "automatic", " New Magics: Parameter axis_title_colour sent to new Magics[XYSystem].  ");
static MagicsParameter<double> axis_title_height("axis_title_height", 0.4, " New Magics: Parameter axis_title_height sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_title_orientation("axis_title_orientation", "parallel", " New Magics: Parameter axis_title_orientation sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_title_text("axis_title_text", "", " New Magics: Parameter axis_title_text sent to new Magics[XYSystem].  ");
static MagicsParameter<stringarray> axis_title_lines("axis_title_lines", stringarray(), " New Magics: Parameter axis_title_text sent to new Magics[XYSystem].  ");
