
/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file MgQAnimation.cc
    \brief Definition of MgQAnimation
    \author Graphics Section, ECMWF

    Started: Feb 2010
*/

#include "QtDriver.h"

#include "MgQAnimation.h"
#include "MgQLayoutNode.h"
#include "MgQStepNode.h"

void MgQAnimationStep::addNode(MgQStepNode* node)
{
	nodes_.push_back(node);
}

int MgQAnimationStep::cachedNodeNum()
{
	int num=0;
	foreach(MgQStepNode *node,nodes_)
	{
		if(node->cached() == true)
		{
			num++;
		}
	}
	return num;
}

bool MgQAnimationStep::cached()
{
	foreach(MgQStepNode *node,nodes_)
	{
		if(node->cached() == false)
		{
			return false;
		}
	}
	return true;
}

void MgQAnimationStep::setVisible(bool visible)
{
	if(visible == true && cached()==false)
	{
		execute();
	}
	
	foreach(MgQStepNode *node,nodes_)
	{
		node->setVisible(visible);
	}
}

//That can be only called after all the nodes were added!!
void MgQAnimationStep::execute() const
{
	foreach(MgQStepNode *node,nodes_)
	{
		if(node->cached() == false)
		{
			driver_.executeStep(*this,node);
			node->setCached(true);
		}
	}
}



MgQAnimation::MgQAnimation(AnimationRules *rule,const QtDriver& driver) : 
	rule_(rule), driver_(driver), currentStep_(-1)
{
	int i=0;
	for(vector<AnimationStep*>::iterator it=rule->begin(); it != rule->end(); it++)
	{
		AnimationStep* step=*it;
		push_back(new MgQAnimationStep(i,step,driver));
	}
}


MgQAnimation::~MgQAnimation()
{
	for(int i=0; i < count(); i++)
	{
		delete at(i);
	}
}

void MgQAnimation::setCurrentStep(int step)
{
	currentStep_=step;

	if(currentStep_< 0 || currentStep_ >=count())
		return;

	for(int i=0; i < count(); i++)
	{
		at(i)->setVisible(false);
	}
	at(currentStep_)->setVisible(true);
}

AnimationStep* MgQAnimation::currentStepObject()
{
	if(currentStep_< 0 || currentStep_ >=count())
		return 0;

	return at(currentStep_)->stepObject();
}