/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include <stdarg.h>
#include "finestre.h"

Window btnwin[10];	// Siccome non posso passare argomenti alla
			// funzione interna alert_stop (eseguita
			// dai bottoni) tengo traccia esterna

int LarghezzaMassimaBottone(int nBt,char *Bt[])
{
	int x=0;
	int rvalue=0;
	int value;
	for (x=0;x<nBt;x++)
	{
		value=XTextWidth(WX11_FontCurrent(),Bt[x],strlen(Bt[x]));
		if (value > rvalue)
			rvalue=value;
	}
	return (rvalue);
}

int LarghezzaMassimaMessaggio (int NRighe, char *pmsg[])
{
	int x=0;
	int rvalue=0;
	int value;
	for (x=1;x<=NRighe;x++)
	{
		value=XTextWidth(WX11_FontCurrent(),pmsg[x],strlen(pmsg[x]));
		if (value > rvalue)
			rvalue=value;
	}
	return (rvalue);
}

int SpezzaMessaggio (char *pmsg[])
{
	// Controlla la presenza di ritorni a capo (\n)
	// restituisce il numero di righe presenti
	char *i=pmsg[0];
	int rvalue=0;
	
	if (pmsg[0])
	{
       		rvalue++;
		pmsg[rvalue]=pmsg[0];
	}
	while (*i)
	{
		if (*i=='\n')
		{
			*i='\0';

			rvalue++;
			pmsg[rvalue]=i+1;
		}
		i++;
	}
	
	return (rvalue);
}

int alert_stop ()
{
	//
	// Funzione chiamata dalla pressione bottoni 
	// Restituisce il numero del Bottone premuto 
	// Nota che se la finestra viene chusa dal client
	// sara' il client a restituire un valore di -1.
	//
	CmdInfo *comando=UltimoComandoSelezionato(0,NULL);

	Window focusWin;
	int reverToReturn;
	int retcode=0;
	
	// Cerca il Numero bottone premuto
	while (btnwin[retcode++]!=comando->win);

	// Prende la finestra attiva	
	XGetInputFocus(WX11_GetDisplay(), &focusWin, &reverToReturn);

	ChiudeFinestra (focusWin);
	
	// Esce da 1 a Nbottoni
	return (retcode);
}



int WX11_Alert (char *Messaggio, ...)
{
	va_list args;
	char *Bt[10];     	// 10 Bottoni al massimo
	char *pmsg[25];  	// 25 Righe al massimo
	
	int GapBottoni=10;	// Spazio tra Bottoni
	int LlWin=0;		// Larghezza Finestra
	int HhWin=0;		// Altezza   Finestra

	int LlBottone=0; 	// Larghezza Bottone
	int LlBottoni=0;	// Larghezza Bottoni
	int HhBottone=0;	// Altezza   Bottone
	int LlMessaggio=0;	// Larghezza Messaggio
	int HhMessaggio=0;	// Altezza   Messaggio
	int nBt=0;		// Numero Bottoni
	int NRighe=0;	 	// Numero Righe Messaggio
	
	int x=0,pos;
	int retcode=0;

	CmdInfo *PrevMain;
	CmdInfo *mio,*cmd;

	pmsg[0]= (char *) malloc (strlen(Messaggio)+1); // $$max
	strcpy (pmsg[0],Messaggio);

	va_start(args, Messaggio);
	Bt[x]=va_arg(args,char *);
	while (Bt[x]!=NULL)
	{
		x++;
		Bt[x]=va_arg(args,char *);
	}
	va_end(args);
	nBt=x;

	NRighe=SpezzaMessaggio(pmsg);
	LlMessaggio=LarghezzaMassimaMessaggio(NRighe,pmsg);
	HhMessaggio=(NRighe+2)*(WX11_FontHeight()+6);

	LlBottone=LarghezzaMassimaBottone(nBt,Bt)+(GapBottoni*5);
	LlBottoni=(LlBottone*nBt)+(GapBottoni*(nBt+1));
	HhBottone=WX11_FontHeight ()+10;
		
	LlWin=LlMessaggio+100;
	HhWin=(HhMessaggio+10)+(HhBottone+10);

	if (LlBottoni > LlWin)
		LlWin=LlBottoni;

	PrevMain=GetPrevTopLevelWindow();

	if (PrevMain)
	{

		WX11_DisableTopLevelWindow(PrevMain);

		mio=ApreFinestra (
			" ",//"Messaggio",
			PrevMain->x+(((PrevMain->Width)-(LlWin))/2),
			PrevMain->y+(((PrevMain->Height)-(HhWin))/2),
			LlWin,HhWin);

		XSetTransientForHint(
			WX11_GetDisplay(), 
			mio->win,
			PrevMain->win
			);
	}
	else
	{
		mio=ApreFinestraCentrale ("Messaggio",LlWin,HhWin);
	}

	for (x=1;x<=NRighe;x++)
		WX11_PrintCenter (mio,x * (WX11_FontHeight()+6),pmsg[x]);

	pos=(LlWin-LlBottoni)/2;
	for (x=0;x<nBt;x++)
	{
		
		cmd=ApreBottone (mio,pos+(GapBottoni*(x+1))+(x*LlBottone),HhWin-HhBottone-10,LlBottone,HhBottone,Bt[x]);
                WX11_SetSignalCallBack (cmd,Button1Release,alert_stop, NULL);

		btnwin[x]=cmd->win;
	}

	retcode=WX11_Events (mio);
	
	free(pmsg[0]);

	if (PrevMain)
		WX11_EnableTopLevelWindow (PrevMain);
	
	return (retcode);
	
}

