/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include <stdlib.h>
#include <stdio.h>
#include "finestre.h"

#define SCROLLCURSMIN 20
void WX11_UpDateScrollMax (CmdInfo *cmd)
{
	
	CmdInfo *cmdparent;
	int scroll_max_x=0,scroll_max_y=0;

	cmdparent=CercaComando(cmd->parent);
	if (!cmdparent)
		return;

	scroll_max_x=(cmd->x) + (cmd->Width);
	scroll_max_y=(cmd->y) + (cmd->Height);

	if ((cmdparent->scroll_max_x) < scroll_max_x)
		cmdparent->scroll_max_x=scroll_max_x;

	if ((cmdparent->scroll_max_y) < scroll_max_y)
		cmdparent->scroll_max_y=scroll_max_y;

	return;		
}

int WX11_WheelScroll (CmdInfo *cmd,unsigned int Button)
{
	// --------------------------------------
	// Gestione Scrolling con Rotellina Mouse
	// --------------------------------------

	CmdInfo *scroll_up=NULL;		// Scroll Up
	CmdInfo *scroll_dn=NULL;		// Scroll Down
	CmdInfo *tmp=NULL;			// Temporaneo

	tmp=cmd;

	while (tmp && !tmp->scrollv)
	{
		tmp=CercaComando (tmp->parent);
	}
	if (tmp==NULL)	return (-1);
	
	tmp=tmp->scrollv;
	while (tmp && tmp->Tipo!=MAIN)
	{
	
		if (tmp->Tipo==SCROLL_UP)	scroll_up=tmp;
		if (tmp->Tipo==SCROLL_DN)	scroll_dn=tmp;
		
		tmp=tmp->Next;

		if (scroll_up && scroll_dn) tmp=NULL;
	}

	if (Button==5)
		WX11_ScrollingArea (scroll_dn,0,(WX11_FontHeight()+4)*(-2));
	if (Button==4)
		WX11_ScrollingArea (scroll_up,0,(WX11_FontHeight()+4)*(+2));

	return (0);
}

int WX11_HandleScroll (int Mode,XEvent event)
{
	// ------------------------------
	// Gestione dello scrolling 
	// tenendo premuto il bottone e 
	// muovendo il cursore 
	// SCROLL_VCUR e SCROLL_HCUR
	// ------------------------------
	static CmdInfo *p1;
	static int old_x,old_y;
	int x,y;
	int b2;
	int z,w,k;

	int TipoCursore;
	int DimUtile;
	int DimScrollCursore;
	int Bordo=0;
	int LatoArrow=15; // warning
	int Larghezza=0;
	int Altezza=0;


	CmdInfo *area_cur,*area_scroll,*c;
	
	// Gestione movimento
	x=event.xmotion.x;	y=event.xmotion.y;
	
	area_cur=CercaComando (event.xmotion.window);
	if (area_cur->Tipo!=SCROLL_VCUR && area_cur->Tipo!=SCROLL_HCUR) return (-1); 

	TipoCursore=(area_cur->Tipo==SCROLL_VCUR) ? 1 : 2;
	Bordo=area_cur->Bordo;
	if (Bordo) area_cur=area_cur->Prev; 

	c=area_cur;
	area_scroll=NULL;
	do
	{
		if (c->Tipo==SCROLL) area_scroll=c;
		c=CercaComando (c->parent);
		
	}while (c && c->Tipo!=AREA);
	if (c==NULL)
	{
		//Errore non trovata area per scroll 
		return (-1);
	}


	if (TipoCursore==1 && c->scrollv)
	{
		// SCROLL_VCUR
		Altezza=((c->scrollv)->Height)+(Bordo*2);
		b2=(c->scroll_y)*(-1);
		DimUtile=(Altezza)-(LatoArrow*2)-(Bordo*4); 
		DimScrollCursore=((Altezza)*DimUtile)/c->scroll_max_y;
		if (DimScrollCursore<SCROLLCURSMIN) DimScrollCursore=SCROLLCURSMIN; // $$maxaddd
	}
	else 
	{
		// SCROLL_HCUR
		Larghezza=((c->scrollh)->Width)+(Bordo*2);
		b2=(c->scroll_x)*(-1);
		DimUtile=(Larghezza)-(LatoArrow*2)-(Bordo*4); 
		DimScrollCursore=((Larghezza)*DimUtile)/c->scroll_max_x;
	}
			 
	if (Mode==0)
	{
		// ------------------------------------
		// Unset and Scrolling (lascia bottone)
		// ------------------------------------
		if (p1)
		{
			//printf ("Chiusa Handling\n");
			if (TipoCursore==1)
			{
				// SCROLL_VCUR
				z=(c->scroll_max_y)-(Altezza);
				w=(DimUtile-DimScrollCursore-Bordo);
				k=(((p1->y)-(LatoArrow+Bordo))*z)/w;
				b2=b2-(int) k;

				WX11_ScrollingArea (area_cur,0,b2);
			}
			else
			{
				// SCROLL_HCUR
				z=(c->scroll_max_x)-(Larghezza);
				w=(DimUtile-DimScrollCursore-Bordo);
				k=(((p1->x)-(LatoArrow+Bordo))*z)/w;
				b2=b2-(int) k;

				WX11_ScrollingArea (area_cur,b2,0);
			}
			XDestroyWindow(WX11_GetDisplay(), p1->win);
			FreeCom (p1);
			p1=NULL;
		}
		return (0);
	}

	if (Mode==1)
	{
		// ------------------------------------
		// Set (premi bottone)
		// ------------------------------------
		old_x=event.xbutton.x;	old_y=event.xbutton.y;
		//
		//printf ("Aperta Handling\n");
		if (TipoCursore==1)
		{
			p1=WX11_CmdOpen (SCROLL,area_scroll,
					area_cur->x,area_cur->y,
					area_scroll->Width,area_cur->Height,
					BIANCO, NERO,0,"");
		}
		else
		{
			p1=WX11_CmdOpen (SCROLL,area_scroll,
					area_cur->x,area_cur->y,
					area_cur->Width,area_scroll->Height,
					BIANCO, NERO,0,"");

		}

		return (0);

	}
	if (Mode==2) 
	{
		//
		// Handling (col bottone premuto muovi)
		//
		if (p1)
		{
			if (TipoCursore==1)
			{
				p1->y=p1->y+(y-old_y);
				if ((p1->y)<16) 
					p1->y=16;
				if ((p1->y)+(p1->Height)>(area_scroll->Height)-16)
					p1->y=(area_scroll->Height)-(p1->Height)-16;
		
				XMoveWindow(WX11_GetDisplay(), p1->win, p1->x, p1->y);
				old_y=y;
			}
			else 
			{
				p1->x=p1->x+(x-old_x);
				if ((p1->x)<16) 
					p1->x=16;
				if ((p1->x)+(p1->Width)>(area_scroll->Width)-16)
					p1->x=(area_scroll->Width)-(p1->Width)-16;
		
				XMoveWindow(WX11_GetDisplay(), p1->win, p1->x, p1->y);
				old_x=x;

			}
		}
		return (0);
	}
	
	return (0);
}

int xpp (CmdInfo * areascroll, int Tipo)
{
	//
	// Definisce le aree ed il cursore per scroll 
	// Logica:
	// Ricerca l'esistenza di figli di areascroll
	// ridimensiona o crea le finestre SCROLL_PGUP,
	// SCROLL_PGDN e SCROLL_VCUR
	// 
	// Tipo==0 Niente
	// Tipo==1 Verticale
	// Tipo==2 Horizzontale
	// Tipo==3 Verticale+Horizzontale
	//
	CmdInfo *c;				// tmp
	CmdInfo *area;				// Area da scrollare
	CmdInfo *area_pgup=NULL,*area_pgdn=NULL;// Aree PgUp PgDn
	CmdInfo *area_vcur=NULL;		// Area V cursore 
	CmdInfo *area_pgsx=NULL,*area_pgdx=NULL;// Aree PgUp PgDn
	CmdInfo *area_hcur=NULL;		// Area H cursore

	//
	int Larghezza=0;
	int Altezza=0;
	int LatoArrow=0;
	int Bordo=0;
	int DimUtile=0;
	int DimScrollCursore=0;
	int p1=0,p2=0,p3=0,p4=0;
	//
	// Cerca l'area da scrollare x rilevare
	// le impostazione di grandezza
	c=areascroll;
	do
	{
		c=CercaComando (c->parent);
		
	}while (c && c->Tipo!=AREA);
	if (c==NULL)
	{
		printf ("Errore non trovata area per scroll in funz:xpp\n");
		return (-1);
	}
	area=c;
	if (Tipo & 1 && area->scrollv)
	{
		c=area->scrollv;
		Bordo=c->Bordo;
		Larghezza=c->Width;
		Altezza=c->Height+(Bordo*1);

		c=c->Next; 
		while (c)
		{
			if (c->Tipo==SCROLL)
				;
			else if (c->Tipo==BORDO)
				;
			else if (c->Tipo==SCROLL_UP)
				LatoArrow=c->Width;
			else if (c->Tipo==SCROLL_DN)
				;
			else if (c->Tipo==SCROLL_PGUP)
				area_pgup=c;
			else if (c->Tipo==SCROLL_VCUR)
				area_vcur=c;
			else if (c->Tipo==SCROLL_PGDN)
				area_pgdn=c;
			else
				c=NULL;

			if (c) c=c->Next;	
		}


		if (area_vcur && area_vcur->Bordo) area_vcur=area_vcur->Prev;
		
		DimUtile=(Altezza)-(LatoArrow*2)-(Bordo*2);

		DimScrollCursore=
			((Altezza)*DimUtile)/area->scroll_max_y;

		if (DimScrollCursore<SCROLLCURSMIN) DimScrollCursore=SCROLLCURSMIN; //$$max newadd

		p1=LatoArrow+Bordo;
		p2=(area->scroll_y*(DimUtile-DimScrollCursore-Bordo))/((area->scroll_max_y)-Altezza);
		p2=p1+(p2*(-1));	// Inverte il segno
		p3=p2+DimScrollCursore;
		p4=Altezza-LatoArrow-Bordo;//-1;
		//
		if (p1>p2) 
		{
			p3=p3-(p1-p2);
			p2=p1;
		}
		if (p3>p4) 
		{
			p2=p2-(p3-p4);	
			p3=p4;
		}
		//
		// PgUp
		if (p2-p1)
		{
			area_pgup->Height=(p2-p1);
			XResizeWindow(WX11_GetDisplay(), area_pgup->win, 
				area_pgup->Width, area_pgup->Height);
		}
		//
		// PgDn
		if (p4-p3)
		{
			// se esiste PgDn setta
			area_pgdn->y=p3;
			area_pgdn->Height=(p4-p3);
		}
		else
		{
			// se non esiste
			// nascondi dietro al cursore
			area_pgdn->y=p2;
			area_pgdn->Height=(p3-p2);
		}
		
		XMoveResizeWindow(WX11_GetDisplay(), area_pgdn->win,
			area_pgdn->x, area_pgdn->y, area_pgdn->Width, area_pgdn->Height);
		//
		// VCurs
		if (p3-p2)
		{
			//if (area_vcur->Bordo) area_vcur=area_vcur->Prev;
			
			area_vcur->y=p2;
			area_vcur->Height=(p3-p2);

			XMoveResizeWindow(WX11_GetDisplay(), area_vcur->win,
				area_vcur->x, area_vcur->y, area_vcur->Width, area_vcur->Height);
		}

	}

	if (Tipo & 2 && area->scrollh)
	{
		c=area->scrollh;
		Bordo=c->Bordo;
		Larghezza=c->Width+(Bordo*1);
		Altezza=c->Height;

		c=c->Next; 
		while (c)
		{
			if (c->Tipo==SCROLL)
				;
			else if (c->Tipo==BORDO)
				;
			else if (c->Tipo==SCROLL_SX)
				LatoArrow=c->Width;
			else if (c->Tipo==SCROLL_DX)
				;
			else if (c->Tipo==SCROLL_PGSX)
				area_pgsx=c;
			else if (c->Tipo==SCROLL_HCUR)
				area_hcur=c;
			else if (c->Tipo==SCROLL_PGDX)
				area_pgdx=c;
			else
				c=NULL;

			if (c) c=c->Next;	
		}


		if (area_hcur && area_hcur->Bordo) area_hcur=area_hcur->Prev;
		
		DimUtile=(Larghezza)-(LatoArrow*2)-(Bordo*2);

		DimScrollCursore=
			((Larghezza)*DimUtile)/area->scroll_max_x;

		p1=LatoArrow+Bordo;
		p2=(area->scroll_x*(DimUtile-DimScrollCursore-Bordo))/((area->scroll_max_x)-Larghezza);
		p2=p1+(p2*(-1));	// Inverte il segno
		p3=p2+DimScrollCursore;
		p4=Larghezza-LatoArrow-Bordo;//-1;
		//
		if (p1>p2) 
		{
			p3=p3-(p1-p2);
			p2=p1;
		}
		if (p3>p4) 
		{
			p2=p2-(p3-p4);	
			p3=p4;
		}
		//
		// PgSx
		if (p2-p1)
		{
			area_pgsx->Width=(p2-p1);
			XResizeWindow(WX11_GetDisplay(), area_pgsx->win, 
				area_pgsx->Width, area_pgsx->Height);
		}
		//
		// PgDx
		if (p4-p3)
		{
			// Se esiste PgDx Setta
			area_pgdx->x=p3;
			area_pgdx->Width=(p4-p3);
		}
		else
		{
			// se non esiste
			// nascondi dietro al cursore
			area_pgdx->x=p2;
			area_pgdx->Width=(p3-p2);

		}

		XMoveResizeWindow(WX11_GetDisplay(), area_pgdx->win,
			area_pgdx->x, area_pgdx->y, area_pgdx->Width, area_pgdx->Height);
		//
		// VCurs
		if (p3-p2)
		{
			//if (area_vcur->Bordo) area_vcur=area_vcur->Prev;
			
			area_hcur->x=p2;
			area_hcur->Width=(p3-p2);

			XMoveResizeWindow(WX11_GetDisplay(), area_hcur->win,
				area_hcur->x, area_hcur->y, area_hcur->Width, area_hcur->Height);
		}

	}

	return(0);
	
}

int WX11_ScrollingPage (CmdInfo *cmd)
{
	//
	// Calcola il salto di Pagina
	// ed esegue WX11_ScrollingArea
	//
	CmdInfo *c=cmd; 	// Area da scrollare
	
	int AltezzaArea=0;
	int LarghezzaArea=0;

	while (c && c->Tipo!=AREA)
	{
		c=CercaComando (c->parent);
	}
	if (!c)
	{
		printf ("Error in Funz:WX11_ScrollingPage\n");
		return (-1);
	}

	if (cmd->Tipo==SCROLL_PGUP)
		AltezzaArea=(c->Height)*(+1);
	if (cmd->Tipo==SCROLL_PGDN)
		AltezzaArea=(c->Height)*(-1);

	if (cmd->Tipo==SCROLL_PGSX)
		LarghezzaArea=(c->Width)*(+1);
	if (cmd->Tipo==SCROLL_PGDX)
		LarghezzaArea=(c->Width)*(-1);
	
	//
	WX11_ScrollingArea (cmd,LarghezzaArea,AltezzaArea);

	return (0);
}

int WX11_ScrollingArea (CmdInfo *cmd,int Cols,int Rows)
{
	// Scrolling
	//
	// Prima deve cercare quale area
	// di cmd appartiente l'evento
	// poi muovere tutte le finestre
	// figlie tranne quella di scroll.
	// La traccia dello spostamento
	// viene mantenuta nella finestra
	// madre (scroll_y) 
	// Cols e Rows possono essere sia
	// positivi che negativi.
	// Se Cols e/o Rows sono a zero non
	// eseguono scrolling 
	//
	Window p;
	CmdInfo *c=cmd; 	// Area da scrollare
	CmdInfo *fixedv=NULL;	// Area da non scrollare
	CmdInfo *fixedh=NULL;	// Area da non scrollare
	CmdInfo *k=NULL;	// Temporaneo di giro
	int test1,test2,test3;

	while (c && c->Tipo!=AREA)
	{
		p=c->parent;
		c=CercaComando (p);
	}
	if (c==NULL)
	{
		printf ("Error area not found in:WX11_ScrollingArea\n");
		return (-1);
	}
	fixedv=c->scrollv;
	fixedh=c->scrollh;
	if (fixedv && fixedv->Bordo) fixedv=fixedv->Prev;
	if (fixedh && fixedh->Bordo) fixedh=fixedh->Prev;
	//
	if (cmd->Tipo==SCROLL_UP || cmd->Tipo==SCROLL_PGUP)
	{
		if (c->scroll_y==0)
			return (1);
		if ((c->scroll_y)+(Rows)>0)
			Rows=(c->scroll_y)*(-1);
	}
	if (cmd->Tipo==SCROLL_DN && 
		((c->scroll_y)*(-1)) > (c->scroll_max_y)-(c->Height))
		return (2);

	if (cmd->Tipo==SCROLL_PGDN)
	{
		if (((c->scroll_y+Rows)*(-1)) > (c->scroll_max_y)-(c->Height))
			Rows=((c->scroll_max_y)-(c->Height)-(c->scroll_y*(-1)))*(-1);
	}

	if (cmd->Tipo==SCROLL_SX || cmd->Tipo==SCROLL_PGSX)
	{
		if (c->scroll_x==0)
			return (3);
		if ((c->scroll_x)+(Cols)>0)
			Cols=(c->scroll_x)*(-1);
	}
	if (cmd->Tipo==SCROLL_DX && 
		((c->scroll_x)*(-1)) > (c->scroll_max_x)-(c->Width))
		return (4);
	
	if (cmd->Tipo==SCROLL_PGDX)
	{
		if (((c->scroll_x+Cols)*(-1)) > (c->scroll_max_x)-(c->Width))
			Cols=((c->scroll_max_x)-(c->Width)-(c->scroll_x*(-1)))*(-1);
	}


	k=PrimoComando(0,NULL);
	while (k)
	{
		test1=(k->parent==c->win);
		test2=(k!=fixedv);
		test3=(k!=fixedh);

		if (test1 && test2 && test3)
		{
			k->y=k->y+Rows;
			k->x=k->x+Cols;
			XMoveWindow(WX11_GetDisplay(), k->win, k->x, k->y);
		}	
		k=k->Next;
	}
	c->scroll_y=c->scroll_y+Rows;
	c->scroll_x=c->scroll_x+Cols;

	if (Rows) xpp (fixedv, 1);
	if (Cols) xpp (fixedh, 2);
	

	return (0);
}


int WX11_ScrollBar (CmdInfo *finestra,int Tipo)
{
	//
	// Disegna la scroll-bar
	// Tipo==0 Niente
	// Tipo==1 Verticale
	// Tipo==2 Horizzontale
	// Tipo==3 Verticale+Horizzontale
	//
	// La Posizione è assunta fissa sulla destra
	// per il verticale e in basso per la orizzontale
	//
	//Display * display=WX11_GetDisplay();
	//
	unsigned int colorbg=WX11_ColorGet(WINBG);
	unsigned int colorfg=WX11_ColorGet(WINFG);

	CmdInfo *area,*up,*dn,*left,*right,*cursor;
	int x=0, y=0;
	int Bordo=1;
	int LatoAreaArrow=15;
	int LarghezzaAreaScroll=0;
	int AltezzaAreaScroll=0;
	
	// Segna il tipo di scroll nella
	// struttura
	finestra->scroll_tipo=Tipo;

	if (!Tipo) return (0);


	if (Tipo & 1)
	{
		// Setta le dimensioni dell'area scroll
		// Verticale
		y=0;
		LarghezzaAreaScroll=LatoAreaArrow;
		x=(finestra->Width)-(LarghezzaAreaScroll)+Bordo;

		AltezzaAreaScroll=(finestra->Height);
		//
		area=WX11_CmdOpen (SCROLL,finestra,x,y,
			LarghezzaAreaScroll,AltezzaAreaScroll,
			WX11_ColorLight(colorbg), colorfg,Bordo,"");

		finestra->scrollv=area; 

		up=WX11_CmdOpen (SCROLL_UP,area,0,0,
			LatoAreaArrow,LatoAreaArrow,
			colorbg, colorfg,Bordo,"");
		up->IsButton=1;
		dn=WX11_CmdOpen (SCROLL_DN,area,0,AltezzaAreaScroll-LatoAreaArrow,
			LatoAreaArrow,LatoAreaArrow,
			colorbg, colorfg,Bordo,"");
		dn->IsButton=1;

		WX11_CmdOpen (SCROLL_PGUP,area,0,LatoAreaArrow+1,
			LarghezzaAreaScroll,
			AltezzaAreaScroll-((LatoAreaArrow+Bordo)*2),
			 WX11_ColorLightSmall(colorbg), colorfg,0,"");
		WX11_CmdOpen (SCROLL_PGDN,area,0,LatoAreaArrow+1,
			LarghezzaAreaScroll,
			AltezzaAreaScroll-((LatoAreaArrow+Bordo)*2),
			 WX11_ColorLightSmall(colorbg), colorfg,0,"");
		// $$MAX
		cursor=WX11_CmdOpen (SCROLL_VCUR,area,1,LatoAreaArrow+1,
			LarghezzaAreaScroll-2,
			AltezzaAreaScroll-((LatoAreaArrow+Bordo)*2),
			colorbg, colorfg,Bordo,"");
		cursor->BUpDn=1;
/*
		WX11_CmdOpen (SCROLL_VCUR,area,1,LatoAreaArrow+1,
			LarghezzaAreaScroll-2,
			AltezzaAreaScroll-((LatoAreaArrow+Bordo)*2),
			colorbg, colorfg,Bordo,"");
*/
		xpp (area, 1); //Tipo);
		
	}
	if (Tipo & 2)
	{
		// Setta le dimensioni dell'area scroll
		// Orizzonatale
		x=0;
		AltezzaAreaScroll=LatoAreaArrow;
		y=(finestra->Height)-(AltezzaAreaScroll)-(Bordo)+1;		
		LarghezzaAreaScroll=(finestra->Width);
		// Se previsto anche lo scroll Verticale
		// riduce la larghezza dell'area di scroll
		if (Tipo & 1) 
			LarghezzaAreaScroll=LarghezzaAreaScroll-LatoAreaArrow-Bordo;
		//
		area=WX11_CmdOpen (SCROLL,finestra,x,y,
			LarghezzaAreaScroll,AltezzaAreaScroll,
			WX11_ColorLight(colorbg), colorfg,Bordo,"");

		finestra->scrollh=area;

		left=WX11_CmdOpen (SCROLL_SX,area,0,0,
			LatoAreaArrow,LatoAreaArrow,
			colorbg, colorfg,Bordo,"");
		left->IsButton=1;
		right=WX11_CmdOpen (SCROLL_DX,area,LarghezzaAreaScroll-LatoAreaArrow,0,
			LatoAreaArrow,LatoAreaArrow,
			colorbg, colorfg,Bordo,"");
		right->IsButton=1;
		WX11_CmdOpen (SCROLL_PGSX,area,LatoAreaArrow+1,0,
			LarghezzaAreaScroll-((LatoAreaArrow+Bordo)*2),
			AltezzaAreaScroll,
			 WX11_ColorLightSmall(colorbg), colorfg,0,"");
		WX11_CmdOpen (SCROLL_PGDX,area,LatoAreaArrow+1,0,
			LarghezzaAreaScroll-((LatoAreaArrow+Bordo)*2),
			AltezzaAreaScroll,
			 WX11_ColorLightSmall(colorbg), colorfg,0,"");
		cursor=WX11_CmdOpen (SCROLL_HCUR,area,LatoAreaArrow+1,1,
			LarghezzaAreaScroll-((LatoAreaArrow+Bordo)*2),
			AltezzaAreaScroll-Bordo,
			colorbg, colorfg,Bordo,"");
		cursor->BUpDn=1;
	
		xpp (area, 2); //Tipo);
	}

	return (0);	
}

