//
// Include da aggiungere in tutti i programmi
// 
#include "finestre.h"
//
// Definizione Variabili esterne
// 

int getrand (int toprange)
{
	//
	// Funzione Random
	//
	//
	static int f=0;
	if (!f)
	{
		srand (time (NULL));
		f=!f;
	}
	return (rand()/(int)(((unsigned)RAND_MAX + 1) / toprange));
}


int mytrap (CmdInfo *cmd,int EventType,ListCmdInfo *ViewComment)
{
    //
    // Example trap
    //
    char buf[64];

    if (EventType==EnterNotify)
        printf ("EnterNotify by %s\n",cmd->Label);
    else if (EventType==Button1Release)
    {
        sprintf  (buf,"Button 1 Release by %s",cmd->Label);
        printf ("%s\n",buf);
        WX11_Alert (buf,"Ok",NULL);
    }
    else if (EventType==Button1Press)
    {
        sprintf  (buf,"Button 1 Press by %s",cmd->Label);
        printf ("%s\n",buf);
    }
    else
        printf ("Other Event\n");
    
    return (0);
}

int New(CmdInfo *cmd, int EventType,ListCmdInfo *ViewComment)
{
	char Buff[64];
	int riga,max;

	xClearAllListBoxItem (ViewComment);

	max=getrand(200)+1;
	sprintf (Buff,"INSERIMENTO DI %d RIGHE",max);	
	WX11_ListCmdItemAdd (ViewComment, LABEL,Buff);
	for (riga=1;riga<=max;riga++)
	{
		sprintf (Buff,"Inserimento Automatico Riga %d",riga);	
		WX11_ListCmdItemAdd (ViewComment, LIST_BOX,Buff);
	}
	WX11_ListCmdItemAdd (ViewComment, LABEL,"--break--");

	WX11_FontOpen ("6x10");
	WX11_ListBoxRefresh (ViewComment);
	WX11_FontOpen ("9x15");
	
	return (0);
}
int Newtest (CmdInfo *cmd, int EventType,ListCmdInfo *ViewComment)
{
	int SIZE=1024;
	char *filename="LICENSE";
	char buff[SIZE];
	size_t r_bytes;

	FILE *in, *fopen();

	in = fopen(filename, "r");
	if (!in)
	{
		sprintf (buff,"Errore apertura %s",filename);
		printf (buff);
		WX11_Alert (buff,"Ok",NULL);
		return (1);
	}

	xClearAllListBoxItem (ViewComment);
	do
	{
		r_bytes=fread(buff, 1, SIZE, in); 
		printf ("r_bytes=%d\n",r_bytes);
		WX11_ListCmdItemAdd (ViewComment, LABEL,buff);

	}while (r_bytes==SIZE);

	

	

	WX11_FontOpen ("6x10");
	WX11_ListBoxRefresh (ViewComment);
	WX11_FontOpen ("9x15");
	
	return (0);

}

int main (int argc, char **argv)
{
    CmdInfo *my,*button;
    ListCmdInfo *ViewComment;

    InitFinestre (argc, argv);

    my=ApreFinestraCentrale ("Example ListBoxRefresh", 500, 300);
	
    ViewComment=WX11_ListCmdAdd ("Table");
    WX11_ListCmdItemAdd (ViewComment, LIST_BOX,"Prova inserimento multilinea:\n1) Riga\n\n2) Colonna\n");

    WX11_SetSignalCallBack (ViewComment,Button1Press,mytrap,ViewComment);
    WX11_SetSignalCallBack (ViewComment,Button1Release,mytrap,ViewComment);
    WX11_SetSignalCallBack (ViewComment,EnterNotify,mytrap,ViewComment);

    WX11_FontOpen ("6x10");
    WX11_ListBox (my,ViewComment, 200, 150, "\n\nRandom ListBox:");
    WX11_FontOpen ("9x15");

    button=ApreBottone(my,200,250,100,20,"New");
    WX11_SetSignalCallBack (button,Button1Release,New,ViewComment);


    WX11_Events (my);	

    WX11_CloseDisplay ();

	return (0);
}

