/*
 * libvirt-gconfig.h: libvirt gconfig integration
 *
 * Copyright (C) 2010 Red Hat
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 * Author: Daniel P. Berrange <berrange@redhat.com>
 */

#ifndef __LIBVIRT_GCONFIG_H__
#define __LIBVIRT_GCONFIG_H__

#include <glib-object.h>
#include <libxml/tree.h>

#include <libvirt-gconfig/libvirt-gconfig-helpers.h>
#include <libvirt-gconfig/libvirt-gconfig-object.h>
#include <libvirt-gconfig/libvirt-gconfig-capabilities.h>
#include <libvirt-gconfig/libvirt-gconfig-domain.h>
#include <libvirt-gconfig/libvirt-gconfig-domain-snapshot.h>
#include <libvirt-gconfig/libvirt-gconfig-interface.h>
#include <libvirt-gconfig/libvirt-gconfig-network.h>
#include <libvirt-gconfig/libvirt-gconfig-node-device.h>
#include <libvirt-gconfig/libvirt-gconfig-network-filter.h>
#include <libvirt-gconfig/libvirt-gconfig-secret.h>
#include <libvirt-gconfig/libvirt-gconfig-storage-pool.h>
#include <libvirt-gconfig/libvirt-gconfig-storage-vol.h>

#endif /* __LIBVIRT_GCONFIG_H__ */
