/* tool.c generated by valac 0.14.0, the Vala compiler
 * generated from tool.vala, do not modify */

/*
 * Copyright (C) 2011 Daiki Ueno <ueno@unixuser.org>
 * Copyright (C) 2011 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <stdio.h>
#include <libskk/libskk.h>
#include <gee.h>


#define SKK_TYPE_TOOL (skk_tool_get_type ())
#define SKK_TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_TOOL, SkkTool))
#define SKK_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_TOOL, SkkToolClass))
#define SKK_IS_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_TOOL))
#define SKK_IS_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_TOOL))
#define SKK_TOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_TOOL, SkkToolClass))

typedef struct _SkkTool SkkTool;
typedef struct _SkkToolClass SkkToolClass;
typedef struct _SkkToolPrivate SkkToolPrivate;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _SkkTool {
	GObject parent_instance;
	SkkToolPrivate * priv;
};

struct _SkkToolClass {
	GObjectClass parent_class;
};


static gpointer skk_tool_parent_class = NULL;
static gchar* skk_tool_file_dict;
static gchar* skk_tool_file_dict = NULL;
static gchar* skk_tool_user_dict;
static gchar* skk_tool_user_dict = NULL;
static gchar* skk_tool_skkserv;
static gchar* skk_tool_skkserv = NULL;
static gchar* skk_tool_typing_rule;
static gchar* skk_tool_typing_rule = NULL;
static gboolean skk_tool_list_typing_rules;
static gboolean skk_tool_list_typing_rules = FALSE;

GType skk_tool_get_type (void) G_GNUC_CONST;
enum  {
	SKK_TOOL_DUMMY_PROPERTY
};
gint skk_tool_main (gchar** args, int args_length1);
static void _vala_SkkRuleMetadata_array_free (SkkRuleMetadata* array, gint array_length);
SkkTool* skk_tool_new (void);
SkkTool* skk_tool_construct (GType object_type);
static void skk_tool_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry SKK_TOOL_options[6] = {{"file-dict", 'f', 0, G_OPTION_ARG_STRING, &skk_tool_file_dict, "Path to a file dictionary", NULL}, {"user-dict", 'u', 0, G_OPTION_ARG_STRING, &skk_tool_user_dict, "Path to a user dictionary", NULL}, {"skkserv", 's', 0, G_OPTION_ARG_STRING, &skk_tool_skkserv, "Host and port running skkserv (HOST:PORT)", NULL}, {"rule", 'r', 0, G_OPTION_ARG_STRING, &skk_tool_typing_rule, "Typing rule (default: \"default\")", NULL}, {"list-rules", 'l', 0, G_OPTION_ARG_NONE, &skk_tool_list_typing_rules, "List typing rules", NULL}, {NULL}};

static void _vala_SkkRuleMetadata_array_free (SkkRuleMetadata* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			skk_rule_metadata_destroy (&array[i]);
		}
	}
	g_free (array);
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gchar* g_file_stream_read_line (FILE* self) {
	gchar* result = NULL;
	gint c = 0;
	GString* ret;
	GString* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		gint _tmp0_ = 0;
		gint _tmp1_;
		GString* _tmp2_;
		gint _tmp4_;
		GString* _tmp5_;
		gint _tmp6_;
		_tmp0_ = fgetc (self);
		c = _tmp0_;
		_tmp1_ = c;
		if (!(_tmp1_ != EOF)) {
			break;
		}
		_tmp2_ = ret;
		if (_tmp2_ == NULL) {
			GString* _tmp3_;
			_tmp3_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp3_;
		}
		_tmp4_ = c;
		if (_tmp4_ == ((gint) '\n')) {
			break;
		}
		_tmp5_ = ret;
		_tmp6_ = c;
		g_string_append_c (_tmp5_, (gchar) _tmp6_);
	}
	_tmp7_ = ret;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = ret;
		_tmp9_ = _tmp8_->str;
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gint skk_tool_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* _tmp0_;
	GOptionContext* option_context;
	GOptionContext* _tmp1_;
	gboolean _tmp6_;
	GeeArrayList* _tmp18_;
	GeeArrayList* dictionaries;
	const gchar* _tmp19_;
	const gchar* _tmp25_;
	const gchar* _tmp45_;
	GeeArrayList* _tmp68_;
	gint _tmp69_ = 0;
	gpointer* _tmp70_ = NULL;
	SkkDict** _tmp71_;
	gint _tmp71__length1;
	SkkContext* _tmp72_;
	SkkContext* _tmp73_;
	SkkContext* context;
	const gchar* _tmp74_;
	gchar* line = NULL;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new ("- skk");
	option_context = _tmp0_;
	_tmp1_ = option_context;
	g_option_context_add_main_entries (_tmp1_, SKK_TOOL_options, "libskk");
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option_context;
		g_option_context_parse (_tmp2_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "%s\n", _tmp5_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (option_context);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (option_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	skk_init ();
	_tmp6_ = skk_tool_list_typing_rules;
	if (_tmp6_) {
		gint _tmp7_ = 0;
		SkkRuleMetadata* _tmp8_ = NULL;
		SkkRuleMetadata* rules;
		gint rules_length1;
		gint _rules_size_;
		SkkRuleMetadata* _tmp9_;
		gint _tmp9__length1;
		_tmp8_ = skk_rule_list (&_tmp7_);
		rules = _tmp8_;
		rules_length1 = _tmp7_;
		_rules_size_ = rules_length1;
		_tmp9_ = rules;
		_tmp9__length1 = rules_length1;
		{
			SkkRuleMetadata* rule_collection = NULL;
			gint rule_collection_length1 = 0;
			gint _rule_collection_size_ = 0;
			gint rule_it = 0;
			rule_collection = _tmp9_;
			rule_collection_length1 = _tmp9__length1;
			for (rule_it = 0; rule_it < _tmp9__length1; rule_it = rule_it + 1) {
				SkkRuleMetadata _tmp10_ = {0};
				SkkRuleMetadata rule = {0};
				skk_rule_metadata_copy (&rule_collection[rule_it], &_tmp10_);
				rule = _tmp10_;
				{
					FILE* _tmp11_;
					SkkRuleMetadata _tmp12_;
					const gchar* _tmp13_;
					SkkRuleMetadata _tmp14_;
					const gchar* _tmp15_;
					SkkRuleMetadata _tmp16_;
					const gchar* _tmp17_;
					_tmp11_ = stdout;
					_tmp12_ = rule;
					_tmp13_ = _tmp12_.name;
					_tmp14_ = rule;
					_tmp15_ = _tmp14_.label;
					_tmp16_ = rule;
					_tmp17_ = _tmp16_.description;
					fprintf (_tmp11_, "%s - %s: %s\n", _tmp13_, _tmp15_, _tmp17_);
					skk_rule_metadata_destroy (&rule);
				}
			}
		}
		result = 0;
		rules = (_vala_SkkRuleMetadata_array_free (rules, rules_length1), NULL);
		_g_option_context_free0 (option_context);
		return result;
	}
	_tmp18_ = gee_array_list_new (SKK_TYPE_DICT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	dictionaries = _tmp18_;
	_tmp19_ = skk_tool_user_dict;
	if (_tmp19_ != NULL) {
		const gchar* _tmp20_;
		SkkUserDict* _tmp21_;
		SkkUserDict* _tmp22_;
		GeeArrayList* _tmp23_;
		SkkUserDict* _tmp24_;
		_tmp20_ = skk_tool_file_dict;
		_tmp21_ = skk_user_dict_new (_tmp20_, "UTF-8", &_inner_error_);
		_tmp22_ = _tmp21_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp23_ = dictionaries;
		_tmp24_ = _tmp22_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, (SkkDict*) _tmp24_);
		_g_object_unref0 (_tmp24_);
	}
	_tmp25_ = skk_tool_file_dict;
	if (_tmp25_ != NULL) {
		const gchar* _tmp26_;
		gboolean _tmp27_ = FALSE;
		_tmp26_ = skk_tool_file_dict;
		_tmp27_ = g_str_has_suffix (_tmp26_, ".cdb");
		if (_tmp27_) {
			const gchar* _tmp28_;
			SkkCdbDict* _tmp29_;
			SkkCdbDict* _tmp30_;
			GeeArrayList* _tmp31_;
			SkkCdbDict* _tmp32_;
			_tmp28_ = skk_tool_file_dict;
			_tmp29_ = skk_cdb_dict_new (_tmp28_, "EUC-JP", &_inner_error_);
			_tmp30_ = _tmp29_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp31_ = dictionaries;
			_tmp32_ = _tmp30_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, (SkkDict*) _tmp32_);
			_g_object_unref0 (_tmp32_);
		} else {
			const gchar* _tmp33_;
			SkkFileDict* _tmp34_;
			SkkFileDict* _tmp35_;
			GeeArrayList* _tmp36_;
			SkkFileDict* _tmp37_;
			_tmp33_ = skk_tool_file_dict;
			_tmp34_ = skk_file_dict_new (_tmp33_, "EUC-JP", &_inner_error_);
			_tmp35_ = _tmp34_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp36_ = dictionaries;
			_tmp37_ = _tmp35_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, (SkkDict*) _tmp37_);
			_g_object_unref0 (_tmp37_);
		}
	} else {
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_;
		SkkFileDict* _tmp40_;
		SkkFileDict* _tmp41_;
		SkkFileDict* _tmp42_;
		GeeArrayList* _tmp43_;
		SkkFileDict* _tmp44_;
		_tmp38_ = g_build_filename (DATADIR, "skk", "SKK-JISYO.L", NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = skk_file_dict_new (_tmp39_, "EUC-JP", &_inner_error_);
		_tmp41_ = _tmp40_;
		_g_free0 (_tmp39_);
		_tmp42_ = _tmp41_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp43_ = dictionaries;
		_tmp44_ = _tmp42_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp43_, (SkkDict*) _tmp44_);
		_g_object_unref0 (_tmp44_);
	}
	_tmp45_ = skk_tool_skkserv;
	if (_tmp45_ != NULL) {
		const gchar* _tmp46_;
		gint _tmp47_ = 0;
		gint index;
		gchar* host = NULL;
		guint16 port = 0U;
		gint _tmp48_;
		const gchar* _tmp62_;
		guint16 _tmp63_;
		SkkSkkServ* _tmp64_;
		SkkSkkServ* _tmp65_;
		GeeArrayList* _tmp66_;
		SkkSkkServ* _tmp67_;
		_tmp46_ = skk_tool_skkserv;
		_tmp47_ = string_last_index_of (_tmp46_, ":", 0);
		index = _tmp47_;
		_tmp48_ = index;
		if (_tmp48_ < 0) {
			const gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp49_ = skk_tool_skkserv;
			_tmp50_ = g_strdup (_tmp49_);
			_g_free0 (host);
			host = _tmp50_;
			port = (guint16) 1178;
		} else {
			const gchar* _tmp51_;
			gint _tmp52_;
			gchar* _tmp53_ = NULL;
			const gchar* _tmp54_;
			gint _tmp55_;
			const gchar* _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			gchar* _tmp59_ = NULL;
			gchar* _tmp60_;
			gint _tmp61_ = 0;
			_tmp51_ = skk_tool_skkserv;
			_tmp52_ = index;
			_tmp53_ = string_slice (_tmp51_, (glong) 0, (glong) _tmp52_);
			_g_free0 (host);
			host = _tmp53_;
			_tmp54_ = skk_tool_skkserv;
			_tmp55_ = index;
			_tmp56_ = skk_tool_skkserv;
			_tmp57_ = strlen (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = string_slice (_tmp54_, (glong) (_tmp55_ + 1), (glong) _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = atoi (_tmp60_);
			port = (guint16) _tmp61_;
			_g_free0 (_tmp60_);
		}
		_tmp62_ = host;
		_tmp63_ = port;
		_tmp64_ = skk_skk_serv_new (_tmp62_, _tmp63_, "EUC-JP", &_inner_error_);
		_tmp65_ = _tmp64_;
		if (_inner_error_ != NULL) {
			_g_free0 (host);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp66_ = dictionaries;
		_tmp67_ = _tmp65_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, (SkkDict*) _tmp67_);
		_g_object_unref0 (_tmp67_);
		_g_free0 (host);
	}
	_tmp68_ = dictionaries;
	_tmp70_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp68_, &_tmp69_);
	_tmp71_ = _tmp70_;
	_tmp71__length1 = _tmp69_;
	_tmp72_ = skk_context_new (_tmp71_, _tmp69_);
	_tmp73_ = _tmp72_;
	_tmp71_ = (_vala_array_free (_tmp71_, _tmp71__length1, (GDestroyNotify) g_object_unref), NULL);
	context = _tmp73_;
	_tmp74_ = skk_tool_typing_rule;
	if (_tmp74_ != NULL) {
		{
			const gchar* _tmp75_;
			SkkRule* _tmp76_;
			SkkRule* _tmp77_;
			SkkContext* _tmp78_;
			SkkRule* _tmp79_;
			_tmp75_ = skk_tool_typing_rule;
			_tmp76_ = skk_rule_new (_tmp75_, &_inner_error_);
			_tmp77_ = _tmp76_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
					goto __catch1_skk_rule_parse_error;
				}
				_g_object_unref0 (context);
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp78_ = context;
			_tmp79_ = _tmp77_;
			skk_context_set_typing_rule (_tmp78_, _tmp79_);
			_g_object_unref0 (_tmp79_);
		}
		goto __finally1;
		__catch1_skk_rule_parse_error:
		{
			GError* e = NULL;
			FILE* _tmp80_;
			const gchar* _tmp81_;
			GError* _tmp82_;
			const gchar* _tmp83_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp80_ = stderr;
			_tmp81_ = skk_tool_typing_rule;
			_tmp82_ = e;
			_tmp83_ = _tmp82_->message;
			fprintf (_tmp80_, "can't load rule \"%s\": %s\n", _tmp81_, _tmp83_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		FILE* _tmp84_;
		gchar* _tmp85_ = NULL;
		const gchar* _tmp86_;
		SkkContext* _tmp87_;
		const gchar* _tmp88_;
		SkkContext* _tmp89_;
		gchar* _tmp90_ = NULL;
		gchar* output;
		SkkContext* _tmp91_;
		const gchar* _tmp92_;
		const gchar* _tmp93_;
		gchar* _tmp94_;
		gchar* preedit;
		FILE* _tmp95_;
		const gchar* _tmp96_;
		gchar* _tmp97_ = NULL;
		gchar* _tmp98_;
		const gchar* _tmp99_;
		gchar* _tmp100_ = NULL;
		gchar* _tmp101_;
		const gchar* _tmp102_;
		gchar* _tmp103_ = NULL;
		gchar* _tmp104_;
		SkkContext* _tmp105_;
		SkkContext* _tmp106_;
		_tmp84_ = stdin;
		_tmp85_ = g_file_stream_read_line (_tmp84_);
		_g_free0 (line);
		line = _tmp85_;
		_tmp86_ = line;
		if (!(_tmp86_ != NULL)) {
			break;
		}
		_tmp87_ = context;
		_tmp88_ = line;
		skk_context_process_key_events (_tmp87_, _tmp88_);
		_tmp89_ = context;
		_tmp90_ = skk_context_poll_output (_tmp89_);
		output = _tmp90_;
		_tmp91_ = context;
		_tmp92_ = skk_context_get_preedit (_tmp91_);
		_tmp93_ = _tmp92_;
		_tmp94_ = g_strdup (_tmp93_);
		preedit = _tmp94_;
		_tmp95_ = stdout;
		_tmp96_ = line;
		_tmp97_ = string_replace (_tmp96_, "\"", "\\\"");
		_tmp98_ = _tmp97_;
		_tmp99_ = output;
		_tmp100_ = string_replace (_tmp99_, "\"", "\\\"");
		_tmp101_ = _tmp100_;
		_tmp102_ = preedit;
		_tmp103_ = string_replace (_tmp102_, "\"", "\\\"");
		_tmp104_ = _tmp103_;
		fprintf (_tmp95_, "{ \"input\": \"%s\", " "\"output\": \"%s\", " "\"preedit\": \"%s\" }\n", _tmp98_, _tmp101_, _tmp104_);
		_g_free0 (_tmp104_);
		_g_free0 (_tmp101_);
		_g_free0 (_tmp98_);
		_tmp105_ = context;
		skk_context_reset (_tmp105_);
		_tmp106_ = context;
		skk_context_clear_output (_tmp106_);
		_g_free0 (preedit);
		_g_free0 (output);
	}
	result = 0;
	_g_free0 (line);
	_g_object_unref0 (context);
	_g_object_unref0 (dictionaries);
	_g_option_context_free0 (option_context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return skk_tool_main (argv, argc);
}


SkkTool* skk_tool_construct (GType object_type) {
	SkkTool * self = NULL;
	self = (SkkTool*) g_object_new (object_type, NULL);
	return self;
}


SkkTool* skk_tool_new (void) {
	return skk_tool_construct (SKK_TYPE_TOOL);
}


static void skk_tool_class_init (SkkToolClass * klass) {
	skk_tool_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = skk_tool_finalize;
}


static void skk_tool_instance_init (SkkTool * self) {
}


static void skk_tool_finalize (GObject* obj) {
	SkkTool * self;
	self = SKK_TOOL (obj);
	G_OBJECT_CLASS (skk_tool_parent_class)->finalize (obj);
}


GType skk_tool_get_type (void) {
	static volatile gsize skk_tool_type_id__volatile = 0;
	if (g_once_init_enter (&skk_tool_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkTool), 0, (GInstanceInitFunc) skk_tool_instance_init, NULL };
		GType skk_tool_type_id;
		skk_tool_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkTool", &g_define_type_info, 0);
		g_once_init_leave (&skk_tool_type_id__volatile, skk_tool_type_id);
	}
	return skk_tool_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



