/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _SOLAR_HRC
#include <bf_svtools/solar.hrc>
#endif

#define HID_BASE                    HID_APP_START

#define HID_BIB_BASE                (HID_BASE +  1)
#define HID_DBSEL                   (HID_BASE +  2)
#define HID_DBEDIT                  (HID_BASE +  3)
#define HID_PRINT_OPTION            (HID_BASE +  4)
#define HID_MERGE_PRINTMONITOR      (HID_BASE +  5)
#define HID_FLD_INPUT               (HID_BASE +  6)
#define HID_CONFIG_MISC             (HID_BASE +  7)
#define HID_CONFIG_PATH             (HID_BASE +  8)
#define HID_CONFIG_TB               (HID_BASE +  9)
#define HID_PG_FOOTNOTE             (HID_BASE + 10)
#define HID_FORMAT_GRAPHIC          (HID_BASE + 11)
#define HID_FILTERSTATUS            (HID_BASE + 12)
#define HID_DOCINFO_EDT             (HID_BASE + 13)
#define HID_DBLOGON                 (HID_BASE + 14)
#define HID_MAC_ASSIGN              (HID_BASE + 15)
#define HID_CONFIG_MN               (HID_BASE + 16)
#define HID_PAPERSIZE               (HID_BASE + 17)
#define HID_PASSWD                  (HID_BASE + 18)
#define HID_SPELLING_OPTIONS        (HID_BASE + 19)
#define HID_HYPHENATE_OPTIONS       (HID_BASE + 20)
#define HID_FORMAT_COLUMN           (HID_BASE + 21)
#define HID_CONFIG_SAVE             (HID_BASE + 22)
#define HID_NUM_NAMES               (HID_BASE + 23)
#define HID_SYMBOL_SELECT           (HID_BASE + 24)
#define HID_CONFIG_KY               (HID_BASE + 25)
#define HID_LINKEDIT                (HID_BASE + 26)
#define HID_GRAPHIC_PREVIEW         (HID_BASE + 28)
#define HID_DICTIONARY              (HID_BASE + 29)
#define HID_SET_STYLE               (HID_BASE + 30)
#define HID_RIBBONBAR               (HID_BASE + 31)
#define HID_STATUSLINE              (HID_BASE + 32)
#define HID_DOCBAR                  (HID_BASE + 33)
#define HID_VRULER                  (HID_BASE + 34)
#define HID_MAKRO_WINDOW            (HID_BASE + 35)
#define HID_ENVELOP_FORMAT          (HID_BASE + 37)
#define HID_ENVELOP_PRINTER         (HID_BASE + 38)

#define HID_HEADER_FOOTER_DLG       (HID_BASE + 39)
#define HID_GRID_DLG                (HID_BASE + 40)
#define HID_USER_ADDRESS_DLG        (HID_BASE + 41)
#define HID_SELECT_FAX_DLG          (HID_BASE + 42)

#define HID_LABEL_FORMAT            (HID_BASE + 43)
#define HID_BRSORT                  (HID_BASE + 44)
#define HID_BRSEEK                  (HID_BASE + 45)
#define HID_BRCFG                   (HID_BASE + 46)

#define HID_FORMEDT_CONTENT         (HID_BASE + 47)
#define HID_FORMEDT_USER            (HID_BASE + 48)
#define HID_FORMEDT_INDEX           (HID_BASE + 49)

#define HID_SCRL_PAGEUP             (HID_BASE + 50)
#define HID_SCRL_PAGEDOWN           (HID_BASE + 51)

#define HID_DRAW_WIN                (HID_BASE + 52)
#define HID_EDIT_WIN                (HID_BASE + 53)

#define HID_INSERT_CTRL             (HID_BASE + 54) // TbxControl Einfuegen
#define HID_INSERT_OBJ_CTRL         (HID_BASE + 55)
#define HID_INSERT_FIELD_CTRL       (HID_BASE + 56)

#define HID_SOURCEVIEW              (HID_BASE + 57)
#define HID_TBL_OPT_CTRL            (HID_BASE + 58)
#define HID_AUTOFORMAT_CLB          (HID_BASE + 59)

#define HID_SCRL_NAVI               (HID_BASE + 60)
#define HID_NAVI_DRAG_HYP           (HID_BASE + 61)
#define HID_NAVI_DRAG_LINK          (HID_BASE + 62)
#define HID_NAVI_DRAG_COPY          (HID_BASE + 63)
#define HID_NAVI_OUTLINES           (HID_BASE + 64)

#define HID_AUTOFORMAT_EXEC         (HID_BASE + 65)
#define HID_AUTOFORMAT_CLOSE        (HID_BASE + 66)

#define HID_PAGEPREVIEW             (HID_BASE + 67)
#define HID_SOURCE_EDITWIN          (HID_BASE + 68)

// Dialog Help-IDs **********************************************************

#define HID_CONVERT_FROM            (HID_BASE + 200)
#define HID_CONVERT_TO              (HID_BASE + 201)
#define HID_EDIT_POSTIT             (HID_BASE + 202)
#define HID_INSERT_CHART            (HID_BASE + 203)
#define HID_PAGE_PREVIEW            (HID_BASE + 204)
#define HID_INSERT_HYPERLINK        (HID_BASE + 205)
#define HID_NAVIGATOR_TREELIST      (HID_BASE + 206)
#define HID_DLG_CAPTION             (HID_BASE + 207)
#define HID_DLG_GLOSS_DECIDE        (HID_BASE + 208)
#define HID_NAVIGATOR_TOOLBOX       (HID_BASE + 209)
#define HID_NAVIGATOR_LISTBOX       (HID_BASE + 210)
#define HID_NUM_BULLET_DLG          (HID_BASE + 211)
#define HID_VS_SINGLENUM            (HID_BASE + 212)
#define HID_VS_NUM                  (HID_BASE + 213)
#define HID_VS_BULLET               (HID_BASE + 214)
#define HID_VS_NUMBMP               (HID_BASE + 215)
#define HID_VS_RULER                (HID_BASE + 216)
#define HID_RULER_DIALOG            (HID_BASE + 217)
#define HID_INSERT_ABSTRACT         (HID_BASE + 218)
#define HID_NAVI_TBX1               (HID_BASE + 219)
#define HID_NAVI_TBX2               (HID_BASE + 220)
#define HID_NAVI_TBX3               (HID_BASE + 221)
#define HID_NAVI_TBX4               (HID_BASE + 222)
#define HID_NAVI_TBX5               (HID_BASE + 223)
#define HID_NAVI_TBX6               (HID_BASE + 224)
#define HID_NAVI_TBX7               (HID_BASE + 225)
#define HID_NAVI_TBX8               (HID_BASE + 226)
#define HID_NAVI_TBX9               (HID_BASE + 227)
#define HID_NAVI_TBX10              (HID_BASE + 228)
#define HID_NAVI_TBX11              (HID_BASE + 229)
#define HID_NAVI_TBX12              (HID_BASE + 230)
#define HID_NAVI_TBX13              (HID_BASE + 231)
#define HID_NAVI_TBX14              (HID_BASE + 232)
#define HID_NAVI_TBX15              (HID_BASE + 233)
#define HID_NAVI_VS                 (HID_BASE + 234)
#define HID_NUM_FORMAT_BTN          (HID_BASE + 235)
#define HID_PPREV_ZOOM              (HID_BASE + 236)
#define HID_NAVI_TBX16              (HID_BASE + 237)
#define HID_LTEMPL_TEXT             (HID_BASE + 238)
#define HID_LTEMPL_FRAME            (HID_BASE + 239)
#define HID_LTEMPL_PAGE             (HID_BASE + 240)
#define HID_LTEMPL_OVERRIDE         (HID_BASE + 241)
#define HID_LTEMPL_TEMPLATES        (HID_BASE + 242)
#define HID_NAVI_TBX17              (HID_BASE + 243)
#define HID_NAVI_TBX18              (HID_BASE + 244)
#define HID_NAVI_TBX19              (HID_BASE + 245)
#define HID_NAVI_TBX20              (HID_BASE + 246)
#define HID_NAVI_TBX21              (HID_BASE + 247)
#define HID_NAVI_TBX22              (HID_BASE + 248)
#define HID_NAVI_TBX23              (HID_BASE + 249)
#define HID_NAVI_TBX24              (HID_BASE + 250)
#define HID_NAVIGATOR_GLOBAL_TOOLBOX (HID_BASE + 251)
#define HID_NAVIGATOR_GLOB_TREELIST (HID_BASE + 252)
#define HID_GLOS_GROUP_TREE         (HID_BASE + 253)
#define HID_GLBLTREE_UPDATE         (HID_BASE + 254)
#define HID_GLBLTREE_INSERT         (HID_BASE + 255)
#define HID_GLBLTREE_EDIT           (HID_BASE + 256)
#define HID_GLBLTREE_DEL            (HID_BASE + 257)
#define HID_GLBLTREE_INS_IDX        (HID_BASE + 258)
#define HID_GLBLTREE_INS_CNTIDX     (HID_BASE + 259)
#define HID_GLBLTREE_INS_USRIDX     (HID_BASE + 260)
#define HID_GLBLTREE_INS_FILE       (HID_BASE + 261)
#define HID_GLBLTREE_INS_NEW_FILE   (HID_BASE + 262)
#define HID_GLBLTREE_INS_TEXT       (HID_BASE + 263)
#define HID_GLBLTREE_UPD_SEL        (HID_BASE + 264)
#define HID_GLBLTREE_UPD_IDX        (HID_BASE + 265)
#define HID_GLBLTREE_UPD_LINK       (HID_BASE + 266)
#define HID_GLBLTREEUPD_ALL         (HID_BASE + 267)
#define HID_NUM_OUTL_NAMED_NUMS     (HID_BASE + 268)
#define HID_NUM_OUTL_NUM_SAVEAS     (HID_BASE + 269)
#define HID_NUM_NAMED_NUMS          (HID_BASE + 270)
#define HID_NUM_NUM_SAVEAS          (HID_BASE + 271)
#define HID_NUM_STD_NUMBER          (HID_BASE + 272)
#define HID_NUM_DEL_NUMBER          (HID_BASE + 273)
#define HID_NUM_STD_BULLET          (HID_BASE + 274)
#define HID_NUM_DEL_BULLET          (HID_BASE + 275)
#define HID_NAVI_CONTENT            (HID_BASE + 276)
#define HID_NAVI_GLOBAL             (HID_BASE + 277)
#define HID_LTEMPL_NUMBERING        (HID_BASE + 278)
#define HID_FLDVAR_APPLY            (HID_BASE + 279)
#define HID_FLDVAR_DELETE           (HID_BASE + 280)
#define HID_FLDEDT_ADDRESS          (HID_BASE + 281)
#define HID_SORT_ACTION             (HID_BASE + 282)
#define HID_SORT_AUTHOR             (HID_BASE + 283)
#define HID_SORT_DATE               (HID_BASE + 284)
#define HID_SORT_COMMENT            (HID_BASE + 285)
#define HID_SW_SORT_POSITION        (HID_BASE + 286)
#define HID_SYNC_BTN                (HID_BASE + 287)
#define HID_EDIT_COMMENT            (HID_BASE + 288)
#define HID_SEL_TEMPLATE            (HID_BASE + 289)
#define HID_DLG_SEQUENCE_OPTION     (HID_BASE + 290)
#define HID_DLG_FLDEDT_NEXT         (HID_BASE + 291)
#define HID_DLG_FLDEDT_PREV         (HID_BASE + 292)
#define HID_DLG_FLDEDT_ADDRESS      (HID_BASE + 293)
#define HID_DLG_PRV_PRT_OPTIONS     (HID_BASE + 294)

#define HID_FILEDLG_CHARDLG         (HID_BASE + 295)
#define HID_FILEDLG_LOADTEMPLATE    (HID_BASE + 296)
#define HID_FILEDLG_ROMENU          (HID_BASE + 297)
#define HID_FILEDLG_MAILMRGE1       (HID_BASE + 298)
#define HID_FILEDLG_MAILMRGE2       (HID_BASE + 299)
#define HID_FILEDLG_FRMPAGE         (HID_BASE + 300)
#define HID_FILEDLG_SRCVIEW         (HID_BASE + 301)
#define HID_FILEDLG_WIZDOKU         (HID_BASE + 302)
#define HID_PREVIEW_ZOOM            (HID_BASE + 303)

#define HID_REDLINE_AUTOFMT_ACCEPT  (HID_BASE + 304)
#define HID_MULTI_TOX_DLG           (HID_BASE + 305)
#define HID_ASCII_FILTER            (HID_BASE + 306)
#define HID_GLBLTREE_EDIT_LINK      (HID_BASE + 307)
#define HID_FORMAT_NAME_OBJECT_NAME (HID_BASE + 308)// #100286#

// TabPage Help-IDs *********************************************************

#define HID_DROPCAPS                (HID_BASE + 400)
#define HID_FRM_EXT                 (HID_BASE + 401)
#define HID_FRM_STD                 (HID_BASE + 402)
#define HID_GRF_EXT                 (HID_BASE + 403)
#define HID_COLUMN                  (HID_BASE + 404)
#define HID_DOC_STAT                (HID_BASE + 405)
#define HID_MACROASSIGN             (HID_BASE + 406)
#define HID_FOOTNOTE_PAGE           (HID_BASE + 407)
#define HID_OPTDOCDISP_PAGE         (HID_BASE + 408)
#define HID_OPTGRID_PAGE            (HID_BASE + 409)
#define HID_OPTTEST_PAGE            (HID_BASE + 410)
#define HID_OPTPRINT_PAGE           (HID_BASE + 411)
#define HID_FORMAT_TABLE            (HID_BASE + 412)
#define HID_TABLE_COLUMN            (HID_BASE + 413)
#define HID_LAB_LAB                 (HID_BASE + 414)
#define HID_LAB_PRT                 (HID_BASE + 415)
#define HID_ENV_PRT                 (HID_BASE + 416)
#define HID_LAB_FMT                 (HID_BASE + 417)
#define HID_ENV_ENV                 (HID_BASE + 418)
#define HID_ENV_FMT                 (HID_BASE + 419)
#define HID_FRM_URL                 (HID_BASE + 421)
#define HID_CHAR_URL                (HID_BASE + 422)
#define HID_CONTENT_OPT             (HID_BASE + 423)
#define HID_LAYOUT_OPT              (HID_BASE + 424)
#define HID_STD_FONT                (HID_BASE + 425)
#define HID_COND_COLL               (HID_BASE + 426)
#define HID_FRM_ADD                 (HID_BASE + 427)
#define HID_TABLE_TEXTFLOW          (HID_BASE + 428)
#define HID_AUTOFMT_BY_INPUT        (HID_BASE + 429)
#define HID_AUTOFMT_APPLY           (HID_BASE + 430)
#define HID_OPTTABLE_PAGE           (HID_BASE + 431)
#define HID_PICK_SINGLE_NUM         (HID_BASE + 432)
#define HID_PICK_BULLET             (HID_BASE + 433)
#define HID_PICK_NUM                (HID_BASE + 434)
#define HID_PICK_BMP                (HID_BASE + 435)

#define HID_FLD_DB                  (HID_BASE + 437)
#define HID_FLD_DOKINF              (HID_BASE + 438)
#define HID_FLD_VAR                 (HID_BASE + 439)
#define HID_FLD_DOK                 (HID_BASE + 440)
#define HID_FLD_FUNC                (HID_BASE + 441)
#define HID_FLD_REF                 (HID_BASE + 442)
#define HID_OPTSHDWCRSR             (HID_BASE + 443)
#define HID_NUM_OPTIONS             (HID_BASE + 444)
#define HID_NUM_POSITION            (HID_BASE + 445)
#define HID_NUMPARA                 (HID_BASE + 446)
#define HID_FOOTNOTE_OPTIONS        (HID_BASE + 447)
#define HID_ENDNOTE_OPTIONS         (HID_BASE + 448)
#define HID_REDLINE_OPT             (HID_BASE + 449)
#define HID_LINENUMBERING           (HID_BASE + 450)
#define HID_REDLINE_ACCEPT          (HID_BASE + 451)
#define HID_EDIT_FLD_DB             (HID_BASE + 452)
#define HID_EDIT_FLD_DOKINF         (HID_BASE + 453)
#define HID_EDIT_FLD_VAR            (HID_BASE + 454)
#define HID_EDIT_FLD_DOK            (HID_BASE + 455)
#define HID_EDIT_FLD_FUNC           (HID_BASE + 456)
#define HID_EDIT_FLD_REF            (HID_BASE + 457)
#define HID_REDLINE_CTRL            (HID_BASE + 458)
#define HID_TP_OUTLINE_NUM          (HID_BASE + 459)
#define HID_OPTINSERT_PAGE          (HID_BASE + 460)
#define HID_OPTCAPTION_PAGE         (HID_BASE + 461)
#define HID_OPTLOAD_PAGE            (HID_BASE + 462)
#define HID_INSERT_TOX_PAGE         (HID_BASE + 463)
#define HID_TOX_FORM_ENTRY_PAGE     (HID_BASE + 464)
#define HID_TOX_FORM_STYLES_PAGE    (HID_BASE + 465)
#define HID_INSERT_TOX_TABDLG       (HID_BASE + 466)
#define HID_INSERT_SECTION_PAGE     (HID_BASE + 467)
#define HID_INSERT_SECTION_DLG      (HID_BASE + 468)
#define HID_SECTION_PROPERTIES_DLG  (HID_BASE + 469)
#define HID_RENAME_XNAMED           (HID_BASE + 470)
#define HID_TP_TOX_SELECT           (HID_BASE + 471)
#define HID_TP_TOX_ENTRY            (HID_BASE + 472)
#define HID_TOX_STYLES_PAGE         (HID_BASE + 473)
#define HID_TP_VISITING_CARDS       (HID_BASE + 474)
#define HID_DLG_ADD_IDX_STYLES      (HID_BASE + 475)
#define HID_ADD_STYLES_TLB          (HID_BASE + 476)
#define HID_OLE_CHECKLB             (HID_BASE + 477)
#define HID_DLG_CREATE_AUTH_ENTRY   (HID_BASE + 478)
#define HID_TP_PRIVATE_DATA         (HID_BASE + 479)
#define HID_TP_BUSINESS_DATA        (HID_BASE + 480)
#define HID_SECTION_FTNENDNOTES_PAGE (HID_BASE + 481)
#define HID_TEXTGRID_PAGE           (HID_BASE + 482)

// AutoPilot Help-IDs *********************************************************

#define HID_LETTER_PAGE1            (HID_BASE + 501)
#define HID_LETTER_PAGE2            (HID_BASE + 502)
#define HID_LETTER_PAGE3            (HID_BASE + 503)
#define HID_LETTER_PAGE4            (HID_BASE + 504)
#define HID_LETTER_PAGE5            (HID_BASE + 505)
#define HID_LETTER_PAGE6            (HID_BASE + 506)
#define HID_LETTER_PAGE7            (HID_BASE + 507)
#define HID_LETTER_PAGE8            (HID_BASE + 508)
#define HID_LETTER_PAGE9            (HID_BASE + 509)

#define HID_FAX_PAGE1               (HID_BASE + 511)
#define HID_FAX_PAGE2               (HID_BASE + 512)
#define HID_FAX_PAGE3               (HID_BASE + 513)
#define HID_FAX_PAGE4               (HID_BASE + 514)
#define HID_FAX_PAGE5               (HID_BASE + 515)
#define HID_FAX_PAGE6               (HID_BASE + 516)
#define HID_FAX_PAGE7               (HID_BASE + 517)
#define HID_FAX_PAGE8               (HID_BASE + 518)

#define HID_MEMO_PAGE1              (HID_BASE + 521)
#define HID_MEMO_PAGE2              (HID_BASE + 522)
#define HID_MEMO_PAGE3              (HID_BASE + 523)
#define HID_MEMO_PAGE4              (HID_BASE + 524)
#define HID_MEMO_PAGE5              (HID_BASE + 525)

#define HID_AGENDA_PAGE1            (HID_BASE + 531)
#define HID_AGENDA_PAGE2            (HID_BASE + 532)
#define HID_AGENDA_PAGE3            (HID_BASE + 533)
#define HID_AGENDA_PAGE4            (HID_BASE + 534)
#define HID_AGENDA_PAGE5            (HID_BASE + 535)
#define HID_AGENDA_PAGE6            (HID_BASE + 536)

#define HID_AUTOPILOT_NEXT          (HID_BASE + 537)
#define HID_AUTOPILOT_PREV          (HID_BASE + 538)
#define HID_AUTOPILOT_OK            (HID_BASE + 539)

// HelpIds fuers Menue *****************************************************

#define HID_MN_SUB_TBLROW           (HID_BASE + 600)
#define HID_MN_SUB_TBLCOL           (HID_BASE + 601)
#define HID_MN_SUB_AUTOFORMAT       (HID_BASE + 602)
#define HID_MN_SUB_TOOLBAR          (HID_BASE + 603)
#define HID_MN_SUB_FIELD            (HID_BASE + 604)
#define HID_MN_SUB_GRAPHIC          (HID_BASE + 605)
#define HID_MN_SUB_TEMPLATES        (HID_BASE + 606)
#define HID_MN_SUB_ARRANGE          (HID_BASE + 607)
#define HID_MN_SUB_SPELLING         (HID_BASE + 608)
#define HID_MN_SUB_UPDATE           (HID_BASE + 609)
#define HID_MN_SUB_MIRROR           (HID_BASE + 610)
#define HID_MN_SUB_ALIGN            (HID_BASE + 611)
#define HID_MN_SUB_OPTIONS          (HID_BASE + 612)

#define HID_MN_CALC_PHD             (HID_BASE + 613)
#define HID_MN_CALC_SQRT            (HID_BASE + 614)
#define HID_MN_CALC_OR              (HID_BASE + 615)
#define HID_MN_CALC_XOR             (HID_BASE + 616)
#define HID_MN_CALC_AND             (HID_BASE + 617)
#define HID_MN_CALC_NOT             (HID_BASE + 618)
#define HID_MN_CALC_EQ              (HID_BASE + 619)
#define HID_MN_CALC_NEQ             (HID_BASE + 620)
#define HID_MN_CALC_LEQ             (HID_BASE + 621)
#define HID_MN_CALC_GEQ             (HID_BASE + 622)
#define HID_MN_CALC_LES             (HID_BASE + 623)
#define HID_MN_CALC_GRE             (HID_BASE + 624)
#define HID_MN_CALC_SUM             (HID_BASE + 625)
#define HID_MN_CALC_MEAN            (HID_BASE + 626)
#define HID_MN_CALC_MIN             (HID_BASE + 627)
#define HID_MN_CALC_MAX             (HID_BASE + 628)
#define HID_MN_CALC_SIN             (HID_BASE + 629)
#define HID_MN_CALC_COS             (HID_BASE + 630)
#define HID_MN_CALC_TAN             (HID_BASE + 631)
#define HID_MN_CALC_ASIN            (HID_BASE + 632)
#define HID_MN_CALC_ACOS            (HID_BASE + 633)
#define HID_MN_CALC_ATAN            (HID_BASE + 634)
#define HID_MN_CALC_POW             (HID_BASE + 635)
#define HID_MN_CALC_LISTSEP         (HID_BASE + 636)
#define HID_MN_POP_OPS              (HID_BASE + 637)
#define HID_MN_POP_STATISTICS       (HID_BASE + 638)
#define HID_MN_POP_FUNC             (HID_BASE + 639)
#define HID_MN_RSC_END              (HID_BASE + 640)
#define HID_MN_CALC_ROUND           (HID_BASE + 641)
#define HID_MN_SUB_MACRO            (HID_BASE + 642)

#define HID_MN_READONLY_SAVEGRAPHIC             (HID_BASE + 645)
#define HID_MN_READONLY_GRAPHICTOGALLERY        (HID_BASE + 646)
#define HID_MN_READONLY_TOGALLERYLINK           (HID_BASE + 647)
#define HID_MN_READONLY_TOGALLERYCOPY           (HID_BASE + 648)
#define HID_MN_READONLY_SAVEBACKGROUND          (HID_BASE + 649)
#define HID_MN_READONLY_BACKGROUNDTOGALLERY     (HID_BASE + 650)
#define HID_MN_READONLY_COPYLINK                (HID_BASE + 651)
#define HID_MN_READONLY_COPYGRAPHIC             (HID_BASE + 652)
#define HID_MN_READONLY_LOADGRAPHIC             (HID_BASE + 653)
#define HID_MN_READONLY_GRAPHICOFF              (HID_BASE + 654)
#define HID_MN_READONLY_PLUGINOFF               (HID_BASE + 655)

#define HID_MD_GLOS_DEFINE          (HID_BASE + 656)
#define HID_MD_GLOS_REPLACE         (HID_BASE + 657)
#define HID_MD_GLOS_RENAME          (HID_BASE + 658)
#define HID_MD_GLOS_DELETE          (HID_BASE + 659)
#define HID_MD_GLOS_EDIT            (HID_BASE + 660)
#define HID_MD_GLOS_MACRO           (HID_BASE + 661)
#define HID_LINGU_ADD_WORD          (HID_BASE + 662)
#define HID_LINGU_IGNORE_WORD       (HID_BASE + 663)
#define HID_LINGU_SPELLING_DLG      (HID_BASE + 664)
#define HID_LINGU_AUTOCORR          (HID_BASE + 665)
#define HID_LINGU_REPLACE           (HID_BASE + 666)
#define HID_MD_GLOS_CATEGORY        (HID_BASE + 667)
#define HID_REGION_TREE             (HID_BASE + 668)
#define HID_LINGU_WORD_LANGUAGE     (HID_BASE + 669)
#define HID_LINGU_PARA_LANGUAGE     (HID_BASE + 670)
#define HID_MD_GLOS_DEFINE_TEXT     (HID_BASE + 671)
#define HID_DLG_PASSWD_SECTION      (HID_BASE + 672)
#define HID_MD_COPY_TO_CLIPBOARD    (HID_BASE + 673)
#define HID_MD_GLOS_IMPORT          (HID_BASE + 674)

// Weiter Help-IDs **********************************************************

#define HID_CLOSE_FILE              (HID_BASE + 1001)
#define HID_LAUNCH_REGISTRY         (HID_BASE + 1002)
#define HID_MERGE_FILE              (HID_BASE + 1003)
#define HID_MERGE_FILE_DLG          (HID_BASE + 1004)
#define HID_NEW_FILE                (HID_BASE + 1005)
#define HID_OPEN_FILE               (HID_BASE + 1007)
#define HID_OPEN_LASTVERSION        (HID_BASE + 1009)
#define HID_PRINT_FILE              (HID_BASE + 1010)
#define HID_PRINT_FILE_OPTIONS      (HID_BASE + 1011)
#define HID_SAVE_FILE_AS            (HID_BASE + 1012)
#define HID_SAVE_FILE               (HID_BASE + 1013)
#define HID_SETUP_PRINTER_DLG       (HID_BASE + 1015)
#define HID_EXIT                    (HID_BASE + 1017)
#define HID_CREATE_DOCUMENT         (HID_BASE + 1019)
#define HID_DOCSTAT_DLG             (HID_BASE + 1020)
#define HID_LOAD_TEMPLATE_DLG       (HID_BASE + 1021)
#define HID_SAVE_ALL                (HID_BASE + 1023)
#define HID_NEW_FILE_DEFAULT        (HID_BASE + 1024)
#define HID_PRINT_FILE_DEFAULT      (HID_BASE + 1025)
#define HID_FAX                     (HID_BASE + 1028)
#define HID_SELECT_DATABASE         (HID_BASE + 1030)
#define HID_DOC_INFO_DLG            (HID_BASE + 1031)
#define HID_DOC_MGR_DLG             (HID_BASE + 1032)
#define HID_OPTCAPTION_CLB          (HID_BASE + 1033)

#define HID_COPY                    (HID_BASE + 1102)
#define HID_CUT                     (HID_BASE + 1103)
#define HID_EDIT_FIELD              (HID_BASE + 1104)
#define HID_EDIT_FILE_INFO_DLG      (HID_BASE + 1107)
#define HID_EDIT_LINK_DLG           (HID_BASE + 1109)
#define HID_EDIT_OBJECT             (HID_BASE + 1110)
#define HID_GOTO                    (HID_BASE + 1111)
#define HID_SET_FIELD_VALUE         (HID_BASE + 1112)
#define HID_PASTE                   (HID_BASE + 1113)
#define HID_REDO                    (HID_BASE + 1116)
#define HID_SEARCH                  (HID_BASE + 1117)
#define HID_REPLACE                 (HID_BASE + 1118)
#define HID_SELECT_ALL              (HID_BASE + 1119)
#define HID_UNDO                    (HID_BASE + 1120)
#define HID_REPEAT                  (HID_BASE + 1122)
#define HID_BUFFER_UPDATE           (HID_BASE + 1124)
#define HID_UPDATE_FIELDS           (HID_BASE + 1126)
#define HID_EXECUTE_MACROFIELD      (HID_BASE + 1127)
#define HID_EDIT_FORMULA            (HID_BASE + 1128)
#define HID_CALC_TABLE              (HID_BASE + 1129)
#define HID_NUM_BULLET_DOWN         (HID_BASE + 1130)
#define HID_NUM_BULLET_UP           (HID_BASE + 1131)
#define HID_NUM_BULLET_PREV         (HID_BASE + 1132)
#define HID_NUM_BULLET_NEXT         (HID_BASE + 1133)
#define HID_NUM_BULLET_MOVEUP       (HID_BASE + 1134)
#define HID_NUM_BULLET_MOVEDOWN     (HID_BASE + 1135)
#define HID_NUM_BULLET_NONUM        (HID_BASE + 1136)
#define HID_NUM_BULLET_OFF          (HID_BASE + 1137)
#define HID_NUM_BULLET_ON           (HID_BASE + 1138)
#define HID_NUM_BULLET_OUTLINE_DOWN (HID_BASE + 1139)
#define HID_NUM_BULLET_OUTLINE_UP   (HID_BASE + 1140)
#define HID_NUM_BULLET_OUTLINE_MOVEUP   (HID_BASE + 1141)
#define HID_NUM_BULLET_OUTLINE_MOVEDOWN (HID_BASE + 1142)
#define HID_UPDATE_INPUTFIELDS      (HID_BASE + 1143)
#define HID_NUM_NUMBERING_ON        (HID_BASE + 1144)
#define HID_REPEAT_SEARCH           (HID_BASE + 1150)
#define HID_REPAGINATE              (HID_BASE + 1161)

#define HID_REFRESH_VIEW            (HID_BASE + 1201)
#define HID_RIBBON                  (HID_BASE + 1210)
#define HID_RULER                   (HID_BASE + 1211)
#define HID_STATUSBAR               (HID_BASE + 1212)
#define HID_TOOLBOX                 (HID_BASE + 1213)
#define HID_VIEW_BOUNDS             (HID_BASE + 1214)
#define HID_VIEW_FIELDS             (HID_BASE + 1215)
#define HID_VLINEAL                 (HID_BASE + 1216)
#define HID_VSCROLLBAR              (HID_BASE + 1217)
#define HID_HSCROLLBAR              (HID_BASE + 1218)
#define HID_VIEW_META_CHARS         (HID_BASE + 1224)
#define HID_VIEW_MARKS              (HID_BASE + 1225)
#define HID_VIEW_FIELDNAME          (HID_BASE + 1226)
#define HID_VIEW_TABLEGRID          (HID_BASE + 1227)
#define HID_ZOOM                    (HID_BASE + 1231)

#define HID_DELETE_BOOKMARK         (HID_BASE + 1301)
#define HID_INSERT_BREAK            (HID_BASE + 1303)
#define HID_INSERT_COLUMN_BREAK     (HID_BASE + 1305)
#define HID_INSERT_FILE             (HID_BASE + 1309)
#define HID_INSERT_FOOTNOTE         (HID_BASE + 1311)
#define HID_INSERT_GRAFIC           (HID_BASE + 1315)
#define HID_INSERT_LINEBREAK        (HID_BASE + 1318)
#define HID_INSERT_MERGEFIELD_DLG   (HID_BASE + 1320)
#define HID_INSERT_OBJECT_DLG       (HID_BASE + 1322)
#define HID_INSERT_PAGEBREAK        (HID_BASE + 1323)
#define HID_INSERT_RECORD           (HID_BASE + 1326)
#define HID_MERGE_RECORD            (HID_BASE + 1327)
#define HID_INSERT_SYMBOL           (HID_BASE + 1328)
#define HID_INSERT_STRING           (HID_BASE + 1331)
#define HID_INSERT_COLS             (HID_BASE + 1332)
#define HID_INSERT_FRAME_INTERACT   (HID_BASE + 1333)
#define HID_INSERT_FRAME            (HID_BASE + 1334)
#define HID_INSERT_IDX_ENTRY        (HID_BASE + 1340)
#define HID_INSERT_USERIDX_ENTRY    (HID_BASE + 1341)
#define HID_INSERT_CNTNTIDX_ENTRY   (HID_BASE + 1342)
#define HID_INSERT_SOFT_HYPHEN      (HID_BASE + 1350)
#define HID_INSERT_HARD_SPACE       (HID_BASE + 1351)

#define HID_SET_FONT                (HID_BASE + 1401)
#define HID_SET_FONT_SIZE           (HID_BASE + 1402)
#define HID_GROW_FONT_SIZE          (HID_BASE + 1403)
#define HID_SHRINK_FONT_SIZE        (HID_BASE + 1404)
#define HID_SET_BOLD                (HID_BASE + 1405)
#define HID_SET_ITALIC              (HID_BASE + 1406)
#define HID_SET_SHADOW              (HID_BASE + 1407)
#define HID_SET_OUTLINE             (HID_BASE + 1408)
#define HID_SET_UNDERLINE           (HID_BASE + 1409)
#define HID_SET_STRIKEOUT           (HID_BASE + 1410)
#define HID_SET_SUPER_SCRIPT        (HID_BASE + 1411)
#define HID_SET_SUB_SCRIPT          (HID_BASE + 1412)
#define HID_SET_COLOR               (HID_BASE + 1413)
#define HID_SET_CASEMAP             (HID_BASE + 1414)
#define HID_SET_LANGUAGE            (HID_BASE + 1415)
#define HID_SET_KERNING             (HID_BASE + 1416)
#define HID_INDENT_TO_TABSTOP       (HID_BASE + 1417)
#define HID_SET_LEFT_PARA           (HID_BASE + 1418)
#define HID_SET_RIGHT_PARA          (HID_BASE + 1419)
#define HID_SET_CENTER_PARA         (HID_BASE + 1420)
#define HID_SET_JUSTIFY_PARA        (HID_BASE + 1421)
#define HID_SET_LINE_SPACE_1        (HID_BASE + 1422)
#define HID_SET_LINE_SPACE_15       (HID_BASE + 1423)
#define HID_SET_LINE_SPACE_2        (HID_BASE + 1424)
#define HID_FLIP_HORZ_GRAFIC        (HID_BASE + 1425)
#define HID_FLIP_VERT_GRAFIC        (HID_BASE + 1426)
#define HID_SET_ADJUST              (HID_BASE + 1428)
#define HID_SET_LRMARGIN            (HID_BASE + 1429)
#define HID_SET_ULMARGIN            (HID_BASE + 1430)
#define HID_UNINDENT_TO_TABSTOP     (HID_BASE + 1431)
#define HID_SET_HYPHEN_ZONE         (HID_BASE + 1432)
#define HID_SET_PAGE_BREAK          (HID_BASE + 1433)
#define HID_SET_KEEP_TOGETHER       (HID_BASE + 1434)
#define HID_SET_WIDOW               (HID_BASE + 1436)
#define HID_SET_ORPHAN              (HID_BASE + 1437)
#define HID_FORMAT_SHADOW           (HID_BASE + 1438)
#define HID_FORMAT_BORDER           (HID_BASE + 1439)
#define HID_FORMAT_CHAR_DLG         (HID_BASE + 1441)
#define HID_FORMAT_PARA_DLG         (HID_BASE + 1443)
#define HID_FORMAT_TAB              (HID_BASE + 1444)
#define HID_FORMAT_TAB_DLG          (HID_BASE + 1445)
#define HID_FORMAT_BORDER_DLG       (HID_BASE + 1447)
#define HID_FORMAT_BACKGROUND       (HID_BASE + 1448)
#define HID_FORMAT_BACKGROUND_DLG   (HID_BASE + 1450)
#define HID_FORMAT_PAGE             (HID_BASE + 1451)
#define HID_FORMAT_PAGE_DLG         (HID_BASE + 1452)
#define HID_FORMAT_DROPCAPS         (HID_BASE + 1454)
#define HID_FORMAT_FRAME_DLG        (HID_BASE + 1456)
#define HID_FORMAT_GRAFIC_DLG       (HID_BASE + 1458)
#define HID_FORMAT_TABLE_DLG        (HID_BASE + 1460)
#define HID_NEW_STYLE_BY_EXAMPLE    (HID_BASE + 1462)
#define HID_UPDATE_STYLE_BY_EXAMPLE (HID_BASE + 1463)
#define HID_STYLE_SHEET_FRAME_DLG   (HID_BASE + 1464)
#define HID_STYLE_SHEET_DOC_DLG     (HID_BASE + 1465)
#define HID_FORMAT_RESET            (HID_BASE + 1469)
#define HID_FRAME_TO_TOP            (HID_BASE + 1470)
#define HID_FRAME_TO_BOTTOM         (HID_BASE + 1471)
#define HID_FRAME_NOWRAP            (HID_BASE + 1472)
#define HID_FRAME_WRAP              (HID_BASE + 1473)
#define HID_FRAME_WRAPTHRU          (HID_BASE + 1474)
#define HID_FRAME_ALIGN_HORZ_LEFT   (HID_BASE + 1475)
#define HID_FRAME_ALIGN_HORZ_RIGHT  (HID_BASE + 1476)
#define HID_FRAME_ALIGN_HORZ_CENTER (HID_BASE + 1477)
#define HID_FRAME_ALIGN_VERT_TOP    (HID_BASE + 1478)
#define HID_FRAME_ALIGN_VERT_BOTTOM (HID_BASE + 1479)
#define HID_FRAME_ALIGN_VERT_CENTER (HID_BASE + 1480)
#define HID_SET_FRM_SIZE            (HID_BASE + 1481)
#define HID_SET_FRM_POSITION        (HID_BASE + 1482)
#define HID_SET_FRM_ANCHOR          (HID_BASE + 1483)
#define HID_SET_FRM_WRAP            (HID_BASE + 1484)
#define HID_SET_FRM_DIST            (HID_BASE + 1485)
#define HID_SET_FRM_OPTIONS         (HID_BASE + 1486)
#define HID_SET_GRF_MIRROR          (HID_BASE + 1488)
#define HID_SET_TABLE_WIDTH         (HID_BASE + 1489)
#define HID_SET_TABLE_ALIGN         (HID_BASE + 1490)
#define HID_SET_CHAR_STYLE          (HID_BASE + 1491)
#define HID_SET_PARA_STYLE          (HID_BASE + 1492)
#define HID_SET_PAGE_STYLE          (HID_BASE + 1493)
#define HID_SET_FRM_MACRO           (HID_BASE + 1494)
#define HID_SET_FRM_COLUMNS         (HID_BASE + 1495)
#define HID_SET_FRM_COLUMN_WIDTH    (HID_BASE + 1496)
#define HID_UPDATE_STYLES_DIRECT    (HID_BASE + 1497)

#define HID_TABLE_INSERT_ROW        (HID_BASE + 1501)
#define HID_TABLE_DELETE_ROW        (HID_BASE + 1503)
#define HID_TABLE_DELETE_COL        (HID_BASE + 1504)
#define HID_TABLE_MERGE_CELLS       (HID_BASE + 1506)
#define HID_AUTOFMT_TABLE           (HID_BASE + 1507)
#define HID_SWDLG_STRINPUT          (HID_BASE + 1508)
#define HID_TABLE_SET_ULSPACE       (HID_BASE + 1509)
#define HID_TABLE_SET_GRID          (HID_BASE + 1510)
#define HID_TABLE_SET_SHADOW        (HID_BASE + 1511)
#define HID_TABLE_SELECT_ROW        (HID_BASE + 1513)
#define HID_TABLE_SELECT_COL        (HID_BASE + 1514)
#define HID_TABLE_SELECT_ALL        (HID_BASE + 1515)
#define HID_TABLE_SET_READ_ONLY_CELLS   (HID_BASE + 1517)
#define HID_TABLE_UNSET_READ_ONLY_CELLS (HID_BASE + 1519)
#define HID_PAGE_STYLE_SET_COLS     (HID_BASE + 1538)
#define HID_SET_PROP_LINE_SPACE     (HID_BASE + 1540)
#define HID_SET_ABS_LINE_SPACE      (HID_BASE + 1541)

#define HID_SPELLING_DLG            (HID_BASE + 1601)
#define HID_THESAURUS_DLG           (HID_BASE + 1604)
#define HID_HYPHENATE_OPT_DLG       (HID_BASE + 1607)
#define HID_SORTING                 (HID_BASE + 1613)
#define HID_SORTING_DLG             (HID_BASE + 1614)
#define HID_CALCULATE               (HID_BASE + 1615)
#define HID_RECORD_MACRO_DLG        (HID_BASE + 1622)
#define HID_PLAY_MACRO_DLG          (HID_BASE + 1624)
#define HID_CONFIG_DLG              (HID_BASE + 1627)
#define HID_EXPAND_GLOSSARY         (HID_BASE + 1628)
#define HID_RENAME_GLOSSARY         (HID_BASE + 1629)
#define HID_CONFIG_MENU             (HID_BASE + 1630)
#define HID_CONFIG_KEY              (HID_BASE + 1631)
#define HID_ASSIGN_LOCAL_MACRO_DLG  (HID_BASE + 1632)
#define HID_COMPILE_MACRO           (HID_BASE + 1633)
#define HID_CONFIG_VIEWOPTIONS      (HID_BASE + 1635)
#define HID_CONFIG_COLORS           (HID_BASE + 1636)
#define HID_INSERT_GLOSSARY         (HID_BASE + 1640)
#define HID_AUTO_CORRECT            (HID_BASE + 1649)
#define HID_AUTO_CORRECT_DLG        (HID_BASE + 1650)
#define HID_HELP_PI                 (HID_BASE + 1655)
#define HID_NAVIGATION_PI           (HID_BASE + 1656)
#define HID_TEMPLATE_PI             (HID_BASE + 1657)
#define HID_ADDR_PI                 (HID_BASE + 1658)
#define HID_NAVIGATION_PI_GOTO_PAGE (HID_BASE + 1659)
#define HID_LETTER_WIZZARD          (HID_BASE + 1660)
#define HID_FAX_WIZZARD             (HID_BASE + 1661)
#define HID_MEMO_WIZZARD            (HID_BASE + 1662)
#define HID_AGENDA_WIZZARD          (HID_BASE + 1663)

#define HID_NEW_WINDOW              (HID_BASE + 1701)
#define HID_ARRANGE_ALL_WIN         (HID_BASE + 1702)
#define HID_ARRANGE_CASCADE_WIN     (HID_BASE + 1703)
#define HID_ARRANGE_HORZ_WIN        (HID_BASE + 1704)
#define HID_ARRANGE_VERT_WIN        (HID_BASE + 1705)

#define HID_SHOW_HELP_INDEX         (HID_BASE + 1802)
#define HID_SHOW_KEYBOARD_HELP      (HID_BASE + 1803)
#define HID_SHOW_HELP_MANUAL        (HID_BASE + 1804)
#define HID_SHOW_UPDATE_HELP        (HID_BASE + 1805)

#define HID_CHAR_LEFT               (HID_BASE + 1901)
#define HID_CHAR_RIGHT              (HID_BASE + 1902)
#define HID_LINE_UP                 (HID_BASE + 1903)
#define HID_LINE_DOWN               (HID_BASE + 1904)
#define HID_START_OF_LINE           (HID_BASE + 1905)
#define HID_END_OF_LINE             (HID_BASE + 1906)
#define HID_START_OF_DOCUMENT       (HID_BASE + 1907)
#define HID_END_OF_DOCUMENT         (HID_BASE + 1908)
#define HID_START_OF_NEXT_PAGE      (HID_BASE + 1909)
#define HID_END_OF_NEXT_PAGE        (HID_BASE + 1910)
#define HID_START_OF_PREV_PAGE      (HID_BASE + 1911)
#define HID_END_OF_PREV_PAGE        (HID_BASE + 1912)
#define HID_START_OF_PAGE           (HID_BASE + 1913)
#define HID_END_OF_PAGE             (HID_BASE + 1914)
#define HID_START_OF_COLUMN         (HID_BASE + 1917)
#define HID_END_OF_COLUMN           (HID_BASE + 1918)
#define HID_START_OF_PARA           (HID_BASE + 1919)
#define HID_END_OF_PARA             (HID_BASE + 1920)
#define HID_NEXT_WORD               (HID_BASE + 1921)
#define HID_PREV_WORD               (HID_BASE + 1922)
#define HID_NEXT_SENT               (HID_BASE + 1923)
#define HID_PREV_SENT               (HID_BASE + 1924)
#define HID_DELETE                  (HID_BASE + 1925)
#define HID_BACKSPACE               (HID_BASE + 1926)
#define HID_DELETE_SENT             (HID_BASE + 1927)
#define HID_DELETE_BACK_SENT        (HID_BASE + 1928)
#define HID_DELETE_WORD             (HID_BASE + 1929)
#define HID_DELETE_BACK_WORD        (HID_BASE + 1930)
#define HID_DELETE_LINE             (HID_BASE + 1931)
#define HID_DELETE_BACK_LINE        (HID_BASE + 1932)
#define HID_DELETE_PARA             (HID_BASE + 1933)
#define HID_DELETE_BACK_PARA        (HID_BASE + 1934)
#define HID_DELETE_WHOLE_LINE       (HID_BASE + 1935)
#define HID_SET_INS_MODE            (HID_BASE + 1936)
#define HID_PAGEUP                  (HID_BASE + 1937)
#define HID_PAGEDOWN                (HID_BASE + 1938)
#define HID_SET_ADD_MODE            (HID_BASE + 1939)
#define HID_SET_EXT_MODE            (HID_BASE + 1940)
#define HID_ESCAPE                  (HID_BASE + 1941)
#define HID_SELECT_WORD             (HID_BASE + 1943)
#define HID_START_TABLE             (HID_BASE + 1947)
#define HID_END_TABLE               (HID_BASE + 1948)
#define HID_NEXT_TABLE              (HID_BASE + 1949)
#define HID_PREV_TABLE              (HID_BASE + 1950)
#define HID_START_OF_NEXT_COLUMN    (HID_BASE + 1951)
#define HID_END_OF_NEXT_COLUMN      (HID_BASE + 1952)
#define HID_START_OF_PREV_COLUMN    (HID_BASE + 1953)
#define HID_END_OF_PREV_COLUMN      (HID_BASE + 1954)
#define HID_FOOTNOTE_TO_ANCHOR      (HID_BASE + 1955)
#define HID_NEXT_FOOTNOTE           (HID_BASE + 1956)
#define HID_PREV_FOOTNOTE           (HID_BASE + 1957)
#define HID_CNTNT_TO_NEXT_FRAME     (HID_BASE + 1958)
#define HID_FRAME_TO_ANCHOR         (HID_BASE + 1959)
#define HID_TO_HEADER               (HID_BASE + 1960)
#define HID_TO_FOOTER               (HID_BASE + 1961)
#define HID_IDX_MARK_TO_IDX         (HID_BASE + 1962)

#define HID_ENVELOP                 (HID_BASE + 2050)
#define HID_LABEL                   (HID_BASE + 2051)
#define HID_ENVELOP_PRINT           (HID_BASE + 2052)

#define HID_NAVIGATION_IMGBTN       (HID_BASE + 2054)
#define HID_ENVELOP_INSERT          (HID_BASE + 2055)

#define HID_WEBTOOLS_TOOLBOX        (HID_BASE + 2056)
#define HID_WEBTEXT_TOOLBOX         (HID_BASE + 2057)
#define HID_WEBFRAME_TOOLBOX        (HID_BASE + 2058)
#define HID_TEXT_TOOLBOX            (HID_BASE + 2059)
#define HID_TABLE_TOOLBOX           (HID_BASE + 2060)
#define HID_FRAME_TOOLBOX           (HID_BASE + 2061)
#define HID_GRAFIK_TOOLBOX          (HID_BASE + 2062)
#define HID_OLE_TOOLBOX             (HID_BASE + 2063)
#define HID_DRAW_TOOLBOX            (HID_BASE + 2064)
#define HID_BEZIER_TOOLBOX          (HID_BASE + 2066)
#define HID_DRAW_TEXT_TOOLBOX       (HID_BASE + 2067)
#define HID_NUM_TOOLBOX             (HID_BASE + 2068)
#define HID_TOOLS_TOOLBOX           (HID_BASE + 2069)
#define HID_SRCVIEW_TOOLBOX         (HID_BASE + 2070)

#define HID_LABEL_INSERT            (HID_BASE + 2071)
#define HID_CALC_TOOLBOX            (HID_BASE + 2072)
#define HID_PVIEW_TOOLBOX           (HID_BASE + 2073)

#define HID_FIELD_INSERT            (HID_BASE + 2074)
#define HID_FIELD_CLOSE             (HID_BASE + 2075)

#define HID_COND_COLL_TABLIST       (HID_BASE + 2076)

#define HID_DB_SELECTION_TLB        (HID_BASE + 2077)
#define HID_FIELD_DINF_TYPE         (HID_BASE + 2078)

#define HID_DRAWFORM_TOOLBOX        (HID_BASE + 2079)
#define HID_SELECT_TEMPLATE         (HID_BASE + 2080)

#define HID_AP_INSERT_DB_SEL        (HID_BASE + 2081)
#define HID_WEBGRAPHIC_TOOLBOX      (HID_BASE + 2082)
#define HID_OUTLINE_FORM            (HID_BASE + 2083)
#define HID_NUM_RESET               (HID_BASE + 2084)

#define HID_AUTOFORMAT_REJECT       (HID_BASE + 2085)
#define HID_AUTOFORMAT_ACCEPT       (HID_BASE + 2086)
#define HID_AUTOFORMAT_EDIT_CHG     (HID_BASE + 2087)

//insert index/entries/Pattern buttons and edits
#define HID_TOX_ENTRY_BUTTON        (HID_BASE + 2088)
#define HID_TOX_ENTRY_EDIT          (HID_BASE + 2089)

#define HID_DLG_NEW_USER_IDX        (HID_BASE + 2090)
#define HID_INSERT_IDX_MRK_OK       (HID_BASE + 2091)
#define HID_INSERT_IDX_MRK_CLOSE    (HID_BASE + 2092)
#define HID_INSERT_AUTH_MRK_OK      (HID_BASE + 2093)
#define HID_INSERT_AUTH_MRK_CLOSE   (HID_BASE + 2094)
#define HID_INSERT_IDX_MRK_DELETE       (HID_BASE + 2095)
#define HID_INSERT_IDX_MRK_NEW          (HID_BASE + 2096)
#define HID_INSERT_IDX_MRK_PREV         (HID_BASE + 2097)
#define HID_INSERT_IDX_MRK_PREV_SAME    (HID_BASE + 2098)
#define HID_INSERT_IDX_MRK_NEXT         (HID_BASE + 2099)
#define HID_INSERT_IDX_MRK_NEXT_SAME    (HID_BASE + 2100)
#define HID_INSERT_IDX_MRK_TYPE         (HID_BASE + 2101)
#define HID_INSERT_IDX_MRK_ENTRY        (HID_BASE + 2102)
#define HID_INSERT_IDX_MRK_PRIM_KEY     (HID_BASE + 2103)
#define HID_INSERT_IDX_MRK_SEC_KEY      (HID_BASE + 2104)
#define HID_INSERT_IDX_MRK_LEVEL        (HID_BASE + 2105)
#define HID_INSERT_IDX_MRK_MAIN_ENTRY   (HID_BASE + 2106)
#define HID_INSERT_IDX_MRK_APPLY_ALL    (HID_BASE + 2107)
#define HID_INSERT_AUTH_MRK_ENTRY           (HID_BASE + 2108)
#define HID_INSERT_AUTH_MRK_CREATE_ENTRY    (HID_BASE + 2109)
#define HID_INSERT_AUTH_MRK_EDIT_ENTRY      (HID_BASE + 2110)
#define HID_TOKEN_WINDOW                    (HID_BASE + 2111)

#define HID_AUTH_FIELD_IDENTIFIER        (HID_BASE + 2112  )
#define HID_AUTH_FIELD_AUTHORITY_TYPE    (HID_BASE + 2113  )
#define HID_AUTH_FIELD_ADDRESS           (HID_BASE + 2114  )
#define HID_AUTH_FIELD_ANNOTE            (HID_BASE + 2115  )
#define HID_AUTH_FIELD_AUTHOR            (HID_BASE + 2116  )
#define HID_AUTH_FIELD_BOOKTITLE         (HID_BASE + 2117  )
#define HID_AUTH_FIELD_CHAPTER           (HID_BASE + 2118  )
#define HID_AUTH_FIELD_EDITION           (HID_BASE + 2119  )
#define HID_AUTH_FIELD_EDITOR            (HID_BASE + 2120  )
#define HID_AUTH_FIELD_HOWPUBLISHED      (HID_BASE + 2121  )
#define HID_AUTH_FIELD_INSTITUTION       (HID_BASE + 2122  )
#define HID_AUTH_FIELD_JOURNAL           (HID_BASE + 2123  )
#define HID_AUTH_FIELD_MONTH             (HID_BASE + 2124  )
#define HID_AUTH_FIELD_NOTE              (HID_BASE + 2125  )
#define HID_AUTH_FIELD_NUMBER            (HID_BASE + 2126  )
#define HID_AUTH_FIELD_ORGANIZATIONS     (HID_BASE + 2127  )
#define HID_AUTH_FIELD_PAGES             (HID_BASE + 2128  )
#define HID_AUTH_FIELD_PUBLISHER         (HID_BASE + 2129  )
#define HID_AUTH_FIELD_SCHOOL            (HID_BASE + 2130  )
#define HID_AUTH_FIELD_SERIES            (HID_BASE + 2131  )
#define HID_AUTH_FIELD_TITLE             (HID_BASE + 2132  )
#define HID_AUTH_FIELD_REPORT_TYPE       (HID_BASE + 2133  )
#define HID_AUTH_FIELD_VOLUME            (HID_BASE + 2134  )
#define HID_AUTH_FIELD_YEAR              (HID_BASE + 2135  )
#define HID_AUTH_FIELD_URL               (HID_BASE + 2136  )
#define HID_AUTH_FIELD_CUSTOM1           (HID_BASE + 2137  )
#define HID_AUTH_FIELD_CUSTOM2           (HID_BASE + 2138  )
#define HID_AUTH_FIELD_CUSTOM3           (HID_BASE + 2139  )
#define HID_AUTH_FIELD_CUSTOM4           (HID_BASE + 2140  )
#define HID_AUTH_FIELD_CUSTOM5           (HID_BASE + 2141  )
#define HID_AUTH_FIELD_ISBN              (HID_BASE + 2142  )

#define HID_AUTH_MARK_DLG_FROM_COMP_RB   (HID_BASE + 2143  )
#define HID_AUTH_MARK_DLG_FROM_DOC_RB    (HID_BASE + 2144  )
#define HID_AUTH_MARK_DLG_ID_LISTBOX     (HID_BASE + 2145  )

#define HID_INSERT_INDEX_ENTRY_LEVEL_LB  (HID_BASE + 2146  )
#define HID_INSERT_IDX_MRK_SRCH_CASESENSITIVE   (HID_BASE + 2147 )
#define HID_INSERT_IDX_MRK_SRCH_WORDONLY        (HID_BASE + 2148 )
#define HID_DLG_CREATE_AUTOMARK                 (HID_BASE + 2149 )
#define HID_BUSINESS_CARD_CONTENT               (HID_BASE + 2150 )
#define HID_SAVE_LABEL_DLG                      (HID_BASE + 2151 )
#define HID_BUSINESS_FMT_PAGE                   (HID_BASE + 2152 )
#define HID_BUSINESS_FMT_PAGE_CONT              (HID_BASE + 2153 )
#define HID_BUSINESS_FMT_PAGE_SHEET             (HID_BASE + 2154 )
#define HID_BUSINESS_FMT_PAGE_BRAND             (HID_BASE + 2155 )
#define HID_BUSINESS_FMT_PAGE_TYPE              (HID_BASE + 2156 )
#define HID_SEND_MASTER_DIALOG                      (HID_BASE + 2157 )
#define HID_SEND_MASTER_CTRL_PUSHBUTTON_OK          (HID_BASE + 2158 )
#define HID_SEND_MASTER_CTRL_PUSHBUTTON_CANCEL      (HID_BASE + 2159 )
#define HID_SEND_MASTER_CTRL_LISTBOX_FILTER         (HID_BASE + 2160 )
#define HID_SEND_MASTER_CTRL_CONTROL_FILEVIEW       (HID_BASE + 2161 )
#define HID_SEND_MASTER_CTRL_EDIT_FILEURL           (HID_BASE + 2162 )
#define HID_SEND_MASTER_CTRL_CHECKBOX_AUTOEXTENSION (HID_BASE + 2163 )
#define HID_SEND_MASTER_CTRL_LISTBOX_TEMPLATE       (HID_BASE + 2164 )
#define HID_SEND_MASTER_CTRL_DUMMY                  (HID_BASE + 2165 )

#define HID_SEND_HTML_DIALOG                        (HID_BASE + 2166 )
#define HID_SEND_HTML_CTRL_PUSHBUTTON_OK            (HID_BASE + 2167 )
#define HID_SEND_HTML_CTRL_PUSHBUTTON_CANCEL        (HID_BASE + 2168 )
#define HID_SEND_HTML_CTRL_LISTBOX_FILTER           (HID_BASE + 2169 )
#define HID_SEND_HTML_CTRL_CONTROL_FILEVIEW         (HID_BASE + 2170 )
#define HID_SEND_HTML_CTRL_EDIT_FILEURL             (HID_BASE + 2171 )
#define HID_SEND_HTML_CTRL_CHECKBOX_AUTOEXTENSION   (HID_BASE + 2172 )
#define HID_SEND_HTML_CTRL_LISTBOX_TEMPLATE         (HID_BASE + 2173 )
#define HID_SEND_HTML_CTRL_DUMMY                    (HID_BASE + 2174 )

#define HID_INSERT_IDX_MRK_PHONETIC_READING         (HID_BASE + 2175 )
#define HID_COLUMN_VALUESET                         (HID_BASE + 2176 )
#define HID_PVIEW_ZOOM_LB                           (HID_BASE + 2177 )
#define HID_MAIL_MERGE_SELECT                       (HID_BASE + 2178 )
#define HID_MAIL_MERGE_CREATE_FROM                  (HID_BASE + 2179 )
#define HID_MAIL_MERGE_INSERT_FIELDS                (HID_BASE + 2180 )
#define HID_PRINT_AS_MERGE                          (HID_BASE + 2181 )
#define HID_MERGE_SOURCE_UNAVAILABLE                (HID_BASE + 2182 )
#define HID_DATA_SOURCES_UNAVAILABLE                (HID_BASE + 2183 )
#define HID_MODULE_TOOLBOX                          (HID_BASE + 2184 )
#define HID_SECTION_INDENTS_PAGE                    (HID_BASE + 2185 )

#define HID_FLD_DROPDOWN                            (HID_BASE + 2186 )

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
