/*************************************************************************
 *
 *  The Contents of this file are made available subject to the terms of
 *  the BSD license.
 *  
 *  Copyright 2000, 2010 Oracle and/or its affiliates.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of Sun Microsystems, Inc. nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *     
 *************************************************************************/

import com.sun.star.reflection.XIdlMethod;
import com.sun.star.uno.Type;
import com.sun.star.uno.XComponentContext;
import javax.swing.tree.DefaultMutableTreeNode;

public class UnoFacetteNode extends UnoNode{
    String m_sFilter = "";
    
    
    /** Creates a new instance of UnoMethodNode */
    public UnoFacetteNode(Object _oUnoObject){
        super(_oUnoObject);
        addDummyNode();        
    }
    
    
    public String getFilter(){
        return m_sFilter;
    }
    
    public void setFilter(String _sFilter){
        m_sFilter = _sFilter;
    }
    
    public String getName(){
        return toString();
    }
    
// TODO The implementation of the following nodes is not really robust and should be changed!!!
    public boolean isMethodNode(){
        return ((String) getUserObject()).equals(SMETHODDESCRIPTION);
    }

    public boolean isPropertyNode(){
        String sNodeDescription = (String) getUserObject();
        return ((sNodeDescription.equals(SPROPERTYDESCRIPTION)) || (sNodeDescription.equals(SPROPERTYINFODESCRIPTION)) || (sNodeDescription.equals(SPROPERTYVALUEDESCRIPTION)));
    }

    public boolean isContainerNode(){
        return ((String) getUserObject()).equals(SCONTAINERDESCRIPTION);
    }

    public boolean isServiceNode(){
        return ((String) getUserObject()).equals(SSERVICEDESCRIPTION);
    }
    
    public boolean isInterfaceNode(){
        return ((String) getUserObject()).equals(SINTERFACEDESCRIPTION);
    }
}

