/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.swing.autospell;

import com.swabunga.spell.swing.autospell.AutoSpellConstants;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class AutoSpellView
extends View
implements AutoSpellConstants {
    private View view = null;
    private int[] wavePoints = new int[10];

    public AutoSpellView(View view) {
        super(view.getElement());
        this.view = view;
        for (int i = 0; i < this.wavePoints.length; ++i) {
            this.wavePoints[i] = (int)Math.round(Math.cos((double)(2 * i) * (Math.PI * 2 / (double)this.wavePoints.length)));
        }
    }

    public void append(View view) {
        this.view.append(view);
    }

    public View breakView(int n, int n2, float f, float f2) {
        return this.view.breakView(n, n2, f, f2);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.view.changedUpdate(documentEvent, shape, viewFactory);
    }

    public View createFragment(int n, int n2) {
        return this.view.createFragment(n, n2);
    }

    public boolean equals(Object object) {
        return this.view.equals(object);
    }

    public float getAlignment(int n) {
        return this.view.getAlignment(n);
    }

    public AttributeSet getAttributes() {
        return this.view.getAttributes();
    }

    public int getBreakWeight(int n, float f, float f2) {
        return this.view.getBreakWeight(n, f, f2);
    }

    public Shape getChildAllocation(int n, Shape shape) {
        return this.view.getChildAllocation(n, shape);
    }

    public Container getContainer() {
        return this.view.getContainer();
    }

    public Document getDocument() {
        return this.view.getDocument();
    }

    public Element getElement() {
        return this.view.getElement();
    }

    public int getEndOffset() {
        return this.view.getEndOffset();
    }

    public Graphics getGraphics() {
        return this.view.getGraphics();
    }

    public float getMaximumSpan(int n) {
        return this.view.getMaximumSpan(n);
    }

    public float getMinimumSpan(int n) {
        return this.view.getMinimumSpan(n);
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        return this.view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
    }

    public View getParent() {
        return this.view.getParent();
    }

    public float getPreferredSpan(int n) {
        return this.view.getPreferredSpan(n);
    }

    public int getResizeWeight(int n) {
        return this.view.getResizeWeight(n);
    }

    public int getStartOffset() {
        return this.view.getStartOffset();
    }

    public String getToolTipText(float f, float f2, Shape shape) {
        return this.view.getToolTipText(f, f2, shape);
    }

    public View getView(int n) {
        return this.view.getView(n);
    }

    public int getViewCount() {
        return this.view.getViewCount();
    }

    public ViewFactory getViewFactory() {
        return this.view.getViewFactory();
    }

    public int getViewIndex(float f, float f2, Shape shape) {
        return this.view.getViewIndex(f, f2, shape);
    }

    public int getViewIndex(int n, Position.Bias bias) {
        return this.view.getViewIndex(n, bias);
    }

    public void insert(int n, View view) {
        this.view.insert(n, view);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.view.insertUpdate(documentEvent, shape, viewFactory);
    }

    public boolean isVisible() {
        return this.view.isVisible();
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        return this.view.modelToView(n, shape, bias);
    }

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        return this.view.modelToView(n, bias, n2, bias2, shape);
    }

    public void paint(Graphics graphics, Shape shape) {
        Graphics graphics2 = graphics;
        this.view.paint(graphics, shape);
        if (this.getAttributes().containsAttribute("misspelled", AutoSpellConstants.wordMisspelledTrue)) {
            Rectangle rectangle = shape.getBounds();
            Color color = graphics2.getColor();
            graphics2.setColor(Color.red);
            for (int i = rectangle.x; i < rectangle.x + rectangle.width; ++i) {
                graphics2.drawLine(i, rectangle.y + rectangle.height - 2 - this.wavePoints[i % this.wavePoints.length], i, rectangle.y + rectangle.height - 2 - this.wavePoints[i % this.wavePoints.length]);
            }
        }
    }

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        this.view.preferenceChanged(view, bl, bl2);
    }

    public void remove(int n) {
        this.view.remove(n);
    }

    public void removeAll() {
        this.view.removeAll();
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.view.removeUpdate(documentEvent, shape, viewFactory);
    }

    public void replace(int n, int n2, View[] viewArray) {
        this.view.replace(n, n2, viewArray);
    }

    public void setParent(View view) {
        this.view.setParent(view);
    }

    public void setSize(float f, float f2) {
        this.view.setSize(f, f2);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        return this.view.viewToModel(f, f2, shape, biasArray);
    }
}

