builds := llvm-gcc

BUILDDEPS	:= llvm-$(UVERSION)-dev (>= $(dev_version))
BUILDCONFLICTS	:= ocaml, ocaml-nox

llvm-gcc_packages := llvm-gcc-4.2

llvm-gcc_confargs := $(confargs) \
	--prefix=$(PF)/gcc-$(gcc_version) --enable-llvm=$(PF) \
	--enable-languages=c,c++ --program-prefix=llvm- \
	--enable-threads --disable-nls --disable-shared \
	--disable-multilib --with-pic

check_archs := amd64 i386
ifneq (,$(filter $(DEB_HOST_ARCH),$(check_archs)))
  llvm-gcc_check := yes
endif

tarpath		:= $(firstword $(wildcard $(D)/llvm-gcc-$(gcc_version)-$(UVERSION)*.tar.* \
				/usr/src/llvm/llvm-gcc-$(gcc_version)-$(UVERSION)*.tar.*))
tarball		:= $(notdir $(tarpath))
srcdir		:= $(subst -dfsg,,$(subst .tar$(suffix $(tarball)),,$(tarball)))

define llvm-gcc-4.2_extra_binary
	if test "x$*" = "xllvm-gcc-4.2" ; then \
		$(RM) $(D)/debian/$(strip $(call pkgname,$*))/$(PF)/gcc-$(gcc_version)/bin/*-$(gcc_version).* ; \
		for i in $$(ls $(D)/debian/$(strip $(call pkgname,$*))/$(PF)/gcc-$(gcc_version)/bin) ; do \
			echo "$(PF)/gcc-$(gcc_version)/bin/$$i usr/bin/$$i-$(gcc_version)" >> $(D)/debian/$(strip $(call pkgname,$*)).links ; \
		done ; \
	fi
endef

