/*
 * Hardware modules present on the OMAP44xx chips
 *
 * Copyright (C) 2009-2011 Texas Instruments, Inc.
 * Copyright (C) 2009-2010 Nokia Corporation
 *
 * Paul Walmsley
 * Benoit Cousson
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/io.h>

#include <plat/omap_hwmod.h>
#include <plat/cpu.h>
#include <plat/i2c.h>
#include <plat/gpio.h>
#include <plat/dma.h>
#include <plat/mcspi.h>
#include <plat/mcbsp.h>
#include <plat/mmc.h>
#include <plat/i2c.h>

#include "omap_hwmod_common_data.h"

#include "cm1_44xx.h"
#include "cm2_44xx.h"
#include "prm44xx.h"
#include "prm-regbits-44xx.h"
#include "wd_timer.h"

/* Base offset for all OMAP4 interrupts external to MPUSS */
#define OMAP44XX_IRQ_GIC_START	32

/* Base offset for all OMAP4 dma requests */
#define OMAP44XX_DMA_REQ_START  1

/* Backward references (IPs with Bus Master capability) */
static struct omap_hwmod omap44xx_aess_hwmod;
static struct omap_hwmod omap44xx_dma_system_hwmod;
static struct omap_hwmod omap44xx_dmm_hwmod;
static struct omap_hwmod omap44xx_dsp_hwmod;
static struct omap_hwmod omap44xx_dss_hwmod;
static struct omap_hwmod omap44xx_emif_fw_hwmod;
static struct omap_hwmod omap44xx_hsi_hwmod;
static struct omap_hwmod omap44xx_ipu_hwmod;
static struct omap_hwmod omap44xx_iss_hwmod;
static struct omap_hwmod omap44xx_iva_hwmod;
static struct omap_hwmod omap44xx_l3_instr_hwmod;
static struct omap_hwmod omap44xx_l3_main_1_hwmod;
static struct omap_hwmod omap44xx_l3_main_2_hwmod;
static struct omap_hwmod omap44xx_l3_main_3_hwmod;
static struct omap_hwmod omap44xx_l4_abe_hwmod;
static struct omap_hwmod omap44xx_l4_cfg_hwmod;
static struct omap_hwmod omap44xx_l4_per_hwmod;
static struct omap_hwmod omap44xx_l4_wkup_hwmod;
static struct omap_hwmod omap44xx_mmc1_hwmod;
static struct omap_hwmod omap44xx_mmc2_hwmod;
static struct omap_hwmod omap44xx_mpu_hwmod;
static struct omap_hwmod omap44xx_mpu_private_hwmod;
static struct omap_hwmod omap44xx_usb_otg_hs_hwmod;

/*
 * Interconnects omap_hwmod structures
 * hwmods that compose the global OMAP interconnect
 */

/*
 * 'dmm' class
 * instance(s): dmm
 */
static struct omap_hwmod_class omap44xx_dmm_hwmod_class = {
	.name	= "dmm",
};

/* dmm */
static struct omap_hwmod_irq_info omap44xx_dmm_irqs[] = {
	{ .irq = 113 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

/* l3_main_1 -> dmm */
static struct omap_hwmod_ocp_if omap44xx_l3_main_1__dmm = {
	.master		= &omap44xx_l3_main_1_hwmod,
	.slave		= &omap44xx_dmm_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap44xx_dmm_addrs[] = {
	{
		.pa_start	= 0x4e000000,
		.pa_end		= 0x4e0007ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* mpu -> dmm */
static struct omap_hwmod_ocp_if omap44xx_mpu__dmm = {
	.master		= &omap44xx_mpu_hwmod,
	.slave		= &omap44xx_dmm_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap44xx_dmm_addrs,
	.user		= OCP_USER_MPU,
};

/* dmm slave ports */
static struct omap_hwmod_ocp_if *omap44xx_dmm_slaves[] = {
	&omap44xx_l3_main_1__dmm,
	&omap44xx_mpu__dmm,
};

static struct omap_hwmod omap44xx_dmm_hwmod = {
	.name		= "dmm",
	.class		= &omap44xx_dmm_hwmod_class,
	.clkdm_name	= "l3_emif_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_MEMIF_DMM_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_MEMIF_DMM_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap44xx_dmm_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_dmm_slaves),
	.mpu_irqs	= omap44xx_dmm_irqs,
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'emif_fw' class
 * instance(s): emif_fw
 */
static struct omap_hwmod_class omap44xx_emif_fw_hwmod_class = {
	.name	= "emif_fw",
};

/* emif_fw */
/* dmm -> emif_fw */
static struct omap_hwmod_ocp_if omap44xx_dmm__emif_fw = {
	.master		= &omap44xx_dmm_hwmod,
	.slave		= &omap44xx_emif_fw_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap44xx_emif_fw_addrs[] = {
	{
		.pa_start	= 0x4a20c000,
		.pa_end		= 0x4a20c0ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> emif_fw */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__emif_fw = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_emif_fw_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_emif_fw_addrs,
	.user		= OCP_USER_MPU,
};

/* emif_fw slave ports */
static struct omap_hwmod_ocp_if *omap44xx_emif_fw_slaves[] = {
	&omap44xx_dmm__emif_fw,
	&omap44xx_l4_cfg__emif_fw,
};

static struct omap_hwmod omap44xx_emif_fw_hwmod = {
	.name		= "emif_fw",
	.class		= &omap44xx_emif_fw_hwmod_class,
	.clkdm_name	= "l3_emif_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_MEMIF_EMIF_FW_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_MEMIF_EMIF_FW_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap44xx_emif_fw_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_emif_fw_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'l3' class
 * instance(s): l3_instr, l3_main_1, l3_main_2, l3_main_3
 */
static struct omap_hwmod_class omap44xx_l3_hwmod_class = {
	.name	= "l3",
};

/* l3_instr */
/* iva -> l3_instr */
static struct omap_hwmod_ocp_if omap44xx_iva__l3_instr = {
	.master		= &omap44xx_iva_hwmod,
	.slave		= &omap44xx_l3_instr_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_3 -> l3_instr */
static struct omap_hwmod_ocp_if omap44xx_l3_main_3__l3_instr = {
	.master		= &omap44xx_l3_main_3_hwmod,
	.slave		= &omap44xx_l3_instr_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_instr slave ports */
static struct omap_hwmod_ocp_if *omap44xx_l3_instr_slaves[] = {
	&omap44xx_iva__l3_instr,
	&omap44xx_l3_main_3__l3_instr,
};

static struct omap_hwmod omap44xx_l3_instr_hwmod = {
	.name		= "l3_instr",
	.class		= &omap44xx_l3_hwmod_class,
	.clkdm_name	= "l3_instr_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L3INSTR_L3_INSTR_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L3INSTR_L3_INSTR_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.slaves		= omap44xx_l3_instr_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_l3_instr_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* l3_main_1 */
static struct omap_hwmod_irq_info omap44xx_l3_main_1_irqs[] = {
	{ .name = "dbg_err", .irq = 9 + OMAP44XX_IRQ_GIC_START },
	{ .name = "app_err", .irq = 10 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

/* dsp -> l3_main_1 */
static struct omap_hwmod_ocp_if omap44xx_dsp__l3_main_1 = {
	.master		= &omap44xx_dsp_hwmod,
	.slave		= &omap44xx_l3_main_1_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* dss -> l3_main_1 */
static struct omap_hwmod_ocp_if omap44xx_dss__l3_main_1 = {
	.master		= &omap44xx_dss_hwmod,
	.slave		= &omap44xx_l3_main_1_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_2 -> l3_main_1 */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__l3_main_1 = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_l3_main_1_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> l3_main_1 */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__l3_main_1 = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_l3_main_1_hwmod,
	.clk		= "l4_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mmc1 -> l3_main_1 */
static struct omap_hwmod_ocp_if omap44xx_mmc1__l3_main_1 = {
	.master		= &omap44xx_mmc1_hwmod,
	.slave		= &omap44xx_l3_main_1_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mmc2 -> l3_main_1 */
static struct omap_hwmod_ocp_if omap44xx_mmc2__l3_main_1 = {
	.master		= &omap44xx_mmc2_hwmod,
	.slave		= &omap44xx_l3_main_1_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap44xx_l3_main_1_addrs[] = {
	{
		.pa_start	= 0x44000000,
		.pa_end		= 0x44000fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* mpu -> l3_main_1 */
static struct omap_hwmod_ocp_if omap44xx_mpu__l3_main_1 = {
	.master		= &omap44xx_mpu_hwmod,
	.slave		= &omap44xx_l3_main_1_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap44xx_l3_main_1_addrs,
	.user		= OCP_USER_MPU,
};

/* l3_main_1 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_l3_main_1_slaves[] = {
	&omap44xx_dsp__l3_main_1,
	&omap44xx_dss__l3_main_1,
	&omap44xx_l3_main_2__l3_main_1,
	&omap44xx_l4_cfg__l3_main_1,
	&omap44xx_mmc1__l3_main_1,
	&omap44xx_mmc2__l3_main_1,
	&omap44xx_mpu__l3_main_1,
};

static struct omap_hwmod omap44xx_l3_main_1_hwmod = {
	.name		= "l3_main_1",
	.class		= &omap44xx_l3_hwmod_class,
	.clkdm_name	= "l3_1_clkdm",
	.mpu_irqs	= omap44xx_l3_main_1_irqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L3_1_L3_1_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L3_1_L3_1_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap44xx_l3_main_1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_l3_main_1_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* l3_main_2 */
/* dma_system -> l3_main_2 */
static struct omap_hwmod_ocp_if omap44xx_dma_system__l3_main_2 = {
	.master		= &omap44xx_dma_system_hwmod,
	.slave		= &omap44xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* hsi -> l3_main_2 */
static struct omap_hwmod_ocp_if omap44xx_hsi__l3_main_2 = {
	.master		= &omap44xx_hsi_hwmod,
	.slave		= &omap44xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* ipu -> l3_main_2 */
static struct omap_hwmod_ocp_if omap44xx_ipu__l3_main_2 = {
	.master		= &omap44xx_ipu_hwmod,
	.slave		= &omap44xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* iss -> l3_main_2 */
static struct omap_hwmod_ocp_if omap44xx_iss__l3_main_2 = {
	.master		= &omap44xx_iss_hwmod,
	.slave		= &omap44xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* iva -> l3_main_2 */
static struct omap_hwmod_ocp_if omap44xx_iva__l3_main_2 = {
	.master		= &omap44xx_iva_hwmod,
	.slave		= &omap44xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap44xx_l3_main_2_addrs[] = {
	{
		.pa_start	= 0x44800000,
		.pa_end		= 0x44801fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_1 -> l3_main_2 */
static struct omap_hwmod_ocp_if omap44xx_l3_main_1__l3_main_2 = {
	.master		= &omap44xx_l3_main_1_hwmod,
	.slave		= &omap44xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap44xx_l3_main_2_addrs,
	.user		= OCP_USER_MPU,
};

/* l4_cfg -> l3_main_2 */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__l3_main_2 = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_l3_main_2_hwmod,
	.clk		= "l4_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* usb_otg_hs -> l3_main_2 */
static struct omap_hwmod_ocp_if omap44xx_usb_otg_hs__l3_main_2 = {
	.master		= &omap44xx_usb_otg_hs_hwmod,
	.slave		= &omap44xx_l3_main_2_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_2 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_l3_main_2_slaves[] = {
	&omap44xx_dma_system__l3_main_2,
	&omap44xx_hsi__l3_main_2,
	&omap44xx_ipu__l3_main_2,
	&omap44xx_iss__l3_main_2,
	&omap44xx_iva__l3_main_2,
	&omap44xx_l3_main_1__l3_main_2,
	&omap44xx_l4_cfg__l3_main_2,
	&omap44xx_usb_otg_hs__l3_main_2,
};

static struct omap_hwmod omap44xx_l3_main_2_hwmod = {
	.name		= "l3_main_2",
	.class		= &omap44xx_l3_hwmod_class,
	.clkdm_name	= "l3_2_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L3_2_L3_2_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L3_2_L3_2_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap44xx_l3_main_2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_l3_main_2_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* l3_main_3 */
static struct omap_hwmod_addr_space omap44xx_l3_main_3_addrs[] = {
	{
		.pa_start	= 0x45000000,
		.pa_end		= 0x45000fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_1 -> l3_main_3 */
static struct omap_hwmod_ocp_if omap44xx_l3_main_1__l3_main_3 = {
	.master		= &omap44xx_l3_main_1_hwmod,
	.slave		= &omap44xx_l3_main_3_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap44xx_l3_main_3_addrs,
	.user		= OCP_USER_MPU,
};

/* l3_main_2 -> l3_main_3 */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__l3_main_3 = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_l3_main_3_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> l3_main_3 */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__l3_main_3 = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_l3_main_3_hwmod,
	.clk		= "l4_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_3 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_l3_main_3_slaves[] = {
	&omap44xx_l3_main_1__l3_main_3,
	&omap44xx_l3_main_2__l3_main_3,
	&omap44xx_l4_cfg__l3_main_3,
};

static struct omap_hwmod omap44xx_l3_main_3_hwmod = {
	.name		= "l3_main_3",
	.class		= &omap44xx_l3_hwmod_class,
	.clkdm_name	= "l3_instr_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L3INSTR_L3_3_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L3INSTR_L3_3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.slaves		= omap44xx_l3_main_3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_l3_main_3_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'l4' class
 * instance(s): l4_abe, l4_cfg, l4_per, l4_wkup
 */
static struct omap_hwmod_class omap44xx_l4_hwmod_class = {
	.name	= "l4",
};

/* l4_abe */
/* aess -> l4_abe */
static struct omap_hwmod_ocp_if omap44xx_aess__l4_abe = {
	.master		= &omap44xx_aess_hwmod,
	.slave		= &omap44xx_l4_abe_hwmod,
	.clk		= "ocp_abe_iclk",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* dsp -> l4_abe */
static struct omap_hwmod_ocp_if omap44xx_dsp__l4_abe = {
	.master		= &omap44xx_dsp_hwmod,
	.slave		= &omap44xx_l4_abe_hwmod,
	.clk		= "ocp_abe_iclk",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_abe */
static struct omap_hwmod_ocp_if omap44xx_l3_main_1__l4_abe = {
	.master		= &omap44xx_l3_main_1_hwmod,
	.slave		= &omap44xx_l4_abe_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu -> l4_abe */
static struct omap_hwmod_ocp_if omap44xx_mpu__l4_abe = {
	.master		= &omap44xx_mpu_hwmod,
	.slave		= &omap44xx_l4_abe_hwmod,
	.clk		= "ocp_abe_iclk",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_abe slave ports */
static struct omap_hwmod_ocp_if *omap44xx_l4_abe_slaves[] = {
	&omap44xx_aess__l4_abe,
	&omap44xx_dsp__l4_abe,
	&omap44xx_l3_main_1__l4_abe,
	&omap44xx_mpu__l4_abe,
};

static struct omap_hwmod omap44xx_l4_abe_hwmod = {
	.name		= "l4_abe",
	.class		= &omap44xx_l4_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM1_ABE_L4ABE_CLKCTRL_OFFSET,
		},
	},
	.slaves		= omap44xx_l4_abe_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_l4_abe_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* l4_cfg */
/* l3_main_1 -> l4_cfg */
static struct omap_hwmod_ocp_if omap44xx_l3_main_1__l4_cfg = {
	.master		= &omap44xx_l3_main_1_hwmod,
	.slave		= &omap44xx_l4_cfg_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg slave ports */
static struct omap_hwmod_ocp_if *omap44xx_l4_cfg_slaves[] = {
	&omap44xx_l3_main_1__l4_cfg,
};

static struct omap_hwmod omap44xx_l4_cfg_hwmod = {
	.name		= "l4_cfg",
	.class		= &omap44xx_l4_hwmod_class,
	.clkdm_name	= "l4_cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4CFG_L4_CFG_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4CFG_L4_CFG_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap44xx_l4_cfg_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_l4_cfg_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* l4_per */
/* l3_main_2 -> l4_per */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__l4_per = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_l4_per_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per slave ports */
static struct omap_hwmod_ocp_if *omap44xx_l4_per_slaves[] = {
	&omap44xx_l3_main_2__l4_per,
};

static struct omap_hwmod omap44xx_l4_per_hwmod = {
	.name		= "l4_per",
	.class		= &omap44xx_l4_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_L4PER_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_L4_PER_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap44xx_l4_per_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_l4_per_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* l4_wkup */
/* l4_cfg -> l4_wkup */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__l4_wkup = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_l4_wkup_hwmod,
	.clk		= "l4_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_wkup slave ports */
static struct omap_hwmod_ocp_if *omap44xx_l4_wkup_slaves[] = {
	&omap44xx_l4_cfg__l4_wkup,
};

static struct omap_hwmod omap44xx_l4_wkup_hwmod = {
	.name		= "l4_wkup",
	.class		= &omap44xx_l4_hwmod_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_WKUP_L4WKUP_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_WKUP_L4WKUP_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap44xx_l4_wkup_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_l4_wkup_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'mpu_bus' class
 * instance(s): mpu_private
 */
static struct omap_hwmod_class omap44xx_mpu_bus_hwmod_class = {
	.name	= "mpu_bus",
};

/* mpu_private */
/* mpu -> mpu_private */
static struct omap_hwmod_ocp_if omap44xx_mpu__mpu_private = {
	.master		= &omap44xx_mpu_hwmod,
	.slave		= &omap44xx_mpu_private_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu_private slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mpu_private_slaves[] = {
	&omap44xx_mpu__mpu_private,
};

static struct omap_hwmod omap44xx_mpu_private_hwmod = {
	.name		= "mpu_private",
	.class		= &omap44xx_mpu_bus_hwmod_class,
	.clkdm_name	= "mpuss_clkdm",
	.slaves		= omap44xx_mpu_private_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mpu_private_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * Modules omap_hwmod structures
 *
 * The following IPs are excluded for the moment because:
 * - They do not need an explicit SW control using omap_hwmod API.
 * - They still need to be validated with the driver
 *   properly adapted to omap_hwmod / omap_device
 *
 *  c2c
 *  c2c_target_fw
 *  cm_core
 *  cm_core_aon
 *  ctrl_module_core
 *  ctrl_module_pad_core
 *  ctrl_module_pad_wkup
 *  ctrl_module_wkup
 *  debugss
 *  efuse_ctrl_cust
 *  efuse_ctrl_std
 *  elm
 *  emif1
 *  emif2
 *  fdif
 *  gpmc
 *  gpu
 *  hdq1w
 *  mcasp
 *  mpu_c0
 *  mpu_c1
 *  ocmc_ram
 *  ocp2scp_usb_phy
 *  ocp_wp_noc
 *  prcm_mpu
 *  prm
 *  scrm
 *  sl2if
 *  slimbus1
 *  slimbus2
 *  usb_host_fs
 *  usb_host_hs
 *  usb_phy_cm
 *  usb_tll_hs
 *  usim
 */

/*
 * 'aess' class
 * audio engine sub system
 */

static struct omap_hwmod_class_sysconfig omap44xx_aess_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_MIDLEMODE | SYSC_HAS_SIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   MSTANDBY_FORCE | MSTANDBY_NO | MSTANDBY_SMART |
			   MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap44xx_aess_hwmod_class = {
	.name	= "aess",
	.sysc	= &omap44xx_aess_sysc,
};

/* aess */
static struct omap_hwmod_irq_info omap44xx_aess_irqs[] = {
	{ .irq = 99 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_aess_sdma_reqs[] = {
	{ .name = "fifo0", .dma_req = 100 + OMAP44XX_DMA_REQ_START },
	{ .name = "fifo1", .dma_req = 101 + OMAP44XX_DMA_REQ_START },
	{ .name = "fifo2", .dma_req = 102 + OMAP44XX_DMA_REQ_START },
	{ .name = "fifo3", .dma_req = 103 + OMAP44XX_DMA_REQ_START },
	{ .name = "fifo4", .dma_req = 104 + OMAP44XX_DMA_REQ_START },
	{ .name = "fifo5", .dma_req = 105 + OMAP44XX_DMA_REQ_START },
	{ .name = "fifo6", .dma_req = 106 + OMAP44XX_DMA_REQ_START },
	{ .name = "fifo7", .dma_req = 107 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

/* aess master ports */
static struct omap_hwmod_ocp_if *omap44xx_aess_masters[] = {
	&omap44xx_aess__l4_abe,
};

static struct omap_hwmod_addr_space omap44xx_aess_addrs[] = {
	{
		.pa_start	= 0x401f1000,
		.pa_end		= 0x401f13ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> aess */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__aess = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_aess_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_aess_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap44xx_aess_dma_addrs[] = {
	{
		.pa_start	= 0x490f1000,
		.pa_end		= 0x490f13ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> aess (dma) */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__aess_dma = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_aess_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_aess_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* aess slave ports */
static struct omap_hwmod_ocp_if *omap44xx_aess_slaves[] = {
	&omap44xx_l4_abe__aess,
	&omap44xx_l4_abe__aess_dma,
};

static struct omap_hwmod omap44xx_aess_hwmod = {
	.name		= "aess",
	.class		= &omap44xx_aess_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap44xx_aess_irqs,
	.sdma_reqs	= omap44xx_aess_sdma_reqs,
	.main_clk	= "aess_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM1_ABE_AESS_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_ABE_AESS_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_aess_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_aess_slaves),
	.masters	= omap44xx_aess_masters,
	.masters_cnt	= ARRAY_SIZE(omap44xx_aess_masters),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'bandgap' class
 * bangap reference for ldo regulators
 */

static struct omap_hwmod_class omap44xx_bandgap_hwmod_class = {
	.name	= "bandgap",
};

/* bandgap */
static struct omap_hwmod_opt_clk bandgap_opt_clks[] = {
	{ .role = "fclk", .clk = "bandgap_fclk" },
};

static struct omap_hwmod omap44xx_bandgap_hwmod = {
	.name		= "bandgap",
	.class		= &omap44xx_bandgap_hwmod_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_WKUP_BANDGAP_CLKCTRL_OFFSET,
		},
	},
	.opt_clks	= bandgap_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(bandgap_opt_clks),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'counter' class
 * 32-bit ordinary counter, clocked by the falling edge of the 32 khz clock
 */

static struct omap_hwmod_class_sysconfig omap44xx_counter_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0004,
	.sysc_flags	= SYSC_HAS_SIDLEMODE,
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_counter_hwmod_class = {
	.name	= "counter",
	.sysc	= &omap44xx_counter_sysc,
};

/* counter_32k */
static struct omap_hwmod omap44xx_counter_32k_hwmod;
static struct omap_hwmod_addr_space omap44xx_counter_32k_addrs[] = {
	{
		.pa_start	= 0x4a304000,
		.pa_end		= 0x4a30401f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_wkup -> counter_32k */
static struct omap_hwmod_ocp_if omap44xx_l4_wkup__counter_32k = {
	.master		= &omap44xx_l4_wkup_hwmod,
	.slave		= &omap44xx_counter_32k_hwmod,
	.clk		= "l4_wkup_clk_mux_ck",
	.addr		= omap44xx_counter_32k_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* counter_32k slave ports */
static struct omap_hwmod_ocp_if *omap44xx_counter_32k_slaves[] = {
	&omap44xx_l4_wkup__counter_32k,
};

static struct omap_hwmod omap44xx_counter_32k_hwmod = {
	.name		= "counter_32k",
	.class		= &omap44xx_counter_hwmod_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.flags		= HWMOD_SWSUP_SIDLE,
	.main_clk	= "sys_32k_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_WKUP_SYNCTIMER_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_WKUP_SYNCTIMER_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap44xx_counter_32k_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_counter_32k_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'dma' class
 * dma controller for data exchange between memory to memory (i.e. internal or
 * external memory) and gp peripherals to memory or memory to gp peripherals
 */

static struct omap_hwmod_class_sysconfig omap44xx_dma_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x002c,
	.syss_offs	= 0x0028,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_EMUFREE | SYSC_HAS_MIDLEMODE |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   MSTANDBY_FORCE | MSTANDBY_NO | MSTANDBY_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_dma_hwmod_class = {
	.name	= "dma",
	.sysc	= &omap44xx_dma_sysc,
};

/* dma dev_attr */
static struct omap_dma_dev_attr dma_dev_attr = {
	.dev_caps	= RESERVE_CHANNEL | DMA_LINKED_LCH | GLOBAL_PRIORITY |
			  IS_CSSA_32 | IS_CDSA_32 | IS_RW_PRIORITY,
	.lch_count	= 32,
};

/* dma_system */
static struct omap_hwmod_irq_info omap44xx_dma_system_irqs[] = {
	{ .name = "0", .irq = 12 + OMAP44XX_IRQ_GIC_START },
	{ .name = "1", .irq = 13 + OMAP44XX_IRQ_GIC_START },
	{ .name = "2", .irq = 14 + OMAP44XX_IRQ_GIC_START },
	{ .name = "3", .irq = 15 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

/* dma_system master ports */
static struct omap_hwmod_ocp_if *omap44xx_dma_system_masters[] = {
	&omap44xx_dma_system__l3_main_2,
};

static struct omap_hwmod_addr_space omap44xx_dma_system_addrs[] = {
	{
		.pa_start	= 0x4a056000,
		.pa_end		= 0x4a056fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> dma_system */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__dma_system = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_dma_system_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_dma_system_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* dma_system slave ports */
static struct omap_hwmod_ocp_if *omap44xx_dma_system_slaves[] = {
	&omap44xx_l4_cfg__dma_system,
};

static struct omap_hwmod omap44xx_dma_system_hwmod = {
	.name		= "dma_system",
	.class		= &omap44xx_dma_hwmod_class,
	.clkdm_name	= "l3_dma_clkdm",
	.mpu_irqs	= omap44xx_dma_system_irqs,
	.main_clk	= "l3_div_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_SDMA_SDMA_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_SDMA_SDMA_CONTEXT_OFFSET,
		},
	},
	.dev_attr	= &dma_dev_attr,
	.slaves		= omap44xx_dma_system_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_dma_system_slaves),
	.masters	= omap44xx_dma_system_masters,
	.masters_cnt	= ARRAY_SIZE(omap44xx_dma_system_masters),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'dmic' class
 * digital microphone controller
 */

static struct omap_hwmod_class_sysconfig omap44xx_dmic_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap44xx_dmic_hwmod_class = {
	.name	= "dmic",
	.sysc	= &omap44xx_dmic_sysc,
};

/* dmic */
static struct omap_hwmod omap44xx_dmic_hwmod;
static struct omap_hwmod_irq_info omap44xx_dmic_irqs[] = {
	{ .irq = 114 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_dmic_sdma_reqs[] = {
	{ .dma_req = 66 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_dmic_addrs[] = {
	{
		.pa_start	= 0x4012e000,
		.pa_end		= 0x4012e07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> dmic */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__dmic = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_dmic_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_dmic_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap44xx_dmic_dma_addrs[] = {
	{
		.pa_start	= 0x4902e000,
		.pa_end		= 0x4902e07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> dmic (dma) */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__dmic_dma = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_dmic_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_dmic_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* dmic slave ports */
static struct omap_hwmod_ocp_if *omap44xx_dmic_slaves[] = {
	&omap44xx_l4_abe__dmic,
	&omap44xx_l4_abe__dmic_dma,
};

static struct omap_hwmod omap44xx_dmic_hwmod = {
	.name		= "dmic",
	.class		= &omap44xx_dmic_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap44xx_dmic_irqs,
	.sdma_reqs	= omap44xx_dmic_sdma_reqs,
	.main_clk	= "dmic_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM1_ABE_DMIC_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_ABE_DMIC_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_dmic_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_dmic_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'dsp' class
 * dsp sub-system
 */

static struct omap_hwmod_class omap44xx_dsp_hwmod_class = {
	.name	= "dsp",
};

/* dsp */
static struct omap_hwmod_irq_info omap44xx_dsp_irqs[] = {
	{ .irq = 28 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_rst_info omap44xx_dsp_resets[] = {
	{ .name = "mmu_cache", .rst_shift = 1 },
};

static struct omap_hwmod_rst_info omap44xx_dsp_c0_resets[] = {
	{ .name = "dsp", .rst_shift = 0 },
};

/* dsp -> iva */
static struct omap_hwmod_ocp_if omap44xx_dsp__iva = {
	.master		= &omap44xx_dsp_hwmod,
	.slave		= &omap44xx_iva_hwmod,
	.clk		= "dpll_iva_m5x2_ck",
};

/* dsp master ports */
static struct omap_hwmod_ocp_if *omap44xx_dsp_masters[] = {
	&omap44xx_dsp__l3_main_1,
	&omap44xx_dsp__l4_abe,
	&omap44xx_dsp__iva,
};

/* l4_cfg -> dsp */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__dsp = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_dsp_hwmod,
	.clk		= "l4_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* dsp slave ports */
static struct omap_hwmod_ocp_if *omap44xx_dsp_slaves[] = {
	&omap44xx_l4_cfg__dsp,
};

/* Pseudo hwmod for reset control purpose only */
static struct omap_hwmod omap44xx_dsp_c0_hwmod = {
	.name		= "dsp_c0",
	.class		= &omap44xx_dsp_hwmod_class,
	.clkdm_name	= "tesla_clkdm",
	.flags		= HWMOD_INIT_NO_RESET,
	.rst_lines	= omap44xx_dsp_c0_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap44xx_dsp_c0_resets),
	.prcm = {
		.omap4 = {
			.rstctrl_offs = OMAP4_RM_TESLA_RSTCTRL_OFFSET,
		},
	},
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct omap_hwmod omap44xx_dsp_hwmod = {
	.name		= "dsp",
	.class		= &omap44xx_dsp_hwmod_class,
	.clkdm_name	= "tesla_clkdm",
	.mpu_irqs	= omap44xx_dsp_irqs,
	.rst_lines	= omap44xx_dsp_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap44xx_dsp_resets),
	.main_clk	= "dsp_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_TESLA_TESLA_CLKCTRL_OFFSET,
			.rstctrl_offs = OMAP4_RM_TESLA_RSTCTRL_OFFSET,
			.context_offs = OMAP4_RM_TESLA_TESLA_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.slaves		= omap44xx_dsp_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_dsp_slaves),
	.masters	= omap44xx_dsp_masters,
	.masters_cnt	= ARRAY_SIZE(omap44xx_dsp_masters),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'dss' class
 * display sub-system
 */

static struct omap_hwmod_class_sysconfig omap44xx_dss_sysc = {
	.rev_offs	= 0x0000,
	.syss_offs	= 0x0014,
	.sysc_flags	= SYSS_HAS_RESET_STATUS,
};

static struct omap_hwmod_class omap44xx_dss_hwmod_class = {
	.name	= "dss",
	.sysc	= &omap44xx_dss_sysc,
};

/* dss */
/* dss master ports */
static struct omap_hwmod_ocp_if *omap44xx_dss_masters[] = {
	&omap44xx_dss__l3_main_1,
};

static struct omap_hwmod_addr_space omap44xx_dss_dma_addrs[] = {
	{
		.pa_start	= 0x58000000,
		.pa_end		= 0x5800007f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> dss */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__dss = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_dss_hwmod,
	.clk		= "dss_fck",
	.addr		= omap44xx_dss_dma_addrs,
	.user		= OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap44xx_dss_addrs[] = {
	{
		.pa_start	= 0x48040000,
		.pa_end		= 0x4804007f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> dss */
static struct omap_hwmod_ocp_if omap44xx_l4_per__dss = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_dss_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_dss_addrs,
	.user		= OCP_USER_MPU,
};

/* dss slave ports */
static struct omap_hwmod_ocp_if *omap44xx_dss_slaves[] = {
	&omap44xx_l3_main_2__dss,
	&omap44xx_l4_per__dss,
};

static struct omap_hwmod_opt_clk dss_opt_clks[] = {
	{ .role = "sys_clk", .clk = "dss_sys_clk" },
	{ .role = "tv_clk", .clk = "dss_tv_clk" },
	{ .role = "dss_clk", .clk = "dss_dss_clk" },
	{ .role = "video_clk", .clk = "dss_48mhz_clk" },
};

static struct omap_hwmod omap44xx_dss_hwmod = {
	.name		= "dss_core",
	.class		= &omap44xx_dss_hwmod_class,
	.clkdm_name	= "l3_dss_clkdm",
	.main_clk	= "dss_dss_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_DSS_DSS_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_DSS_DSS_CONTEXT_OFFSET,
		},
	},
	.opt_clks	= dss_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(dss_opt_clks),
	.slaves		= omap44xx_dss_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_dss_slaves),
	.masters	= omap44xx_dss_masters,
	.masters_cnt	= ARRAY_SIZE(omap44xx_dss_masters),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'dispc' class
 * display controller
 */

static struct omap_hwmod_class_sysconfig omap44xx_dispc_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_ENAWAKEUP | SYSC_HAS_MIDLEMODE |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   MSTANDBY_FORCE | MSTANDBY_NO | MSTANDBY_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_dispc_hwmod_class = {
	.name	= "dispc",
	.sysc	= &omap44xx_dispc_sysc,
};

/* dss_dispc */
static struct omap_hwmod omap44xx_dss_dispc_hwmod;
static struct omap_hwmod_irq_info omap44xx_dss_dispc_irqs[] = {
	{ .irq = 25 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_dss_dispc_sdma_reqs[] = {
	{ .dma_req = 5 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_dss_dispc_dma_addrs[] = {
	{
		.pa_start	= 0x58001000,
		.pa_end		= 0x58001fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> dss_dispc */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__dss_dispc = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_dss_dispc_hwmod,
	.clk		= "dss_fck",
	.addr		= omap44xx_dss_dispc_dma_addrs,
	.user		= OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap44xx_dss_dispc_addrs[] = {
	{
		.pa_start	= 0x48041000,
		.pa_end		= 0x48041fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> dss_dispc */
static struct omap_hwmod_ocp_if omap44xx_l4_per__dss_dispc = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_dss_dispc_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_dss_dispc_addrs,
	.user		= OCP_USER_MPU,
};

/* dss_dispc slave ports */
static struct omap_hwmod_ocp_if *omap44xx_dss_dispc_slaves[] = {
	&omap44xx_l3_main_2__dss_dispc,
	&omap44xx_l4_per__dss_dispc,
};

static struct omap_hwmod_opt_clk dss_dispc_opt_clks[] = {
	{ .role = "sys_clk", .clk = "dss_sys_clk" },
	{ .role = "tv_clk", .clk = "dss_tv_clk" },
	{ .role = "hdmi_clk", .clk = "dss_48mhz_clk" },
};

static struct omap_hwmod omap44xx_dss_dispc_hwmod = {
	.name		= "dss_dispc",
	.class		= &omap44xx_dispc_hwmod_class,
	.clkdm_name	= "l3_dss_clkdm",
	.mpu_irqs	= omap44xx_dss_dispc_irqs,
	.sdma_reqs	= omap44xx_dss_dispc_sdma_reqs,
	.main_clk	= "dss_dss_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_DSS_DSS_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_DSS_DSS_CONTEXT_OFFSET,
		},
	},
	.opt_clks	= dss_dispc_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(dss_dispc_opt_clks),
	.slaves		= omap44xx_dss_dispc_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_dss_dispc_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'dsi' class
 * display serial interface controller
 */

static struct omap_hwmod_class_sysconfig omap44xx_dsi_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_dsi_hwmod_class = {
	.name	= "dsi",
	.sysc	= &omap44xx_dsi_sysc,
};

/* dss_dsi1 */
static struct omap_hwmod omap44xx_dss_dsi1_hwmod;
static struct omap_hwmod_irq_info omap44xx_dss_dsi1_irqs[] = {
	{ .irq = 53 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_dss_dsi1_sdma_reqs[] = {
	{ .dma_req = 74 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_dss_dsi1_dma_addrs[] = {
	{
		.pa_start	= 0x58004000,
		.pa_end		= 0x580041ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> dss_dsi1 */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__dss_dsi1 = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_dss_dsi1_hwmod,
	.clk		= "dss_fck",
	.addr		= omap44xx_dss_dsi1_dma_addrs,
	.user		= OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap44xx_dss_dsi1_addrs[] = {
	{
		.pa_start	= 0x48044000,
		.pa_end		= 0x480441ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> dss_dsi1 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__dss_dsi1 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_dss_dsi1_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_dss_dsi1_addrs,
	.user		= OCP_USER_MPU,
};

/* dss_dsi1 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_dss_dsi1_slaves[] = {
	&omap44xx_l3_main_2__dss_dsi1,
	&omap44xx_l4_per__dss_dsi1,
};

static struct omap_hwmod_opt_clk dss_dsi1_opt_clks[] = {
	{ .role = "sys_clk", .clk = "dss_sys_clk" },
};

static struct omap_hwmod omap44xx_dss_dsi1_hwmod = {
	.name		= "dss_dsi1",
	.class		= &omap44xx_dsi_hwmod_class,
	.clkdm_name	= "l3_dss_clkdm",
	.mpu_irqs	= omap44xx_dss_dsi1_irqs,
	.sdma_reqs	= omap44xx_dss_dsi1_sdma_reqs,
	.main_clk	= "dss_dss_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_DSS_DSS_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_DSS_DSS_CONTEXT_OFFSET,
		},
	},
	.opt_clks	= dss_dsi1_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(dss_dsi1_opt_clks),
	.slaves		= omap44xx_dss_dsi1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_dss_dsi1_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* dss_dsi2 */
static struct omap_hwmod omap44xx_dss_dsi2_hwmod;
static struct omap_hwmod_irq_info omap44xx_dss_dsi2_irqs[] = {
	{ .irq = 84 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_dss_dsi2_sdma_reqs[] = {
	{ .dma_req = 83 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_dss_dsi2_dma_addrs[] = {
	{
		.pa_start	= 0x58005000,
		.pa_end		= 0x580051ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> dss_dsi2 */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__dss_dsi2 = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_dss_dsi2_hwmod,
	.clk		= "dss_fck",
	.addr		= omap44xx_dss_dsi2_dma_addrs,
	.user		= OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap44xx_dss_dsi2_addrs[] = {
	{
		.pa_start	= 0x48045000,
		.pa_end		= 0x480451ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> dss_dsi2 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__dss_dsi2 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_dss_dsi2_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_dss_dsi2_addrs,
	.user		= OCP_USER_MPU,
};

/* dss_dsi2 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_dss_dsi2_slaves[] = {
	&omap44xx_l3_main_2__dss_dsi2,
	&omap44xx_l4_per__dss_dsi2,
};

static struct omap_hwmod_opt_clk dss_dsi2_opt_clks[] = {
	{ .role = "sys_clk", .clk = "dss_sys_clk" },
};

static struct omap_hwmod omap44xx_dss_dsi2_hwmod = {
	.name		= "dss_dsi2",
	.class		= &omap44xx_dsi_hwmod_class,
	.clkdm_name	= "l3_dss_clkdm",
	.mpu_irqs	= omap44xx_dss_dsi2_irqs,
	.sdma_reqs	= omap44xx_dss_dsi2_sdma_reqs,
	.main_clk	= "dss_dss_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_DSS_DSS_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_DSS_DSS_CONTEXT_OFFSET,
		},
	},
	.opt_clks	= dss_dsi2_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(dss_dsi2_opt_clks),
	.slaves		= omap44xx_dss_dsi2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_dss_dsi2_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'hdmi' class
 * hdmi controller
 */

static struct omap_hwmod_class_sysconfig omap44xx_hdmi_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_RESET_STATUS | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap44xx_hdmi_hwmod_class = {
	.name	= "hdmi",
	.sysc	= &omap44xx_hdmi_sysc,
};

/* dss_hdmi */
static struct omap_hwmod omap44xx_dss_hdmi_hwmod;
static struct omap_hwmod_irq_info omap44xx_dss_hdmi_irqs[] = {
	{ .irq = 101 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_dss_hdmi_sdma_reqs[] = {
	{ .dma_req = 75 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_dss_hdmi_dma_addrs[] = {
	{
		.pa_start	= 0x58006000,
		.pa_end		= 0x58006fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> dss_hdmi */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__dss_hdmi = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_dss_hdmi_hwmod,
	.clk		= "dss_fck",
	.addr		= omap44xx_dss_hdmi_dma_addrs,
	.user		= OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap44xx_dss_hdmi_addrs[] = {
	{
		.pa_start	= 0x48046000,
		.pa_end		= 0x48046fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> dss_hdmi */
static struct omap_hwmod_ocp_if omap44xx_l4_per__dss_hdmi = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_dss_hdmi_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_dss_hdmi_addrs,
	.user		= OCP_USER_MPU,
};

/* dss_hdmi slave ports */
static struct omap_hwmod_ocp_if *omap44xx_dss_hdmi_slaves[] = {
	&omap44xx_l3_main_2__dss_hdmi,
	&omap44xx_l4_per__dss_hdmi,
};

static struct omap_hwmod_opt_clk dss_hdmi_opt_clks[] = {
	{ .role = "sys_clk", .clk = "dss_sys_clk" },
};

static struct omap_hwmod omap44xx_dss_hdmi_hwmod = {
	.name		= "dss_hdmi",
	.class		= &omap44xx_hdmi_hwmod_class,
	.clkdm_name	= "l3_dss_clkdm",
	.mpu_irqs	= omap44xx_dss_hdmi_irqs,
	.sdma_reqs	= omap44xx_dss_hdmi_sdma_reqs,
	.main_clk	= "dss_dss_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_DSS_DSS_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_DSS_DSS_CONTEXT_OFFSET,
		},
	},
	.opt_clks	= dss_hdmi_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(dss_hdmi_opt_clks),
	.slaves		= omap44xx_dss_hdmi_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_dss_hdmi_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'rfbi' class
 * remote frame buffer interface
 */

static struct omap_hwmod_class_sysconfig omap44xx_rfbi_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_rfbi_hwmod_class = {
	.name	= "rfbi",
	.sysc	= &omap44xx_rfbi_sysc,
};

/* dss_rfbi */
static struct omap_hwmod omap44xx_dss_rfbi_hwmod;
static struct omap_hwmod_dma_info omap44xx_dss_rfbi_sdma_reqs[] = {
	{ .dma_req = 13 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_dss_rfbi_dma_addrs[] = {
	{
		.pa_start	= 0x58002000,
		.pa_end		= 0x580020ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> dss_rfbi */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__dss_rfbi = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_dss_rfbi_hwmod,
	.clk		= "dss_fck",
	.addr		= omap44xx_dss_rfbi_dma_addrs,
	.user		= OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap44xx_dss_rfbi_addrs[] = {
	{
		.pa_start	= 0x48042000,
		.pa_end		= 0x480420ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> dss_rfbi */
static struct omap_hwmod_ocp_if omap44xx_l4_per__dss_rfbi = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_dss_rfbi_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_dss_rfbi_addrs,
	.user		= OCP_USER_MPU,
};

/* dss_rfbi slave ports */
static struct omap_hwmod_ocp_if *omap44xx_dss_rfbi_slaves[] = {
	&omap44xx_l3_main_2__dss_rfbi,
	&omap44xx_l4_per__dss_rfbi,
};

static struct omap_hwmod_opt_clk dss_rfbi_opt_clks[] = {
	{ .role = "ick", .clk = "dss_fck" },
};

static struct omap_hwmod omap44xx_dss_rfbi_hwmod = {
	.name		= "dss_rfbi",
	.class		= &omap44xx_rfbi_hwmod_class,
	.clkdm_name	= "l3_dss_clkdm",
	.sdma_reqs	= omap44xx_dss_rfbi_sdma_reqs,
	.main_clk	= "dss_dss_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_DSS_DSS_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_DSS_DSS_CONTEXT_OFFSET,
		},
	},
	.opt_clks	= dss_rfbi_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(dss_rfbi_opt_clks),
	.slaves		= omap44xx_dss_rfbi_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_dss_rfbi_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'venc' class
 * video encoder
 */

static struct omap_hwmod_class omap44xx_venc_hwmod_class = {
	.name	= "venc",
};

/* dss_venc */
static struct omap_hwmod omap44xx_dss_venc_hwmod;
static struct omap_hwmod_addr_space omap44xx_dss_venc_dma_addrs[] = {
	{
		.pa_start	= 0x58003000,
		.pa_end		= 0x580030ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> dss_venc */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__dss_venc = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_dss_venc_hwmod,
	.clk		= "dss_fck",
	.addr		= omap44xx_dss_venc_dma_addrs,
	.user		= OCP_USER_SDMA,
};

static struct omap_hwmod_addr_space omap44xx_dss_venc_addrs[] = {
	{
		.pa_start	= 0x48043000,
		.pa_end		= 0x480430ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> dss_venc */
static struct omap_hwmod_ocp_if omap44xx_l4_per__dss_venc = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_dss_venc_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_dss_venc_addrs,
	.user		= OCP_USER_MPU,
};

/* dss_venc slave ports */
static struct omap_hwmod_ocp_if *omap44xx_dss_venc_slaves[] = {
	&omap44xx_l3_main_2__dss_venc,
	&omap44xx_l4_per__dss_venc,
};

static struct omap_hwmod omap44xx_dss_venc_hwmod = {
	.name		= "dss_venc",
	.class		= &omap44xx_venc_hwmod_class,
	.clkdm_name	= "l3_dss_clkdm",
	.main_clk	= "dss_dss_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_DSS_DSS_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_DSS_DSS_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap44xx_dss_venc_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_dss_venc_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'gpio' class
 * general purpose io module
 */

static struct omap_hwmod_class_sysconfig omap44xx_gpio_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0114,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_ENAWAKEUP |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_gpio_hwmod_class = {
	.name	= "gpio",
	.sysc	= &omap44xx_gpio_sysc,
	.rev	= 2,
};

/* gpio dev_attr */
static struct omap_gpio_dev_attr gpio_dev_attr = {
	.bank_width	= 32,
	.dbck_flag	= true,
};

/* gpio1 */
static struct omap_hwmod omap44xx_gpio1_hwmod;
static struct omap_hwmod_irq_info omap44xx_gpio1_irqs[] = {
	{ .irq = 29 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_gpio1_addrs[] = {
	{
		.pa_start	= 0x4a310000,
		.pa_end		= 0x4a3101ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_wkup -> gpio1 */
static struct omap_hwmod_ocp_if omap44xx_l4_wkup__gpio1 = {
	.master		= &omap44xx_l4_wkup_hwmod,
	.slave		= &omap44xx_gpio1_hwmod,
	.clk		= "l4_wkup_clk_mux_ck",
	.addr		= omap44xx_gpio1_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio1 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_gpio1_slaves[] = {
	&omap44xx_l4_wkup__gpio1,
};

static struct omap_hwmod_opt_clk gpio1_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio1_dbclk" },
};

static struct omap_hwmod omap44xx_gpio1_hwmod = {
	.name		= "gpio1",
	.class		= &omap44xx_gpio_hwmod_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.mpu_irqs	= omap44xx_gpio1_irqs,
	.main_clk	= "gpio1_ick",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_WKUP_GPIO1_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_WKUP_GPIO1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio1_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio1_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap44xx_gpio1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_gpio1_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* gpio2 */
static struct omap_hwmod omap44xx_gpio2_hwmod;
static struct omap_hwmod_irq_info omap44xx_gpio2_irqs[] = {
	{ .irq = 30 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_gpio2_addrs[] = {
	{
		.pa_start	= 0x48055000,
		.pa_end		= 0x480551ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> gpio2 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__gpio2 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_gpio2_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_gpio2_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio2 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_gpio2_slaves[] = {
	&omap44xx_l4_per__gpio2,
};

static struct omap_hwmod_opt_clk gpio2_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio2_dbclk" },
};

static struct omap_hwmod omap44xx_gpio2_hwmod = {
	.name		= "gpio2",
	.class		= &omap44xx_gpio_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.mpu_irqs	= omap44xx_gpio2_irqs,
	.main_clk	= "gpio2_ick",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_GPIO2_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_GPIO2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio2_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio2_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap44xx_gpio2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_gpio2_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* gpio3 */
static struct omap_hwmod omap44xx_gpio3_hwmod;
static struct omap_hwmod_irq_info omap44xx_gpio3_irqs[] = {
	{ .irq = 31 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_gpio3_addrs[] = {
	{
		.pa_start	= 0x48057000,
		.pa_end		= 0x480571ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> gpio3 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__gpio3 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_gpio3_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_gpio3_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio3 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_gpio3_slaves[] = {
	&omap44xx_l4_per__gpio3,
};

static struct omap_hwmod_opt_clk gpio3_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio3_dbclk" },
};

static struct omap_hwmod omap44xx_gpio3_hwmod = {
	.name		= "gpio3",
	.class		= &omap44xx_gpio_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.mpu_irqs	= omap44xx_gpio3_irqs,
	.main_clk	= "gpio3_ick",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_GPIO3_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_GPIO3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio3_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio3_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap44xx_gpio3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_gpio3_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* gpio4 */
static struct omap_hwmod omap44xx_gpio4_hwmod;
static struct omap_hwmod_irq_info omap44xx_gpio4_irqs[] = {
	{ .irq = 32 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_gpio4_addrs[] = {
	{
		.pa_start	= 0x48059000,
		.pa_end		= 0x480591ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> gpio4 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__gpio4 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_gpio4_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_gpio4_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio4 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_gpio4_slaves[] = {
	&omap44xx_l4_per__gpio4,
};

static struct omap_hwmod_opt_clk gpio4_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio4_dbclk" },
};

static struct omap_hwmod omap44xx_gpio4_hwmod = {
	.name		= "gpio4",
	.class		= &omap44xx_gpio_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.mpu_irqs	= omap44xx_gpio4_irqs,
	.main_clk	= "gpio4_ick",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_GPIO4_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_GPIO4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio4_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio4_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap44xx_gpio4_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_gpio4_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* gpio5 */
static struct omap_hwmod omap44xx_gpio5_hwmod;
static struct omap_hwmod_irq_info omap44xx_gpio5_irqs[] = {
	{ .irq = 33 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_gpio5_addrs[] = {
	{
		.pa_start	= 0x4805b000,
		.pa_end		= 0x4805b1ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> gpio5 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__gpio5 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_gpio5_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_gpio5_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio5 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_gpio5_slaves[] = {
	&omap44xx_l4_per__gpio5,
};

static struct omap_hwmod_opt_clk gpio5_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio5_dbclk" },
};

static struct omap_hwmod omap44xx_gpio5_hwmod = {
	.name		= "gpio5",
	.class		= &omap44xx_gpio_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.mpu_irqs	= omap44xx_gpio5_irqs,
	.main_clk	= "gpio5_ick",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_GPIO5_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_GPIO5_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio5_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio5_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap44xx_gpio5_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_gpio5_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* gpio6 */
static struct omap_hwmod omap44xx_gpio6_hwmod;
static struct omap_hwmod_irq_info omap44xx_gpio6_irqs[] = {
	{ .irq = 34 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_gpio6_addrs[] = {
	{
		.pa_start	= 0x4805d000,
		.pa_end		= 0x4805d1ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> gpio6 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__gpio6 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_gpio6_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_gpio6_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* gpio6 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_gpio6_slaves[] = {
	&omap44xx_l4_per__gpio6,
};

static struct omap_hwmod_opt_clk gpio6_opt_clks[] = {
	{ .role = "dbclk", .clk = "gpio6_dbclk" },
};

static struct omap_hwmod omap44xx_gpio6_hwmod = {
	.name		= "gpio6",
	.class		= &omap44xx_gpio_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.mpu_irqs	= omap44xx_gpio6_irqs,
	.main_clk	= "gpio6_ick",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_GPIO6_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_GPIO6_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= gpio6_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(gpio6_opt_clks),
	.dev_attr	= &gpio_dev_attr,
	.slaves		= omap44xx_gpio6_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_gpio6_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'hsi' class
 * mipi high-speed synchronous serial interface (multichannel and full-duplex
 * serial if)
 */

static struct omap_hwmod_class_sysconfig omap44xx_hsi_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_EMUFREE |
			   SYSC_HAS_MIDLEMODE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_hsi_hwmod_class = {
	.name	= "hsi",
	.sysc	= &omap44xx_hsi_sysc,
};

/* hsi */
static struct omap_hwmod_irq_info omap44xx_hsi_irqs[] = {
	{ .name = "mpu_p1", .irq = 67 + OMAP44XX_IRQ_GIC_START },
	{ .name = "mpu_p2", .irq = 68 + OMAP44XX_IRQ_GIC_START },
	{ .name = "mpu_dma", .irq = 71 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

/* hsi master ports */
static struct omap_hwmod_ocp_if *omap44xx_hsi_masters[] = {
	&omap44xx_hsi__l3_main_2,
};

static struct omap_hwmod_addr_space omap44xx_hsi_addrs[] = {
	{
		.pa_start	= 0x4a058000,
		.pa_end		= 0x4a05bfff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> hsi */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__hsi = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_hsi_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_hsi_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* hsi slave ports */
static struct omap_hwmod_ocp_if *omap44xx_hsi_slaves[] = {
	&omap44xx_l4_cfg__hsi,
};

static struct omap_hwmod omap44xx_hsi_hwmod = {
	.name		= "hsi",
	.class		= &omap44xx_hsi_hwmod_class,
	.clkdm_name	= "l3_init_clkdm",
	.mpu_irqs	= omap44xx_hsi_irqs,
	.main_clk	= "hsi_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L3INIT_HSI_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L3INIT_HSI_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.slaves		= omap44xx_hsi_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_hsi_slaves),
	.masters	= omap44xx_hsi_masters,
	.masters_cnt	= ARRAY_SIZE(omap44xx_hsi_masters),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'i2c' class
 * multimaster high-speed i2c controller
 */

static struct omap_hwmod_class_sysconfig omap44xx_i2c_sysc = {
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0090,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_i2c_hwmod_class = {
	.name	= "i2c",
	.sysc	= &omap44xx_i2c_sysc,
	.rev	= OMAP_I2C_IP_VERSION_2,
	.reset	= &omap_i2c_reset,
};

static struct omap_i2c_dev_attr i2c_dev_attr = {
	.flags	= OMAP_I2C_FLAG_BUS_SHIFT_NONE,
};

/* i2c1 */
static struct omap_hwmod omap44xx_i2c1_hwmod;
static struct omap_hwmod_irq_info omap44xx_i2c1_irqs[] = {
	{ .irq = 56 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_i2c1_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 26 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 27 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_i2c1_addrs[] = {
	{
		.pa_start	= 0x48070000,
		.pa_end		= 0x480700ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> i2c1 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__i2c1 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_i2c1_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_i2c1_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* i2c1 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_i2c1_slaves[] = {
	&omap44xx_l4_per__i2c1,
};

static struct omap_hwmod omap44xx_i2c1_hwmod = {
	.name		= "i2c1",
	.class		= &omap44xx_i2c_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.flags		= HWMOD_16BIT_REG,
	.mpu_irqs	= omap44xx_i2c1_irqs,
	.sdma_reqs	= omap44xx_i2c1_sdma_reqs,
	.main_clk	= "i2c1_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_I2C1_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_I2C1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_i2c1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_i2c1_slaves),
	.dev_attr	= &i2c_dev_attr,
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* i2c2 */
static struct omap_hwmod omap44xx_i2c2_hwmod;
static struct omap_hwmod_irq_info omap44xx_i2c2_irqs[] = {
	{ .irq = 57 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_i2c2_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 28 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 29 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_i2c2_addrs[] = {
	{
		.pa_start	= 0x48072000,
		.pa_end		= 0x480720ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> i2c2 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__i2c2 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_i2c2_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_i2c2_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* i2c2 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_i2c2_slaves[] = {
	&omap44xx_l4_per__i2c2,
};

static struct omap_hwmod omap44xx_i2c2_hwmod = {
	.name		= "i2c2",
	.class		= &omap44xx_i2c_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.flags		= HWMOD_16BIT_REG,
	.mpu_irqs	= omap44xx_i2c2_irqs,
	.sdma_reqs	= omap44xx_i2c2_sdma_reqs,
	.main_clk	= "i2c2_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_I2C2_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_I2C2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_i2c2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_i2c2_slaves),
	.dev_attr	= &i2c_dev_attr,
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* i2c3 */
static struct omap_hwmod omap44xx_i2c3_hwmod;
static struct omap_hwmod_irq_info omap44xx_i2c3_irqs[] = {
	{ .irq = 61 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_i2c3_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 24 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 25 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_i2c3_addrs[] = {
	{
		.pa_start	= 0x48060000,
		.pa_end		= 0x480600ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> i2c3 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__i2c3 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_i2c3_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_i2c3_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* i2c3 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_i2c3_slaves[] = {
	&omap44xx_l4_per__i2c3,
};

static struct omap_hwmod omap44xx_i2c3_hwmod = {
	.name		= "i2c3",
	.class		= &omap44xx_i2c_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.flags		= HWMOD_16BIT_REG,
	.mpu_irqs	= omap44xx_i2c3_irqs,
	.sdma_reqs	= omap44xx_i2c3_sdma_reqs,
	.main_clk	= "i2c3_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_I2C3_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_I2C3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_i2c3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_i2c3_slaves),
	.dev_attr	= &i2c_dev_attr,
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* i2c4 */
static struct omap_hwmod omap44xx_i2c4_hwmod;
static struct omap_hwmod_irq_info omap44xx_i2c4_irqs[] = {
	{ .irq = 62 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_i2c4_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 123 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 124 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_i2c4_addrs[] = {
	{
		.pa_start	= 0x48350000,
		.pa_end		= 0x483500ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> i2c4 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__i2c4 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_i2c4_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_i2c4_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* i2c4 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_i2c4_slaves[] = {
	&omap44xx_l4_per__i2c4,
};

static struct omap_hwmod omap44xx_i2c4_hwmod = {
	.name		= "i2c4",
	.class		= &omap44xx_i2c_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.flags		= HWMOD_16BIT_REG,
	.mpu_irqs	= omap44xx_i2c4_irqs,
	.sdma_reqs	= omap44xx_i2c4_sdma_reqs,
	.main_clk	= "i2c4_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_I2C4_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_I2C4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_i2c4_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_i2c4_slaves),
	.dev_attr	= &i2c_dev_attr,
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'ipu' class
 * imaging processor unit
 */

static struct omap_hwmod_class omap44xx_ipu_hwmod_class = {
	.name	= "ipu",
};

/* ipu */
static struct omap_hwmod_irq_info omap44xx_ipu_irqs[] = {
	{ .irq = 100 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_rst_info omap44xx_ipu_c0_resets[] = {
	{ .name = "cpu0", .rst_shift = 0 },
};

static struct omap_hwmod_rst_info omap44xx_ipu_c1_resets[] = {
	{ .name = "cpu1", .rst_shift = 1 },
};

static struct omap_hwmod_rst_info omap44xx_ipu_resets[] = {
	{ .name = "mmu_cache", .rst_shift = 2 },
};

/* ipu master ports */
static struct omap_hwmod_ocp_if *omap44xx_ipu_masters[] = {
	&omap44xx_ipu__l3_main_2,
};

/* l3_main_2 -> ipu */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__ipu = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_ipu_hwmod,
	.clk		= "l3_div_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* ipu slave ports */
static struct omap_hwmod_ocp_if *omap44xx_ipu_slaves[] = {
	&omap44xx_l3_main_2__ipu,
};

/* Pseudo hwmod for reset control purpose only */
static struct omap_hwmod omap44xx_ipu_c0_hwmod = {
	.name		= "ipu_c0",
	.class		= &omap44xx_ipu_hwmod_class,
	.clkdm_name	= "ducati_clkdm",
	.flags		= HWMOD_INIT_NO_RESET,
	.rst_lines	= omap44xx_ipu_c0_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap44xx_ipu_c0_resets),
	.prcm = {
		.omap4 = {
			.rstctrl_offs = OMAP4_RM_DUCATI_RSTCTRL_OFFSET,
		},
	},
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* Pseudo hwmod for reset control purpose only */
static struct omap_hwmod omap44xx_ipu_c1_hwmod = {
	.name		= "ipu_c1",
	.class		= &omap44xx_ipu_hwmod_class,
	.clkdm_name	= "ducati_clkdm",
	.flags		= HWMOD_INIT_NO_RESET,
	.rst_lines	= omap44xx_ipu_c1_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap44xx_ipu_c1_resets),
	.prcm = {
		.omap4 = {
			.rstctrl_offs = OMAP4_RM_DUCATI_RSTCTRL_OFFSET,
		},
	},
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct omap_hwmod omap44xx_ipu_hwmod = {
	.name		= "ipu",
	.class		= &omap44xx_ipu_hwmod_class,
	.clkdm_name	= "ducati_clkdm",
	.mpu_irqs	= omap44xx_ipu_irqs,
	.rst_lines	= omap44xx_ipu_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap44xx_ipu_resets),
	.main_clk	= "ipu_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_DUCATI_DUCATI_CLKCTRL_OFFSET,
			.rstctrl_offs = OMAP4_RM_DUCATI_RSTCTRL_OFFSET,
			.context_offs = OMAP4_RM_DUCATI_DUCATI_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.slaves		= omap44xx_ipu_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_ipu_slaves),
	.masters	= omap44xx_ipu_masters,
	.masters_cnt	= ARRAY_SIZE(omap44xx_ipu_masters),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'iss' class
 * external images sensor pixel data processor
 */

static struct omap_hwmod_class_sysconfig omap44xx_iss_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_MIDLEMODE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap44xx_iss_hwmod_class = {
	.name	= "iss",
	.sysc	= &omap44xx_iss_sysc,
};

/* iss */
static struct omap_hwmod_irq_info omap44xx_iss_irqs[] = {
	{ .irq = 24 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_iss_sdma_reqs[] = {
	{ .name = "1", .dma_req = 8 + OMAP44XX_DMA_REQ_START },
	{ .name = "2", .dma_req = 9 + OMAP44XX_DMA_REQ_START },
	{ .name = "3", .dma_req = 11 + OMAP44XX_DMA_REQ_START },
	{ .name = "4", .dma_req = 12 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

/* iss master ports */
static struct omap_hwmod_ocp_if *omap44xx_iss_masters[] = {
	&omap44xx_iss__l3_main_2,
};

static struct omap_hwmod_addr_space omap44xx_iss_addrs[] = {
	{
		.pa_start	= 0x52000000,
		.pa_end		= 0x520000ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> iss */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__iss = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_iss_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap44xx_iss_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* iss slave ports */
static struct omap_hwmod_ocp_if *omap44xx_iss_slaves[] = {
	&omap44xx_l3_main_2__iss,
};

static struct omap_hwmod_opt_clk iss_opt_clks[] = {
	{ .role = "ctrlclk", .clk = "iss_ctrlclk" },
};

static struct omap_hwmod omap44xx_iss_hwmod = {
	.name		= "iss",
	.class		= &omap44xx_iss_hwmod_class,
	.clkdm_name	= "iss_clkdm",
	.mpu_irqs	= omap44xx_iss_irqs,
	.sdma_reqs	= omap44xx_iss_sdma_reqs,
	.main_clk	= "iss_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_CAM_ISS_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_CAM_ISS_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= iss_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(iss_opt_clks),
	.slaves		= omap44xx_iss_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_iss_slaves),
	.masters	= omap44xx_iss_masters,
	.masters_cnt	= ARRAY_SIZE(omap44xx_iss_masters),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'iva' class
 * multi-standard video encoder/decoder hardware accelerator
 */

static struct omap_hwmod_class omap44xx_iva_hwmod_class = {
	.name	= "iva",
};

/* iva */
static struct omap_hwmod_irq_info omap44xx_iva_irqs[] = {
	{ .name = "sync_1", .irq = 103 + OMAP44XX_IRQ_GIC_START },
	{ .name = "sync_0", .irq = 104 + OMAP44XX_IRQ_GIC_START },
	{ .name = "mailbox_0", .irq = 107 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_rst_info omap44xx_iva_resets[] = {
	{ .name = "logic", .rst_shift = 2 },
};

static struct omap_hwmod_rst_info omap44xx_iva_seq0_resets[] = {
	{ .name = "seq0", .rst_shift = 0 },
};

static struct omap_hwmod_rst_info omap44xx_iva_seq1_resets[] = {
	{ .name = "seq1", .rst_shift = 1 },
};

/* iva master ports */
static struct omap_hwmod_ocp_if *omap44xx_iva_masters[] = {
	&omap44xx_iva__l3_main_2,
	&omap44xx_iva__l3_instr,
};

static struct omap_hwmod_addr_space omap44xx_iva_addrs[] = {
	{
		.pa_start	= 0x5a000000,
		.pa_end		= 0x5a07ffff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l3_main_2 -> iva */
static struct omap_hwmod_ocp_if omap44xx_l3_main_2__iva = {
	.master		= &omap44xx_l3_main_2_hwmod,
	.slave		= &omap44xx_iva_hwmod,
	.clk		= "l3_div_ck",
	.addr		= omap44xx_iva_addrs,
	.user		= OCP_USER_MPU,
};

/* iva slave ports */
static struct omap_hwmod_ocp_if *omap44xx_iva_slaves[] = {
	&omap44xx_dsp__iva,
	&omap44xx_l3_main_2__iva,
};

/* Pseudo hwmod for reset control purpose only */
static struct omap_hwmod omap44xx_iva_seq0_hwmod = {
	.name		= "iva_seq0",
	.class		= &omap44xx_iva_hwmod_class,
	.clkdm_name	= "ivahd_clkdm",
	.flags		= HWMOD_INIT_NO_RESET,
	.rst_lines	= omap44xx_iva_seq0_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap44xx_iva_seq0_resets),
	.prcm = {
		.omap4 = {
			.rstctrl_offs = OMAP4_RM_IVAHD_RSTCTRL_OFFSET,
		},
	},
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* Pseudo hwmod for reset control purpose only */
static struct omap_hwmod omap44xx_iva_seq1_hwmod = {
	.name		= "iva_seq1",
	.class		= &omap44xx_iva_hwmod_class,
	.clkdm_name	= "ivahd_clkdm",
	.flags		= HWMOD_INIT_NO_RESET,
	.rst_lines	= omap44xx_iva_seq1_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap44xx_iva_seq1_resets),
	.prcm = {
		.omap4 = {
			.rstctrl_offs = OMAP4_RM_IVAHD_RSTCTRL_OFFSET,
		},
	},
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static struct omap_hwmod omap44xx_iva_hwmod = {
	.name		= "iva",
	.class		= &omap44xx_iva_hwmod_class,
	.clkdm_name	= "ivahd_clkdm",
	.mpu_irqs	= omap44xx_iva_irqs,
	.rst_lines	= omap44xx_iva_resets,
	.rst_lines_cnt	= ARRAY_SIZE(omap44xx_iva_resets),
	.main_clk	= "iva_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_IVAHD_IVAHD_CLKCTRL_OFFSET,
			.rstctrl_offs = OMAP4_RM_IVAHD_RSTCTRL_OFFSET,
			.context_offs = OMAP4_RM_IVAHD_IVAHD_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.slaves		= omap44xx_iva_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_iva_slaves),
	.masters	= omap44xx_iva_masters,
	.masters_cnt	= ARRAY_SIZE(omap44xx_iva_masters),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'kbd' class
 * keyboard controller
 */

static struct omap_hwmod_class_sysconfig omap44xx_kbd_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_EMUFREE | SYSC_HAS_ENAWAKEUP |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_kbd_hwmod_class = {
	.name	= "kbd",
	.sysc	= &omap44xx_kbd_sysc,
};

/* kbd */
static struct omap_hwmod omap44xx_kbd_hwmod;
static struct omap_hwmod_irq_info omap44xx_kbd_irqs[] = {
	{ .irq = 120 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_kbd_addrs[] = {
	{
		.pa_start	= 0x4a31c000,
		.pa_end		= 0x4a31c07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_wkup -> kbd */
static struct omap_hwmod_ocp_if omap44xx_l4_wkup__kbd = {
	.master		= &omap44xx_l4_wkup_hwmod,
	.slave		= &omap44xx_kbd_hwmod,
	.clk		= "l4_wkup_clk_mux_ck",
	.addr		= omap44xx_kbd_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* kbd slave ports */
static struct omap_hwmod_ocp_if *omap44xx_kbd_slaves[] = {
	&omap44xx_l4_wkup__kbd,
};

static struct omap_hwmod omap44xx_kbd_hwmod = {
	.name		= "kbd",
	.class		= &omap44xx_kbd_hwmod_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.mpu_irqs	= omap44xx_kbd_irqs,
	.main_clk	= "kbd_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_WKUP_KEYBOARD_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_WKUP_KEYBOARD_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_kbd_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_kbd_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'mailbox' class
 * mailbox module allowing communication between the on-chip processors using a
 * queued mailbox-interrupt mechanism.
 */

static struct omap_hwmod_class_sysconfig omap44xx_mailbox_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_RESET_STATUS | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap44xx_mailbox_hwmod_class = {
	.name	= "mailbox",
	.sysc	= &omap44xx_mailbox_sysc,
};

/* mailbox */
static struct omap_hwmod omap44xx_mailbox_hwmod;
static struct omap_hwmod_irq_info omap44xx_mailbox_irqs[] = {
	{ .irq = 26 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_mailbox_addrs[] = {
	{
		.pa_start	= 0x4a0f4000,
		.pa_end		= 0x4a0f41ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> mailbox */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__mailbox = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_mailbox_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_mailbox_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mailbox slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mailbox_slaves[] = {
	&omap44xx_l4_cfg__mailbox,
};

static struct omap_hwmod omap44xx_mailbox_hwmod = {
	.name		= "mailbox",
	.class		= &omap44xx_mailbox_hwmod_class,
	.clkdm_name	= "l4_cfg_clkdm",
	.mpu_irqs	= omap44xx_mailbox_irqs,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4CFG_MAILBOX_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4CFG_MAILBOX_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap44xx_mailbox_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mailbox_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'mcbsp' class
 * multi channel buffered serial port controller
 */

static struct omap_hwmod_class_sysconfig omap44xx_mcbsp_sysc = {
	.sysc_offs	= 0x008c,
	.sysc_flags	= (SYSC_HAS_CLOCKACTIVITY | SYSC_HAS_ENAWAKEUP |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_mcbsp_hwmod_class = {
	.name	= "mcbsp",
	.sysc	= &omap44xx_mcbsp_sysc,
	.rev	= MCBSP_CONFIG_TYPE4,
};

/* mcbsp1 */
static struct omap_hwmod omap44xx_mcbsp1_hwmod;
static struct omap_hwmod_irq_info omap44xx_mcbsp1_irqs[] = {
	{ .irq = 17 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_mcbsp1_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 32 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 33 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_mcbsp1_addrs[] = {
	{
		.name		= "mpu",
		.pa_start	= 0x40122000,
		.pa_end		= 0x401220ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> mcbsp1 */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__mcbsp1 = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_mcbsp1_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_mcbsp1_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap44xx_mcbsp1_dma_addrs[] = {
	{
		.name		= "dma",
		.pa_start	= 0x49022000,
		.pa_end		= 0x490220ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> mcbsp1 (dma) */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__mcbsp1_dma = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_mcbsp1_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_mcbsp1_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* mcbsp1 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mcbsp1_slaves[] = {
	&omap44xx_l4_abe__mcbsp1,
	&omap44xx_l4_abe__mcbsp1_dma,
};

static struct omap_hwmod omap44xx_mcbsp1_hwmod = {
	.name		= "mcbsp1",
	.class		= &omap44xx_mcbsp_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap44xx_mcbsp1_irqs,
	.sdma_reqs	= omap44xx_mcbsp1_sdma_reqs,
	.main_clk	= "mcbsp1_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM1_ABE_MCBSP1_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_ABE_MCBSP1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_mcbsp1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mcbsp1_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* mcbsp2 */
static struct omap_hwmod omap44xx_mcbsp2_hwmod;
static struct omap_hwmod_irq_info omap44xx_mcbsp2_irqs[] = {
	{ .irq = 22 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_mcbsp2_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 16 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 17 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_mcbsp2_addrs[] = {
	{
		.name		= "mpu",
		.pa_start	= 0x40124000,
		.pa_end		= 0x401240ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> mcbsp2 */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__mcbsp2 = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_mcbsp2_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_mcbsp2_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap44xx_mcbsp2_dma_addrs[] = {
	{
		.name		= "dma",
		.pa_start	= 0x49024000,
		.pa_end		= 0x490240ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> mcbsp2 (dma) */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__mcbsp2_dma = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_mcbsp2_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_mcbsp2_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* mcbsp2 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mcbsp2_slaves[] = {
	&omap44xx_l4_abe__mcbsp2,
	&omap44xx_l4_abe__mcbsp2_dma,
};

static struct omap_hwmod omap44xx_mcbsp2_hwmod = {
	.name		= "mcbsp2",
	.class		= &omap44xx_mcbsp_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap44xx_mcbsp2_irqs,
	.sdma_reqs	= omap44xx_mcbsp2_sdma_reqs,
	.main_clk	= "mcbsp2_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM1_ABE_MCBSP2_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_ABE_MCBSP2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_mcbsp2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mcbsp2_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* mcbsp3 */
static struct omap_hwmod omap44xx_mcbsp3_hwmod;
static struct omap_hwmod_irq_info omap44xx_mcbsp3_irqs[] = {
	{ .irq = 23 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_mcbsp3_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 18 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 19 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_mcbsp3_addrs[] = {
	{
		.name		= "mpu",
		.pa_start	= 0x40126000,
		.pa_end		= 0x401260ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> mcbsp3 */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__mcbsp3 = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_mcbsp3_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_mcbsp3_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap44xx_mcbsp3_dma_addrs[] = {
	{
		.name		= "dma",
		.pa_start	= 0x49026000,
		.pa_end		= 0x490260ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> mcbsp3 (dma) */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__mcbsp3_dma = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_mcbsp3_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_mcbsp3_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* mcbsp3 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mcbsp3_slaves[] = {
	&omap44xx_l4_abe__mcbsp3,
	&omap44xx_l4_abe__mcbsp3_dma,
};

static struct omap_hwmod omap44xx_mcbsp3_hwmod = {
	.name		= "mcbsp3",
	.class		= &omap44xx_mcbsp_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap44xx_mcbsp3_irqs,
	.sdma_reqs	= omap44xx_mcbsp3_sdma_reqs,
	.main_clk	= "mcbsp3_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM1_ABE_MCBSP3_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_ABE_MCBSP3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_mcbsp3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mcbsp3_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* mcbsp4 */
static struct omap_hwmod omap44xx_mcbsp4_hwmod;
static struct omap_hwmod_irq_info omap44xx_mcbsp4_irqs[] = {
	{ .irq = 16 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_mcbsp4_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 30 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 31 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_mcbsp4_addrs[] = {
	{
		.pa_start	= 0x48096000,
		.pa_end		= 0x480960ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mcbsp4 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__mcbsp4 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_mcbsp4_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_mcbsp4_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mcbsp4 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mcbsp4_slaves[] = {
	&omap44xx_l4_per__mcbsp4,
};

static struct omap_hwmod omap44xx_mcbsp4_hwmod = {
	.name		= "mcbsp4",
	.class		= &omap44xx_mcbsp_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_mcbsp4_irqs,
	.sdma_reqs	= omap44xx_mcbsp4_sdma_reqs,
	.main_clk	= "mcbsp4_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_MCBSP4_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_MCBSP4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_mcbsp4_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mcbsp4_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'mcpdm' class
 * multi channel pdm controller (proprietary interface with phoenix power
 * ic)
 */

static struct omap_hwmod_class_sysconfig omap44xx_mcpdm_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap44xx_mcpdm_hwmod_class = {
	.name	= "mcpdm",
	.sysc	= &omap44xx_mcpdm_sysc,
};

/* mcpdm */
static struct omap_hwmod omap44xx_mcpdm_hwmod;
static struct omap_hwmod_irq_info omap44xx_mcpdm_irqs[] = {
	{ .irq = 112 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_mcpdm_sdma_reqs[] = {
	{ .name = "up_link", .dma_req = 64 + OMAP44XX_DMA_REQ_START },
	{ .name = "dn_link", .dma_req = 65 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_mcpdm_addrs[] = {
	{
		.pa_start	= 0x40132000,
		.pa_end		= 0x4013207f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> mcpdm */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__mcpdm = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_mcpdm_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_mcpdm_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap44xx_mcpdm_dma_addrs[] = {
	{
		.pa_start	= 0x49032000,
		.pa_end		= 0x4903207f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> mcpdm (dma) */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__mcpdm_dma = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_mcpdm_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_mcpdm_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* mcpdm slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mcpdm_slaves[] = {
	&omap44xx_l4_abe__mcpdm,
	&omap44xx_l4_abe__mcpdm_dma,
};

static struct omap_hwmod omap44xx_mcpdm_hwmod = {
	.name		= "mcpdm",
	.class		= &omap44xx_mcpdm_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap44xx_mcpdm_irqs,
	.sdma_reqs	= omap44xx_mcpdm_sdma_reqs,
	.main_clk	= "mcpdm_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM1_ABE_PDM_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_ABE_PDM_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_mcpdm_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mcpdm_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'mcspi' class
 * multichannel serial port interface (mcspi) / master/slave synchronous serial
 * bus
 */

static struct omap_hwmod_class_sysconfig omap44xx_mcspi_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap44xx_mcspi_hwmod_class = {
	.name	= "mcspi",
	.sysc	= &omap44xx_mcspi_sysc,
	.rev	= OMAP4_MCSPI_REV,
};

/* mcspi1 */
static struct omap_hwmod omap44xx_mcspi1_hwmod;
static struct omap_hwmod_irq_info omap44xx_mcspi1_irqs[] = {
	{ .irq = 65 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_mcspi1_sdma_reqs[] = {
	{ .name = "tx0", .dma_req = 34 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx0", .dma_req = 35 + OMAP44XX_DMA_REQ_START },
	{ .name = "tx1", .dma_req = 36 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx1", .dma_req = 37 + OMAP44XX_DMA_REQ_START },
	{ .name = "tx2", .dma_req = 38 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx2", .dma_req = 39 + OMAP44XX_DMA_REQ_START },
	{ .name = "tx3", .dma_req = 40 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx3", .dma_req = 41 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_mcspi1_addrs[] = {
	{
		.pa_start	= 0x48098000,
		.pa_end		= 0x480981ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mcspi1 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__mcspi1 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_mcspi1_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_mcspi1_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mcspi1 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mcspi1_slaves[] = {
	&omap44xx_l4_per__mcspi1,
};

/* mcspi1 dev_attr */
static struct omap2_mcspi_dev_attr mcspi1_dev_attr = {
	.num_chipselect	= 4,
};

static struct omap_hwmod omap44xx_mcspi1_hwmod = {
	.name		= "mcspi1",
	.class		= &omap44xx_mcspi_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_mcspi1_irqs,
	.sdma_reqs	= omap44xx_mcspi1_sdma_reqs,
	.main_clk	= "mcspi1_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_MCSPI1_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_MCSPI1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &mcspi1_dev_attr,
	.slaves		= omap44xx_mcspi1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mcspi1_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* mcspi2 */
static struct omap_hwmod omap44xx_mcspi2_hwmod;
static struct omap_hwmod_irq_info omap44xx_mcspi2_irqs[] = {
	{ .irq = 66 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_mcspi2_sdma_reqs[] = {
	{ .name = "tx0", .dma_req = 42 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx0", .dma_req = 43 + OMAP44XX_DMA_REQ_START },
	{ .name = "tx1", .dma_req = 44 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx1", .dma_req = 45 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_mcspi2_addrs[] = {
	{
		.pa_start	= 0x4809a000,
		.pa_end		= 0x4809a1ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mcspi2 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__mcspi2 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_mcspi2_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_mcspi2_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mcspi2 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mcspi2_slaves[] = {
	&omap44xx_l4_per__mcspi2,
};

/* mcspi2 dev_attr */
static struct omap2_mcspi_dev_attr mcspi2_dev_attr = {
	.num_chipselect	= 2,
};

static struct omap_hwmod omap44xx_mcspi2_hwmod = {
	.name		= "mcspi2",
	.class		= &omap44xx_mcspi_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_mcspi2_irqs,
	.sdma_reqs	= omap44xx_mcspi2_sdma_reqs,
	.main_clk	= "mcspi2_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_MCSPI2_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_MCSPI2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &mcspi2_dev_attr,
	.slaves		= omap44xx_mcspi2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mcspi2_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* mcspi3 */
static struct omap_hwmod omap44xx_mcspi3_hwmod;
static struct omap_hwmod_irq_info omap44xx_mcspi3_irqs[] = {
	{ .irq = 91 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_mcspi3_sdma_reqs[] = {
	{ .name = "tx0", .dma_req = 14 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx0", .dma_req = 15 + OMAP44XX_DMA_REQ_START },
	{ .name = "tx1", .dma_req = 22 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx1", .dma_req = 23 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_mcspi3_addrs[] = {
	{
		.pa_start	= 0x480b8000,
		.pa_end		= 0x480b81ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mcspi3 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__mcspi3 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_mcspi3_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_mcspi3_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mcspi3 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mcspi3_slaves[] = {
	&omap44xx_l4_per__mcspi3,
};

/* mcspi3 dev_attr */
static struct omap2_mcspi_dev_attr mcspi3_dev_attr = {
	.num_chipselect	= 2,
};

static struct omap_hwmod omap44xx_mcspi3_hwmod = {
	.name		= "mcspi3",
	.class		= &omap44xx_mcspi_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_mcspi3_irqs,
	.sdma_reqs	= omap44xx_mcspi3_sdma_reqs,
	.main_clk	= "mcspi3_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_MCSPI3_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_MCSPI3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &mcspi3_dev_attr,
	.slaves		= omap44xx_mcspi3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mcspi3_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* mcspi4 */
static struct omap_hwmod omap44xx_mcspi4_hwmod;
static struct omap_hwmod_irq_info omap44xx_mcspi4_irqs[] = {
	{ .irq = 48 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_mcspi4_sdma_reqs[] = {
	{ .name = "tx0", .dma_req = 69 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx0", .dma_req = 70 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_mcspi4_addrs[] = {
	{
		.pa_start	= 0x480ba000,
		.pa_end		= 0x480ba1ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mcspi4 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__mcspi4 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_mcspi4_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_mcspi4_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mcspi4 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mcspi4_slaves[] = {
	&omap44xx_l4_per__mcspi4,
};

/* mcspi4 dev_attr */
static struct omap2_mcspi_dev_attr mcspi4_dev_attr = {
	.num_chipselect	= 1,
};

static struct omap_hwmod omap44xx_mcspi4_hwmod = {
	.name		= "mcspi4",
	.class		= &omap44xx_mcspi_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_mcspi4_irqs,
	.sdma_reqs	= omap44xx_mcspi4_sdma_reqs,
	.main_clk	= "mcspi4_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_MCSPI4_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_MCSPI4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &mcspi4_dev_attr,
	.slaves		= omap44xx_mcspi4_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mcspi4_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'mmc' class
 * multimedia card high-speed/sd/sdio (mmc/sd/sdio) host controller
 */

static struct omap_hwmod_class_sysconfig omap44xx_mmc_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_MIDLEMODE |
			   SYSC_HAS_RESET_STATUS | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap44xx_mmc_hwmod_class = {
	.name	= "mmc",
	.sysc	= &omap44xx_mmc_sysc,
};

/* mmc1 */
static struct omap_hwmod_irq_info omap44xx_mmc1_irqs[] = {
	{ .irq = 83 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_mmc1_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 60 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 61 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

/* mmc1 master ports */
static struct omap_hwmod_ocp_if *omap44xx_mmc1_masters[] = {
	&omap44xx_mmc1__l3_main_1,
};

static struct omap_hwmod_addr_space omap44xx_mmc1_addrs[] = {
	{
		.pa_start	= 0x4809c000,
		.pa_end		= 0x4809c3ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mmc1 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__mmc1 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_mmc1_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_mmc1_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mmc1 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mmc1_slaves[] = {
	&omap44xx_l4_per__mmc1,
};

/* mmc1 dev_attr */
static struct omap_mmc_dev_attr mmc1_dev_attr = {
	.flags	= OMAP_HSMMC_SUPPORTS_DUAL_VOLT,
};

static struct omap_hwmod omap44xx_mmc1_hwmod = {
	.name		= "mmc1",
	.class		= &omap44xx_mmc_hwmod_class,
	.clkdm_name	= "l3_init_clkdm",
	.mpu_irqs	= omap44xx_mmc1_irqs,
	.sdma_reqs	= omap44xx_mmc1_sdma_reqs,
	.main_clk	= "mmc1_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L3INIT_MMC1_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L3INIT_MMC1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &mmc1_dev_attr,
	.slaves		= omap44xx_mmc1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mmc1_slaves),
	.masters	= omap44xx_mmc1_masters,
	.masters_cnt	= ARRAY_SIZE(omap44xx_mmc1_masters),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* mmc2 */
static struct omap_hwmod_irq_info omap44xx_mmc2_irqs[] = {
	{ .irq = 86 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_mmc2_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 46 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 47 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

/* mmc2 master ports */
static struct omap_hwmod_ocp_if *omap44xx_mmc2_masters[] = {
	&omap44xx_mmc2__l3_main_1,
};

static struct omap_hwmod_addr_space omap44xx_mmc2_addrs[] = {
	{
		.pa_start	= 0x480b4000,
		.pa_end		= 0x480b43ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mmc2 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__mmc2 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_mmc2_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_mmc2_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mmc2 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mmc2_slaves[] = {
	&omap44xx_l4_per__mmc2,
};

static struct omap_hwmod omap44xx_mmc2_hwmod = {
	.name		= "mmc2",
	.class		= &omap44xx_mmc_hwmod_class,
	.clkdm_name	= "l3_init_clkdm",
	.mpu_irqs	= omap44xx_mmc2_irqs,
	.sdma_reqs	= omap44xx_mmc2_sdma_reqs,
	.main_clk	= "mmc2_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L3INIT_MMC2_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L3INIT_MMC2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_mmc2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mmc2_slaves),
	.masters	= omap44xx_mmc2_masters,
	.masters_cnt	= ARRAY_SIZE(omap44xx_mmc2_masters),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* mmc3 */
static struct omap_hwmod omap44xx_mmc3_hwmod;
static struct omap_hwmod_irq_info omap44xx_mmc3_irqs[] = {
	{ .irq = 94 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_mmc3_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 76 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 77 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_mmc3_addrs[] = {
	{
		.pa_start	= 0x480ad000,
		.pa_end		= 0x480ad3ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mmc3 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__mmc3 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_mmc3_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_mmc3_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mmc3 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mmc3_slaves[] = {
	&omap44xx_l4_per__mmc3,
};

static struct omap_hwmod omap44xx_mmc3_hwmod = {
	.name		= "mmc3",
	.class		= &omap44xx_mmc_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_mmc3_irqs,
	.sdma_reqs	= omap44xx_mmc3_sdma_reqs,
	.main_clk	= "mmc3_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_MMCSD3_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_MMCSD3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_mmc3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mmc3_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* mmc4 */
static struct omap_hwmod omap44xx_mmc4_hwmod;
static struct omap_hwmod_irq_info omap44xx_mmc4_irqs[] = {
	{ .irq = 96 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_mmc4_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 56 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 57 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_mmc4_addrs[] = {
	{
		.pa_start	= 0x480d1000,
		.pa_end		= 0x480d13ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mmc4 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__mmc4 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_mmc4_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_mmc4_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mmc4 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mmc4_slaves[] = {
	&omap44xx_l4_per__mmc4,
};

static struct omap_hwmod omap44xx_mmc4_hwmod = {
	.name		= "mmc4",
	.class		= &omap44xx_mmc_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_mmc4_irqs,

	.sdma_reqs	= omap44xx_mmc4_sdma_reqs,
	.main_clk	= "mmc4_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_MMCSD4_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_MMCSD4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_mmc4_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mmc4_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* mmc5 */
static struct omap_hwmod omap44xx_mmc5_hwmod;
static struct omap_hwmod_irq_info omap44xx_mmc5_irqs[] = {
	{ .irq = 59 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_mmc5_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 58 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 59 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_mmc5_addrs[] = {
	{
		.pa_start	= 0x480d5000,
		.pa_end		= 0x480d53ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> mmc5 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__mmc5 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_mmc5_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_mmc5_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mmc5 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_mmc5_slaves[] = {
	&omap44xx_l4_per__mmc5,
};

static struct omap_hwmod omap44xx_mmc5_hwmod = {
	.name		= "mmc5",
	.class		= &omap44xx_mmc_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_mmc5_irqs,
	.sdma_reqs	= omap44xx_mmc5_sdma_reqs,
	.main_clk	= "mmc5_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_MMCSD5_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_MMCSD5_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_mmc5_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_mmc5_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'mpu' class
 * mpu sub-system
 */

static struct omap_hwmod_class omap44xx_mpu_hwmod_class = {
	.name	= "mpu",
};

/* mpu */
static struct omap_hwmod_irq_info omap44xx_mpu_irqs[] = {
	{ .name = "pl310", .irq = 0 + OMAP44XX_IRQ_GIC_START },
	{ .name = "cti0", .irq = 1 + OMAP44XX_IRQ_GIC_START },
	{ .name = "cti1", .irq = 2 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

/* mpu master ports */
static struct omap_hwmod_ocp_if *omap44xx_mpu_masters[] = {
	&omap44xx_mpu__l3_main_1,
	&omap44xx_mpu__l4_abe,
	&omap44xx_mpu__dmm,
};

static struct omap_hwmod omap44xx_mpu_hwmod = {
	.name		= "mpu",
	.class		= &omap44xx_mpu_hwmod_class,
	.clkdm_name	= "mpuss_clkdm",
	.flags		= HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET,
	.mpu_irqs	= omap44xx_mpu_irqs,
	.main_clk	= "dpll_mpu_m2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_MPU_MPU_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_MPU_MPU_CONTEXT_OFFSET,
		},
	},
	.masters	= omap44xx_mpu_masters,
	.masters_cnt	= ARRAY_SIZE(omap44xx_mpu_masters),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'smartreflex' class
 * smartreflex module (monitor silicon performance and outputs a measure of
 * performance error)
 */

/* The IP is not compliant to type1 / type2 scheme */
static struct omap_hwmod_sysc_fields omap_hwmod_sysc_type_smartreflex = {
	.sidle_shift	= 24,
	.enwkup_shift	= 26,
};

static struct omap_hwmod_class_sysconfig omap44xx_smartreflex_sysc = {
	.sysc_offs	= 0x0038,
	.sysc_flags	= (SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type_smartreflex,
};

static struct omap_hwmod_class omap44xx_smartreflex_hwmod_class = {
	.name	= "smartreflex",
	.sysc	= &omap44xx_smartreflex_sysc,
	.rev	= 2,
};

/* smartreflex_core */
static struct omap_hwmod omap44xx_smartreflex_core_hwmod;
static struct omap_hwmod_irq_info omap44xx_smartreflex_core_irqs[] = {
	{ .irq = 19 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_smartreflex_core_addrs[] = {
	{
		.pa_start	= 0x4a0dd000,
		.pa_end		= 0x4a0dd03f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> smartreflex_core */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__smartreflex_core = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_smartreflex_core_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_smartreflex_core_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* smartreflex_core slave ports */
static struct omap_hwmod_ocp_if *omap44xx_smartreflex_core_slaves[] = {
	&omap44xx_l4_cfg__smartreflex_core,
};

static struct omap_hwmod omap44xx_smartreflex_core_hwmod = {
	.name		= "smartreflex_core",
	.class		= &omap44xx_smartreflex_hwmod_class,
	.clkdm_name	= "l4_ao_clkdm",
	.mpu_irqs	= omap44xx_smartreflex_core_irqs,

	.main_clk	= "smartreflex_core_fck",
	.vdd_name	= "core",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_ALWON_SR_CORE_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_ALWON_SR_CORE_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_smartreflex_core_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_smartreflex_core_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* smartreflex_iva */
static struct omap_hwmod omap44xx_smartreflex_iva_hwmod;
static struct omap_hwmod_irq_info omap44xx_smartreflex_iva_irqs[] = {
	{ .irq = 102 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_smartreflex_iva_addrs[] = {
	{
		.pa_start	= 0x4a0db000,
		.pa_end		= 0x4a0db03f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> smartreflex_iva */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__smartreflex_iva = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_smartreflex_iva_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_smartreflex_iva_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* smartreflex_iva slave ports */
static struct omap_hwmod_ocp_if *omap44xx_smartreflex_iva_slaves[] = {
	&omap44xx_l4_cfg__smartreflex_iva,
};

static struct omap_hwmod omap44xx_smartreflex_iva_hwmod = {
	.name		= "smartreflex_iva",
	.class		= &omap44xx_smartreflex_hwmod_class,
	.clkdm_name	= "l4_ao_clkdm",
	.mpu_irqs	= omap44xx_smartreflex_iva_irqs,
	.main_clk	= "smartreflex_iva_fck",
	.vdd_name	= "iva",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_ALWON_SR_IVA_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_ALWON_SR_IVA_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_smartreflex_iva_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_smartreflex_iva_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* smartreflex_mpu */
static struct omap_hwmod omap44xx_smartreflex_mpu_hwmod;
static struct omap_hwmod_irq_info omap44xx_smartreflex_mpu_irqs[] = {
	{ .irq = 18 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_smartreflex_mpu_addrs[] = {
	{
		.pa_start	= 0x4a0d9000,
		.pa_end		= 0x4a0d903f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> smartreflex_mpu */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__smartreflex_mpu = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_smartreflex_mpu_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_smartreflex_mpu_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* smartreflex_mpu slave ports */
static struct omap_hwmod_ocp_if *omap44xx_smartreflex_mpu_slaves[] = {
	&omap44xx_l4_cfg__smartreflex_mpu,
};

static struct omap_hwmod omap44xx_smartreflex_mpu_hwmod = {
	.name		= "smartreflex_mpu",
	.class		= &omap44xx_smartreflex_hwmod_class,
	.clkdm_name	= "l4_ao_clkdm",
	.mpu_irqs	= omap44xx_smartreflex_mpu_irqs,
	.main_clk	= "smartreflex_mpu_fck",
	.vdd_name	= "mpu",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_ALWON_SR_MPU_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_ALWON_SR_MPU_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_smartreflex_mpu_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_smartreflex_mpu_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'spinlock' class
 * spinlock provides hardware assistance for synchronizing the processes
 * running on multiple processors
 */

static struct omap_hwmod_class_sysconfig omap44xx_spinlock_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_spinlock_hwmod_class = {
	.name	= "spinlock",
	.sysc	= &omap44xx_spinlock_sysc,
};

/* spinlock */
static struct omap_hwmod omap44xx_spinlock_hwmod;
static struct omap_hwmod_addr_space omap44xx_spinlock_addrs[] = {
	{
		.pa_start	= 0x4a0f6000,
		.pa_end		= 0x4a0f6fff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> spinlock */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__spinlock = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_spinlock_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_spinlock_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* spinlock slave ports */
static struct omap_hwmod_ocp_if *omap44xx_spinlock_slaves[] = {
	&omap44xx_l4_cfg__spinlock,
};

static struct omap_hwmod omap44xx_spinlock_hwmod = {
	.name		= "spinlock",
	.class		= &omap44xx_spinlock_hwmod_class,
	.clkdm_name	= "l4_cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4CFG_HW_SEM_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4CFG_HW_SEM_CONTEXT_OFFSET,
		},
	},
	.slaves		= omap44xx_spinlock_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_spinlock_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'timer' class
 * general purpose timer module with accurate 1ms tick
 * This class contains several variants: ['timer_1ms', 'timer']
 */

static struct omap_hwmod_class_sysconfig omap44xx_timer_1ms_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_EMUFREE | SYSC_HAS_ENAWAKEUP |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_timer_1ms_hwmod_class = {
	.name	= "timer",
	.sysc	= &omap44xx_timer_1ms_sysc,
};

static struct omap_hwmod_class_sysconfig omap44xx_timer_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap44xx_timer_hwmod_class = {
	.name	= "timer",
	.sysc	= &omap44xx_timer_sysc,
};

/* timer1 */
static struct omap_hwmod omap44xx_timer1_hwmod;
static struct omap_hwmod_irq_info omap44xx_timer1_irqs[] = {
	{ .irq = 37 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_timer1_addrs[] = {
	{
		.pa_start	= 0x4a318000,
		.pa_end		= 0x4a31807f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_wkup -> timer1 */
static struct omap_hwmod_ocp_if omap44xx_l4_wkup__timer1 = {
	.master		= &omap44xx_l4_wkup_hwmod,
	.slave		= &omap44xx_timer1_hwmod,
	.clk		= "l4_wkup_clk_mux_ck",
	.addr		= omap44xx_timer1_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* timer1 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_timer1_slaves[] = {
	&omap44xx_l4_wkup__timer1,
};

static struct omap_hwmod omap44xx_timer1_hwmod = {
	.name		= "timer1",
	.class		= &omap44xx_timer_1ms_hwmod_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.mpu_irqs	= omap44xx_timer1_irqs,
	.main_clk	= "timer1_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_WKUP_TIMER1_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_WKUP_TIMER1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_timer1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_timer1_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* timer2 */
static struct omap_hwmod omap44xx_timer2_hwmod;
static struct omap_hwmod_irq_info omap44xx_timer2_irqs[] = {
	{ .irq = 38 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_timer2_addrs[] = {
	{
		.pa_start	= 0x48032000,
		.pa_end		= 0x4803207f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> timer2 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__timer2 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_timer2_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_timer2_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* timer2 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_timer2_slaves[] = {
	&omap44xx_l4_per__timer2,
};

static struct omap_hwmod omap44xx_timer2_hwmod = {
	.name		= "timer2",
	.class		= &omap44xx_timer_1ms_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_timer2_irqs,
	.main_clk	= "timer2_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_DMTIMER2_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_DMTIMER2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_timer2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_timer2_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* timer3 */
static struct omap_hwmod omap44xx_timer3_hwmod;
static struct omap_hwmod_irq_info omap44xx_timer3_irqs[] = {
	{ .irq = 39 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_timer3_addrs[] = {
	{
		.pa_start	= 0x48034000,
		.pa_end		= 0x4803407f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> timer3 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__timer3 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_timer3_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_timer3_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* timer3 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_timer3_slaves[] = {
	&omap44xx_l4_per__timer3,
};

static struct omap_hwmod omap44xx_timer3_hwmod = {
	.name		= "timer3",
	.class		= &omap44xx_timer_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_timer3_irqs,
	.main_clk	= "timer3_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_DMTIMER3_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_DMTIMER3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_timer3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_timer3_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* timer4 */
static struct omap_hwmod omap44xx_timer4_hwmod;
static struct omap_hwmod_irq_info omap44xx_timer4_irqs[] = {
	{ .irq = 40 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_timer4_addrs[] = {
	{
		.pa_start	= 0x48036000,
		.pa_end		= 0x4803607f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> timer4 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__timer4 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_timer4_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_timer4_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* timer4 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_timer4_slaves[] = {
	&omap44xx_l4_per__timer4,
};

static struct omap_hwmod omap44xx_timer4_hwmod = {
	.name		= "timer4",
	.class		= &omap44xx_timer_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_timer4_irqs,
	.main_clk	= "timer4_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_DMTIMER4_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_DMTIMER4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_timer4_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_timer4_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* timer5 */
static struct omap_hwmod omap44xx_timer5_hwmod;
static struct omap_hwmod_irq_info omap44xx_timer5_irqs[] = {
	{ .irq = 41 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_timer5_addrs[] = {
	{
		.pa_start	= 0x40138000,
		.pa_end		= 0x4013807f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> timer5 */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__timer5 = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_timer5_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_timer5_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap44xx_timer5_dma_addrs[] = {
	{
		.pa_start	= 0x49038000,
		.pa_end		= 0x4903807f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> timer5 (dma) */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__timer5_dma = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_timer5_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_timer5_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* timer5 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_timer5_slaves[] = {
	&omap44xx_l4_abe__timer5,
	&omap44xx_l4_abe__timer5_dma,
};

static struct omap_hwmod omap44xx_timer5_hwmod = {
	.name		= "timer5",
	.class		= &omap44xx_timer_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap44xx_timer5_irqs,
	.main_clk	= "timer5_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM1_ABE_TIMER5_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_ABE_TIMER5_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_timer5_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_timer5_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* timer6 */
static struct omap_hwmod omap44xx_timer6_hwmod;
static struct omap_hwmod_irq_info omap44xx_timer6_irqs[] = {
	{ .irq = 42 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_timer6_addrs[] = {
	{
		.pa_start	= 0x4013a000,
		.pa_end		= 0x4013a07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> timer6 */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__timer6 = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_timer6_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_timer6_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap44xx_timer6_dma_addrs[] = {
	{
		.pa_start	= 0x4903a000,
		.pa_end		= 0x4903a07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> timer6 (dma) */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__timer6_dma = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_timer6_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_timer6_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* timer6 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_timer6_slaves[] = {
	&omap44xx_l4_abe__timer6,
	&omap44xx_l4_abe__timer6_dma,
};

static struct omap_hwmod omap44xx_timer6_hwmod = {
	.name		= "timer6",
	.class		= &omap44xx_timer_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap44xx_timer6_irqs,

	.main_clk	= "timer6_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM1_ABE_TIMER6_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_ABE_TIMER6_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_timer6_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_timer6_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* timer7 */
static struct omap_hwmod omap44xx_timer7_hwmod;
static struct omap_hwmod_irq_info omap44xx_timer7_irqs[] = {
	{ .irq = 43 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_timer7_addrs[] = {
	{
		.pa_start	= 0x4013c000,
		.pa_end		= 0x4013c07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> timer7 */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__timer7 = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_timer7_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_timer7_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap44xx_timer7_dma_addrs[] = {
	{
		.pa_start	= 0x4903c000,
		.pa_end		= 0x4903c07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> timer7 (dma) */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__timer7_dma = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_timer7_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_timer7_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* timer7 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_timer7_slaves[] = {
	&omap44xx_l4_abe__timer7,
	&omap44xx_l4_abe__timer7_dma,
};

static struct omap_hwmod omap44xx_timer7_hwmod = {
	.name		= "timer7",
	.class		= &omap44xx_timer_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap44xx_timer7_irqs,
	.main_clk	= "timer7_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM1_ABE_TIMER7_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_ABE_TIMER7_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_timer7_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_timer7_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* timer8 */
static struct omap_hwmod omap44xx_timer8_hwmod;
static struct omap_hwmod_irq_info omap44xx_timer8_irqs[] = {
	{ .irq = 44 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_timer8_addrs[] = {
	{
		.pa_start	= 0x4013e000,
		.pa_end		= 0x4013e07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> timer8 */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__timer8 = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_timer8_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_timer8_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap44xx_timer8_dma_addrs[] = {
	{
		.pa_start	= 0x4903e000,
		.pa_end		= 0x4903e07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> timer8 (dma) */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__timer8_dma = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_timer8_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_timer8_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* timer8 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_timer8_slaves[] = {
	&omap44xx_l4_abe__timer8,
	&omap44xx_l4_abe__timer8_dma,
};

static struct omap_hwmod omap44xx_timer8_hwmod = {
	.name		= "timer8",
	.class		= &omap44xx_timer_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap44xx_timer8_irqs,
	.main_clk	= "timer8_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM1_ABE_TIMER8_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_ABE_TIMER8_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_timer8_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_timer8_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* timer9 */
static struct omap_hwmod omap44xx_timer9_hwmod;
static struct omap_hwmod_irq_info omap44xx_timer9_irqs[] = {
	{ .irq = 45 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_timer9_addrs[] = {
	{
		.pa_start	= 0x4803e000,
		.pa_end		= 0x4803e07f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> timer9 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__timer9 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_timer9_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_timer9_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* timer9 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_timer9_slaves[] = {
	&omap44xx_l4_per__timer9,
};

static struct omap_hwmod omap44xx_timer9_hwmod = {
	.name		= "timer9",
	.class		= &omap44xx_timer_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_timer9_irqs,
	.main_clk	= "timer9_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_DMTIMER9_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_DMTIMER9_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_timer9_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_timer9_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* timer10 */
static struct omap_hwmod omap44xx_timer10_hwmod;
static struct omap_hwmod_irq_info omap44xx_timer10_irqs[] = {
	{ .irq = 46 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_timer10_addrs[] = {
	{
		.pa_start	= 0x48086000,
		.pa_end		= 0x4808607f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> timer10 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__timer10 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_timer10_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_timer10_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* timer10 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_timer10_slaves[] = {
	&omap44xx_l4_per__timer10,
};

static struct omap_hwmod omap44xx_timer10_hwmod = {
	.name		= "timer10",
	.class		= &omap44xx_timer_1ms_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_timer10_irqs,
	.main_clk	= "timer10_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_DMTIMER10_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_DMTIMER10_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_timer10_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_timer10_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* timer11 */
static struct omap_hwmod omap44xx_timer11_hwmod;
static struct omap_hwmod_irq_info omap44xx_timer11_irqs[] = {
	{ .irq = 47 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_timer11_addrs[] = {
	{
		.pa_start	= 0x48088000,
		.pa_end		= 0x4808807f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> timer11 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__timer11 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_timer11_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_timer11_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* timer11 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_timer11_slaves[] = {
	&omap44xx_l4_per__timer11,
};

static struct omap_hwmod omap44xx_timer11_hwmod = {
	.name		= "timer11",
	.class		= &omap44xx_timer_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_timer11_irqs,
	.main_clk	= "timer11_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_DMTIMER11_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_DMTIMER11_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_timer11_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_timer11_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'uart' class
 * universal asynchronous receiver/transmitter (uart)
 */

static struct omap_hwmod_class_sysconfig omap44xx_uart_sysc = {
	.rev_offs	= 0x0050,
	.sysc_offs	= 0x0054,
	.syss_offs	= 0x0058,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_ENAWAKEUP |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_uart_hwmod_class = {
	.name	= "uart",
	.sysc	= &omap44xx_uart_sysc,
};

/* uart1 */
static struct omap_hwmod omap44xx_uart1_hwmod;
static struct omap_hwmod_irq_info omap44xx_uart1_irqs[] = {
	{ .irq = 72 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_uart1_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 48 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 49 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_uart1_addrs[] = {
	{
		.pa_start	= 0x4806a000,
		.pa_end		= 0x4806a0ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> uart1 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__uart1 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_uart1_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_uart1_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* uart1 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_uart1_slaves[] = {
	&omap44xx_l4_per__uart1,
};

static struct omap_hwmod omap44xx_uart1_hwmod = {
	.name		= "uart1",
	.class		= &omap44xx_uart_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_uart1_irqs,
	.sdma_reqs	= omap44xx_uart1_sdma_reqs,
	.main_clk	= "uart1_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_UART1_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_UART1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_uart1_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_uart1_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* uart2 */
static struct omap_hwmod omap44xx_uart2_hwmod;
static struct omap_hwmod_irq_info omap44xx_uart2_irqs[] = {
	{ .irq = 73 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_uart2_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 50 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 51 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_uart2_addrs[] = {
	{
		.pa_start	= 0x4806c000,
		.pa_end		= 0x4806c0ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> uart2 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__uart2 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_uart2_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_uart2_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* uart2 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_uart2_slaves[] = {
	&omap44xx_l4_per__uart2,
};

static struct omap_hwmod omap44xx_uart2_hwmod = {
	.name		= "uart2",
	.class		= &omap44xx_uart_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_uart2_irqs,
	.sdma_reqs	= omap44xx_uart2_sdma_reqs,
	.main_clk	= "uart2_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_UART2_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_UART2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_uart2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_uart2_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* uart3 */
static struct omap_hwmod omap44xx_uart3_hwmod;
static struct omap_hwmod_irq_info omap44xx_uart3_irqs[] = {
	{ .irq = 74 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_uart3_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 52 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 53 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_uart3_addrs[] = {
	{
		.pa_start	= 0x48020000,
		.pa_end		= 0x480200ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> uart3 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__uart3 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_uart3_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_uart3_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* uart3 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_uart3_slaves[] = {
	&omap44xx_l4_per__uart3,
};

static struct omap_hwmod omap44xx_uart3_hwmod = {
	.name		= "uart3",
	.class		= &omap44xx_uart_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.flags		= HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET,
	.mpu_irqs	= omap44xx_uart3_irqs,
	.sdma_reqs	= omap44xx_uart3_sdma_reqs,
	.main_clk	= "uart3_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_UART3_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_UART3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_uart3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_uart3_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* uart4 */
static struct omap_hwmod omap44xx_uart4_hwmod;
static struct omap_hwmod_irq_info omap44xx_uart4_irqs[] = {
	{ .irq = 70 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_dma_info omap44xx_uart4_sdma_reqs[] = {
	{ .name = "tx", .dma_req = 54 + OMAP44XX_DMA_REQ_START },
	{ .name = "rx", .dma_req = 55 + OMAP44XX_DMA_REQ_START },
	{ .dma_req = -1 }
};

static struct omap_hwmod_addr_space omap44xx_uart4_addrs[] = {
	{
		.pa_start	= 0x4806e000,
		.pa_end		= 0x4806e0ff,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_per -> uart4 */
static struct omap_hwmod_ocp_if omap44xx_l4_per__uart4 = {
	.master		= &omap44xx_l4_per_hwmod,
	.slave		= &omap44xx_uart4_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_uart4_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* uart4 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_uart4_slaves[] = {
	&omap44xx_l4_per__uart4,
};

static struct omap_hwmod omap44xx_uart4_hwmod = {
	.name		= "uart4",
	.class		= &omap44xx_uart_hwmod_class,
	.clkdm_name	= "l4_per_clkdm",
	.mpu_irqs	= omap44xx_uart4_irqs,
	.sdma_reqs	= omap44xx_uart4_sdma_reqs,
	.main_clk	= "uart4_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L4PER_UART4_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L4PER_UART4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_uart4_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_uart4_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'usb_otg_hs' class
 * high-speed on-the-go universal serial bus (usb_otg_hs) controller
 */

static struct omap_hwmod_class_sysconfig omap44xx_usb_otg_hs_sysc = {
	.rev_offs	= 0x0400,
	.sysc_offs	= 0x0404,
	.syss_offs	= 0x0408,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_ENAWAKEUP |
			   SYSC_HAS_MIDLEMODE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_usb_otg_hs_hwmod_class = {
	.name	= "usb_otg_hs",
	.sysc	= &omap44xx_usb_otg_hs_sysc,
};

/* usb_otg_hs */
static struct omap_hwmod_irq_info omap44xx_usb_otg_hs_irqs[] = {
	{ .name = "mc", .irq = 92 + OMAP44XX_IRQ_GIC_START },
	{ .name = "dma", .irq = 93 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

/* usb_otg_hs master ports */
static struct omap_hwmod_ocp_if *omap44xx_usb_otg_hs_masters[] = {
	&omap44xx_usb_otg_hs__l3_main_2,
};

static struct omap_hwmod_addr_space omap44xx_usb_otg_hs_addrs[] = {
	{
		.pa_start	= 0x4a0ab000,
		.pa_end		= 0x4a0ab003,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_cfg -> usb_otg_hs */
static struct omap_hwmod_ocp_if omap44xx_l4_cfg__usb_otg_hs = {
	.master		= &omap44xx_l4_cfg_hwmod,
	.slave		= &omap44xx_usb_otg_hs_hwmod,
	.clk		= "l4_div_ck",
	.addr		= omap44xx_usb_otg_hs_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* usb_otg_hs slave ports */
static struct omap_hwmod_ocp_if *omap44xx_usb_otg_hs_slaves[] = {
	&omap44xx_l4_cfg__usb_otg_hs,
};

static struct omap_hwmod_opt_clk usb_otg_hs_opt_clks[] = {
	{ .role = "xclk", .clk = "usb_otg_hs_xclk" },
};

static struct omap_hwmod omap44xx_usb_otg_hs_hwmod = {
	.name		= "usb_otg_hs",
	.class		= &omap44xx_usb_otg_hs_hwmod_class,
	.clkdm_name	= "l3_init_clkdm",
	.flags		= HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY,
	.mpu_irqs	= omap44xx_usb_otg_hs_irqs,
	.main_clk	= "usb_otg_hs_ick",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_L3INIT_USB_OTG_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_L3INIT_USB_OTG_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= usb_otg_hs_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(usb_otg_hs_opt_clks),
	.slaves		= omap44xx_usb_otg_hs_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_usb_otg_hs_slaves),
	.masters	= omap44xx_usb_otg_hs_masters,
	.masters_cnt	= ARRAY_SIZE(omap44xx_usb_otg_hs_masters),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/*
 * 'wd_timer' class
 * 32-bit watchdog upward counter that generates a pulse on the reset pin on
 * overflow condition
 */

static struct omap_hwmod_class_sysconfig omap44xx_wd_timer_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap44xx_wd_timer_hwmod_class = {
	.name		= "wd_timer",
	.sysc		= &omap44xx_wd_timer_sysc,
	.pre_shutdown	= &omap2_wd_timer_disable,
};

/* wd_timer2 */
static struct omap_hwmod omap44xx_wd_timer2_hwmod;
static struct omap_hwmod_irq_info omap44xx_wd_timer2_irqs[] = {
	{ .irq = 80 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_wd_timer2_addrs[] = {
	{
		.pa_start	= 0x4a314000,
		.pa_end		= 0x4a31407f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_wkup -> wd_timer2 */
static struct omap_hwmod_ocp_if omap44xx_l4_wkup__wd_timer2 = {
	.master		= &omap44xx_l4_wkup_hwmod,
	.slave		= &omap44xx_wd_timer2_hwmod,
	.clk		= "l4_wkup_clk_mux_ck",
	.addr		= omap44xx_wd_timer2_addrs,
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* wd_timer2 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_wd_timer2_slaves[] = {
	&omap44xx_l4_wkup__wd_timer2,
};

static struct omap_hwmod omap44xx_wd_timer2_hwmod = {
	.name		= "wd_timer2",
	.class		= &omap44xx_wd_timer_hwmod_class,
	.clkdm_name	= "l4_wkup_clkdm",
	.mpu_irqs	= omap44xx_wd_timer2_irqs,
	.main_clk	= "wd_timer2_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM_WKUP_WDT2_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_WKUP_WDT2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_wd_timer2_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_wd_timer2_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

/* wd_timer3 */
static struct omap_hwmod omap44xx_wd_timer3_hwmod;
static struct omap_hwmod_irq_info omap44xx_wd_timer3_irqs[] = {
	{ .irq = 36 + OMAP44XX_IRQ_GIC_START },
	{ .irq = -1 }
};

static struct omap_hwmod_addr_space omap44xx_wd_timer3_addrs[] = {
	{
		.pa_start	= 0x40130000,
		.pa_end		= 0x4013007f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> wd_timer3 */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__wd_timer3 = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_wd_timer3_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_wd_timer3_addrs,
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_addr_space omap44xx_wd_timer3_dma_addrs[] = {
	{
		.pa_start	= 0x49030000,
		.pa_end		= 0x4903007f,
		.flags		= ADDR_TYPE_RT
	},
	{ }
};

/* l4_abe -> wd_timer3 (dma) */
static struct omap_hwmod_ocp_if omap44xx_l4_abe__wd_timer3_dma = {
	.master		= &omap44xx_l4_abe_hwmod,
	.slave		= &omap44xx_wd_timer3_hwmod,
	.clk		= "ocp_abe_iclk",
	.addr		= omap44xx_wd_timer3_dma_addrs,
	.user		= OCP_USER_SDMA,
};

/* wd_timer3 slave ports */
static struct omap_hwmod_ocp_if *omap44xx_wd_timer3_slaves[] = {
	&omap44xx_l4_abe__wd_timer3,
	&omap44xx_l4_abe__wd_timer3_dma,
};

static struct omap_hwmod omap44xx_wd_timer3_hwmod = {
	.name		= "wd_timer3",
	.class		= &omap44xx_wd_timer_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.mpu_irqs	= omap44xx_wd_timer3_irqs,
	.main_clk	= "wd_timer3_fck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP4_CM1_ABE_WDT3_CLKCTRL_OFFSET,
			.context_offs = OMAP4_RM_ABE_WDT3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.slaves		= omap44xx_wd_timer3_slaves,
	.slaves_cnt	= ARRAY_SIZE(omap44xx_wd_timer3_slaves),
	.omap_chip	= OMAP_CHIP_INIT(CHIP_IS_OMAP4430),
};

static __initdata struct omap_hwmod *omap44xx_hwmods[] = {

	/* dmm class */
	&omap44xx_dmm_hwmod,

	/* emif_fw class */
	&omap44xx_emif_fw_hwmod,

	/* l3 class */
	&omap44xx_l3_instr_hwmod,
	&omap44xx_l3_main_1_hwmod,
	&omap44xx_l3_main_2_hwmod,
	&omap44xx_l3_main_3_hwmod,

	/* l4 class */
	&omap44xx_l4_abe_hwmod,
	&omap44xx_l4_cfg_hwmod,
	&omap44xx_l4_per_hwmod,
	&omap44xx_l4_wkup_hwmod,

	/* mpu_bus class */
	&omap44xx_mpu_private_hwmod,

	/* aess class */
/*	&omap44xx_aess_hwmod, */

	/* bandgap class */
	&omap44xx_bandgap_hwmod,

	/* counter class */
/*	&omap44xx_counter_32k_hwmod, */

	/* dma class */
	&omap44xx_dma_system_hwmod,

	/* dmic class */
	&omap44xx_dmic_hwmod,

	/* dsp class */
	&omap44xx_dsp_hwmod,
	&omap44xx_dsp_c0_hwmod,

	/* dss class */
	&omap44xx_dss_hwmod,
	&omap44xx_dss_dispc_hwmod,
	&omap44xx_dss_dsi1_hwmod,
	&omap44xx_dss_dsi2_hwmod,
	&omap44xx_dss_hdmi_hwmod,
	&omap44xx_dss_rfbi_hwmod,
	&omap44xx_dss_venc_hwmod,

	/* gpio class */
	&omap44xx_gpio1_hwmod,
	&omap44xx_gpio2_hwmod,
	&omap44xx_gpio3_hwmod,
	&omap44xx_gpio4_hwmod,
	&omap44xx_gpio5_hwmod,
	&omap44xx_gpio6_hwmod,

	/* hsi class */
/*	&omap44xx_hsi_hwmod, */

	/* i2c class */
	&omap44xx_i2c1_hwmod,
	&omap44xx_i2c2_hwmod,
	&omap44xx_i2c3_hwmod,
	&omap44xx_i2c4_hwmod,

	/* ipu class */
	&omap44xx_ipu_hwmod,
	&omap44xx_ipu_c0_hwmod,
	&omap44xx_ipu_c1_hwmod,

	/* iss class */
/*	&omap44xx_iss_hwmod, */

	/* iva class */
	&omap44xx_iva_hwmod,
	&omap44xx_iva_seq0_hwmod,
	&omap44xx_iva_seq1_hwmod,

	/* kbd class */
	&omap44xx_kbd_hwmod,

	/* mailbox class */
	&omap44xx_mailbox_hwmod,

	/* mcbsp class */
	&omap44xx_mcbsp1_hwmod,
	&omap44xx_mcbsp2_hwmod,
	&omap44xx_mcbsp3_hwmod,
	&omap44xx_mcbsp4_hwmod,

	/* mcpdm class */
/*	&omap44xx_mcpdm_hwmod, */

	/* mcspi class */
	&omap44xx_mcspi1_hwmod,
	&omap44xx_mcspi2_hwmod,
	&omap44xx_mcspi3_hwmod,
	&omap44xx_mcspi4_hwmod,

	/* mmc class */
	&omap44xx_mmc1_hwmod,
	&omap44xx_mmc2_hwmod,
	&omap44xx_mmc3_hwmod,
	&omap44xx_mmc4_hwmod,
	&omap44xx_mmc5_hwmod,

	/* mpu class */
	&omap44xx_mpu_hwmod,

	/* smartreflex class */
	&omap44xx_smartreflex_core_hwmod,
	&omap44xx_smartreflex_iva_hwmod,
	&omap44xx_smartreflex_mpu_hwmod,

	/* spinlock class */
	&omap44xx_spinlock_hwmod,

	/* timer class */
	&omap44xx_timer1_hwmod,
	&omap44xx_timer2_hwmod,
	&omap44xx_timer3_hwmod,
	&omap44xx_timer4_hwmod,
	&omap44xx_timer5_hwmod,
	&omap44xx_timer6_hwmod,
	&omap44xx_timer7_hwmod,
	&omap44xx_timer8_hwmod,
	&omap44xx_timer9_hwmod,
	&omap44xx_timer10_hwmod,
	&omap44xx_timer11_hwmod,

	/* uart class */
	&omap44xx_uart1_hwmod,
	&omap44xx_uart2_hwmod,
	&omap44xx_uart3_hwmod,
	&omap44xx_uart4_hwmod,

	/* usb_otg_hs class */
	&omap44xx_usb_otg_hs_hwmod,

	/* wd_timer class */
	&omap44xx_wd_timer2_hwmod,
	&omap44xx_wd_timer3_hwmod,

	NULL,
};

int __init omap44xx_hwmod_init(void)
{
	return omap_hwmod_register(omap44xx_hwmods);
}

