/*
 *  Copyright 1994-2011 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include <arpa/inet.h>
#include "context.h"

/*
 * Protocol v1:
 * [ width ] "W"          2 bytes
 * [ height ] "H"         2 bytes
 * [ image data ] (RGB)   W*H*3 bytes
 *
 */

extern FILE *out;
extern void xfwrite(const void *, size_t, size_t, FILE *);


void
v1(const Context_t *ctx)
{
  uint16_t width = WIDTH, width2;
  uint16_t height = HEIGHT, height2;
  uint32_t proto = 1, proto2;
  uint32_t total, total2;
  Pixel_t *src;

  /* send packet size */
  total = sizeof(uint32_t)+2*sizeof(uint16_t)+BUFFSIZE*3*sizeof(u_char);
  total2 = htonl(total);
  xfwrite((const void *)&total2, sizeof(uint32_t), 1, out);
  
  /* protocol version */
  proto2 = htonl(proto);
  xfwrite((const void *)&proto2, sizeof(uint32_t), 1, out);
  
  /* send width, height */
  width2 = htons(width);
  height2 = htons(height);
  xfwrite((const void *)&width2, sizeof(uint16_t), 1, out);
  xfwrite((const void *)&height2, sizeof(uint16_t), 1, out);
  
  /* send picture */
  src = export_RGB_active_buffer(ctx, 0);
  xfwrite((const void *)src, sizeof(u_char), BUFFSIZE*3, out);
  xfree(src);
}


