/**
 * \file script-lua.h
 *
 * see script_lua.c
 * see fetchnews.c::getarticle()
 * see store.c::store_stream()
 *
 * see script-test-store.c for testing all this.
 *
 * clemens fischer <ino-news@spotteswoode.dnsalias.org>
 */

/* lua scripts return a table:
 *
 * { result=<code> [, result1=value1 [, resultN=valueN]] }
 * resultI: (header body)
 * valueI: c-string
 *
 */

/* implemented in the first version */

/* access to leafnode log function */
#define LN_LOG_LUA "ln_log"
#define LN_AGE_LUA "ln_age"

/*
 * fetchnews stuff
 */

/* fetchnews_init() */
#define FN_INIT "fetchnews_init"
/* fetchnews_finish(int status) */
#define FN_FINISH "fetchnews_finish"

/* fetchnews_init_group(name_string) */
#define FN_INIT_GROUP "fetchnews_init_group"
/* fetchnews_finish_group(status_code) */
#define FN_FINISH_GROUP "fetchnews_finish_group"

/* fetchnews_init_article() */
#define FN_INIT_ARTICLE "fetchnews_init_article"
/* fetchnews_finish_article(status_code) */
#define FN_FINISH_ARTICLE "fetchnews_finish_article"

/* fetchnews_headertxt(header_string) */
#define FN_HEADERTXT "fetchnews_headertxt"
/* fetchnews_headertable(header_table) */
#define FN_HEADERTABLE "fetchnews_headertable"
/* fetchnews_headertxt_bodytxt(header_string, article_string) */
#define FN_HEADERTXT_BODYTXT "fetchnews_headertxt_bodytxt"

/*
 * leafnode stuff
 */

/* leafnode_init() */
#define LN_INIT "leafnode_init"
/* leafnode_enter_group(name_string) */
#define LN_ENTER_GROUP "leafnode_enter_group"

/* optional, maybe implemented in later versions */

/* fetchnews_headertable_text(header_table, article_string) */
#define FN_HEADERTABLE_TEXT "fetchnews_headertable_text"
/* fetchnews_retrieve_file() */
#define FN_RETRIEVE_FILE "fetchnews_retrieve_file"
/* fetchnews_headertable_file(header_table, article_file) */
#define FN_HEADERTABLE_FILE "fetchnews_headertable_file"

/* etc/leafnode/config "scripthooks_lua = lua-hooks.lua" */
#define CONFIG_SCRIPT_CONFIGDIR "/etc/leafnode"
#define CONFIG_SCRIPT_NAME "scripthooks_lua"
#define CONFIG_SCRIPT_VAL "scripthooks.lua"
#define CONFIG_SCRIPT_DEFAULT "/etc/leafnode/scripthooks.lua"

#define ERRMESS_RUNTIME "runtime error"
#define ERRMESS_MEMORY_ALLOC "memory allocation error"
#define ERRMESS_ERR_HANDLER "error while running error handler"
#define ERRMESS_API_RETURN_PROB "error inside script backend"
#define ERRMESS_RESULT_TYPE "result must be table"
#define ERRMESS_DOFILE_CANTREAD "dofile cannot read hooks file"
#define ERRMESS_DOFILE_SYNTAX "dofile syntax error"
#define ERRMESS_DOFILE_UNSPEC "dofile unspecified error"
#define ERRMESS_API_SEQ "api called out of sequence"

/* used by data collection fun, eg. add_header(), to make sure this
 * number of stack entries are left to use.
 */
#define FN_MIN_STACK_LUA 20

/* these are the result fields in the table user scripts return.  not
 * providing them will normally get ignored, but the "result" field
 * _MUST_ be supplied in a valid result.
 */
#define RES_FIELD_NEWSGROUPS "newsgroups"
#define RES_FIELD_BODY "body"
#define RES_FIELD_HEADER "header"
#define RES_FIELD_RESULT "result"

/* aux functions for the lua backend */

int script_init_ready_lua(int);
const char * mk_init_file_lua(const char * filename);
script_return_t mk_mess(const char *);

/* canonic interface functions, see script.h */

unsigned long int
check_script_return_lua(script_return_t, const char *, const char *, script_cmd_t, script_result_t *);

script_return_t
script_ln_chk_grp_access_lua(const char * cmd, const char * group);
script_return_t script_ln_init_lua(void);
int script_ln_register_user_lua(const char * user);

script_return_t script_fn_init_lua(void);
script_return_t script_fn_finish_lua(int rc);

script_return_t script_fn_init_article_lua(void);
script_return_t script_fn_finish_article_lua(int);

script_return_t script_fn_init_group_lua(char *);
script_return_t script_fn_finish_group_lua(int);

script_return_t script_fn_add_header_lua(script_data_t);
script_return_t script_fn_filter_header_table_lua(void);
script_return_t script_fn_filter_header_lua(script_data_t);
script_return_t script_fn_filter_header_body_lua(script_data_t, script_data_t);
script_return_t script_fn_add_body_lua(script_data_t);

script_result_t script_fn_get_result_lua(script_cmd_t);
