/*
 *   LADCCA
 *    
 *   Copyright (C) 2002 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <ladcca/types.h>
#include <ladcca/client.h>
#include <ladcca/xmalloc.h>
#include <ladcca/internal.h>

cca_client_t *
cca_client_new ()
{
  cca_client_t * client;
  client = cca_malloc0 (sizeof (cca_client_t));
  pthread_mutex_init (&client->configs_in_lock, NULL);
  pthread_mutex_init (&client->events_in_lock, NULL);
  pthread_mutex_init (&client->comm_events_out_lock, NULL);
  pthread_cond_init (&client->send_conditional, NULL);
  return client;
}

void
cca_client_destroy (cca_client_t * client)
{
  pthread_mutex_destroy (&client->configs_in_lock);
  pthread_mutex_destroy (&client->events_in_lock);
  pthread_mutex_destroy (&client->comm_events_out_lock);
  pthread_cond_destroy  (&client->send_conditional);

  cca_client_set_class        (client, NULL);

  cca_args_destroy (client->args);

  free (client);
}

const char *
cca_client_get_class (const cca_client_t * client)
{
  return client->class;
}

void
cca_client_set_class (cca_client_t * client, const char * class)
{
  set_string_property (client->class, class);
}

/* EOF */

