/*
 *   LADCCA
 *    
 *   Copyright (C) 2002, 2003 Robert Ham <rah@bash.sh>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>

#include <ladcca/ladcca.h>
#include <ladcca/args.h>
#include <ladcca/internal.h>

void
cca_args_free_argv (cca_args_t * args)
{
  if (args->argv)
    {
      int i;
      for (i = 0; i < args->argc; i++)
        free (args->argv[i]);
      free (args->argv);
      args->argv = NULL;
    }
}

void
cca_args_free (cca_args_t * args)
{
  if (args->project)
    free (args->project);
  if (args->server)
    free (args->server);
  cca_args_free_argv (args);
}

cca_args_t *
cca_args_new ()
{
  cca_args_t * args;
  args = cca_malloc0 (sizeof (cca_args_t));
  uuid_clear (args->id);
  return args;
}

void
cca_args_destroy (cca_args_t * args)
{
  cca_args_free (args);
  free (args);
}

void
cca_args_set_project (cca_args_t * args, const char * project)
{
  set_string_property (args->project, project);
}

void
cca_args_set_server  (cca_args_t * args, const char * server)
{
  set_string_property (args->server, server);
}
void
cca_args_set_id      (cca_args_t * args, uuid_t id)
{
  uuid_copy (args->id, id);
}

void
cca_args_set_flags (cca_args_t * args, int flags)
{
  args->flags = flags;
}

void
cca_args_set_flag (cca_args_t * args, int flag)
{
  args->flags |= flag;
}

const char *
cca_args_get_project (const cca_args_t * args)
{
  return args->project;
}

const char *
cca_args_get_server  (const cca_args_t * args)
{
  return args->server;
}

void
cca_args_get_id      (const cca_args_t * args, uuid_t id)
{
  uuid_copy (id, ((cca_args_t *)args)->id);
}

int
cca_args_get_flags    (const cca_args_t * args)
{
  return args->flags;
}

void cca_args_set_args    (cca_args_t * args, int argc, const char * const * argv)
{
  int i;
  
  cca_args_free_argv (args);
  
  args->argc = argc;
  args->argv = cca_malloc (sizeof (char *) * argc);

  for (i = 0; i < argc; i++)
    args->argv[i] = cca_strdup (argv[i]);
}

int
cca_args_get_argc    (const cca_args_t * args)
{
  return args->argc;
}

char **
cca_args_take_argv   (cca_args_t * args)
{
  char ** argv;
  argv = args->argv;
  args->argv = NULL;
  return argv;
}

const char * const *
cca_args_get_argv   (const cca_args_t * args)
{
  return (const char * const *) args->argv;
}


/* EOF */
