//LabPlot : FilterAUDIOFILE.h

#ifndef FILTERAUDIOFILE_H
#define FILTERAUDIOFILE_H

#include <qstring.h>
#include <qstringlist.h>

#ifdef HAVE_AUDIOFILE
#include <audiofile.h>
#endif

class FilterAUDIOFILE
{
public:
	FilterAUDIOFILE(QString filename=0);
	bool fileOK() { return fileok; }
	QString description() { return QString("TODO"); }	// TODO
	int frameCount() { 
#ifdef HAVE_AUDIOFILE
		return (int) afGetFrameCount(file, AF_DEFAULT_TRACK); 
#else
		return 0;
#endif
	}
	int channelCount() { 
#ifdef HAVE_AUDIOFILE
		return afGetVirtualChannels(file, AF_DEFAULT_TRACK); 
#else
		return 0;
#endif
	}
	QString Name() { 
#ifdef HAVE_AUDIOFILE
		return QString((char *)afQueryPointer(AF_QUERYTYPE_FILEFMT,AF_QUERY_NAME,format,0,0)); 
#else
		return QString::null;
#endif
	}
	QString Desc() { 
#ifdef HAVE_AUDIOFILE
		return QString((char *)afQueryPointer(AF_QUERYTYPE_FILEFMT,AF_QUERY_DESC,format,0,0)); 
#else
		return QString::null;
#endif
	}
	QString sampleFormat();
	QString Format(int f);
	int sampleWidth();
	double sampleRate() { 
#ifdef HAVE_AUDIOFILE
		return afGetRate(file, AF_DEFAULT_TRACK); 
#else
		return 0;
#endif
	}
	double frameSize() { 
#ifdef HAVE_AUDIOFILE
		return (double) afGetVirtualFrameSize(file, AF_DEFAULT_TRACK, 1); 
#else
		return 0;
#endif
	}
	unsigned int virtualFrameSize() { 
#ifdef HAVE_AUDIOFILE
		return (unsigned int)afGetVirtualFrameSize(file,AF_DEFAULT_TRACK, 1);
#else
		return 0;
#endif
	}
	double *Data();

private:
	QString filename;			// file
	bool fileok;				// is an audio file and readable
#ifdef HAVE_AUDIOFILE
	AFfilehandle file;
#endif
	int format;				// numeric format id
};

#endif //FILTERAUDIOFILE_H
