//LabPlot : FilterAUDIOFILE.cc

#include <klocale.h>
#include <kdebug.h>

#include "FilterAUDIOFILE.h"

#define BUFFER_FRAMES 4096

FilterAUDIOFILE::FilterAUDIOFILE(QString fn)
	: filename(fn)
{
	fileok=false;
#ifdef HAVE_AUDIOFILE
	if(!filename.isEmpty()) {
		file = afOpenFile(filename, "r", NULL);

		if (file != AF_NULL_FILEHANDLE) {	// an audio file and readable
			fileok=true;
			format=afGetFileFormat(file,0);
		}
	}
#endif
}

QString FilterAUDIOFILE::Format(int f) {
#ifdef HAVE_AUDIOFILE
	switch(f) {
	case AF_FILE_UNKNOWN: return QString("AF_FILE_UNKNOWN"); break;
	case AF_FILE_RAWDATA: return QString("AF_FILE_RAWDATA"); break;
	case AF_FILE_AIFFC: return QString("AF_FILE_AIFFC"); break;
	case AF_FILE_AIFF: return QString("AF_FILE_AIFF"); break;
	case AF_FILE_NEXTSND: return QString("AF_FILE_NEXTSND"); break;
	case AF_FILE_WAVE: return QString("AF_FILE_WAVE"); break;
	case AF_FILE_BICSF: return QString("AF_FILE_BICSF/AF_FILE_IRCAM"); break;
	}
#endif

	return 0;
}

double *FilterAUDIOFILE::Data() {
#ifdef HAVE_AUDIOFILE
	int format, width;
	afGetVirtualSampleFormat(file, AF_DEFAULT_TRACK, &format,&width);

	int size = frameCount()*channelCount();
	double *data = new double[size];

	switch(format) {
	case AF_SAMPFMT_UNSIGNED:	// unsigned
		switch(width) {
		case 8: {		// 8 bit
			unsigned char *buffer = new unsigned char[size];
			afReadFrames(file, AF_DEFAULT_TRACK,buffer,size);

			for(int i=0;i<size;i++) {
				// TODO : explain this
				data[i] = buffer[i]-128;
				//kdDebug()<<" x/y "<<i<<'/'<<data[2*i]<<" "<<data[2*i+1]<<endl;
			}
			for(int i=0;i<100;i++)
				kdDebug()<<" 1/2 : "<<data[2*i]<<'/'<<data[2*i+1]<<endl;
			}
			break;
		case 16: {
			unsigned short *buffer = new unsigned short[size];
			afReadFrames(file, AF_DEFAULT_TRACK,buffer,size);

			for(int i=0;i<size;i++) {
				// TODO : explain this
				data[i] = buffer[i]-128;
				//kdDebug()<<" x/y "<<i<<'/'<<y<<endl;
			}
			}
			break;
		}
		break;
	case AF_SAMPFMT_TWOSCOMP:	// signed "two's complement"
		switch(width) {
		case 8: {		// 8 bit
			char *buffer = new char[size];
			afReadFrames(file, AF_DEFAULT_TRACK,buffer,size);

			for(int i=0;i<size;i++)
				data[i] = buffer[i];
			}
			break;
		case 16: {	// 16 bit
			short *buffer = new short[size];
			afReadFrames(file, AF_DEFAULT_TRACK,buffer,size);

			for(int i=0;i<size;i++)
				data[i] = buffer[i];
			}
			break;
		}
		break;
	}
	return data;
#else
	return 0;
#endif
}

QString FilterAUDIOFILE::sampleFormat() {
#ifdef HAVE_AUDIOFILE
	int format, width;
	afGetVirtualSampleFormat(file, AF_DEFAULT_TRACK, &format,&width);

	switch(format) {
	case AF_SAMPFMT_TWOSCOMP:
		return i18n("two's complement");break;
	case AF_SAMPFMT_UNSIGNED:
		return i18n("unsigned");break;
	case AF_SAMPFMT_FLOAT:
		return i18n("float");break;
	case AF_SAMPFMT_DOUBLE:
		return i18n("double");break;

	}
#endif

	return i18n("UNKNOWN");
}

int FilterAUDIOFILE::sampleWidth() {
#ifdef HAVE_AUDIOFILE
	int format, width;
	afGetVirtualSampleFormat(file, AF_DEFAULT_TRACK, &format,&width);

	return width;
#else
	return 0;
#endif
}
