//LabPlot : ObjectDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <qfiledialog.h>
#include <klocale.h>
#include <kdebug.h>
#include "ObjectDialog.h"

using namespace std;

ObjectDialog::ObjectDialog(MainWin *m, const char *name, int activetab, int item)
	: Dialog(m, name), item(item)
{
	setCaption(i18n("Drawing Objects"));
	tw = new QTabWidget(vbox);
	KConfig *config = mw->Config();
	config->setGroup( "Objects" );

	QHBox *hb;
	KPushButton *deletepb = new KPushButton(i18n("delete selected object"),vbox);
	QObject::connect(deletepb,SIGNAL(clicked()),SLOT(deleteObject()));

	// Line
	QVBox *tab1 = new QVBox(tw);

	lv1 = new QListView(tab1,0);
	lv1->addColumn(i18n("From"));
	lv1->addColumn(i18n("To"));
	lv1->addColumn(i18n("Width"));
	lv1->addColumn(i18n("Color"));
	lv1->addColumn(i18n("Start Arrow"));
	lv1->addColumn(i18n("Length"));
	lv1->addColumn(i18n("Angle"));
	lv1->addColumn(i18n("Filled"));
	lv1->addColumn(i18n("Fill Color"));
	lv1->addColumn(i18n("End Arrow"));
	lv1->addColumn(i18n("Length"));
	lv1->addColumn(i18n("Angle"));
	lv1->addColumn(i18n("Filled"));
	lv1->addColumn(i18n("Fill Color"));

	updateLineListView();
	QObject::connect(lv1,SIGNAL(selectionChanged()),this,SLOT(updateLine()));

	hb = new QHBox(tab1);
	new QLabel(i18n("From : "),hb);
	lx1le = new KLineEdit("",hb);
	lx1le->setValidator(new QDoubleValidator(0,1,3,lx1le));
	ly1le = new KLineEdit("",hb);
	ly1le->setValidator(new QDoubleValidator(0,1,3,ly1le));
	new QLabel(i18n(" To : "),hb);
	lx2le = new KLineEdit("",hb);
	lx2le->setValidator(new QDoubleValidator(0,1,3,lx2le));
	ly2le = new KLineEdit("",hb);
	ly2le->setValidator(new QDoubleValidator(0,1,3,ly2le));

	hb = new QHBox(tab1);
	new QLabel(i18n("Width : "),hb);
	lwni = new KIntNumInput(0,hb);
	lwni->setRange(0,100,1,false);
	new QLabel(i18n(" Color : "),hb);
	lcb = new KColorButton(Qt::black,hb);

	new QLabel(i18n("Start Arrow : "),tab1);
	hb = new QHBox(tab1);
	startcb = new QCheckBox(i18n("enabled"),hb);
	new QLabel(i18n("Length (0..1) : "),hb);
	salle = new KLineEdit("",hb);
	salle->setValidator(new QDoubleValidator(0,1,3,salle));
	salle->setMaximumWidth(50);
	new QLabel(i18n(" Angle : "),hb);
	saale = new KLineEdit("",hb);
	saale->setValidator(new QDoubleValidator(-360,360,2,saale));
	saale->setMaximumWidth(50);
	safcb = new QCheckBox(i18n("Filled"),hb);
	new QLabel(i18n(" Color : "),hb);
	safccb = new KColorButton(Qt::white,hb);

	new QLabel(i18n("End Arrow : "),tab1);
	hb = new QHBox(tab1);
	endcb = new QCheckBox(i18n("enabled"),hb);
	new QLabel(i18n("Length (0..1) : "),hb);
	ealle = new KLineEdit("",hb);
	ealle->setValidator(new QDoubleValidator(0,1,3,ealle));
	ealle->setMaximumWidth(50);
	new QLabel(i18n(" Angle : "),hb);
	eaale = new KLineEdit("",hb);
	eaale->setValidator(new QDoubleValidator(-360,360,2,eaale));
	eaale->setMaximumWidth(50);
	eafcb = new QCheckBox(i18n("Filled"),hb);
	new QLabel(i18n(" Color : "),hb);
	eafccb = new KColorButton(Qt::white,hb);

	// Label
	QVBox *tab2 = new QVBox(tw);

	lv2 = new QListView(tab2,0);
	lv2->addColumn(i18n("Position"));

	updateLabelListView();		// set current item
	QObject::connect(lv2,SIGNAL(selectionChanged()),this,SLOT(updateLabel()));

	Label *l = p->getLabel(0);
	if(mw->activeWorksheet() && mw->activeWorksheet()->getPlot(0) &&
		mw->activeWorksheet()->getPlot(0)->Type() == PQWT3D )
		rtw = new RichTextWidget((QWidget *)tab2,l,0,1);
	else
		rtw = new RichTextWidget((QWidget *)tab2,l,0);

	// Box
	QVBox *tab3 = new QVBox(tw);
	lv3 = new QListView(tab3,0);
	lv3->addColumn(i18n("Position"));
	lv3->addColumn(i18n("Size"));
	lv3->addColumn(i18n("Width"));
	lv3->addColumn(i18n("Color"));
	lv3->addColumn(i18n("Filled"));
	lv3->addColumn(i18n("Fill Color"));
	//lv3->addColumn(i18n("LNR"));

	updateRectListView();
	QObject::connect(lv3,SIGNAL(selectionChanged()),this,SLOT(updateRect()));

	hb = new QHBox(tab3);
	new QLabel(i18n("Position : "),hb);
	rx1le = new KLineEdit("",hb);
	rx1le->setValidator(new QDoubleValidator(0,1,3,rx1le));
	ry1le = new KLineEdit("",hb);
	ry1le->setValidator(new QDoubleValidator(0,1,3,ry1le));
	new QLabel(i18n(" Size : "),hb);
	rx2le = new KLineEdit("",hb);
	rx2le->setValidator(new QDoubleValidator(0,1,3,rx2le));
	ry2le = new KLineEdit("",hb);
	ry2le->setValidator(new QDoubleValidator(0,1,3,ry2le));

	hb = new QHBox(tab3);
	new QLabel(i18n("Width : "),hb);
	rwni = new KIntNumInput(0,hb);
	rwni->setRange(0,100,1,false);
	new QLabel(i18n(" Color : "),hb);
	rcb = new KColorButton(Qt::black,hb);

	hb = new QHBox(tab3);
	rfccb = new QCheckBox(i18n("Filled"),hb);
	new QLabel(i18n(" Color : "),hb);
	rfcb = new KColorButton(Qt::white,hb);

	// Ellipse
	QVBox *tab4 = new QVBox(tw);
	lv4 = new QListView(tab4,0);
	lv4->addColumn(i18n("Position"));
	lv4->addColumn(i18n("Size"));
	lv4->addColumn(i18n("Width"));
	lv4->addColumn(i18n("Color"));
	lv4->addColumn(i18n("Filled"));
	lv4->addColumn(i18n("Fill Color"));

	updateEllipseListView();
	QObject::connect(lv4,SIGNAL(selectionChanged()),this,SLOT(updateEllipse()));

	hb = new QHBox(tab4);
	new QLabel(i18n("Position : "),hb);
	ex1le = new KLineEdit("",hb);
	ex1le->setValidator(new QDoubleValidator(0,1,3,ex1le));
	ey1le = new KLineEdit("",hb);
	ey1le->setValidator(new QDoubleValidator(0,1,3,ey1le));
	new QLabel(i18n(" Size : "),hb);
	ex2le = new KLineEdit("",hb);
	ex2le->setValidator(new QDoubleValidator(0,1,3,ex2le));
	ey2le = new KLineEdit("",hb);
	ey2le->setValidator(new QDoubleValidator(0,1,3,ey2le));

	hb = new QHBox(tab4);
	new QLabel(i18n("Width : "),hb);
	ewni = new KIntNumInput(0,hb);
	ewni->setRange(0,100,1,false);
	new QLabel(i18n(" Color : "),hb);
	ecb = new KColorButton(Qt::black,hb);

	hb = new QHBox(tab4);
	efccb = new QCheckBox(i18n("Filled"),hb);
	new QLabel(i18n(" Color : "),hb);
	efcb = new KColorButton(Qt::white,hb);

	// Image
	QVBox *tab5 = new QVBox(tw);
	lv5 = new QListView(tab5,0);
	lv5->addColumn(i18n("Position"));
	lv5->addColumn(i18n("File"));
	lv5->addColumn(i18n("Scale"));
	lv5->addColumn(i18n("Rotation Angle"));

	updateImageListView();
	QObject::connect(lv5,SIGNAL(selectionChanged()),this,SLOT(updateImage()));

	hb = new QHBox(tab5);
	new QLabel(i18n("Position : "),hb);
	ixle = new KLineEdit("",hb);
	ixle->setValidator(new QDoubleValidator(0,1,3,ixle));
	iyle = new KLineEdit("",hb);
	iyle->setValidator(new QDoubleValidator(0,1,3,iyle));

	hb = new QHBox(tab5);
	new QLabel(i18n("File : "),hb);
	ile = new KLineEdit("",hb);
	KPushButton *newFile = new KPushButton(i18n("Browse..."),hb);
	QObject::connect(newFile,SIGNAL(clicked()),SLOT(selectFile()));

	hb = new QHBox(tab5);
	new QLabel(i18n("Scale : "),hb);
	isle = new KLineEdit("",hb);
	isle->setValidator(new QDoubleValidator(isle));
	new QLabel(i18n(" Rotation Angle : "),hb);
	iale = new KLineEdit("",hb);
	iale->setValidator(new QDoubleValidator(-360,360,2,iale));

	tw->addTab(tab1,i18n("Line"));
	tw->addTab(tab2,i18n("Label"));
	tw->addTab(tab3,i18n("Rect"));
	tw->addTab(tab4,i18n("Ellipse"));
	tw->addTab(tab5,i18n("Image"));

	tw->setCurrentPage(activetab);	// used from Worksheet (mouse event)

	// update for current item (define object)
	updateLabel();					// udate shown label
	updateImage();				// udate shown image

	updateDialog();

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
//	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));
	save->setEnabled(false);

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize((int)(1.1*minimumSize().width()),minimumSize().height());
}

void ObjectDialog::saveSettings() {
	KConfig *config = mw->Config();
	config->setGroup( "Objects" );
	//TODO : not used
}

void ObjectDialog::updateDialog() {
	p = mw->activeWorksheet();

	Line *line = p->getLine(0);
	Point start = line->startPoint();
	Point end = line->endPoint();
	lx1le->setText(QString::number(start.X()));
	ly1le->setText(QString::number(start.Y()));
	lx2le->setText(QString::number(end.X()));
	ly2le->setText(QString::number(end.Y()));
	lwni->setValue(line->Width());
	lcb->setColor(line->Color());

	Arrow *sarrow = line->startArrow();
	Arrow *earrow = line->endArrow();
	startcb->setChecked(sarrow->Enabled());
	salle->setText(QString::number(sarrow->Length()));
	saale->setText(QString::number(sarrow->Angle()));
	safcb->setChecked(sarrow->Filled());
	safccb->setColor(sarrow->fillColor());

	endcb->setChecked(earrow->Enabled());
	ealle->setText(QString::number(earrow->Length()));
	eaale->setText(QString::number(earrow->Angle()));
	eafcb->setChecked(earrow->Filled());
	eafccb->setColor(earrow->fillColor());

	Label *l = p->getLabel(0);
	rtw->setLabel(l);

	Rect *rect = p->getRect(0);
	start = rect->startPoint();
	end = rect->endPoint();
	rx1le->setText(QString::number(start.X()));
	ry1le->setText(QString::number(start.Y()));
	rx2le->setText(QString::number(end.X()));
	ry2le->setText(QString::number(end.Y()));
	rwni->setValue(rect->Width());
	rcb->setColor(rect->Color());
	rfccb->setChecked(rect->isFilled());
	rfcb->setColor(rect->FillColor());

	Ellipse *ellipse = p->getEllipse(0);
	start = ellipse->startPoint();
	ex1le->setText(QString::number(start.X()));
	ey1le->setText(QString::number(start.Y()));
	end = ellipse->endPoint();
	ex2le->setText(QString::number(end.X()));
	ey2le->setText(QString::number(end.Y()));
	ewni->setValue(ellipse->Width());
	ecb->setColor(ellipse->Color());
	efccb->setChecked(ellipse->isFilled());
	efcb->setColor(ellipse->FillColor());

	LImage *image = p->getImage(0);
	ixle->setText(QString::number(image->Pos().X()));
	iyle->setText(QString::number(image->Pos().Y()));
	ile->setText(image->Name());
	isle->setText(QString::number(image->Scale()));
	iale->setText(QString::number(image->Angle()));
}

void ObjectDialog::selectFile() {
	QString filename = QFileDialog::getOpenFileName( QString::null,
		i18n("Images (*.png *.xpm *.jpg *.jpeg *.tif *.gif)"), this );
	if ( filename )
		ile->setText(filename);
}

void ObjectDialog::deleteObject() {
	int tab = tw->currentPageIndex();
	Label *label = new Label();
	Line *line = new Line();
	Rect *rect = new Rect();
	Ellipse *ellipse = new Ellipse();
	LImage *image = new LImage();
	switch (tab) {
	case 0:	// line
		item = (int) (lv1->itemPos(lv1->currentItem())/lv1->currentItem()->height());
		p->setLine(item,line);
		updateLineListView();
		break;
	case 1:	//label
		item = (int) (lv2->itemPos(lv2->currentItem())/lv2->currentItem()->height());
		p->setLabel(item,label);
		updateLabelListView();
		break;
	case 2:	//rect
		item = (int) (lv3->itemPos(lv3->currentItem())/lv3->currentItem()->height());
		p->setRect(item,rect);
		updateRectListView();
		break;
	case 3:	//ellipse
		item = (int) (lv4->itemPos(lv4->currentItem())/lv4->currentItem()->height());
		p->setEllipse(item,ellipse);
		updateEllipseListView();
		break;
	case 4:	//image
		item = (int) (lv5->itemPos(lv5->currentItem())/lv5->currentItem()->height());
		p->setImage(item,image);
		updateImageListView();
		break;
	}
	p->updatePixmap();
}

// update when selected different line
void ObjectDialog::updateLine() {
	item = (int) (lv1->itemPos(lv1->currentItem())/lv1->currentItem()->height());
	kdDebug()<<"ObjectDialog::updateLine() : item = "<<item<<endl;
	Line *line = p->getLine(item);
	Point start = line->startPoint();
	Point end = line->endPoint();

	lx1le->setText(QString::number(start.X()));
	ly1le->setText(QString::number(start.Y()));
	lx2le->setText(QString::number(end.X()));
	ly2le->setText(QString::number(end.Y()));

	lwni->setValue(line->Width());
	lcb->setColor(line->Color());

	Arrow *sarrow = line->startArrow();
	Arrow *earrow = line->endArrow();

	startcb->setChecked(sarrow->Enabled());
	salle->setText(QString::number(sarrow->Length()));
	saale->setText(QString::number(sarrow->Angle()));
	safcb->setChecked(sarrow->Filled());
	safccb->setColor(sarrow->fillColor());

	endcb->setChecked(earrow->Enabled());
	ealle->setText(QString::number(earrow->Length()));
	eaale->setText(QString::number(earrow->Angle()));
	eafcb->setChecked(earrow->Filled());
	eafccb->setColor(earrow->fillColor());
}

void ObjectDialog::updateLineListView() {
	kdDebug()<<"updateLineListView()"<<endl;
	lv1->clear();
	lv1->setSorting(-1);
	for (int i=0;i<p->NrObjects();i++) {
		QStringList sl = p->getLine(p->NrObjects()-i-1)->Info();
		QListViewItem *lvi = new QListViewItem(lv1);
		for (unsigned int j = 0;j < sl.count();j++) {
			lvi->setText(j,sl[j]);
		}
	}
	lv1->setSelected( lv1->firstChild(), true );
}

void ObjectDialog::updateLabel() {
	kdDebug()<<"updateLabel()"<<endl;
	item = (int) (lv2->itemPos(lv2->currentItem())/lv2->currentItem()->height());
	rtw->setLabel(p->getLabel(item));
}

void ObjectDialog::updateLabelListView() {
	kdDebug()<<"updateLabelListView()"<<endl;
	lv2->clear();
	lv2->setSorting(-1);
	for (int i=0;i<p->NrObjects();i++) {
		QStringList sl = p->getLabel(p->NrObjects()-i-1)->Info();
		QListViewItem *lvi = new QListViewItem(lv2);
		for (unsigned int j = 0;j < sl.count();j++) {
			lvi->setText(j,sl[j]);
		}
		if(p->NrObjects()-i-1==item)
			lv2->setSelected(lvi,true);
	}
}

void ObjectDialog::updateRect() {
	item = (int) (lv3->itemPos(lv3->currentItem())/lv3->currentItem()->height());

	kdDebug()<<"PICKED RECT ITEM "<<item<<endl;

	Rect *rect = p->getRect(item);
	Point start = rect->startPoint();
	Point end = rect->endPoint();

	rx1le->setText(QString::number(start.X()));
	ry1le->setText(QString::number(start.Y()));
	rx2le->setText(QString::number(end.X()));
	ry2le->setText(QString::number(end.Y()));

	rwni->setValue(rect->Width());
	rcb->setColor(rect->Color());
	rfccb->setChecked(rect->isFilled());
	rfcb->setColor(rect->FillColor());
}

void ObjectDialog::updateRectListView() {
	lv3->clear();
	lv3->setSorting(-1);
	for (int i=0;i<p->NrObjects();i++) {
		QStringList sl = p->getRect(p->NrObjects()-i-1)->Info();
		QListViewItem *lvi = new QListViewItem(lv3);
		for (unsigned int j = 0;j < sl.count();j++) {
			lvi->setText(j,sl[j]);
		}
		//lvi->setText(s.count(),QString::number(p->NrObjects()-i-1));
	}
	lv3->setSelected( lv3->firstChild(), true );
}

void ObjectDialog::updateEllipse() {
	item = (int) (lv4->itemPos(lv4->currentItem())/lv4->currentItem()->height());

	kdDebug()<<"PICKED ELLIPSE ITEM "<<item<<endl;

	Ellipse *ellipse = p->getEllipse(item);
	Point start = ellipse->startPoint();
	Point end = ellipse->endPoint();

	ex1le->setText(QString::number(start.X()));
	ey1le->setText(QString::number(start.Y()));
	ex2le->setText(QString::number(end.X()));
	ey2le->setText(QString::number(end.Y()));

	ewni->setValue(ellipse->Width());
	ecb->setColor(ellipse->Color());
	efccb->setChecked(ellipse->isFilled());
	efcb->setColor(ellipse->FillColor());
}

void ObjectDialog::updateEllipseListView() {
	lv4->clear();
	lv4->setSorting(-1);
	for (int i=0;i<p->NrObjects();i++) {
		QStringList sl = p->getEllipse(p->NrObjects()-i-1)->Info();
		QListViewItem *lvi = new QListViewItem(lv4);
		for (unsigned int j = 0;j < sl.count();j++) {
			lvi->setText(j,sl[j]);
		}
	}
	lv4->setSelected( lv4->firstChild(), true );
}

void ObjectDialog::updateImage() {
	item = (int) (lv5->itemPos(lv5->currentItem())/lv5->currentItem()->height());
	LImage *image = p->getImage(item);
	ile->setText(image->Name());
	isle->setText(QString::number(image->Scale()));
	iale->setText(QString::number(image->Angle()));
	ixle->setText(QString::number(image->Pos().X()));
	iyle->setText(QString::number(image->Pos().Y()));
}

void ObjectDialog::updateImageListView() {
	lv5->clear();
	lv5->setSorting(-1);
	for (int i=0;i<p->NrObjects();i++) {
		QStringList sl = p->getImage(p->NrObjects()-i-1)->Info();
		QListViewItem *lvi = new QListViewItem(lv5);
		for (unsigned int j = 0;j < sl.count();j++) {
			lvi->setText(j,sl[j]);
		}
		if(p->NrObjects()-i-1==item)
			lv5->setSelected(lvi,true);
	}
	lv5->setSelected( lv5->firstChild(), true );
}

int ObjectDialog::apply_clicked() {
	int item1 = (int) (lv1->itemPos(lv1->currentItem())/lv1->currentItem()->height());
	int item2 = (int) (lv2->itemPos(lv2->currentItem())/lv2->currentItem()->height());
	int item3 = (int) (lv3->itemPos(lv3->currentItem())/lv3->currentItem()->height());
	int item4 = (int) (lv4->itemPos(lv4->currentItem())/lv4->currentItem()->height());
	int item5 = (int) (lv5->itemPos(lv5->currentItem())/lv5->currentItem()->height());

	kdDebug()<<"ITEM1 = "<<item1<<endl;
	kdDebug()<<"ITEM2 = "<<item2<<endl;
	kdDebug()<<"ITEM3 = "<<item3<<endl;
	kdDebug()<<"ITEM4 = "<<item4<<endl;
	kdDebug()<<"ITEM5 = "<<item5<<endl;

	Point start = Point(lx1le->text().toDouble(),ly1le->text().toDouble());
	Point end = Point(lx2le->text().toDouble(),ly2le->text().toDouble());
	Arrow* sarrow = new Arrow(0,startcb->isChecked(),salle->text().toDouble(),saale->text().toDouble(),
		safcb->isChecked(),safccb->color());
	Arrow* earrow = new Arrow(1,endcb->isChecked(),ealle->text().toDouble(),eaale->text().toDouble(),
		eafcb->isChecked(),eafccb->color());

	Line *line = new Line(start,end,lcb->color(),lwni->value());
	line->setStartArrow(sarrow);
	line->setEndArrow(earrow);

	p->setLine(item1,line);

	p->setLabel(item2,rtw->label());

	start = Point(rx1le->text().toDouble(),ry1le->text().toDouble());
	end = Point(rx2le->text().toDouble(),ry2le->text().toDouble());
	Rect* rect = new Rect(start,end,rcb->color(),rwni->value(),rfccb->isChecked(),rfcb->color());

	p->setRect(item3,rect);

	start = Point(ex1le->text().toDouble(),ey1le->text().toDouble());
	end = Point(ex2le->text().toDouble(),ey2le->text().toDouble());
	Ellipse* ellipse = new Ellipse(start,end,ecb->color(),ewni->value(),efccb->isChecked(),efcb->color());

	p->setEllipse(item4,ellipse);

	start = Point(ixle->text().toDouble(),iyle->text().toDouble());
	LImage* image = new LImage(start,ile->text(),isle->text().toDouble(),iale->text().toDouble());

	p->setImage(item5,image);

	updateLineListView();
	updateLabelListView();
	updateRectListView();
	updateEllipseListView();
	updateImageListView();

	p->updatePixmap();

	return 0;
}
