/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#ifndef KDIALUPCLASS_H
#define KDIALUPCLASS_H


#include "dialup.h"

#include <qobject.h>

class QString;
class SuProcessBase;
class KProcess;

class dialupClass : public QObject
{
    Q_OBJECT
    public:
        dialupClass(QObject *parent = 0, const char *name = 0);
        ~dialupClass();
        bool readData(QString profile);
        bool writeData(QString profile);
        void parseConfigLine( QString line);
        dialupData* getData()
        {
            return &m_data;
        }
    signals:
        void dataWritten();
                
    public slots:
        //void slotWriteProcessExited(SuProcessBase *);
        void slotWriteProcessExited(KProcess *);
        void slotWriteProcessWrote(KProcess *, char *, int);
        
    private:
        dialupData m_data;
};

#endif
