/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kinfowidget.h"

#include "kwc.xpm"

/*!
	\fn KInfoWidget::KInfoWidget( QWidget *parent, const char *name )
*/
KInfoWidget::KInfoWidget( QWidget *parent, const char *name ) : QWidget( parent, name )
{
	logoLabel = new QLabel( this );
	logoLabel->setPixmap( QPixmap( kwc_xpm ) );
	logoLabel->adjustSize();
	gridWidget = new KSingleTabWidget( this );
}


/*!
	\fn KInfoWidget::~KInfoWidget()
*/
KInfoWidget::~KInfoWidget()
{
	delete logoLabel;
}


/*!
    \fn KInfoWidget::resizeEvent( QResizeEvent * )
 */
void KInfoWidget::resizeEvent( QResizeEvent * )
{
	logoLabel->move( ( this->width() - logoLabel->width() ) / 2, 2 * KWaveControl::SPACING );
	gridWidget->move( logoLabel->x(), logoLabel->y() + logoLabel->height() + 1 * KWaveControl::SPACING );
	gridWidget->resize( this->width() - gridWidget->x(), this->height() - gridWidget->y() );
}


#include "kinfowidget.moc"
