/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <qlayout.h>
#include <qlabel.h>


#include <klocale.h>
#include <kdialogbase.h>
#include <kiconloader.h>
#include <kapplication.h>
#include <kstandarddirs.h>
#include <kdebug.h>

#include "ksystemlogConfig.h"

#include "options.h"


Options::Options(QWidget* parent, const char *name, bool modal) :
	KDialogBase(IconList, i18n("Configuration"), Ok|Apply|Cancel, Ok, parent, name, modal, true)
	{

	this->setMinimumSize(480, 500);
	
	setupGeneralOptions();
	
	setupSystemOptions();
	setupBootAuthenticationOptions();
	setupKernelOptions();
	setupCronOptions();
	setupDaemonOptions();
	
	setupXorgOptions();
	setupAcpidOptions();
	setupCupsOptions();
	
	setupApacheOptions();
	setupPostfixOptions();
	
	disableApplyButton();

	connect(this, SIGNAL(applyClicked()), this, SLOT(saveConfig()));
	connect(this, SIGNAL(okClicked()), this, SLOT(saveConfig()));
	
	
	//Really update size of this Configuration Dialog Box
	this->adjustSize();
}

Options::~Options() {
	//TODO Delete option frames
}


void Options::disableApplyButton() {
	this->enableButtonApply(false);
}

void Options::saveConfig() {
	kdDebug() << "Saving config from Main Config Dialog..." << endl;

	KSystemLogConfig::writeConfig();
	
	kdDebug() << "Configuration synchronized" << endl;
	
	disableApplyButton();
}

void Options::setupGeneralOptions() {
	QFrame* frame=addPage(i18n("General"), i18n("General"), DesktopIcon(KSYSTEMLOG_ICON));
	
	QGridLayout* frameLayout=new QGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	QScrollView* container = new QScrollView(frame);
	container->setResizePolicy(QScrollView::AutoOneFit);
	container->setFrameShadow(QScrollView::Plain);
	container->setFrameShape(QScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	generalOptions = new GeneralOptions(container->viewport());
	container->addChild(generalOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(generalOptions, SIGNAL(optionsChanged(bool)), this, SLOT(optionsChanged(bool)));

	connect(this, SIGNAL(applyClicked()), generalOptions, SLOT(saveConfig()));
	connect(this, SIGNAL(okClicked()), generalOptions, SLOT(saveConfig()));

}


void Options::setupBootAuthenticationOptions() {
	QFrame* frame=addPage(i18n("Boot / Authentication"), i18n("Boot & Authentication Logs"), DesktopIcon(BOOT_MODE_ICON));
	
	QGridLayout* frameLayout=new QGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	QScrollView* container = new QScrollView(frame);
	container->setResizePolicy(QScrollView::AutoOneFit);
	container->setFrameShadow(QScrollView::Plain);
	container->setFrameShape(QScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	bootAuthenticationOptions = new BootAuthenticationOptions(container->viewport());
	container->addChild(bootAuthenticationOptions, 0, 0);

	connect(bootAuthenticationOptions, SIGNAL(optionsChanged(bool)), this, SLOT(optionsChanged(bool)));

	connect(this, SIGNAL(applyClicked()), bootAuthenticationOptions, SLOT(saveConfig()));
	connect(this, SIGNAL(okClicked()), bootAuthenticationOptions, SLOT(saveConfig()));

}


void Options::setupSystemOptions() {
	QFrame* frame=addPage(i18n("System Log"), i18n("System Log"), DesktopIcon(SYSTEM_MODE_ICON));
	
	QGridLayout* frameLayout=new QGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	QScrollView* container=new QScrollView(frame);
	
	
	container->setResizePolicy(QScrollView::AutoOneFit);
	container->setFrameShadow(QScrollView::Plain);
	container->setFrameShape(QScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	systemOptions=new SystemOptions(container->viewport());
	container->addChild(systemOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(systemOptions, SIGNAL(optionsChanged(bool)), this, SLOT(optionsChanged(bool)));

	connect(this, SIGNAL(applyClicked()), systemOptions, SLOT(saveConfig()));
	connect(this, SIGNAL(okClicked()), systemOptions, SLOT(saveConfig()));
}

void Options::setupKernelOptions() {
	QFrame* frame=addPage(i18n("Kernel Log"), i18n("Kernel Log"), DesktopIcon(KERNEL_MODE_ICON));
	
	QGridLayout* frameLayout=new QGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	QScrollView* container=new QScrollView(frame);
	container->setResizePolicy(QScrollView::AutoOneFit);
	container->setFrameShadow(QScrollView::Plain);
	container->setFrameShape(QScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	kernelOptions=new KernelOptions(container->viewport());
	container->addChild(kernelOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(kernelOptions, SIGNAL(optionsChanged(bool)), this, SLOT(optionsChanged(bool)));

	connect(this, SIGNAL(applyClicked()), kernelOptions, SLOT(saveConfig()));
	connect(this, SIGNAL(okClicked()), kernelOptions, SLOT(saveConfig()));
}

void Options::setupCronOptions() {
	QFrame* frame=addPage(i18n("Cron Log"), i18n("Cron Log"), DesktopIcon(CRON_MODE_ICON));
	
	QGridLayout* frameLayout=new QGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	QScrollView* container=new QScrollView(frame);
	container->setResizePolicy(QScrollView::AutoOneFit);
	container->setFrameShadow(QScrollView::Plain);
	container->setFrameShape(QScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	cronOptions=new CronOptions(container->viewport());
	container->addChild(cronOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(cronOptions, SIGNAL(optionsChanged(bool)), this, SLOT(optionsChanged(bool)));

	connect(this, SIGNAL(applyClicked()), cronOptions, SLOT(saveConfig()));
	connect(this, SIGNAL(okClicked()), cronOptions, SLOT(saveConfig()));
}

void Options::setupDaemonOptions() {
	QFrame* frame=addPage(i18n("Daemons Log"), i18n("Daemons Log"), DesktopIcon(DAEMON_MODE_ICON));
	
	QGridLayout* frameLayout=new QGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	QScrollView* container=new QScrollView(frame);
	container->setResizePolicy(QScrollView::AutoOneFit);
	container->setFrameShadow(QScrollView::Plain);
	container->setFrameShape(QScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	daemonOptions=new DaemonOptions(container->viewport());
	container->addChild(daemonOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(daemonOptions, SIGNAL(optionsChanged(bool)), this, SLOT(optionsChanged(bool)));

	connect(this, SIGNAL(applyClicked()), daemonOptions, SLOT(saveConfig()));
	connect(this, SIGNAL(okClicked()), daemonOptions, SLOT(saveConfig()));
}

void Options::setupXorgOptions() {
	QFrame* frame=addPage(i18n("X.org Log"), i18n("X.org Log"), DesktopIcon(XORG_MODE_ICON));
	
	QGridLayout* frameLayout=new QGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	QScrollView* container=new QScrollView(frame);
	container->setResizePolicy(QScrollView::AutoOneFit);
	container->setFrameShadow(QScrollView::Plain);
	container->setFrameShape(QScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	xorgOptions=new XorgOptions(container->viewport());
	container->addChild(xorgOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(xorgOptions, SIGNAL(optionsChanged(bool)), this, SLOT(optionsChanged(bool)));

	connect(this, SIGNAL(applyClicked()), xorgOptions, SLOT(saveConfig()));
	connect(this, SIGNAL(okClicked()), xorgOptions, SLOT(saveConfig()));

}


void Options::setupAcpidOptions() {
	QFrame* frame=addPage(i18n("ACPI Log"), i18n("ACPI Daemon Log"), DesktopIcon(ACPID_MODE_ICON));
	
	QGridLayout* frameLayout=new QGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	QScrollView* container=new QScrollView(frame);
	container->setResizePolicy(QScrollView::AutoOneFit);
	container->setFrameShadow(QScrollView::Plain);
	container->setFrameShape(QScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	acpidOptions=new AcpidOptions(container->viewport());
	container->addChild(acpidOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(acpidOptions, SIGNAL(optionsChanged(bool)), this, SLOT(optionsChanged(bool)));

	connect(this, SIGNAL(applyClicked()), acpidOptions, SLOT(saveConfig()));
	connect(this, SIGNAL(okClicked()), acpidOptions, SLOT(saveConfig()));

}


void Options::setupCupsOptions() {
	QFrame* frame=addPage(i18n("CUPS Log"), i18n("CUPS & CUPS Web Server Log"), DesktopIcon(CUPS_MODE_ICON));
	
	QGridLayout* frameLayout=new QGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	QScrollView* container=new QScrollView(frame);
	container->setResizePolicy(QScrollView::AutoOneFit);
	container->setFrameShadow(QScrollView::Plain);
	container->setFrameShape(QScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	cupsOptions=new CupsOptions(container->viewport());
	container->addChild(cupsOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(cupsOptions, SIGNAL(optionsChanged(bool)), this, SLOT(optionsChanged(bool)));

	connect(this, SIGNAL(applyClicked()), cupsOptions, SLOT(saveConfig()));
	connect(this, SIGNAL(okClicked()), cupsOptions, SLOT(saveConfig()));

}

void Options::setupApacheOptions() {
	QFrame* frame=addPage(i18n("Apache Log"), i18n("Apache and Web Access Logs"), DesktopIcon(APACHE_MODE_ICON));
	
	QGridLayout* frameLayout=new QGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	QScrollView* container=new QScrollView(frame);
	container->setResizePolicy(QScrollView::AutoOneFit);
	container->setFrameShadow(QScrollView::Plain);
	container->setFrameShape(QScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	apacheOptions=new ApacheOptions(container->viewport());
	container->addChild(apacheOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(apacheOptions, SIGNAL(optionsChanged(bool)), this, SLOT(optionsChanged(bool)));

	connect(this, SIGNAL(applyClicked()), apacheOptions, SLOT(saveConfig()));
	connect(this, SIGNAL(okClicked()), apacheOptions, SLOT(saveConfig()));

}


void Options::setupPostfixOptions() {
	QFrame* frame=addPage(i18n("Postfix Log"), i18n("Postfix Log"), DesktopIcon(POSTFIX_MODE_ICON));
	
	QGridLayout* frameLayout=new QGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	QScrollView* container=new QScrollView(frame);
	container->setResizePolicy(QScrollView::AutoOneFit);
	container->setFrameShadow(QScrollView::Plain);
	container->setFrameShape(QScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	postfixOptions=new PostfixOptions(container->viewport());
	container->addChild(postfixOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(postfixOptions, SIGNAL(optionsChanged(bool)), this, SLOT(optionsChanged(bool)));

	connect(this, SIGNAL(applyClicked()), postfixOptions, SLOT(saveConfig()));
	connect(this, SIGNAL(okClicked()), postfixOptions, SLOT(saveConfig()));
}


void Options::optionsChanged(bool valid) {
	if (valid==false) {
		this->enableButtonApply(false);
		this->enableButtonOK(false);
	}
	else {
		//If all tab options are valid, then, we reactivate the Apply and OK buttons
		if (generalOptions->isValid() &&
			systemOptions->isValid() &&
			cronOptions->isValid() &&
			daemonOptions->isValid() &&
			kernelOptions->isValid() &&
			xorgOptions->isValid() && 
			acpidOptions->isValid() && 
			cupsOptions->isValid() && 
			bootAuthenticationOptions->isValid()) {
			
			this->enableButtonApply(true);
			this->enableButtonOK(true);
			
		}
		else {
			this->enableButtonApply(true);
			this->enableButtonOK(true);
		}
	}
}

#include "options.moc"

