/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//Qt includes
#include <qlayout.h>
#include <qvgroupbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <qhbox.h>

//KDE includes
#include <klocale.h>
#include <kactioncollection.h>
#include <kbuttonbox.h>
#include <klistbox.h>
#include <kfiledialog.h>
#include <kurl.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include <kdebug.h>

//Project includes
#include "acpidOptions.h"
#include "ksystemlogConfig.h"

AcpidOptions::AcpidOptions(QWidget *parent) : 
	QWidget(parent) 
	{
	
	QHBoxLayout *layout = new QHBoxLayout(this);
	layout->setAutoAdd(true);

	QString description=i18n("<qt><p>These files will be analyzed to display <b>ACPId log</b>. This list also determines the order in which the files are read.</p></qt>");
	fileList=new FileList(this, description);
	
	connect(fileList, SIGNAL(fileListChanged(int)), this, SLOT(slotFileListChanged(int)));
	
	readConfig();
	

}

AcpidOptions::~AcpidOptions() {
	//TODO Delete fileList (and also in other *Options classes)
}

bool AcpidOptions::isValid() {
	if (fileList->count()>0)
		return(true);
	else
		return(false);
}

void AcpidOptions::slotFileListChanged(int itemLeft) {
	if (itemLeft==0)
		emit optionsChanged(false);
	else
		emit optionsChanged(true);
}

void AcpidOptions::saveConfig() {
	kdDebug() << "Save config from AcpidOptions" << endl;
	
	QStringList list;
	
	int count=fileList->count();
	
	for (int i=0; i<count; i++) {
		list.push_back(fileList->getText(i));
	}
	
	KSystemLogConfig::setAcpidPaths(list);
}

void AcpidOptions::readConfig() {
	QStringList files(KSystemLogConfig::acpidPaths());
		
	QStringList::iterator it;
	for(it=files.begin(); it!=files.end(); ++it) {
		fileList->insertItem(*it);
	}

}

#include "acpidOptions.moc"
