//
// C++ Implementation: kpgsearchdialog
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgsearchdialog.h"

// include files for Qt
#include <qpushbutton.h>

// include files for KDE
#include <kiconloader.h>
#include <kpushbutton.h>

KPGSearchDialog::KPGSearchDialog(QWidget *parent, const char *name, bool modal)
	: KPGSearchDialogBase(parent, name, modal)
{
	m_pPushButtonFind->setEnabled(false);
	m_pEditSearchedString->setFocus();
		
	m_pPushButtonFind->setIconSet(QIconSet(QPixmap(SmallIcon("find"))));
	m_pPushButtonCancel->setIconSet(QIconSet(QPixmap(SmallIcon("fileclose"))));  
}


KPGSearchDialog::~KPGSearchDialog()
{
}

void KPGSearchDialog::slotTextChanged(const QString& string)
{
	if ( string.isEmpty() )
		m_pPushButtonFind->setEnabled(false);
	else
		m_pPushButtonFind->setEnabled(true);

	toggleAcceptButton();
}

void KPGSearchDialog::slotFindInChanged(int)
{
	toggleAcceptButton();
}

void KPGSearchDialog::toggleAcceptButton()
{
	if ( (m_pCheckBoxNames->isChecked()) ||(m_pCheckBoxOIDs->isChecked()) )
	{
		if ( m_pEditSearchedString->text().isEmpty() )
			m_pPushButtonFind->setEnabled(false);
		else
			m_pPushButtonFind->setEnabled(true);
	}
	else
		m_pPushButtonFind->setEnabled(false);
}

#include "kpgsearchdialog.moc"
