/***************************************************************************
                          kpgconfiguration.h  -  description
                             -------------------
    begin                : Ne led 18 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPGCONFIGURATION_H
#define KPGCONFIGURATION_H

#include <qwidget.h>
#include <qobject.h>

class KPGSqlEditorSettings;
class KPGGeneralSettings;
class KPGDataTableSettings;
class KXETextViewSettings;

class KConfig;
class KDialogBase;

/**
  This class is a container for KXMLEditor's configuration data.
 * It consists of objects for the different groups of settings
 * (objects of child classes of KXESettings) and manages the configuration
 * dialog (@ref m_pDialog). This dialog consists of one page per settings
 * group, that are initialized by them (using their dialogPage* functions).
 *
 * @short container for KXMLEditor's configuration data
 
  *@author Lumir Vanek

Note: Borrowed from KXMLEditor - Olaf Hartig's KXEConfiguration class

  */

class KPGConfiguration : public QObject
{
	Q_OBJECT

public:

	/**
	 * The constructor initializes the configuration setting groups
	 * (objects of KPGSettings' child classes) and restores the
	 * configuration data from the config file by calling @ref restore.
	 */
	KPGConfiguration();
	~KPGConfiguration();

	/**
	 * Stores all configuration to the given @ref KConfig object by
	 * using @ref KXESettings's @ref store function.
	 * If no @ref KConfig object is given, @ref KGlobal::config is
	 * used.
	 */
	void store( KConfig * pConfig = 0 ) const;
		
	/**
	 * Restores all configuration from the given @ref KConfig object
	 * by using @ref KXESettings's @ref restore function.
	 * If no @ref KConfig object is given, @ref KGlobal::config is
	 * used.
	 */
	void restore( KConfig * pConfig = 0 );
		
	/**
	 * Shows the configuration dialog.
	 * If there is no one yet, it is created by.
	 */
	void showDialog();

	// The following functions return pointers to the configuration setting
	// groups (objects of KXESettings' child classes), that can be used to
	// access their data (or to connect to their signals).

	KPGSqlEditorSettings * const sqleditor() const { return m_pSettingsSqlEditor; }
    KPGGeneralSettings * const general() const { return m_pSettingsGeneral; }
    KPGDataTableSettings * const datatable() const { return m_pSettingsDataTable; }
	//KXETextViewSettings * const kxetextview() const { return m_pSettingsKXETextView; }
	
protected slots:

	/**
	 * Applies the new data in the dialog's pages to our setting groups
	 * by using @ref KPGSettings's @ref apply function and stores
	 * all settings with @ref store.
	 * After applying, the dialog's state is reseted (disabled Apply- and
	 * OK-buttons).
	 */
		
	void slotDlgApplied();
	/**
	 * Enables the configuration dialog's Apply- and OK-button.
	 */
	void slotDlgChanged();

protected:

	// The following members are the configuration setting
	// groups (objects of KPGSettings' child classes).

	KPGSqlEditorSettings * m_pSettingsSqlEditor;
    KPGGeneralSettings * m_pSettingsGeneral;
    KPGDataTableSettings * m_pSettingsDataTable;
    //KXETextViewSettings * m_pSettingsKXETextView;
		
	/**
	 * This is a pointer to our configuration dialog.
	 * The dialog itself is created on demand in @ref showDialog.
	 * It consists of one page per settings group.
	 */
	KDialogBase * m_pDialog;
};

#endif
