//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgsetclustertablewizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgtable.h"
#include "kpgsetclustertablewidget1.h"


KPGSetClusterTableWizard::KPGSetClusterTableWizard(QWidget *parent, const char *name, const QString & strNamespace, KPGTable *pTable)
 : KPG3StepsWizard(parent, name)
{
  KPGSetClusterTableWidget1 *pSetClusterTableWidget1 = new KPGSetClusterTableWidget1(WizardPage1, "KPGSetClusterTableWidget1", strNamespace, pTable);
  m_pPageWidget1 = pSetClusterTableWidget1;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pSetClusterTableWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
  
  setNextEnabled(WizardPage1, true);
  languageChange();
}

KPGSetClusterTableWizard::~KPGSetClusterTableWizard()
{
}

void KPGSetClusterTableWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
    
    setCaption( i18n( "Set cluster for table" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Select  index for cluster" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGSetClusterTableWizard::showPage(QWidget *pPage)
{
  if(pPage == WizardPage2) // Step 2 - Review SQL statement
  {
    // prepare SQL statement
    m_pTextEditSQL->setText((static_cast <KPGSetClusterTableWidget1 *> (m_pPageWidget1))->getSQL());
  }
  
  if(pPage == WizardPage3) // Step 3 - Check operation result
  {
    runQuery(false);
  }
  
  // call parent
  KPG3StepsWizard::showPage(pPage);
}


#include "kpgsetclustertablewizard.moc"
