//
// C++ Implementation: kpgcreateviewwidget1
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreateviewwidget1.h"

// include files for Qt
#include <qpushbutton.h>

// include files for KDE
#include <kcombobox.h>
#include <klineedit.h>
#include <klistbox.h>
#include <klistview.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgtreeitem.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgtablesfolder.h"
#include "../kpgutil.h"


KPGCreateViewWidget1::KPGCreateViewWidget1(QWidget *parent, const char *name, KPGDatabase *pDatabase, QPtrList<QListViewItem> & listOfSchemas)
 : KPGCreateViewWidget1Base(parent, name)
{
  	m_pDatabase = pDatabase;
	m_pLineEditViewName->setFocus();
	
	m_bIsDirty1 = false;
	m_bIsDirty2 = false;
	m_bIsDirty3 = false;
   
	int iCurrentItem = -1;
	int i = 0;  
	for(QListViewItem *pSchema = listOfSchemas.first(); pSchema; pSchema = listOfSchemas.next())
	{
		m_pComboBoxSchema->insertItem(* pSchema->pixmap(0), pSchema->text(0));
		
		if(pSchema->text(0) == "public")
			iCurrentItem = i;
			
		++i;
	}
		
	if(iCurrentItem >= 0)
		m_pComboBoxSchema->setCurrentItem(iCurrentItem);
}


KPGCreateViewWidget1::~KPGCreateViewWidget1()
{
}

void KPGCreateViewWidget1::slotViewNameChanged(const QString& strText)
{
	emit sigEnableNextButton((! strText.isEmpty()) && (m_pListViewTables->childCount() > 0));
}

void KPGCreateViewWidget1::slotSchemaActivated(const QString & strSchema)
{
	refreshAvailTablesList(strSchema);
}

void KPGCreateViewWidget1::refreshAvailTablesList(const QString & strNamespace)
{
	m_pListBoxAvailTables->clear();
	m_pListViewTables->clear();
	
	// list of available tables
	KPGTreeItem *pItem = m_pDatabase->getChildByName(strNamespace);
	if(!pItem)
	{
		kdDebug() << "KPGCreateViewWizard::showPage: no item found: " << strNamespace << endl;
		return;
	}
			
	KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
	pSchema->getTablesFolder()->fillListBoxWithChildItems(m_pListBoxAvailTables); 
}

void KPGCreateViewWidget1::slotAvailableTablesSelectChanged(QListBoxItem* pSelectedItem)
{
	m_pPushButtonTableAdd->setEnabled(pSelectedItem != 0);
}

void KPGCreateViewWidget1::slotViewTablesSelectChanged(QListViewItem* pSelectedItem)
{
	m_pPushButtonTableDel->setEnabled(pSelectedItem != 0);
}

void KPGCreateViewWidget1::slotTableAdd()
{
	QListBoxItem *pSelectedItem = m_pListBoxAvailTables->selectedItem();
	if(!pSelectedItem) return;
	
	// Avoid duplicity
	QString strTableName(pSelectedItem->text());
	QString strAlias(m_pLineEditAlias->text());
	
	if(strAlias.contains(' ') || strAlias.contains('.'))
	{
		KMessageBox::sorry(this, i18n("Alias cannot contain space or dot !"));
		return;	
	}
		
	QListViewItem * pItem = m_pListViewTables->firstChild();
	while(pItem)
	{
		// Avoid table name duplicity
		if((pItem->text(0) == strTableName))
		{
			KMessageBox::sorry(this, i18n("Table is already in list !"));
			return;	
		}
		
		// Avoid Alias duplicity
		if(m_pLineEditAlias->text().isEmpty() == false)
		{
			if(pItem->text(1) == strAlias)
			{
				KMessageBox::sorry(this, i18n("Table with this alias already exists !"));
				return;	
			}
		}
		
		pItem = pItem->nextSibling();
	}
	
	// Move column from available list to list
	QListViewItem *pNewItem = new QListViewItem(m_pListViewTables, strTableName, strAlias);
	pNewItem->setPixmap(0, * pSelectedItem->pixmap());
			
	// set default view name, if empty
	if(m_pLineEditViewName->text().isEmpty())
		m_pLineEditViewName->setText("vw_" + pSelectedItem->text());
	
	// clear alias
	m_pLineEditAlias->setText("");
	
	emit sigEnableNextButton((! m_pLineEditViewName->text().isEmpty()) && (m_pListViewTables->childCount() > 0));
	
	m_bIsDirty1 = true;
	m_bIsDirty2 = true;
	m_bIsDirty3 = true;
}

void KPGCreateViewWidget1::slotTableDelete()
{
	QListViewItem *pSelectedItem = m_pListViewTables->selectedItem();
	if(!pSelectedItem) return;

	delete pSelectedItem;
	
	m_pPushButtonTableDel->setEnabled(false);
	
	emit sigEnableNextButton((! m_pLineEditViewName->text().isEmpty()) && (m_pListViewTables->childCount() > 0));
	
	m_bIsDirty1 = true;
	m_bIsDirty2 = true;
	m_bIsDirty3 = true;
}

// Return part of SQL statement for CREATE VIEW
const QString KPGCreateViewWidget1::getSQL() const
{
	QString strSql("CREATE VIEW ");
	
	strSql.append(KPGUtil::fullyQualifiedName(m_pComboBoxSchema->currentText(), m_pLineEditViewName->text()));
	
	return strSql;
}

#include "kpgcreateviewwidget1.moc"
