//
// C++ Implementation: kpgcreategroupwizard 
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreategroupwizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <kdebug.h>
#include <ktextedit.h>
#include <kactionselector.h> 
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgtreeitem.h"
#include "../DbObjects/kpgusersfolder.h"
#include "kpgcreategroupwidget1.h"

KPGCreateGroupWizard::KPGCreateGroupWizard(QWidget *parent, const char *name, KPGUsersFolder *pUsersFolder)
 : KPG3StepsWizard(parent, name)
{
	KPGCreateGroupWidget1 *pCreateGroupWidget1 = new KPGCreateGroupWidget1(WizardPage1, "KPGCreateGroupWidget1");
	m_pPageWidget1 = pCreateGroupWidget1;
	WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
	connect(pCreateGroupWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
	
	pUsersFolder->fillListBoxWithChildItems(pCreateGroupWidget1->m_pActionSelectorUsers->availableListBox());
	
	languageChange();
}


KPGCreateGroupWizard::~KPGCreateGroupWizard()
{
}

void KPGCreateGroupWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
		
		setCaption( i18n( "Create new group" ) );
		
    setTitle( WizardPage1, i18n( "Step 1 - Group name and another properties" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateGroupWizard::showPage(QWidget *pPage)
{	
	if(pPage == WizardPage2) // Step 2 - Review SQL statement
	{
		// prepare SQL statement
		QString strSQL("CREATE GROUP ");
		
		strSQL.append((static_cast <KPGCreateGroupWidget1 *> (m_pPageWidget1))->getSQL());
				
		strSQL.append(";");
		
		m_pTextEditSQL->setText(strSQL);
	}
	
	if(pPage == WizardPage3) // Step 3 - Check operation result
	{
		runQuery();
	}
	
	// call parent
	KPG3StepsWizard::showPage(pPage);
}

#include "kpgcreategroupwizard.moc"
