//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcopytotablewizard.h"

// include files for Qt
#include <qlayout.h>
#include <qcheckbox.h>

// include files for KDE
#include <kdebug.h>
//#include <klineedit.h>
#include <ktextedit.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgtable.h"
#include "kpgcopytotablewidget1.h"
#include "kpgcopytablewidget2.h"
#include "kpgcopytablewidget3.h"


KPGCopyToTableWizard::KPGCopyToTableWizard(QWidget *parent, const char *name, const QString & strNamespace, KPGTable *pTable)
 : KPG5StepsWizard(parent, name)
{
  KPGCopyToTableWidget1 *pCopyToTableWidget1 = new KPGCopyToTableWidget1(WizardPage1, "KPGCopyToTableWidget1", strNamespace, pTable);
  m_pPageWidget1 = pCopyToTableWidget1;
  WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
  connect(pCopyToTableWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
    
  KPGCopyTableWidget2 *pCopyTableWidget2 = new KPGCopyTableWidget2(WizardPage2, "KPGCopyTableWidget2");
  m_pPageWidget2 = pCopyTableWidget2;
  WizardPage2Layout->addWidget(m_pPageWidget2, 0, 0);
  connect(pCopyTableWidget2, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton2(bool)));
  
  KPGCopyTableWidget3 *pCopyTableWidget3 = new KPGCopyTableWidget3(WizardPage3, "KPGCopyTableWidget3", pTable);
  m_pPageWidget3 = pCopyTableWidget3;
  WizardPage3Layout->addWidget(m_pPageWidget3, 0, 0);
  connect(pCopyTableWidget3, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton3(bool)));
  
  languageChange();
  setNextEnabled(WizardPage1, true);
}

KPGCopyToTableWizard::~KPGCopyToTableWizard()
{
}

void KPGCopyToTableWizard::languageChange()
{
    KPG5StepsWizard::languageChange();
    
    setCaption( i18n( "Copy from file to table" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Copy from file parameters" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Copy file parameters" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Force NOT NULL columns" ) );
    setTitle( WizardPage4, i18n( "Step 4 - Review SQL statement" ) );
    setTitle( WizardPage5, i18n( "Step 5 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCopyToTableWizard::showPage(QWidget *pPage)
{
  if(pPage == WizardPage2) 
  {
    KPGCopyToTableWidget1 *pCopyToTableWidget1 = static_cast <KPGCopyToTableWidget1 *> (m_pPageWidget1);
    KPGCopyTableWidget2 *pCopyTableWidget2 = static_cast <KPGCopyTableWidget2 *> (m_pPageWidget2);
    
    pCopyTableWidget2->setCvsMode(pCopyToTableWidget1->m_pCheckBoxCSV->isChecked());
  }
  
  if(pPage == WizardPage3) 
  {
    KPGCopyToTableWidget1 *pCopyToTableWidget1 = static_cast <KPGCopyToTableWidget1 *> (m_pPageWidget1);
    KPGCopyTableWidget3 *pCopyTableWidget3 = static_cast <KPGCopyTableWidget3 *> (m_pPageWidget3);
    
    pCopyTableWidget3->setCvsMode(pCopyToTableWidget1->m_pCheckBoxCSV->isChecked());
  }
  
  if(pPage == WizardPage4) // Step 4 - Review SQL statement
  {
    // prepare SQL statement
    KPGCopyToTableWidget1 *pCopyToTableWidget1 = static_cast <KPGCopyToTableWidget1 *> (m_pPageWidget1);
    KPGCopyTableWidget2 *pCopyTableWidget2 = static_cast <KPGCopyTableWidget2 *> (m_pPageWidget2);
    KPGCopyTableWidget3 *pCopyTableWidget3 = static_cast <KPGCopyTableWidget3 *> (m_pPageWidget3);
    
    QString strSQL(pCopyToTableWidget1->getSQL());
    strSQL.append(pCopyTableWidget2->getSQL());
    
    if(!pCopyTableWidget3->getSQL().isEmpty())
    {
      strSQL.append("\nFORCE NOT NULL ");
      strSQL.append(pCopyTableWidget3->getSQL());
    }
    strSQL.append(";");
    
    m_pTextEditSQL->setText(strSQL);
  }
  
  if(pPage == WizardPage5) // Step 5 - Check operation result
  {
    runQuery();
  }
  
  // call parent
  KPG5StepsWizard::showPage(pPage);
}



#include "kpgcopytotablewizard.moc"
