//
// C++ Implementation: kpgsequenceproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgsequenceproppage.h"

// include files for Qt
#include <qiconset.h>
#include <qtable.h>  

// include files for KDE
#include <ktabwidget.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <klistview.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <kdebug.h>
#include <klocale.h>
#include "../kpgsqldialog.h"

#include "../kpglinklabel.h"
#include "../DbObjects/kpgsequence.h"
#include "../DbObjects/kpgschema.h"
#include "../kpgsqldialog.h"
#include "../kpgutil.h"


KPGSequencePropPage::KPGSequencePropPage(QWidget *parent, KPGSequence *pSequence)
 : KPGSequencePropPageBase(parent, "KPGSequencePropPage")
{
  m_pSequence = pSequence;

  m_pTabWidget->setTabIconSet(tabStatistics, QIconSet(QPixmap(SmallIcon("ksysguard.png")))); 
  m_pButtonRefresh->setIconSet(QIconSet(QPixmap(BarIcon("reload.png")))); 
  m_pTabWidget->setTabIconSet(tabACL, QIconSet(QPixmap(UserIcon("group.png")))); 
  
  displayProperties();
}


KPGSequencePropPage::~KPGSequencePropPage()
{
}

void KPGSequencePropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();
	
	pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  	
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pSequence->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
  	m_pTableProperties->setText(iRow, 1, m_pSequence->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Name of the sequence"));
	
	//--- Description
	m_pTableProperties->setText(iRow, 0, i18n("Description"));
  	m_pTableProperties->setText(iRow, 1, m_pSequence->description());
	m_pTableProperties->setText(iRow++, 2, i18n("Description of the sequence"));
	
	//--- Owner
	m_pTableProperties->setText(iRow, 0, i18n("Owner"));
  	m_pTableProperties->setText(iRow, 1, m_pSequence->owner());
	m_pTableProperties->setText(iRow++, 2, i18n("Owner of the sequence"));
	
	//--- ACL
	setACL(m_pSequence->acl());
	
	//--- Last value
	m_pTableProperties->setText(iRow, 0, i18n("Last value"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pSequence->lastValue()));
	m_pTableProperties->setText(iRow++, 2, i18n("Last counter value"));
	
	//--- Minimum value
	m_pTableProperties->setText(iRow, 0, i18n("Minimum value"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pSequence->minValue()));
	m_pTableProperties->setText(iRow++, 2, i18n("Minimum counter value"));
	
	//--- Maximum value
	m_pTableProperties->setText(iRow, 0, i18n("Maximum value"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pSequence->maxValue()));
	m_pTableProperties->setText(iRow++, 2, i18n("Maximum counter value"));
	
	//--- Cache value
	m_pTableProperties->setText(iRow, 0, i18n("Cache value"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pSequence->cacheValue()));
	m_pTableProperties->setText(iRow++, 2, i18n("Cache counter value"));
	
	//--- Is Cycled
	m_pTableProperties->setText(iRow, 0, i18n("Is Cycled"));
  	m_pTableProperties->setPixmap(iRow, 1, m_pSequence->isCycled() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("True, if counter value is cycled, when reaching max. value"));
	
	//--- Increment By
	m_pTableProperties->setText(iRow, 0, i18n("Increment By"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pSequence->incrementBy()));
	m_pTableProperties->setText(iRow++, 2, i18n("Increment value for sequence"));
		
				
	for(int nCol = 0; nCol < 3; nCol++)
	{
		m_pTableProperties->adjustColumn(nCol);
	}
  
    displayIoStatistics();
}

void KPGSequencePropPage::displayIoStatistics()
{
    QHeader* pHeader = m_pTableIoStatistics->horizontalHeader();
    
    pHeader->setLabel(0, i18n("Name"));
    pHeader->setLabel(1, i18n("Value"));
    pHeader->setLabel(2, i18n("Description"));
    
    try
    {
        pqxx::result pqxxResultStatistics = m_pSequence->queryIoStatistics();
    
        if(pqxxResultStatistics.size() != 1)
        {
            kdError() << k_funcinfo "Expect one row in result !" <<  endl;
            return;
        }
        
        if(m_pSequence->text(0) != pqxxResultStatistics[0]["relname"].c_str())
        {
            kdDebug() << k_funcinfo <<  ": sequence name not match" << endl;
            return;
        }
        
        int iRow = 0;
        
        //--- blks_read
        m_pTableIoStatistics->setText(iRow, 0, i18n("blks_read"));
        m_pTableIoStatistics->setText(iRow, 1, pqxxResultStatistics[0]["blks_read"].c_str());
        m_pTableIoStatistics->setText(iRow++, 2, i18n("Total number of disc blocks read"));
        
        //--- blks_hit
        m_pTableIoStatistics->setText(iRow, 0, i18n("blks_hit"));
        m_pTableIoStatistics->setText(iRow, 1, pqxxResultStatistics[0]["blks_hit"].c_str());
        m_pTableIoStatistics->setText(iRow++, 2, i18n("Number of buffer hits"));
        
    }
    catch (const KPGSqlException &e)
	{
	   KPGSqlDialog dlg(this, e.getSql(), e.what());
	   dlg.exec();
	}
    
    for(int nCol = 0; nCol < 3; nCol++)
    {
        m_pTableIoStatistics->adjustColumn(nCol);
    }
}

void KPGSequencePropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGSequencePropPage::slotRefreshStatistics()
{
  	displayIoStatistics();
}

void KPGSequencePropPage::setACL(const QString &strACL)
{
	m_pListViewACL->clear();
	m_listOfAclItems.clear();
	m_pLineEditACL->setText(strACL);
	
	QString strAclItem; // string for one ACL item, e.g. miriam=arwdRxt/miriam
	for(unsigned int i = 0; i < strACL.length(); i++)
	{
		if(strACL[i] == '{')
		continue;
		
		if((strACL[i] == ',') || (strACL[i] == ','))
		{
		m_listOfAclItems.append(KPGAclItem(strAclItem)); // create new ACL item
		strAclItem.truncate(0); // clear ACL string
		}
		else
		{
		strAclItem.append(strACL[i]);
		}
	}
	
	if(!strAclItem.isEmpty())
		m_listOfAclItems.append(KPGAclItem(strAclItem)); // create new ACL item
	
	// Traverse list of ACL items
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		QListViewItem * pItem = new QListViewItem( m_pListViewACL, 0 );
		(*it).setListViewItem(pItem);
		
		pItem->setText( 0, (*it).grantee() );
		pItem->setText( 1, (*it).grantor() );
		
		pItem->setPixmap(2, UserIcon((*it).canSelect() ? "box_checked.png" : "box_clear.png"));
		pItem->setPixmap(3, UserIcon((*it).canInsert() ? "box_checked.png" : "box_clear.png"));
		pItem->setPixmap(4, UserIcon((*it).canUpdate() ? "box_checked.png" : "box_clear.png"));
		pItem->setPixmap(5, UserIcon((*it).canDelete() ? "box_checked.png" : "box_clear.png"));
		pItem->setPixmap(6, UserIcon((*it).canCreateRule() ? "box_checked.png" : "box_clear.png"));
		pItem->setPixmap(7, UserIcon((*it).canCreateReference() ? "box_checked.png" : "box_clear.png"));
		pItem->setPixmap(8, UserIcon((*it).canCreateTrigger() ? "box_checked.png" : "box_clear.png"));
		
		if((*it).canPassGrantToOther())
		{  
		pItem->setPixmap(9, UserIcon((*it).canGrantSelect() ? "box_checked.png" : "box_clear.png"));
		pItem->setPixmap(10, UserIcon((*it).canGrantInsert() ? "box_checked.png" : "box_clear.png"));
		pItem->setPixmap(11, UserIcon((*it).canGrantUpdate() ? "box_checked.png" : "box_clear.png"));
		pItem->setPixmap(12, UserIcon((*it).canGrantDelete() ? "box_checked.png" : "box_clear.png"));
		pItem->setPixmap(13, UserIcon((*it).canGrantCreateRule() ? "box_checked.png" : "box_clear.png"));
		pItem->setPixmap(14, UserIcon((*it).canGrantCreateReference() ? "box_checked.png" : "box_clear.png"));
		pItem->setPixmap(15, UserIcon((*it).canGrantCreateTrigger() ? "box_checked.png" : "box_clear.png")); 
		}
	} 
}

void KPGSequencePropPage::slotAclListViewClicked(QListViewItem *pItem, const QPoint &, int iColumn)
{
	// Find KPGAclItem using pItem value
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		if(pItem == (*it).getListViewItem())
		{
		// found ...
		
		switch(iColumn)
		{
			case 0:
			case 1: // do nothing on first 2 columns
				break;
			
			case 2:
				pItem->setPixmap(2, UserIcon((*it).toggleSelect() ? "box_checked.png" : "box_clear.png"));
				break;
		
			case 3:
				pItem->setPixmap(3, UserIcon((*it).toggleInsert() ? "box_checked.png" : "box_clear.png"));
				break;
				
			case 4:
				pItem->setPixmap(4, UserIcon((*it).toggleUpdate() ? "box_checked.png" : "box_clear.png"));
				break;
				
			case 5:
				pItem->setPixmap(5, UserIcon((*it).toggleDelete() ? "box_checked.png" : "box_clear.png"));
				break;
				
			case 6:
				pItem->setPixmap(6, UserIcon((*it).toggleCreateRule() ? "box_checked.png" : "box_clear.png"));
				break;         
				
			case 7:
				pItem->setPixmap(7, UserIcon((*it).toggleCreateReference() ? "box_checked.png" : "box_clear.png"));
				break;
				
			case 8:
				pItem->setPixmap(8, UserIcon((*it).toggleCreateTrigger() ? "box_checked.png" : "box_clear.png"));
				break;
						
			case 9:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(9, UserIcon((*it).toggleGrantSelect() ? "box_checked.png" : "box_clear.png"));
				
				break;
				
			case 10:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(10, UserIcon((*it).toggleGrantInsert() ? "box_checked.png" : "box_clear.png"));
				
				break;
				
			case 11:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(11, UserIcon((*it).toggleGrantUpdate() ? "box_checked.png" : "box_clear.png"));
				
				break;
				
			case 12:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(12, UserIcon((*it).toggleGrantDelete() ? "box_checked.png" : "box_clear.png"));
				
				break;
				
			case 13:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(13, UserIcon((*it).toggleGrantCreateRule() ? "box_checked.png" : "box_clear.png"));
				
				break;         
				
			case 14:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(14, UserIcon((*it).toggleGrantCreateReference() ? "box_checked.png" : "box_clear.png"));
				
				break;
				
			case 15:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(15, UserIcon((*it).toggleGrantCreateTrigger() ? "box_checked.png" : "box_clear.png"));
				
				break;    
				
			default:
					kdError() << k_funcinfo << " Unexpected column !" << endl;
					break;      
		}
		
		m_pPushButtonUpdateACL->setEnabled(true);
		return;
		}
	}
}

void KPGSequencePropPage::slotUpdateACL()
{
	QString strSQL;
	
	KPGSchema *pSchema = static_cast <KPGSchema *> (m_pSequence->parent()->parent());
		
	// Traverse all items and get their SQL's
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		strSQL.append((*it).getSQL("TABLE " + KPGUtil::fullyQualifiedName(pSchema->text(0), m_pSequence->text(0))));
	}
	
	if(!strSQL.isEmpty())
		emit sigRunWizard(strSQL);
}

// Consumes request for context menu for property table
void KPGSequencePropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgsequenceproppage.moc"
