//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGPROPERTYPAGE_H
#define KPGPROPERTYPAGE_H

#include "kpgpropertypagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"

// include files for libpgxx 
#include <pqxx/util> 


/**
  * General property page
  *
  * @author Lumir Vanek
  */
class KPGPropertyPage : public KPGPropertyPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGPropertyPage(QWidget *parent, const char *name);
    ~KPGPropertyPage();
    
    // Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableItems; }
	
    void setLabelText(const QString &);
    
protected slots:
    
    virtual void slotTablePropDblClicked(int, int, int, const QPoint &); 
    
    // Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);
    
signals:
    void sigSearchObject(const pqxx::oid);
            
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
