//
// C++ Implementation: kpgoperatorsfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgoperatorsfolderproppage.h"


#include <qtable.h>

#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgoperatorsfolder.h"


KPGOperatorsFolderPropPage::KPGOperatorsFolderPropPage(QWidget* parent, KPGOperatorsFolder * pOperatorsFolder)
	: KPGPropertyPage(parent, "KPGOperatorsFolderPropPage")
{
	m_pOperatorsFolder = pOperatorsFolder;
	displayProperties();
}


KPGOperatorsFolderPropPage::~KPGOperatorsFolderPropPage()
{
}

void KPGOperatorsFolderPropPage::displayProperties()
{
	setLabelText(i18n("Operators &list:"));
	
	QHeader* pHeader = m_pTableItems->horizontalHeader();

  	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
  	pHeader->setLabel(nCol++, i18n("Description"));
	pHeader->setLabel(nCol++, i18n("Kind"));
  	pHeader->setLabel(nCol++, i18n("Can Hash"));
	pHeader->setLabel(nCol++, i18n("Left Type"));
	pHeader->setLabel(nCol++, i18n("Right Type"));
	pHeader->setLabel(nCol++, i18n("Result Type"));
	pHeader->setLabel(nCol++, i18n("Comutator"));
	pHeader->setLabel(nCol++, i18n("Negator"));
	pHeader->setLabel(nCol++, i18n("Left-hand"));
	pHeader->setLabel(nCol++, i18n("Right-hand"));
	pHeader->setLabel(nCol++, i18n("Less-than"));
	pHeader->setLabel(nCol++, i18n("Greater-than"));
	pHeader->setLabel(nCol++, i18n("Function"));
	pHeader->setLabel(nCol++, i18n("Restriction func."));
	pHeader->setLabel(nCol++, i18n("Join func."));
	pHeader->setLabel(nCol++, i18n("Owner"));

	KPGUtil::fillPropertiesTable(m_pOperatorsFolder->resultOperators(), m_pTableItems);
}


