/***************************************************************************
                          kpgdatabaseproppage  -  description
                             -------------------
    begin                : So led 31 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KPGDATABASEPROPPAGE_H
#define KPGDATABASEPROPPAGE_H

#include "kpgdatabaseproppagebase.h"

// include files for libpgxx 
#include <pqxx/util> 

// application specific includes
#include "kpgabstractpropertypage.h"
#include "../kpgaclitem.h"

// Foreign references
class KPGTreeItem;
class KPGDatabase;

/**
Database properties page

@author Lumir Vanek
*/

class KPGDatabasePropPage : public KPGDatabasePropPageBase, public KPGAbstractPropertyPage
{
Q_OBJECT
public:
    KPGDatabasePropPage(QWidget *parent, KPGDatabase *);
    ~KPGDatabasePropPage();

	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult();

    // Display properties of underlying database object
    virtual void displayProperties();
    
protected:
    void setACL(const QString &);

	void displayCasts();
	void displayLanguages();
	void displaySchemas();
	void displayStatistics();
  	void displayExtendedStatistics();
    
protected:
    KPGDatabase *m_pDatabase;
    KPGAclItemList m_listOfAclItems;

    bool m_bPageCastsDisplaied;
    
protected slots:
    
	virtual void slotTablePropDblClicked(int, int, int, const QPoint &);
	virtual void slotTableCastsDblClicked(int, int, int, const QPoint &);
    virtual void slotTableLanguagesDblClicked(int, int, int, const QPoint &);
    virtual void slotTableSchemasDblClicked(int, int, int, const QPoint &);
	virtual void slotTableStatistics2DblClicked(int, int, int, const QPoint &);
	virtual void slotTableLocksDblClicked(int, int, int, const QPoint &);
	virtual void slotTableDiskUsageDblClicked(int iRow, int iCol,int,const QPoint&);
                         
    virtual void slotCurrentTabChanged(QWidget *);                     
                         
    // Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);
	  	
    virtual void slotRefreshStatistics();
    virtual void slotRefreshLocks();
    virtual void slotRefreshDiskUsage();
    
    virtual void slotAclListViewClicked(QListViewItem *, const QPoint &, int);
    virtual void slotUpdateACL();
 
signals:
	void sigSearchObject(const pqxx::oid);
    void sigRunWizard(const QString &); 
                
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
