//
// C++ Implementation: kpgconversionproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgconversionproppage.h"

#include <qtable.h>

#include "../kpglinklabel.h"

#include <kdebug.h>
#include <klocale.h>

#include "../kpglinklabel.h"
#include "../kpgutil.h"
#include "../DbObjects/kpgconversion.h"

KPGConversionPropPage::KPGConversionPropPage(QWidget *parent, KPGConversion *pConversion)
 : KPGConversionPropPageBase(parent, "KPGConversionPropPage")
{
	m_pConversion = pConversion;
	displayProperties();
}


KPGConversionPropPage::~KPGConversionPropPage()
{
}

void KPGConversionPropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

  	pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  	
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pConversion->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
  	m_pTableProperties->setText(iRow, 1, m_pConversion->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Conversion name"));
	
	//--- Is Default
	m_pTableProperties->setText(iRow, 0, i18n("Is Default"));
    m_pTableProperties->setPixmap(iRow, 1, m_pConversion->isDefault() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("True if this is the default conversion"));
	
	//--- Source encoding
	m_pTableProperties->setText(iRow, 0, i18n("Source encoding"));
  	m_pTableProperties->setText(iRow, 1, m_pConversion->sourceEncoding());
	m_pTableProperties->setText(iRow++, 2, i18n("Source encoding"));

	//--- Destination encoding
	m_pTableProperties->setText(iRow, 0, i18n("Destination encoding"));
 	m_pTableProperties->setText(iRow, 1, m_pConversion->destinationEncoding());
	m_pTableProperties->setText(iRow++, 2, i18n("Destination encoding"));
	
	//--- Conversion procedure
	m_pTableProperties->setText(iRow, 0, i18n("Conversion procedure"));
  	KPGLinkLabel *pLabel = new KPGLinkLabel( m_pTableProperties, "Conversion procedure" );
	pLabel->setValues(m_pConversion->oidConversionProcedure(), m_pConversion->conversionProcedure());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Conversion procedure name"));
	
	//--- Owner
	m_pTableProperties->setText(iRow, 0, i18n("Owner"));
  	m_pTableProperties->setText(iRow, 1, m_pConversion->owner());
	m_pTableProperties->setText(iRow++, 2, i18n("Owner of the conversion"));
	
	
	for(int nCol = 0; nCol < 3; nCol++)
    {
        m_pTableProperties->adjustColumn(nCol);
    }
}

void KPGConversionPropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

// Consumes request for context menu for property table
void KPGConversionPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgconversionproppage.moc"
