//
// C++ Interface: kpgdebugger
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGDEBUGGER_H
#define KPGDEBUGGER_H

#include "kpgdebuggerbase.h"

#include <kparts/factory.h> // KPart Factory
#include <kate/view.h>      // Katepart view

#include "../kpgconnectioninthread.h"
//#include "../kpgactionsstates.h"

class KFind;
class KXMLGUIFactory;

class KPGConnection;
class KPGDatabase;
class KPGFunction;
class KPGDebuggerChildView;
class KPoGreView;

/**
  * PL pg/SQL debugger window
  *
  * @author Lumir Vanek <lvanek@users.sourceforge.net>
  */
class KPGDebugger : public KPGDebuggerBase, virtual public KXMLGUIClient
{
	Q_OBJECT
public:
    KPGDebugger(KPGDebuggerChildView *, KPoGreView *, KParts::Factory *, KXMLGUIFactory *, KPGConnection *, const QString &, KPGFunction *);
    ~KPGDebugger();

	// Add yourself and Kate view to GUI factory
    void addToGuiFactory();
    
    // Remove yourself and Kate view from GUI factory
    void removeFromGuiFactory();
    
    // Set function source code
    void setEditorText(const QString &);
    
    // Get function source code
    const QString editorText() const;
    
    // Get actions state
    //const DebuggerActions & debuggerActions() const { return m_debuggerActions; }
	
signals:

	// Fired when debugger need update actions
	void sigDebuggerStateChanged(KPGDebugger *);
	
protected:
	    
	// Debugger actions
    KAction* m_pActRun;
	KAction* m_pActStop;
	KAction* m_pActStepOver;
	//QPtrList<KAction> m_actListDebugger;

	// XML GUI factory
    KXMLGUIFactory * m_pXmlGuiFactory;
    
    // True, if this is in GUI factory
    bool m_bIsAddedToGuiFactory;

    // Connection to database
    KPGConnection* m_pConnection;
    
    // Database function to execute
    QString m_strFunctionName;
    
    // Function namespace
    QString m_strNamespaceName;
        	
	// List of argument informations, available since PostgreSQL 8.1
	KPGFunction::ListArguments m_listArguments;
	
	// State of actions - enable or disabled
    //DebuggerActions m_debuggerActions;
    
	// Kate part editor
    Kate::View* m_pKateView;
    
protected:
	// Create Kate part view
	Kate::View* createKatePart(KParts::Factory*);

protected slots:

	//--- Debugger actions
    void slotExecute();
    void slotStop();
    void slotStepOver();
};

#endif
